/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.regions.servicemetadata;

import java.net.URI;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.regions.PartitionEndpointKey;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.regions.ServiceEndpointKey;
import software.amazon.awssdk.regions.ServiceMetadata;
import software.amazon.awssdk.regions.ServicePartitionMetadata;
import software.amazon.awssdk.regions.internal.DefaultServicePartitionMetadata;
import software.amazon.awssdk.regions.internal.util.ServiceMetadataUtils;
import software.amazon.awssdk.utils.ImmutableMap;
import software.amazon.awssdk.utils.Pair;

@SdkPublicApi
public final class SupportServiceMetadata
implements ServiceMetadata {
    private static final String ENDPOINT_PREFIX = "support";
    private static final List<Region> REGIONS = Collections.unmodifiableList(Arrays.asList(Region.of("aws-global"), Region.of("aws-cn-global"), Region.of("us-gov-west-1"), Region.of("aws-iso-global"), Region.of("aws-iso-b-global"), Region.of("aws-iso-e-global"), Region.of("aws-iso-f-global"), Region.of("aws-eusc-global")));
    private static final List<ServicePartitionMetadata> PARTITIONS = Collections.unmodifiableList(Arrays.asList(new DefaultServicePartitionMetadata("aws", null), new DefaultServicePartitionMetadata("aws-cn", null), new DefaultServicePartitionMetadata("aws-us-gov", null), new DefaultServicePartitionMetadata("aws-iso", null), new DefaultServicePartitionMetadata("aws-iso-b", null), new DefaultServicePartitionMetadata("aws-iso-e", null), new DefaultServicePartitionMetadata("aws-iso-f", null), new DefaultServicePartitionMetadata("aws-eusc", null)));
    private static final Map<ServiceEndpointKey, String> SIGNING_REGIONS_BY_REGION = ImmutableMap.builder().put(ServiceEndpointKey.builder().region(Region.of("aws-global")).build(), "us-east-1").put(ServiceEndpointKey.builder().region(Region.of("aws-cn-global")).build(), "cn-northwest-1").put(ServiceEndpointKey.builder().region(Region.of("aws-eusc-global")).build(), "eusc-de-east-1").put(ServiceEndpointKey.builder().region(Region.of("aws-iso-global")).build(), "us-iso-east-1").put(ServiceEndpointKey.builder().region(Region.of("aws-iso-b-global")).build(), "us-isob-east-1").put(ServiceEndpointKey.builder().region(Region.of("aws-iso-e-global")).build(), "eu-isoe-west-1\"").put(ServiceEndpointKey.builder().region(Region.of("aws-iso-f-global")).build(), "us-isof-south-1").build();
    private static final Map<Pair<String, PartitionEndpointKey>, String> SIGNING_REGIONS_BY_PARTITION = ImmutableMap.builder().build();
    private static final Map<ServiceEndpointKey, String> DNS_SUFFIXES_BY_REGION = ImmutableMap.builder().build();
    private static final Map<Pair<String, PartitionEndpointKey>, String> DNS_SUFFIXES_BY_PARTITION = ImmutableMap.builder().build();
    private static final Map<ServiceEndpointKey, String> HOSTNAMES_BY_REGION = ImmutableMap.builder().allowDuplicateKeys(true).put(ServiceEndpointKey.builder().region(Region.of("aws-global")).build(), "support.us-east-1.amazonaws.com").put(ServiceEndpointKey.builder().region(Region.of("aws-cn-global")).build(), "support.cn-northwest-1.amazonaws.com.cn").put(ServiceEndpointKey.builder().region(Region.of("aws-eusc-global")).build(), "support.eusc-de-east-1.api.amazonwebservices.eu").put(ServiceEndpointKey.builder().region(Region.of("aws-iso-global")).build(), "support.us-iso-east-1.c2s.ic.gov").put(ServiceEndpointKey.builder().region(Region.of("aws-iso-b-global")).build(), "support.us-isob-east-1.sc2s.sgov.gov").put(ServiceEndpointKey.builder().region(Region.of("aws-iso-e-global")).build(), "support.eu-isoe-west-1.cloud.adc-e.uk").put(ServiceEndpointKey.builder().region(Region.of("aws-iso-f-global")).build(), "support.us-isof-south-1.csp.hci.ic.gov").build();
    private static final Map<Pair<String, PartitionEndpointKey>, String> HOSTNAMES_BY_PARTITION = ImmutableMap.builder().build();

    @Override
    public List<Region> regions() {
        return REGIONS;
    }

    @Override
    public List<ServicePartitionMetadata> servicePartitions() {
        return PARTITIONS;
    }

    @Override
    public URI endpointFor(ServiceEndpointKey key) {
        return ServiceMetadataUtils.endpointFor(ServiceMetadataUtils.hostname(key, HOSTNAMES_BY_REGION, HOSTNAMES_BY_PARTITION), ENDPOINT_PREFIX, key.region().id(), ServiceMetadataUtils.dnsSuffix(key, DNS_SUFFIXES_BY_REGION, DNS_SUFFIXES_BY_PARTITION));
    }

    @Override
    public Region signingRegion(ServiceEndpointKey key) {
        return ServiceMetadataUtils.signingRegion(key, SIGNING_REGIONS_BY_REGION, SIGNING_REGIONS_BY_PARTITION);
    }
}

