/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.athena.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum DataCatalogStatus {
    CREATE_IN_PROGRESS("CREATE_IN_PROGRESS"),
    CREATE_COMPLETE("CREATE_COMPLETE"),
    CREATE_FAILED("CREATE_FAILED"),
    CREATE_FAILED_CLEANUP_IN_PROGRESS("CREATE_FAILED_CLEANUP_IN_PROGRESS"),
    CREATE_FAILED_CLEANUP_COMPLETE("CREATE_FAILED_CLEANUP_COMPLETE"),
    CREATE_FAILED_CLEANUP_FAILED("CREATE_FAILED_CLEANUP_FAILED"),
    DELETE_IN_PROGRESS("DELETE_IN_PROGRESS"),
    DELETE_COMPLETE("DELETE_COMPLETE"),
    DELETE_FAILED("DELETE_FAILED"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, DataCatalogStatus> VALUE_MAP;
    private final String value;

    private DataCatalogStatus(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static DataCatalogStatus fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<DataCatalogStatus> knownValues() {
        EnumSet<DataCatalogStatus> knownValues = EnumSet.allOf(DataCatalogStatus.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(DataCatalogStatus.class, DataCatalogStatus::toString);
    }
}

