/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.athena.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.services.athena.model.AthenaRequest;
import software.amazon.awssdk.services.athena.model.QueryResultType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetQueryResultsRequest
extends AthenaRequest
implements ToCopyableBuilder<Builder, GetQueryResultsRequest> {
    private static final SdkField<String> QUERY_EXECUTION_ID_FIELD = SdkField.builder(MarshallingType.STRING).memberName("QueryExecutionId").getter(GetQueryResultsRequest.getter(GetQueryResultsRequest::queryExecutionId)).setter(GetQueryResultsRequest.setter(Builder::queryExecutionId)).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("QueryExecutionId").build()).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder(MarshallingType.STRING).memberName("NextToken").getter(GetQueryResultsRequest.getter(GetQueryResultsRequest::nextToken)).setter(GetQueryResultsRequest.setter(Builder::nextToken)).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();
    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.builder(MarshallingType.INTEGER).memberName("MaxResults").getter(GetQueryResultsRequest.getter(GetQueryResultsRequest::maxResults)).setter(GetQueryResultsRequest.setter(Builder::maxResults)).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxResults").build()).build();
    private static final SdkField<String> QUERY_RESULT_TYPE_FIELD = SdkField.builder(MarshallingType.STRING).memberName("QueryResultType").getter(GetQueryResultsRequest.getter(GetQueryResultsRequest::queryResultTypeAsString)).setter(GetQueryResultsRequest.setter(Builder::queryResultType)).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("QueryResultType").build()).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(QUERY_EXECUTION_ID_FIELD, NEXT_TOKEN_FIELD, MAX_RESULTS_FIELD, QUERY_RESULT_TYPE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GetQueryResultsRequest.memberNameToFieldInitializer();
    private final String queryExecutionId;
    private final String nextToken;
    private final Integer maxResults;
    private final String queryResultType;

    private GetQueryResultsRequest(BuilderImpl builder) {
        super(builder);
        this.queryExecutionId = builder.queryExecutionId;
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
        this.queryResultType = builder.queryResultType;
    }

    public final String queryExecutionId() {
        return this.queryExecutionId;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final Integer maxResults() {
        return this.maxResults;
    }

    public final QueryResultType queryResultType() {
        return QueryResultType.fromValue(this.queryResultType);
    }

    public final String queryResultTypeAsString() {
        return this.queryResultType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.queryExecutionId());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(this.queryResultTypeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetQueryResultsRequest)) {
            return false;
        }
        GetQueryResultsRequest other = (GetQueryResultsRequest)obj;
        return Objects.equals(this.queryExecutionId(), other.queryExecutionId()) && Objects.equals(this.nextToken(), other.nextToken()) && Objects.equals(this.maxResults(), other.maxResults()) && Objects.equals(this.queryResultTypeAsString(), other.queryResultTypeAsString());
    }

    public final String toString() {
        return ToString.builder("GetQueryResultsRequest").add("QueryExecutionId", this.queryExecutionId()).add("NextToken", this.nextToken()).add("MaxResults", this.maxResults()).add("QueryResultType", this.queryResultTypeAsString()).build();
    }

    @Override
    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "QueryExecutionId": {
                return Optional.ofNullable(clazz.cast(this.queryExecutionId()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "MaxResults": {
                return Optional.ofNullable(clazz.cast(this.maxResults()));
            }
            case "QueryResultType": {
                return Optional.ofNullable(clazz.cast(this.queryResultTypeAsString()));
            }
        }
        return Optional.empty();
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<Object>> map = new HashMap<String, SdkField<Object>>();
        map.put("QueryExecutionId", QUERY_EXECUTION_ID_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        map.put("MaxResults", MAX_RESULTS_FIELD);
        map.put("QueryResultType", QUERY_RESULT_TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetQueryResultsRequest, T> g) {
        return obj -> g.apply((GetQueryResultsRequest)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends AthenaRequest.BuilderImpl
    implements Builder {
        private String queryExecutionId;
        private String nextToken;
        private Integer maxResults;
        private String queryResultType;

        private BuilderImpl() {
        }

        private BuilderImpl(GetQueryResultsRequest model) {
            super(model);
            this.queryExecutionId(model.queryExecutionId);
            this.nextToken(model.nextToken);
            this.maxResults(model.maxResults);
            this.queryResultType(model.queryResultType);
        }

        public final String getQueryExecutionId() {
            return this.queryExecutionId;
        }

        public final void setQueryExecutionId(String queryExecutionId) {
            this.queryExecutionId = queryExecutionId;
        }

        @Override
        public final Builder queryExecutionId(String queryExecutionId) {
            this.queryExecutionId = queryExecutionId;
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getQueryResultType() {
            return this.queryResultType;
        }

        public final void setQueryResultType(String queryResultType) {
            this.queryResultType = queryResultType;
        }

        @Override
        public final Builder queryResultType(String queryResultType) {
            this.queryResultType = queryResultType;
            return this;
        }

        @Override
        public final Builder queryResultType(QueryResultType queryResultType) {
            this.queryResultType(queryResultType == null ? null : queryResultType.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetQueryResultsRequest build() {
            return new GetQueryResultsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends AthenaRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetQueryResultsRequest> {
        public Builder queryExecutionId(String var1);

        public Builder nextToken(String var1);

        public Builder maxResults(Integer var1);

        public Builder queryResultType(String var1);

        public Builder queryResultType(QueryResultType var1);

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

