/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.athena.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.athena.model.AthenaResponse;
import software.amazon.awssdk.services.athena.model.CalculationSummary;
import software.amazon.awssdk.services.athena.model.CalculationsListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListCalculationExecutionsResponse
extends AthenaResponse
implements ToCopyableBuilder<Builder, ListCalculationExecutionsResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder(MarshallingType.STRING).memberName("NextToken").getter(ListCalculationExecutionsResponse.getter(ListCalculationExecutionsResponse::nextToken)).setter(ListCalculationExecutionsResponse.setter(Builder::nextToken)).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();
    private static final SdkField<List<CalculationSummary>> CALCULATIONS_FIELD = SdkField.builder(MarshallingType.LIST).memberName("Calculations").getter(ListCalculationExecutionsResponse.getter(ListCalculationExecutionsResponse::calculations)).setter(ListCalculationExecutionsResponse.setter(Builder::calculations)).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Calculations").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder(MarshallingType.SDK_POJO).constructor(CalculationSummary::builder).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()).build()).build()).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD, CALCULATIONS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListCalculationExecutionsResponse.memberNameToFieldInitializer();
    private final String nextToken;
    private final List<CalculationSummary> calculations;

    private ListCalculationExecutionsResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.calculations = builder.calculations;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final boolean hasCalculations() {
        return this.calculations != null && !(this.calculations instanceof SdkAutoConstructList);
    }

    public final List<CalculationSummary> calculations() {
        return this.calculations;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasCalculations() ? this.calculations() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListCalculationExecutionsResponse)) {
            return false;
        }
        ListCalculationExecutionsResponse other = (ListCalculationExecutionsResponse)obj;
        return Objects.equals(this.nextToken(), other.nextToken()) && this.hasCalculations() == other.hasCalculations() && Objects.equals(this.calculations(), other.calculations());
    }

    public final String toString() {
        return ToString.builder("ListCalculationExecutionsResponse").add("NextToken", this.nextToken()).add("Calculations", this.hasCalculations() ? this.calculations() : null).build();
    }

    @Override
    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "Calculations": {
                return Optional.ofNullable(clazz.cast(this.calculations()));
            }
        }
        return Optional.empty();
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<Object>> map = new HashMap<String, SdkField<Object>>();
        map.put("NextToken", NEXT_TOKEN_FIELD);
        map.put("Calculations", CALCULATIONS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListCalculationExecutionsResponse, T> g) {
        return obj -> g.apply((ListCalculationExecutionsResponse)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends AthenaResponse.BuilderImpl
    implements Builder {
        private String nextToken;
        private List<CalculationSummary> calculations = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListCalculationExecutionsResponse model) {
            super(model);
            this.nextToken(model.nextToken);
            this.calculations(model.calculations);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<CalculationSummary.Builder> getCalculations() {
            List<CalculationSummary.Builder> result = CalculationsListCopier.copyToBuilder(this.calculations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setCalculations(Collection<CalculationSummary.BuilderImpl> calculations) {
            this.calculations = CalculationsListCopier.copyFromBuilder(calculations);
        }

        @Override
        public final Builder calculations(Collection<CalculationSummary> calculations) {
            this.calculations = CalculationsListCopier.copy(calculations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder calculations(CalculationSummary ... calculations) {
            this.calculations(Arrays.asList(calculations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder calculations(Consumer<CalculationSummary.Builder> ... calculations) {
            this.calculations(Stream.of(calculations).map(c -> (CalculationSummary)((CalculationSummary.Builder)CalculationSummary.builder().applyMutation(c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public ListCalculationExecutionsResponse build() {
            return new ListCalculationExecutionsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends AthenaResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListCalculationExecutionsResponse> {
        public Builder nextToken(String var1);

        public Builder calculations(Collection<CalculationSummary> var1);

        public Builder calculations(CalculationSummary ... var1);

        public Builder calculations(Consumer<CalculationSummary.Builder> ... var1);
    }
}

