/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.athena.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.athena.model.AthenaResponse;
import software.amazon.awssdk.services.athena.model.NotebookMetadata;
import software.amazon.awssdk.services.athena.model.NotebookMetadataArrayCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListNotebookMetadataResponse
extends AthenaResponse
implements ToCopyableBuilder<Builder, ListNotebookMetadataResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder(MarshallingType.STRING).memberName("NextToken").getter(ListNotebookMetadataResponse.getter(ListNotebookMetadataResponse::nextToken)).setter(ListNotebookMetadataResponse.setter(Builder::nextToken)).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();
    private static final SdkField<List<NotebookMetadata>> NOTEBOOK_METADATA_LIST_FIELD = SdkField.builder(MarshallingType.LIST).memberName("NotebookMetadataList").getter(ListNotebookMetadataResponse.getter(ListNotebookMetadataResponse::notebookMetadataList)).setter(ListNotebookMetadataResponse.setter(Builder::notebookMetadataList)).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NotebookMetadataList").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder(MarshallingType.SDK_POJO).constructor(NotebookMetadata::builder).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()).build()).build()).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD, NOTEBOOK_METADATA_LIST_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListNotebookMetadataResponse.memberNameToFieldInitializer();
    private final String nextToken;
    private final List<NotebookMetadata> notebookMetadataList;

    private ListNotebookMetadataResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.notebookMetadataList = builder.notebookMetadataList;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final boolean hasNotebookMetadataList() {
        return this.notebookMetadataList != null && !(this.notebookMetadataList instanceof SdkAutoConstructList);
    }

    public final List<NotebookMetadata> notebookMetadataList() {
        return this.notebookMetadataList;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasNotebookMetadataList() ? this.notebookMetadataList() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListNotebookMetadataResponse)) {
            return false;
        }
        ListNotebookMetadataResponse other = (ListNotebookMetadataResponse)obj;
        return Objects.equals(this.nextToken(), other.nextToken()) && this.hasNotebookMetadataList() == other.hasNotebookMetadataList() && Objects.equals(this.notebookMetadataList(), other.notebookMetadataList());
    }

    public final String toString() {
        return ToString.builder("ListNotebookMetadataResponse").add("NextToken", this.nextToken()).add("NotebookMetadataList", this.hasNotebookMetadataList() ? this.notebookMetadataList() : null).build();
    }

    @Override
    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "NotebookMetadataList": {
                return Optional.ofNullable(clazz.cast(this.notebookMetadataList()));
            }
        }
        return Optional.empty();
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<Object>> map = new HashMap<String, SdkField<Object>>();
        map.put("NextToken", NEXT_TOKEN_FIELD);
        map.put("NotebookMetadataList", NOTEBOOK_METADATA_LIST_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListNotebookMetadataResponse, T> g) {
        return obj -> g.apply((ListNotebookMetadataResponse)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends AthenaResponse.BuilderImpl
    implements Builder {
        private String nextToken;
        private List<NotebookMetadata> notebookMetadataList = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListNotebookMetadataResponse model) {
            super(model);
            this.nextToken(model.nextToken);
            this.notebookMetadataList(model.notebookMetadataList);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<NotebookMetadata.Builder> getNotebookMetadataList() {
            List<NotebookMetadata.Builder> result = NotebookMetadataArrayCopier.copyToBuilder(this.notebookMetadataList);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setNotebookMetadataList(Collection<NotebookMetadata.BuilderImpl> notebookMetadataList) {
            this.notebookMetadataList = NotebookMetadataArrayCopier.copyFromBuilder(notebookMetadataList);
        }

        @Override
        public final Builder notebookMetadataList(Collection<NotebookMetadata> notebookMetadataList) {
            this.notebookMetadataList = NotebookMetadataArrayCopier.copy(notebookMetadataList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder notebookMetadataList(NotebookMetadata ... notebookMetadataList) {
            this.notebookMetadataList(Arrays.asList(notebookMetadataList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder notebookMetadataList(Consumer<NotebookMetadata.Builder> ... notebookMetadataList) {
            this.notebookMetadataList(Stream.of(notebookMetadataList).map(c -> (NotebookMetadata)((NotebookMetadata.Builder)NotebookMetadata.builder().applyMutation(c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public ListNotebookMetadataResponse build() {
            return new ListNotebookMetadataResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends AthenaResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListNotebookMetadataResponse> {
        public Builder nextToken(String var1);

        public Builder notebookMetadataList(Collection<NotebookMetadata> var1);

        public Builder notebookMetadataList(NotebookMetadata ... var1);

        public Builder notebookMetadataList(Consumer<NotebookMetadata.Builder> ... var1);
    }
}

