/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.athena.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.athena.model.AthenaResponse;
import software.amazon.awssdk.services.athena.model.QueryExecutionIdListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListQueryExecutionsResponse
extends AthenaResponse
implements ToCopyableBuilder<Builder, ListQueryExecutionsResponse> {
    private static final SdkField<List<String>> QUERY_EXECUTION_IDS_FIELD = SdkField.builder(MarshallingType.LIST).memberName("QueryExecutionIds").getter(ListQueryExecutionsResponse.getter(ListQueryExecutionsResponse::queryExecutionIds)).setter(ListQueryExecutionsResponse.setter(Builder::queryExecutionIds)).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("QueryExecutionIds").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder(MarshallingType.STRING).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()).build()).build()).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder(MarshallingType.STRING).memberName("NextToken").getter(ListQueryExecutionsResponse.getter(ListQueryExecutionsResponse::nextToken)).setter(ListQueryExecutionsResponse.setter(Builder::nextToken)).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(QUERY_EXECUTION_IDS_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListQueryExecutionsResponse.memberNameToFieldInitializer();
    private final List<String> queryExecutionIds;
    private final String nextToken;

    private ListQueryExecutionsResponse(BuilderImpl builder) {
        super(builder);
        this.queryExecutionIds = builder.queryExecutionIds;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasQueryExecutionIds() {
        return this.queryExecutionIds != null && !(this.queryExecutionIds instanceof SdkAutoConstructList);
    }

    public final List<String> queryExecutionIds() {
        return this.queryExecutionIds;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasQueryExecutionIds() ? this.queryExecutionIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListQueryExecutionsResponse)) {
            return false;
        }
        ListQueryExecutionsResponse other = (ListQueryExecutionsResponse)obj;
        return this.hasQueryExecutionIds() == other.hasQueryExecutionIds() && Objects.equals(this.queryExecutionIds(), other.queryExecutionIds()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder("ListQueryExecutionsResponse").add("QueryExecutionIds", this.hasQueryExecutionIds() ? this.queryExecutionIds() : null).add("NextToken", this.nextToken()).build();
    }

    @Override
    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "QueryExecutionIds": {
                return Optional.ofNullable(clazz.cast(this.queryExecutionIds()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<Object>> map = new HashMap<String, SdkField<Object>>();
        map.put("QueryExecutionIds", QUERY_EXECUTION_IDS_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListQueryExecutionsResponse, T> g) {
        return obj -> g.apply((ListQueryExecutionsResponse)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends AthenaResponse.BuilderImpl
    implements Builder {
        private List<String> queryExecutionIds = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListQueryExecutionsResponse model) {
            super(model);
            this.queryExecutionIds(model.queryExecutionIds);
            this.nextToken(model.nextToken);
        }

        public final Collection<String> getQueryExecutionIds() {
            if (this.queryExecutionIds instanceof SdkAutoConstructList) {
                return null;
            }
            return this.queryExecutionIds;
        }

        public final void setQueryExecutionIds(Collection<String> queryExecutionIds) {
            this.queryExecutionIds = QueryExecutionIdListCopier.copy(queryExecutionIds);
        }

        @Override
        public final Builder queryExecutionIds(Collection<String> queryExecutionIds) {
            this.queryExecutionIds = QueryExecutionIdListCopier.copy(queryExecutionIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder queryExecutionIds(String ... queryExecutionIds) {
            this.queryExecutionIds(Arrays.asList(queryExecutionIds));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListQueryExecutionsResponse build() {
            return new ListQueryExecutionsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends AthenaResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListQueryExecutionsResponse> {
        public Builder queryExecutionIds(Collection<String> var1);

        public Builder queryExecutionIds(String ... var1);

        public Builder nextToken(String var1);
    }
}

