/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.athena.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.services.athena.model.NotebookType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class NotebookMetadata
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, NotebookMetadata> {
    private static final SdkField<String> NOTEBOOK_ID_FIELD = SdkField.builder(MarshallingType.STRING).memberName("NotebookId").getter(NotebookMetadata.getter(NotebookMetadata::notebookId)).setter(NotebookMetadata.setter(Builder::notebookId)).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NotebookId").build()).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder(MarshallingType.STRING).memberName("Name").getter(NotebookMetadata.getter(NotebookMetadata::name)).setter(NotebookMetadata.setter(Builder::name)).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();
    private static final SdkField<String> WORK_GROUP_FIELD = SdkField.builder(MarshallingType.STRING).memberName("WorkGroup").getter(NotebookMetadata.getter(NotebookMetadata::workGroup)).setter(NotebookMetadata.setter(Builder::workGroup)).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WorkGroup").build()).build();
    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.builder(MarshallingType.INSTANT).memberName("CreationTime").getter(NotebookMetadata.getter(NotebookMetadata::creationTime)).setter(NotebookMetadata.setter(Builder::creationTime)).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime").build()).build();
    private static final SdkField<String> TYPE_FIELD = SdkField.builder(MarshallingType.STRING).memberName("Type").getter(NotebookMetadata.getter(NotebookMetadata::typeAsString)).setter(NotebookMetadata.setter(Builder::type)).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()).build();
    private static final SdkField<Instant> LAST_MODIFIED_TIME_FIELD = SdkField.builder(MarshallingType.INSTANT).memberName("LastModifiedTime").getter(NotebookMetadata.getter(NotebookMetadata::lastModifiedTime)).setter(NotebookMetadata.setter(Builder::lastModifiedTime)).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModifiedTime").build()).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NOTEBOOK_ID_FIELD, NAME_FIELD, WORK_GROUP_FIELD, CREATION_TIME_FIELD, TYPE_FIELD, LAST_MODIFIED_TIME_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = NotebookMetadata.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String notebookId;
    private final String name;
    private final String workGroup;
    private final Instant creationTime;
    private final String type;
    private final Instant lastModifiedTime;

    private NotebookMetadata(BuilderImpl builder) {
        this.notebookId = builder.notebookId;
        this.name = builder.name;
        this.workGroup = builder.workGroup;
        this.creationTime = builder.creationTime;
        this.type = builder.type;
        this.lastModifiedTime = builder.lastModifiedTime;
    }

    public final String notebookId() {
        return this.notebookId;
    }

    public final String name() {
        return this.name;
    }

    public final String workGroup() {
        return this.workGroup;
    }

    public final Instant creationTime() {
        return this.creationTime;
    }

    public final NotebookType type() {
        return NotebookType.fromValue(this.type);
    }

    public final String typeAsString() {
        return this.type;
    }

    public final Instant lastModifiedTime() {
        return this.lastModifiedTime;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.notebookId());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.workGroup());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastModifiedTime());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof NotebookMetadata)) {
            return false;
        }
        NotebookMetadata other = (NotebookMetadata)obj;
        return Objects.equals(this.notebookId(), other.notebookId()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.workGroup(), other.workGroup()) && Objects.equals(this.creationTime(), other.creationTime()) && Objects.equals(this.typeAsString(), other.typeAsString()) && Objects.equals(this.lastModifiedTime(), other.lastModifiedTime());
    }

    public final String toString() {
        return ToString.builder("NotebookMetadata").add("NotebookId", this.notebookId()).add("Name", this.name()).add("WorkGroup", this.workGroup()).add("CreationTime", this.creationTime()).add("Type", this.typeAsString()).add("LastModifiedTime", this.lastModifiedTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "NotebookId": {
                return Optional.ofNullable(clazz.cast(this.notebookId()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "WorkGroup": {
                return Optional.ofNullable(clazz.cast(this.workGroup()));
            }
            case "CreationTime": {
                return Optional.ofNullable(clazz.cast(this.creationTime()));
            }
            case "Type": {
                return Optional.ofNullable(clazz.cast(this.typeAsString()));
            }
            case "LastModifiedTime": {
                return Optional.ofNullable(clazz.cast(this.lastModifiedTime()));
            }
        }
        return Optional.empty();
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<Object>> map = new HashMap<String, SdkField<Object>>();
        map.put("NotebookId", NOTEBOOK_ID_FIELD);
        map.put("Name", NAME_FIELD);
        map.put("WorkGroup", WORK_GROUP_FIELD);
        map.put("CreationTime", CREATION_TIME_FIELD);
        map.put("Type", TYPE_FIELD);
        map.put("LastModifiedTime", LAST_MODIFIED_TIME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<NotebookMetadata, T> g) {
        return obj -> g.apply((NotebookMetadata)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String notebookId;
        private String name;
        private String workGroup;
        private Instant creationTime;
        private String type;
        private Instant lastModifiedTime;

        private BuilderImpl() {
        }

        private BuilderImpl(NotebookMetadata model) {
            this.notebookId(model.notebookId);
            this.name(model.name);
            this.workGroup(model.workGroup);
            this.creationTime(model.creationTime);
            this.type(model.type);
            this.lastModifiedTime(model.lastModifiedTime);
        }

        public final String getNotebookId() {
            return this.notebookId;
        }

        public final void setNotebookId(String notebookId) {
            this.notebookId = notebookId;
        }

        @Override
        public final Builder notebookId(String notebookId) {
            this.notebookId = notebookId;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getWorkGroup() {
            return this.workGroup;
        }

        public final void setWorkGroup(String workGroup) {
            this.workGroup = workGroup;
        }

        @Override
        public final Builder workGroup(String workGroup) {
            this.workGroup = workGroup;
            return this;
        }

        public final Instant getCreationTime() {
            return this.creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final String getType() {
            return this.type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(NotebookType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final Instant getLastModifiedTime() {
            return this.lastModifiedTime;
        }

        public final void setLastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
        }

        @Override
        public final Builder lastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
            return this;
        }

        @Override
        public NotebookMetadata build() {
            return new NotebookMetadata(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, NotebookMetadata> {
        public Builder notebookId(String var1);

        public Builder name(String var1);

        public Builder workGroup(String var1);

        public Builder creationTime(Instant var1);

        public Builder type(String var1);

        public Builder type(NotebookType var1);

        public Builder lastModifiedTime(Instant var1);
    }
}

