/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.athena.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.services.athena.model.AthenaRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateCapacityReservationRequest
extends AthenaRequest
implements ToCopyableBuilder<Builder, UpdateCapacityReservationRequest> {
    private static final SdkField<Integer> TARGET_DPUS_FIELD = SdkField.builder(MarshallingType.INTEGER).memberName("TargetDpus").getter(UpdateCapacityReservationRequest.getter(UpdateCapacityReservationRequest::targetDpus)).setter(UpdateCapacityReservationRequest.setter(Builder::targetDpus)).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetDpus").build()).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder(MarshallingType.STRING).memberName("Name").getter(UpdateCapacityReservationRequest.getter(UpdateCapacityReservationRequest::name)).setter(UpdateCapacityReservationRequest.setter(Builder::name)).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TARGET_DPUS_FIELD, NAME_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = UpdateCapacityReservationRequest.memberNameToFieldInitializer();
    private final Integer targetDpus;
    private final String name;

    private UpdateCapacityReservationRequest(BuilderImpl builder) {
        super(builder);
        this.targetDpus = builder.targetDpus;
        this.name = builder.name;
    }

    public final Integer targetDpus() {
        return this.targetDpus;
    }

    public final String name() {
        return this.name;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.targetDpus());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateCapacityReservationRequest)) {
            return false;
        }
        UpdateCapacityReservationRequest other = (UpdateCapacityReservationRequest)obj;
        return Objects.equals(this.targetDpus(), other.targetDpus()) && Objects.equals(this.name(), other.name());
    }

    public final String toString() {
        return ToString.builder("UpdateCapacityReservationRequest").add("TargetDpus", this.targetDpus()).add("Name", this.name()).build();
    }

    @Override
    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "TargetDpus": {
                return Optional.ofNullable(clazz.cast(this.targetDpus()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
        }
        return Optional.empty();
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<Object>> map = new HashMap<String, SdkField<Object>>();
        map.put("TargetDpus", TARGET_DPUS_FIELD);
        map.put("Name", NAME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateCapacityReservationRequest, T> g) {
        return obj -> g.apply((UpdateCapacityReservationRequest)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends AthenaRequest.BuilderImpl
    implements Builder {
        private Integer targetDpus;
        private String name;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateCapacityReservationRequest model) {
            super(model);
            this.targetDpus(model.targetDpus);
            this.name(model.name);
        }

        public final Integer getTargetDpus() {
            return this.targetDpus;
        }

        public final void setTargetDpus(Integer targetDpus) {
            this.targetDpus = targetDpus;
        }

        @Override
        public final Builder targetDpus(Integer targetDpus) {
            this.targetDpus = targetDpus;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateCapacityReservationRequest build() {
            return new UpdateCapacityReservationRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends AthenaRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateCapacityReservationRequest> {
        public Builder targetDpus(Integer var1);

        public Builder name(String var1);

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

