/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.athena.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.athena.AthenaClient;
import software.amazon.awssdk.services.athena.internal.UserAgentUtils;
import software.amazon.awssdk.services.athena.model.ListExecutorsRequest;
import software.amazon.awssdk.services.athena.model.ListExecutorsResponse;

public class ListExecutorsIterable
implements SdkIterable<ListExecutorsResponse> {
    private final AthenaClient client;
    private final ListExecutorsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListExecutorsIterable(AthenaClient client, ListExecutorsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListExecutorsResponseFetcher();
    }

    @Override
    public Iterator<ListExecutorsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class ListExecutorsResponseFetcher
    implements SyncPageFetcher<ListExecutorsResponse> {
        private ListExecutorsResponseFetcher() {
        }

        @Override
        public boolean hasNextPage(ListExecutorsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable(previousPage.nextToken());
        }

        @Override
        public ListExecutorsResponse nextPage(ListExecutorsResponse previousPage) {
            if (previousPage == null) {
                return ListExecutorsIterable.this.client.listExecutors(ListExecutorsIterable.this.firstRequest);
            }
            return ListExecutorsIterable.this.client.listExecutors((ListExecutorsRequest)ListExecutorsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build());
        }
    }
}

