/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.athena.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.athena.AthenaClient;
import software.amazon.awssdk.services.athena.internal.UserAgentUtils;
import software.amazon.awssdk.services.athena.model.ListWorkGroupsRequest;
import software.amazon.awssdk.services.athena.model.ListWorkGroupsResponse;

public class ListWorkGroupsIterable
implements SdkIterable<ListWorkGroupsResponse> {
    private final AthenaClient client;
    private final ListWorkGroupsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListWorkGroupsIterable(AthenaClient client, ListWorkGroupsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListWorkGroupsResponseFetcher();
    }

    @Override
    public Iterator<ListWorkGroupsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class ListWorkGroupsResponseFetcher
    implements SyncPageFetcher<ListWorkGroupsResponse> {
        private ListWorkGroupsResponseFetcher() {
        }

        @Override
        public boolean hasNextPage(ListWorkGroupsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable(previousPage.nextToken());
        }

        @Override
        public ListWorkGroupsResponse nextPage(ListWorkGroupsResponse previousPage) {
            if (previousPage == null) {
                return ListWorkGroupsIterable.this.client.listWorkGroups(ListWorkGroupsIterable.this.firstRequest);
            }
            return ListWorkGroupsIterable.this.client.listWorkGroups((ListWorkGroupsRequest)ListWorkGroupsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build());
        }
    }
}

