/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.athenastreaming;

import java.nio.file.Path;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.AwsClient;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.ResponseBytes;
import software.amazon.awssdk.core.ResponseInputStream;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.sync.ResponseTransformer;
import software.amazon.awssdk.regions.ServiceMetadata;
import software.amazon.awssdk.services.athenastreaming.AthenaStreamingClientBuilder;
import software.amazon.awssdk.services.athenastreaming.AthenaStreamingServiceClientConfiguration;
import software.amazon.awssdk.services.athenastreaming.DefaultAthenaStreamingClientBuilder;
import software.amazon.awssdk.services.athenastreaming.model.AthenaStreamingException;
import software.amazon.awssdk.services.athenastreaming.model.GetQueryResultsStreamRequest;
import software.amazon.awssdk.services.athenastreaming.model.GetQueryResultsStreamResponse;
import software.amazon.awssdk.services.athenastreaming.model.InternalServerException;
import software.amazon.awssdk.services.athenastreaming.model.InvalidRequestException;
import software.amazon.awssdk.services.athenastreaming.model.TooManyRequestsException;

@SdkPublicApi
@ThreadSafe
public interface AthenaStreamingClient
extends AwsClient {
    public static final String SERVICE_NAME = "athena";
    public static final String SERVICE_METADATA_ID = "athenastreaming";

    default public <ReturnT> ReturnT getQueryResultsStream(GetQueryResultsStreamRequest getQueryResultsStreamRequest, ResponseTransformer<GetQueryResultsStreamResponse, ReturnT> responseTransformer) throws InternalServerException, InvalidRequestException, TooManyRequestsException, AwsServiceException, SdkClientException, AthenaStreamingException {
        throw new UnsupportedOperationException();
    }

    default public <ReturnT> ReturnT getQueryResultsStream(Consumer<GetQueryResultsStreamRequest.Builder> getQueryResultsStreamRequest, ResponseTransformer<GetQueryResultsStreamResponse, ReturnT> responseTransformer) throws InternalServerException, InvalidRequestException, TooManyRequestsException, AwsServiceException, SdkClientException, AthenaStreamingException {
        return this.getQueryResultsStream((GetQueryResultsStreamRequest)GetQueryResultsStreamRequest.builder().applyMutation(getQueryResultsStreamRequest).build(), responseTransformer);
    }

    default public GetQueryResultsStreamResponse getQueryResultsStream(GetQueryResultsStreamRequest getQueryResultsStreamRequest, Path destinationPath) throws InternalServerException, InvalidRequestException, TooManyRequestsException, AwsServiceException, SdkClientException, AthenaStreamingException {
        return (GetQueryResultsStreamResponse)this.getQueryResultsStream(getQueryResultsStreamRequest, ResponseTransformer.toFile(destinationPath));
    }

    default public GetQueryResultsStreamResponse getQueryResultsStream(Consumer<GetQueryResultsStreamRequest.Builder> getQueryResultsStreamRequest, Path destinationPath) throws InternalServerException, InvalidRequestException, TooManyRequestsException, AwsServiceException, SdkClientException, AthenaStreamingException {
        return this.getQueryResultsStream((GetQueryResultsStreamRequest)GetQueryResultsStreamRequest.builder().applyMutation(getQueryResultsStreamRequest).build(), destinationPath);
    }

    default public ResponseInputStream<GetQueryResultsStreamResponse> getQueryResultsStream(GetQueryResultsStreamRequest getQueryResultsStreamRequest) throws InternalServerException, InvalidRequestException, TooManyRequestsException, AwsServiceException, SdkClientException, AthenaStreamingException {
        return this.getQueryResultsStream(getQueryResultsStreamRequest, ResponseTransformer.toInputStream());
    }

    default public ResponseInputStream<GetQueryResultsStreamResponse> getQueryResultsStream(Consumer<GetQueryResultsStreamRequest.Builder> getQueryResultsStreamRequest) throws InternalServerException, InvalidRequestException, TooManyRequestsException, AwsServiceException, SdkClientException, AthenaStreamingException {
        return this.getQueryResultsStream((GetQueryResultsStreamRequest)GetQueryResultsStreamRequest.builder().applyMutation(getQueryResultsStreamRequest).build());
    }

    default public ResponseBytes<GetQueryResultsStreamResponse> getQueryResultsStreamAsBytes(GetQueryResultsStreamRequest getQueryResultsStreamRequest) throws InternalServerException, InvalidRequestException, TooManyRequestsException, AwsServiceException, SdkClientException, AthenaStreamingException {
        return this.getQueryResultsStream(getQueryResultsStreamRequest, ResponseTransformer.toBytes());
    }

    default public ResponseBytes<GetQueryResultsStreamResponse> getQueryResultsStreamAsBytes(Consumer<GetQueryResultsStreamRequest.Builder> getQueryResultsStreamRequest) throws InternalServerException, InvalidRequestException, TooManyRequestsException, AwsServiceException, SdkClientException, AthenaStreamingException {
        return this.getQueryResultsStreamAsBytes((GetQueryResultsStreamRequest)GetQueryResultsStreamRequest.builder().applyMutation(getQueryResultsStreamRequest).build());
    }

    public static AthenaStreamingClient create() {
        return (AthenaStreamingClient)AthenaStreamingClient.builder().build();
    }

    public static AthenaStreamingClientBuilder builder() {
        return new DefaultAthenaStreamingClientBuilder();
    }

    public static ServiceMetadata serviceMetadata() {
        return ServiceMetadata.of(SERVICE_METADATA_ID);
    }

    @Override
    default public AthenaStreamingServiceClientConfiguration serviceClientConfiguration() {
        throw new UnsupportedOperationException();
    }
}

