/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.datazone.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.datazone.model.AssociateGovernedTermsInputGovernedGlossaryTermsListCopier;
import software.amazon.awssdk.services.datazone.model.DataZoneRequest;
import software.amazon.awssdk.services.datazone.model.GovernedEntityType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AssociateGovernedTermsRequest
extends DataZoneRequest
implements ToCopyableBuilder<Builder, AssociateGovernedTermsRequest> {
    private static final SdkField<String> DOMAIN_IDENTIFIER_FIELD = SdkField.builder(MarshallingType.STRING).memberName("domainIdentifier").getter(AssociateGovernedTermsRequest.getter(AssociateGovernedTermsRequest::domainIdentifier)).setter(AssociateGovernedTermsRequest.setter(Builder::domainIdentifier)).traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("domainIdentifier").build()).build();
    private static final SdkField<String> ENTITY_IDENTIFIER_FIELD = SdkField.builder(MarshallingType.STRING).memberName("entityIdentifier").getter(AssociateGovernedTermsRequest.getter(AssociateGovernedTermsRequest::entityIdentifier)).setter(AssociateGovernedTermsRequest.setter(Builder::entityIdentifier)).traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("entityIdentifier").build()).build();
    private static final SdkField<String> ENTITY_TYPE_FIELD = SdkField.builder(MarshallingType.STRING).memberName("entityType").getter(AssociateGovernedTermsRequest.getter(AssociateGovernedTermsRequest::entityTypeAsString)).setter(AssociateGovernedTermsRequest.setter(Builder::entityType)).traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("entityType").build()).build();
    private static final SdkField<List<String>> GOVERNED_GLOSSARY_TERMS_FIELD = SdkField.builder(MarshallingType.LIST).memberName("governedGlossaryTerms").getter(AssociateGovernedTermsRequest.getter(AssociateGovernedTermsRequest::governedGlossaryTerms)).setter(AssociateGovernedTermsRequest.setter(Builder::governedGlossaryTerms)).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("governedGlossaryTerms").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder(MarshallingType.STRING).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()).build()).build()).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DOMAIN_IDENTIFIER_FIELD, ENTITY_IDENTIFIER_FIELD, ENTITY_TYPE_FIELD, GOVERNED_GLOSSARY_TERMS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = AssociateGovernedTermsRequest.memberNameToFieldInitializer();
    private final String domainIdentifier;
    private final String entityIdentifier;
    private final String entityType;
    private final List<String> governedGlossaryTerms;

    private AssociateGovernedTermsRequest(BuilderImpl builder) {
        super(builder);
        this.domainIdentifier = builder.domainIdentifier;
        this.entityIdentifier = builder.entityIdentifier;
        this.entityType = builder.entityType;
        this.governedGlossaryTerms = builder.governedGlossaryTerms;
    }

    public final String domainIdentifier() {
        return this.domainIdentifier;
    }

    public final String entityIdentifier() {
        return this.entityIdentifier;
    }

    public final GovernedEntityType entityType() {
        return GovernedEntityType.fromValue(this.entityType);
    }

    public final String entityTypeAsString() {
        return this.entityType;
    }

    public final boolean hasGovernedGlossaryTerms() {
        return this.governedGlossaryTerms != null && !(this.governedGlossaryTerms instanceof SdkAutoConstructList);
    }

    public final List<String> governedGlossaryTerms() {
        return this.governedGlossaryTerms;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.domainIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.entityIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.entityTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasGovernedGlossaryTerms() ? this.governedGlossaryTerms() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AssociateGovernedTermsRequest)) {
            return false;
        }
        AssociateGovernedTermsRequest other = (AssociateGovernedTermsRequest)obj;
        return Objects.equals(this.domainIdentifier(), other.domainIdentifier()) && Objects.equals(this.entityIdentifier(), other.entityIdentifier()) && Objects.equals(this.entityTypeAsString(), other.entityTypeAsString()) && this.hasGovernedGlossaryTerms() == other.hasGovernedGlossaryTerms() && Objects.equals(this.governedGlossaryTerms(), other.governedGlossaryTerms());
    }

    public final String toString() {
        return ToString.builder("AssociateGovernedTermsRequest").add("DomainIdentifier", this.domainIdentifier()).add("EntityIdentifier", this.entityIdentifier()).add("EntityType", this.entityTypeAsString()).add("GovernedGlossaryTerms", this.hasGovernedGlossaryTerms() ? this.governedGlossaryTerms() : null).build();
    }

    @Override
    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "domainIdentifier": {
                return Optional.ofNullable(clazz.cast(this.domainIdentifier()));
            }
            case "entityIdentifier": {
                return Optional.ofNullable(clazz.cast(this.entityIdentifier()));
            }
            case "entityType": {
                return Optional.ofNullable(clazz.cast(this.entityTypeAsString()));
            }
            case "governedGlossaryTerms": {
                return Optional.ofNullable(clazz.cast(this.governedGlossaryTerms()));
            }
        }
        return Optional.empty();
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<Object>> map = new HashMap<String, SdkField<Object>>();
        map.put("domainIdentifier", DOMAIN_IDENTIFIER_FIELD);
        map.put("entityIdentifier", ENTITY_IDENTIFIER_FIELD);
        map.put("entityType", ENTITY_TYPE_FIELD);
        map.put("governedGlossaryTerms", GOVERNED_GLOSSARY_TERMS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AssociateGovernedTermsRequest, T> g) {
        return obj -> g.apply((AssociateGovernedTermsRequest)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends DataZoneRequest.BuilderImpl
    implements Builder {
        private String domainIdentifier;
        private String entityIdentifier;
        private String entityType;
        private List<String> governedGlossaryTerms = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(AssociateGovernedTermsRequest model) {
            super(model);
            this.domainIdentifier(model.domainIdentifier);
            this.entityIdentifier(model.entityIdentifier);
            this.entityType(model.entityType);
            this.governedGlossaryTerms(model.governedGlossaryTerms);
        }

        public final String getDomainIdentifier() {
            return this.domainIdentifier;
        }

        public final void setDomainIdentifier(String domainIdentifier) {
            this.domainIdentifier = domainIdentifier;
        }

        @Override
        public final Builder domainIdentifier(String domainIdentifier) {
            this.domainIdentifier = domainIdentifier;
            return this;
        }

        public final String getEntityIdentifier() {
            return this.entityIdentifier;
        }

        public final void setEntityIdentifier(String entityIdentifier) {
            this.entityIdentifier = entityIdentifier;
        }

        @Override
        public final Builder entityIdentifier(String entityIdentifier) {
            this.entityIdentifier = entityIdentifier;
            return this;
        }

        public final String getEntityType() {
            return this.entityType;
        }

        public final void setEntityType(String entityType) {
            this.entityType = entityType;
        }

        @Override
        public final Builder entityType(String entityType) {
            this.entityType = entityType;
            return this;
        }

        @Override
        public final Builder entityType(GovernedEntityType entityType) {
            this.entityType(entityType == null ? null : entityType.toString());
            return this;
        }

        public final Collection<String> getGovernedGlossaryTerms() {
            if (this.governedGlossaryTerms instanceof SdkAutoConstructList) {
                return null;
            }
            return this.governedGlossaryTerms;
        }

        public final void setGovernedGlossaryTerms(Collection<String> governedGlossaryTerms) {
            this.governedGlossaryTerms = AssociateGovernedTermsInputGovernedGlossaryTermsListCopier.copy(governedGlossaryTerms);
        }

        @Override
        public final Builder governedGlossaryTerms(Collection<String> governedGlossaryTerms) {
            this.governedGlossaryTerms = AssociateGovernedTermsInputGovernedGlossaryTermsListCopier.copy(governedGlossaryTerms);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder governedGlossaryTerms(String ... governedGlossaryTerms) {
            this.governedGlossaryTerms(Arrays.asList(governedGlossaryTerms));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public AssociateGovernedTermsRequest build() {
            return new AssociateGovernedTermsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends DataZoneRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, AssociateGovernedTermsRequest> {
        public Builder domainIdentifier(String var1);

        public Builder entityIdentifier(String var1);

        public Builder entityType(String var1);

        public Builder entityType(GovernedEntityType var1);

        public Builder governedGlossaryTerms(Collection<String> var1);

        public Builder governedGlossaryTerms(String ... var1);

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

