/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.datazone.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.datazone.model.AuthenticationType;
import software.amazon.awssdk.services.datazone.model.BasicAuthenticationCredentials;
import software.amazon.awssdk.services.datazone.model.CredentialMapCopier;
import software.amazon.awssdk.services.datazone.model.OAuth2Properties;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AuthenticationConfigurationInput
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AuthenticationConfigurationInput> {
    private static final SdkField<String> AUTHENTICATION_TYPE_FIELD = SdkField.builder(MarshallingType.STRING).memberName("authenticationType").getter(AuthenticationConfigurationInput.getter(AuthenticationConfigurationInput::authenticationTypeAsString)).setter(AuthenticationConfigurationInput.setter(Builder::authenticationType)).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("authenticationType").build()).build();
    private static final SdkField<BasicAuthenticationCredentials> BASIC_AUTHENTICATION_CREDENTIALS_FIELD = SdkField.builder(MarshallingType.SDK_POJO).memberName("basicAuthenticationCredentials").getter(AuthenticationConfigurationInput.getter(AuthenticationConfigurationInput::basicAuthenticationCredentials)).setter(AuthenticationConfigurationInput.setter(Builder::basicAuthenticationCredentials)).constructor(BasicAuthenticationCredentials::builder).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("basicAuthenticationCredentials").build()).build();
    private static final SdkField<Map<String, String>> CUSTOM_AUTHENTICATION_CREDENTIALS_FIELD = SdkField.builder(MarshallingType.MAP).memberName("customAuthenticationCredentials").getter(AuthenticationConfigurationInput.getter(AuthenticationConfigurationInput::customAuthenticationCredentials)).setter(AuthenticationConfigurationInput.setter(Builder::customAuthenticationCredentials)).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("customAuthenticationCredentials").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder(MarshallingType.STRING).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()).build()).build()).build();
    private static final SdkField<String> KMS_KEY_ARN_FIELD = SdkField.builder(MarshallingType.STRING).memberName("kmsKeyArn").getter(AuthenticationConfigurationInput.getter(AuthenticationConfigurationInput::kmsKeyArn)).setter(AuthenticationConfigurationInput.setter(Builder::kmsKeyArn)).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("kmsKeyArn").build()).build();
    private static final SdkField<OAuth2Properties> O_AUTH2_PROPERTIES_FIELD = SdkField.builder(MarshallingType.SDK_POJO).memberName("oAuth2Properties").getter(AuthenticationConfigurationInput.getter(AuthenticationConfigurationInput::oAuth2Properties)).setter(AuthenticationConfigurationInput.setter(Builder::oAuth2Properties)).constructor(OAuth2Properties::builder).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("oAuth2Properties").build()).build();
    private static final SdkField<String> SECRET_ARN_FIELD = SdkField.builder(MarshallingType.STRING).memberName("secretArn").getter(AuthenticationConfigurationInput.getter(AuthenticationConfigurationInput::secretArn)).setter(AuthenticationConfigurationInput.setter(Builder::secretArn)).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("secretArn").build()).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AUTHENTICATION_TYPE_FIELD, BASIC_AUTHENTICATION_CREDENTIALS_FIELD, CUSTOM_AUTHENTICATION_CREDENTIALS_FIELD, KMS_KEY_ARN_FIELD, O_AUTH2_PROPERTIES_FIELD, SECRET_ARN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = AuthenticationConfigurationInput.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String authenticationType;
    private final BasicAuthenticationCredentials basicAuthenticationCredentials;
    private final Map<String, String> customAuthenticationCredentials;
    private final String kmsKeyArn;
    private final OAuth2Properties oAuth2Properties;
    private final String secretArn;

    private AuthenticationConfigurationInput(BuilderImpl builder) {
        this.authenticationType = builder.authenticationType;
        this.basicAuthenticationCredentials = builder.basicAuthenticationCredentials;
        this.customAuthenticationCredentials = builder.customAuthenticationCredentials;
        this.kmsKeyArn = builder.kmsKeyArn;
        this.oAuth2Properties = builder.oAuth2Properties;
        this.secretArn = builder.secretArn;
    }

    public final AuthenticationType authenticationType() {
        return AuthenticationType.fromValue(this.authenticationType);
    }

    public final String authenticationTypeAsString() {
        return this.authenticationType;
    }

    public final BasicAuthenticationCredentials basicAuthenticationCredentials() {
        return this.basicAuthenticationCredentials;
    }

    public final boolean hasCustomAuthenticationCredentials() {
        return this.customAuthenticationCredentials != null && !(this.customAuthenticationCredentials instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> customAuthenticationCredentials() {
        return this.customAuthenticationCredentials;
    }

    public final String kmsKeyArn() {
        return this.kmsKeyArn;
    }

    public final OAuth2Properties oAuth2Properties() {
        return this.oAuth2Properties;
    }

    public final String secretArn() {
        return this.secretArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.authenticationTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.basicAuthenticationCredentials());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasCustomAuthenticationCredentials() ? this.customAuthenticationCredentials() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.kmsKeyArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.oAuth2Properties());
        hashCode = 31 * hashCode + Objects.hashCode(this.secretArn());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AuthenticationConfigurationInput)) {
            return false;
        }
        AuthenticationConfigurationInput other = (AuthenticationConfigurationInput)obj;
        return Objects.equals(this.authenticationTypeAsString(), other.authenticationTypeAsString()) && Objects.equals(this.basicAuthenticationCredentials(), other.basicAuthenticationCredentials()) && this.hasCustomAuthenticationCredentials() == other.hasCustomAuthenticationCredentials() && Objects.equals(this.customAuthenticationCredentials(), other.customAuthenticationCredentials()) && Objects.equals(this.kmsKeyArn(), other.kmsKeyArn()) && Objects.equals(this.oAuth2Properties(), other.oAuth2Properties()) && Objects.equals(this.secretArn(), other.secretArn());
    }

    public final String toString() {
        return ToString.builder("AuthenticationConfigurationInput").add("AuthenticationType", this.authenticationTypeAsString()).add("BasicAuthenticationCredentials", this.basicAuthenticationCredentials() == null ? null : "*** Sensitive Data Redacted ***").add("CustomAuthenticationCredentials", this.customAuthenticationCredentials() == null ? null : "*** Sensitive Data Redacted ***").add("KmsKeyArn", this.kmsKeyArn()).add("OAuth2Properties", this.oAuth2Properties()).add("SecretArn", this.secretArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "authenticationType": {
                return Optional.ofNullable(clazz.cast(this.authenticationTypeAsString()));
            }
            case "basicAuthenticationCredentials": {
                return Optional.ofNullable(clazz.cast(this.basicAuthenticationCredentials()));
            }
            case "customAuthenticationCredentials": {
                return Optional.ofNullable(clazz.cast(this.customAuthenticationCredentials()));
            }
            case "kmsKeyArn": {
                return Optional.ofNullable(clazz.cast(this.kmsKeyArn()));
            }
            case "oAuth2Properties": {
                return Optional.ofNullable(clazz.cast(this.oAuth2Properties()));
            }
            case "secretArn": {
                return Optional.ofNullable(clazz.cast(this.secretArn()));
            }
        }
        return Optional.empty();
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<Object>> map = new HashMap<String, SdkField<Object>>();
        map.put("authenticationType", AUTHENTICATION_TYPE_FIELD);
        map.put("basicAuthenticationCredentials", BASIC_AUTHENTICATION_CREDENTIALS_FIELD);
        map.put("customAuthenticationCredentials", CUSTOM_AUTHENTICATION_CREDENTIALS_FIELD);
        map.put("kmsKeyArn", KMS_KEY_ARN_FIELD);
        map.put("oAuth2Properties", O_AUTH2_PROPERTIES_FIELD);
        map.put("secretArn", SECRET_ARN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AuthenticationConfigurationInput, T> g) {
        return obj -> g.apply((AuthenticationConfigurationInput)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String authenticationType;
        private BasicAuthenticationCredentials basicAuthenticationCredentials;
        private Map<String, String> customAuthenticationCredentials = DefaultSdkAutoConstructMap.getInstance();
        private String kmsKeyArn;
        private OAuth2Properties oAuth2Properties;
        private String secretArn;

        private BuilderImpl() {
        }

        private BuilderImpl(AuthenticationConfigurationInput model) {
            this.authenticationType(model.authenticationType);
            this.basicAuthenticationCredentials(model.basicAuthenticationCredentials);
            this.customAuthenticationCredentials(model.customAuthenticationCredentials);
            this.kmsKeyArn(model.kmsKeyArn);
            this.oAuth2Properties(model.oAuth2Properties);
            this.secretArn(model.secretArn);
        }

        public final String getAuthenticationType() {
            return this.authenticationType;
        }

        public final void setAuthenticationType(String authenticationType) {
            this.authenticationType = authenticationType;
        }

        @Override
        public final Builder authenticationType(String authenticationType) {
            this.authenticationType = authenticationType;
            return this;
        }

        @Override
        public final Builder authenticationType(AuthenticationType authenticationType) {
            this.authenticationType(authenticationType == null ? null : authenticationType.toString());
            return this;
        }

        public final BasicAuthenticationCredentials.Builder getBasicAuthenticationCredentials() {
            return this.basicAuthenticationCredentials != null ? this.basicAuthenticationCredentials.toBuilder() : null;
        }

        public final void setBasicAuthenticationCredentials(BasicAuthenticationCredentials.BuilderImpl basicAuthenticationCredentials) {
            this.basicAuthenticationCredentials = basicAuthenticationCredentials != null ? basicAuthenticationCredentials.build() : null;
        }

        @Override
        public final Builder basicAuthenticationCredentials(BasicAuthenticationCredentials basicAuthenticationCredentials) {
            this.basicAuthenticationCredentials = basicAuthenticationCredentials;
            return this;
        }

        public final Map<String, String> getCustomAuthenticationCredentials() {
            if (this.customAuthenticationCredentials instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.customAuthenticationCredentials;
        }

        public final void setCustomAuthenticationCredentials(Map<String, String> customAuthenticationCredentials) {
            this.customAuthenticationCredentials = CredentialMapCopier.copy(customAuthenticationCredentials);
        }

        @Override
        public final Builder customAuthenticationCredentials(Map<String, String> customAuthenticationCredentials) {
            this.customAuthenticationCredentials = CredentialMapCopier.copy(customAuthenticationCredentials);
            return this;
        }

        public final String getKmsKeyArn() {
            return this.kmsKeyArn;
        }

        public final void setKmsKeyArn(String kmsKeyArn) {
            this.kmsKeyArn = kmsKeyArn;
        }

        @Override
        public final Builder kmsKeyArn(String kmsKeyArn) {
            this.kmsKeyArn = kmsKeyArn;
            return this;
        }

        public final OAuth2Properties.Builder getOAuth2Properties() {
            return this.oAuth2Properties != null ? this.oAuth2Properties.toBuilder() : null;
        }

        public final void setOAuth2Properties(OAuth2Properties.BuilderImpl oAuth2Properties) {
            this.oAuth2Properties = oAuth2Properties != null ? oAuth2Properties.build() : null;
        }

        @Override
        public final Builder oAuth2Properties(OAuth2Properties oAuth2Properties) {
            this.oAuth2Properties = oAuth2Properties;
            return this;
        }

        public final String getSecretArn() {
            return this.secretArn;
        }

        public final void setSecretArn(String secretArn) {
            this.secretArn = secretArn;
        }

        @Override
        public final Builder secretArn(String secretArn) {
            this.secretArn = secretArn;
            return this;
        }

        @Override
        public AuthenticationConfigurationInput build() {
            return new AuthenticationConfigurationInput(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AuthenticationConfigurationInput> {
        public Builder authenticationType(String var1);

        public Builder authenticationType(AuthenticationType var1);

        public Builder basicAuthenticationCredentials(BasicAuthenticationCredentials var1);

        default public Builder basicAuthenticationCredentials(Consumer<BasicAuthenticationCredentials.Builder> basicAuthenticationCredentials) {
            return this.basicAuthenticationCredentials((BasicAuthenticationCredentials)BasicAuthenticationCredentials.builder().applyMutation(basicAuthenticationCredentials).build());
        }

        public Builder customAuthenticationCredentials(Map<String, String> var1);

        public Builder kmsKeyArn(String var1);

        public Builder oAuth2Properties(OAuth2Properties var1);

        default public Builder oAuth2Properties(Consumer<OAuth2Properties.Builder> oAuth2Properties) {
            return this.oAuth2Properties((OAuth2Properties)OAuth2Properties.builder().applyMutation(oAuth2Properties).build());
        }

        public Builder secretArn(String var1);
    }
}

