/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.datazone.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.datazone.model.DataZoneRequest;
import software.amazon.awssdk.services.datazone.model.FormEntryInput;
import software.amazon.awssdk.services.datazone.model.FormsInputMapCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateAssetTypeRequest
extends DataZoneRequest
implements ToCopyableBuilder<Builder, CreateAssetTypeRequest> {
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder(MarshallingType.STRING).memberName("description").getter(CreateAssetTypeRequest.getter(CreateAssetTypeRequest::description)).setter(CreateAssetTypeRequest.setter(Builder::description)).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();
    private static final SdkField<String> DOMAIN_IDENTIFIER_FIELD = SdkField.builder(MarshallingType.STRING).memberName("domainIdentifier").getter(CreateAssetTypeRequest.getter(CreateAssetTypeRequest::domainIdentifier)).setter(CreateAssetTypeRequest.setter(Builder::domainIdentifier)).traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("domainIdentifier").build()).build();
    private static final SdkField<Map<String, FormEntryInput>> FORMS_INPUT_FIELD = SdkField.builder(MarshallingType.MAP).memberName("formsInput").getter(CreateAssetTypeRequest.getter(CreateAssetTypeRequest::formsInput)).setter(CreateAssetTypeRequest.setter(Builder::formsInput)).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("formsInput").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder(MarshallingType.SDK_POJO).constructor(FormEntryInput::builder).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()).build()).build()).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder(MarshallingType.STRING).memberName("name").getter(CreateAssetTypeRequest.getter(CreateAssetTypeRequest::name)).setter(CreateAssetTypeRequest.setter(Builder::name)).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();
    private static final SdkField<String> OWNING_PROJECT_IDENTIFIER_FIELD = SdkField.builder(MarshallingType.STRING).memberName("owningProjectIdentifier").getter(CreateAssetTypeRequest.getter(CreateAssetTypeRequest::owningProjectIdentifier)).setter(CreateAssetTypeRequest.setter(Builder::owningProjectIdentifier)).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("owningProjectIdentifier").build()).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DESCRIPTION_FIELD, DOMAIN_IDENTIFIER_FIELD, FORMS_INPUT_FIELD, NAME_FIELD, OWNING_PROJECT_IDENTIFIER_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CreateAssetTypeRequest.memberNameToFieldInitializer();
    private final String description;
    private final String domainIdentifier;
    private final Map<String, FormEntryInput> formsInput;
    private final String name;
    private final String owningProjectIdentifier;

    private CreateAssetTypeRequest(BuilderImpl builder) {
        super(builder);
        this.description = builder.description;
        this.domainIdentifier = builder.domainIdentifier;
        this.formsInput = builder.formsInput;
        this.name = builder.name;
        this.owningProjectIdentifier = builder.owningProjectIdentifier;
    }

    public final String description() {
        return this.description;
    }

    public final String domainIdentifier() {
        return this.domainIdentifier;
    }

    public final boolean hasFormsInput() {
        return this.formsInput != null && !(this.formsInput instanceof SdkAutoConstructMap);
    }

    public final Map<String, FormEntryInput> formsInput() {
        return this.formsInput;
    }

    public final String name() {
        return this.name;
    }

    public final String owningProjectIdentifier() {
        return this.owningProjectIdentifier;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.domainIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasFormsInput() ? this.formsInput() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.owningProjectIdentifier());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateAssetTypeRequest)) {
            return false;
        }
        CreateAssetTypeRequest other = (CreateAssetTypeRequest)obj;
        return Objects.equals(this.description(), other.description()) && Objects.equals(this.domainIdentifier(), other.domainIdentifier()) && this.hasFormsInput() == other.hasFormsInput() && Objects.equals(this.formsInput(), other.formsInput()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.owningProjectIdentifier(), other.owningProjectIdentifier());
    }

    public final String toString() {
        return ToString.builder("CreateAssetTypeRequest").add("Description", this.description() == null ? null : "*** Sensitive Data Redacted ***").add("DomainIdentifier", this.domainIdentifier()).add("FormsInput", this.hasFormsInput() ? this.formsInput() : null).add("Name", this.name()).add("OwningProjectIdentifier", this.owningProjectIdentifier()).build();
    }

    @Override
    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "domainIdentifier": {
                return Optional.ofNullable(clazz.cast(this.domainIdentifier()));
            }
            case "formsInput": {
                return Optional.ofNullable(clazz.cast(this.formsInput()));
            }
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "owningProjectIdentifier": {
                return Optional.ofNullable(clazz.cast(this.owningProjectIdentifier()));
            }
        }
        return Optional.empty();
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<Object>> map = new HashMap<String, SdkField<Object>>();
        map.put("description", DESCRIPTION_FIELD);
        map.put("domainIdentifier", DOMAIN_IDENTIFIER_FIELD);
        map.put("formsInput", FORMS_INPUT_FIELD);
        map.put("name", NAME_FIELD);
        map.put("owningProjectIdentifier", OWNING_PROJECT_IDENTIFIER_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateAssetTypeRequest, T> g) {
        return obj -> g.apply((CreateAssetTypeRequest)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends DataZoneRequest.BuilderImpl
    implements Builder {
        private String description;
        private String domainIdentifier;
        private Map<String, FormEntryInput> formsInput = DefaultSdkAutoConstructMap.getInstance();
        private String name;
        private String owningProjectIdentifier;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateAssetTypeRequest model) {
            super(model);
            this.description(model.description);
            this.domainIdentifier(model.domainIdentifier);
            this.formsInput(model.formsInput);
            this.name(model.name);
            this.owningProjectIdentifier(model.owningProjectIdentifier);
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getDomainIdentifier() {
            return this.domainIdentifier;
        }

        public final void setDomainIdentifier(String domainIdentifier) {
            this.domainIdentifier = domainIdentifier;
        }

        @Override
        public final Builder domainIdentifier(String domainIdentifier) {
            this.domainIdentifier = domainIdentifier;
            return this;
        }

        public final Map<String, FormEntryInput.Builder> getFormsInput() {
            Map<String, FormEntryInput.Builder> result = FormsInputMapCopier.copyToBuilder(this.formsInput);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setFormsInput(Map<String, FormEntryInput.BuilderImpl> formsInput) {
            this.formsInput = FormsInputMapCopier.copyFromBuilder(formsInput);
        }

        @Override
        public final Builder formsInput(Map<String, FormEntryInput> formsInput) {
            this.formsInput = FormsInputMapCopier.copy(formsInput);
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getOwningProjectIdentifier() {
            return this.owningProjectIdentifier;
        }

        public final void setOwningProjectIdentifier(String owningProjectIdentifier) {
            this.owningProjectIdentifier = owningProjectIdentifier;
        }

        @Override
        public final Builder owningProjectIdentifier(String owningProjectIdentifier) {
            this.owningProjectIdentifier = owningProjectIdentifier;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateAssetTypeRequest build() {
            return new CreateAssetTypeRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends DataZoneRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateAssetTypeRequest> {
        public Builder description(String var1);

        public Builder domainIdentifier(String var1);

        public Builder formsInput(Map<String, FormEntryInput> var1);

        public Builder name(String var1);

        public Builder owningProjectIdentifier(String var1);

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

