/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.datazone.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.datazone.model.DataZoneRequest;
import software.amazon.awssdk.services.datazone.model.GlossaryStatus;
import software.amazon.awssdk.services.datazone.model.GlossaryUsageRestriction;
import software.amazon.awssdk.services.datazone.model.GlossaryUsageRestrictionsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateGlossaryRequest
extends DataZoneRequest
implements ToCopyableBuilder<Builder, CreateGlossaryRequest> {
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.builder(MarshallingType.STRING).memberName("clientToken").getter(CreateGlossaryRequest.getter(CreateGlossaryRequest::clientToken)).setter(CreateGlossaryRequest.setter(Builder::clientToken)).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientToken").build(), DefaultValueTrait.idempotencyToken()).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder(MarshallingType.STRING).memberName("description").getter(CreateGlossaryRequest.getter(CreateGlossaryRequest::description)).setter(CreateGlossaryRequest.setter(Builder::description)).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();
    private static final SdkField<String> DOMAIN_IDENTIFIER_FIELD = SdkField.builder(MarshallingType.STRING).memberName("domainIdentifier").getter(CreateGlossaryRequest.getter(CreateGlossaryRequest::domainIdentifier)).setter(CreateGlossaryRequest.setter(Builder::domainIdentifier)).traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("domainIdentifier").build()).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder(MarshallingType.STRING).memberName("name").getter(CreateGlossaryRequest.getter(CreateGlossaryRequest::name)).setter(CreateGlossaryRequest.setter(Builder::name)).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();
    private static final SdkField<String> OWNING_PROJECT_IDENTIFIER_FIELD = SdkField.builder(MarshallingType.STRING).memberName("owningProjectIdentifier").getter(CreateGlossaryRequest.getter(CreateGlossaryRequest::owningProjectIdentifier)).setter(CreateGlossaryRequest.setter(Builder::owningProjectIdentifier)).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("owningProjectIdentifier").build()).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder(MarshallingType.STRING).memberName("status").getter(CreateGlossaryRequest.getter(CreateGlossaryRequest::statusAsString)).setter(CreateGlossaryRequest.setter(Builder::status)).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();
    private static final SdkField<List<String>> USAGE_RESTRICTIONS_FIELD = SdkField.builder(MarshallingType.LIST).memberName("usageRestrictions").getter(CreateGlossaryRequest.getter(CreateGlossaryRequest::usageRestrictionsAsStrings)).setter(CreateGlossaryRequest.setter(Builder::usageRestrictionsWithStrings)).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("usageRestrictions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder(MarshallingType.STRING).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()).build()).build()).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLIENT_TOKEN_FIELD, DESCRIPTION_FIELD, DOMAIN_IDENTIFIER_FIELD, NAME_FIELD, OWNING_PROJECT_IDENTIFIER_FIELD, STATUS_FIELD, USAGE_RESTRICTIONS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CreateGlossaryRequest.memberNameToFieldInitializer();
    private final String clientToken;
    private final String description;
    private final String domainIdentifier;
    private final String name;
    private final String owningProjectIdentifier;
    private final String status;
    private final List<String> usageRestrictions;

    private CreateGlossaryRequest(BuilderImpl builder) {
        super(builder);
        this.clientToken = builder.clientToken;
        this.description = builder.description;
        this.domainIdentifier = builder.domainIdentifier;
        this.name = builder.name;
        this.owningProjectIdentifier = builder.owningProjectIdentifier;
        this.status = builder.status;
        this.usageRestrictions = builder.usageRestrictions;
    }

    public final String clientToken() {
        return this.clientToken;
    }

    public final String description() {
        return this.description;
    }

    public final String domainIdentifier() {
        return this.domainIdentifier;
    }

    public final String name() {
        return this.name;
    }

    public final String owningProjectIdentifier() {
        return this.owningProjectIdentifier;
    }

    public final GlossaryStatus status() {
        return GlossaryStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final List<GlossaryUsageRestriction> usageRestrictions() {
        return GlossaryUsageRestrictionsCopier.copyStringToEnum(this.usageRestrictions);
    }

    public final boolean hasUsageRestrictions() {
        return this.usageRestrictions != null && !(this.usageRestrictions instanceof SdkAutoConstructList);
    }

    public final List<String> usageRestrictionsAsStrings() {
        return this.usageRestrictions;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.domainIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.owningProjectIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasUsageRestrictions() ? this.usageRestrictionsAsStrings() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateGlossaryRequest)) {
            return false;
        }
        CreateGlossaryRequest other = (CreateGlossaryRequest)obj;
        return Objects.equals(this.clientToken(), other.clientToken()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.domainIdentifier(), other.domainIdentifier()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.owningProjectIdentifier(), other.owningProjectIdentifier()) && Objects.equals(this.statusAsString(), other.statusAsString()) && this.hasUsageRestrictions() == other.hasUsageRestrictions() && Objects.equals(this.usageRestrictionsAsStrings(), other.usageRestrictionsAsStrings());
    }

    public final String toString() {
        return ToString.builder("CreateGlossaryRequest").add("ClientToken", this.clientToken()).add("Description", this.description() == null ? null : "*** Sensitive Data Redacted ***").add("DomainIdentifier", this.domainIdentifier()).add("Name", this.name() == null ? null : "*** Sensitive Data Redacted ***").add("OwningProjectIdentifier", this.owningProjectIdentifier()).add("Status", this.statusAsString()).add("UsageRestrictions", this.hasUsageRestrictions() ? this.usageRestrictionsAsStrings() : null).build();
    }

    @Override
    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "clientToken": {
                return Optional.ofNullable(clazz.cast(this.clientToken()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "domainIdentifier": {
                return Optional.ofNullable(clazz.cast(this.domainIdentifier()));
            }
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "owningProjectIdentifier": {
                return Optional.ofNullable(clazz.cast(this.owningProjectIdentifier()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "usageRestrictions": {
                return Optional.ofNullable(clazz.cast(this.usageRestrictionsAsStrings()));
            }
        }
        return Optional.empty();
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<Object>> map = new HashMap<String, SdkField<Object>>();
        map.put("clientToken", CLIENT_TOKEN_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        map.put("domainIdentifier", DOMAIN_IDENTIFIER_FIELD);
        map.put("name", NAME_FIELD);
        map.put("owningProjectIdentifier", OWNING_PROJECT_IDENTIFIER_FIELD);
        map.put("status", STATUS_FIELD);
        map.put("usageRestrictions", USAGE_RESTRICTIONS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateGlossaryRequest, T> g) {
        return obj -> g.apply((CreateGlossaryRequest)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends DataZoneRequest.BuilderImpl
    implements Builder {
        private String clientToken;
        private String description;
        private String domainIdentifier;
        private String name;
        private String owningProjectIdentifier;
        private String status;
        private List<String> usageRestrictions = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateGlossaryRequest model) {
            super(model);
            this.clientToken(model.clientToken);
            this.description(model.description);
            this.domainIdentifier(model.domainIdentifier);
            this.name(model.name);
            this.owningProjectIdentifier(model.owningProjectIdentifier);
            this.status(model.status);
            this.usageRestrictionsWithStrings(model.usageRestrictions);
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getDomainIdentifier() {
            return this.domainIdentifier;
        }

        public final void setDomainIdentifier(String domainIdentifier) {
            this.domainIdentifier = domainIdentifier;
        }

        @Override
        public final Builder domainIdentifier(String domainIdentifier) {
            this.domainIdentifier = domainIdentifier;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getOwningProjectIdentifier() {
            return this.owningProjectIdentifier;
        }

        public final void setOwningProjectIdentifier(String owningProjectIdentifier) {
            this.owningProjectIdentifier = owningProjectIdentifier;
        }

        @Override
        public final Builder owningProjectIdentifier(String owningProjectIdentifier) {
            this.owningProjectIdentifier = owningProjectIdentifier;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(GlossaryStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final Collection<String> getUsageRestrictions() {
            if (this.usageRestrictions instanceof SdkAutoConstructList) {
                return null;
            }
            return this.usageRestrictions;
        }

        public final void setUsageRestrictions(Collection<String> usageRestrictions) {
            this.usageRestrictions = GlossaryUsageRestrictionsCopier.copy(usageRestrictions);
        }

        @Override
        public final Builder usageRestrictionsWithStrings(Collection<String> usageRestrictions) {
            this.usageRestrictions = GlossaryUsageRestrictionsCopier.copy(usageRestrictions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder usageRestrictionsWithStrings(String ... usageRestrictions) {
            this.usageRestrictionsWithStrings(Arrays.asList(usageRestrictions));
            return this;
        }

        @Override
        public final Builder usageRestrictions(Collection<GlossaryUsageRestriction> usageRestrictions) {
            this.usageRestrictions = GlossaryUsageRestrictionsCopier.copyEnumToString(usageRestrictions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder usageRestrictions(GlossaryUsageRestriction ... usageRestrictions) {
            this.usageRestrictions(Arrays.asList(usageRestrictions));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateGlossaryRequest build() {
            return new CreateGlossaryRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends DataZoneRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateGlossaryRequest> {
        public Builder clientToken(String var1);

        public Builder description(String var1);

        public Builder domainIdentifier(String var1);

        public Builder name(String var1);

        public Builder owningProjectIdentifier(String var1);

        public Builder status(String var1);

        public Builder status(GlossaryStatus var1);

        public Builder usageRestrictionsWithStrings(Collection<String> var1);

        public Builder usageRestrictionsWithStrings(String ... var1);

        public Builder usageRestrictions(Collection<GlossaryUsageRestriction> var1);

        public Builder usageRestrictions(GlossaryUsageRestriction ... var1);

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

