/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.datazone.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.datazone.model.ProjectProfileListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateProjectFromProjectProfilePolicyGrantDetail
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, CreateProjectFromProjectProfilePolicyGrantDetail> {
    private static final SdkField<Boolean> INCLUDE_CHILD_DOMAIN_UNITS_FIELD = SdkField.builder(MarshallingType.BOOLEAN).memberName("includeChildDomainUnits").getter(CreateProjectFromProjectProfilePolicyGrantDetail.getter(CreateProjectFromProjectProfilePolicyGrantDetail::includeChildDomainUnits)).setter(CreateProjectFromProjectProfilePolicyGrantDetail.setter(Builder::includeChildDomainUnits)).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("includeChildDomainUnits").build()).build();
    private static final SdkField<List<String>> PROJECT_PROFILES_FIELD = SdkField.builder(MarshallingType.LIST).memberName("projectProfiles").getter(CreateProjectFromProjectProfilePolicyGrantDetail.getter(CreateProjectFromProjectProfilePolicyGrantDetail::projectProfiles)).setter(CreateProjectFromProjectProfilePolicyGrantDetail.setter(Builder::projectProfiles)).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("projectProfiles").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder(MarshallingType.STRING).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()).build()).build()).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INCLUDE_CHILD_DOMAIN_UNITS_FIELD, PROJECT_PROFILES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CreateProjectFromProjectProfilePolicyGrantDetail.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final Boolean includeChildDomainUnits;
    private final List<String> projectProfiles;

    private CreateProjectFromProjectProfilePolicyGrantDetail(BuilderImpl builder) {
        this.includeChildDomainUnits = builder.includeChildDomainUnits;
        this.projectProfiles = builder.projectProfiles;
    }

    public final Boolean includeChildDomainUnits() {
        return this.includeChildDomainUnits;
    }

    public final boolean hasProjectProfiles() {
        return this.projectProfiles != null && !(this.projectProfiles instanceof SdkAutoConstructList);
    }

    public final List<String> projectProfiles() {
        return this.projectProfiles;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.includeChildDomainUnits());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasProjectProfiles() ? this.projectProfiles() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateProjectFromProjectProfilePolicyGrantDetail)) {
            return false;
        }
        CreateProjectFromProjectProfilePolicyGrantDetail other = (CreateProjectFromProjectProfilePolicyGrantDetail)obj;
        return Objects.equals(this.includeChildDomainUnits(), other.includeChildDomainUnits()) && this.hasProjectProfiles() == other.hasProjectProfiles() && Objects.equals(this.projectProfiles(), other.projectProfiles());
    }

    public final String toString() {
        return ToString.builder("CreateProjectFromProjectProfilePolicyGrantDetail").add("IncludeChildDomainUnits", this.includeChildDomainUnits()).add("ProjectProfiles", this.hasProjectProfiles() ? this.projectProfiles() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "includeChildDomainUnits": {
                return Optional.ofNullable(clazz.cast(this.includeChildDomainUnits()));
            }
            case "projectProfiles": {
                return Optional.ofNullable(clazz.cast(this.projectProfiles()));
            }
        }
        return Optional.empty();
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<Object>> map = new HashMap<String, SdkField<Object>>();
        map.put("includeChildDomainUnits", INCLUDE_CHILD_DOMAIN_UNITS_FIELD);
        map.put("projectProfiles", PROJECT_PROFILES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateProjectFromProjectProfilePolicyGrantDetail, T> g) {
        return obj -> g.apply((CreateProjectFromProjectProfilePolicyGrantDetail)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Boolean includeChildDomainUnits;
        private List<String> projectProfiles = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateProjectFromProjectProfilePolicyGrantDetail model) {
            this.includeChildDomainUnits(model.includeChildDomainUnits);
            this.projectProfiles(model.projectProfiles);
        }

        public final Boolean getIncludeChildDomainUnits() {
            return this.includeChildDomainUnits;
        }

        public final void setIncludeChildDomainUnits(Boolean includeChildDomainUnits) {
            this.includeChildDomainUnits = includeChildDomainUnits;
        }

        @Override
        public final Builder includeChildDomainUnits(Boolean includeChildDomainUnits) {
            this.includeChildDomainUnits = includeChildDomainUnits;
            return this;
        }

        public final Collection<String> getProjectProfiles() {
            if (this.projectProfiles instanceof SdkAutoConstructList) {
                return null;
            }
            return this.projectProfiles;
        }

        public final void setProjectProfiles(Collection<String> projectProfiles) {
            this.projectProfiles = ProjectProfileListCopier.copy(projectProfiles);
        }

        @Override
        public final Builder projectProfiles(Collection<String> projectProfiles) {
            this.projectProfiles = ProjectProfileListCopier.copy(projectProfiles);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder projectProfiles(String ... projectProfiles) {
            this.projectProfiles(Arrays.asList(projectProfiles));
            return this;
        }

        @Override
        public CreateProjectFromProjectProfilePolicyGrantDetail build() {
            return new CreateProjectFromProjectProfilePolicyGrantDetail(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, CreateProjectFromProjectProfilePolicyGrantDetail> {
        public Builder includeChildDomainUnits(Boolean var1);

        public Builder projectProfiles(Collection<String> var1);

        public Builder projectProfiles(String ... var1);
    }
}

