/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.datazone.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class EnvironmentProfileSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, EnvironmentProfileSummary> {
    private static final SdkField<String> AWS_ACCOUNT_ID_FIELD = SdkField.builder(MarshallingType.STRING).memberName("awsAccountId").getter(EnvironmentProfileSummary.getter(EnvironmentProfileSummary::awsAccountId)).setter(EnvironmentProfileSummary.setter(Builder::awsAccountId)).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("awsAccountId").build()).build();
    private static final SdkField<String> AWS_ACCOUNT_REGION_FIELD = SdkField.builder(MarshallingType.STRING).memberName("awsAccountRegion").getter(EnvironmentProfileSummary.getter(EnvironmentProfileSummary::awsAccountRegion)).setter(EnvironmentProfileSummary.setter(Builder::awsAccountRegion)).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("awsAccountRegion").build()).build();
    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.builder(MarshallingType.INSTANT).memberName("createdAt").getter(EnvironmentProfileSummary.getter(EnvironmentProfileSummary::createdAt)).setter(EnvironmentProfileSummary.setter(Builder::createdAt)).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build(), TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();
    private static final SdkField<String> CREATED_BY_FIELD = SdkField.builder(MarshallingType.STRING).memberName("createdBy").getter(EnvironmentProfileSummary.getter(EnvironmentProfileSummary::createdBy)).setter(EnvironmentProfileSummary.setter(Builder::createdBy)).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdBy").build()).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder(MarshallingType.STRING).memberName("description").getter(EnvironmentProfileSummary.getter(EnvironmentProfileSummary::description)).setter(EnvironmentProfileSummary.setter(Builder::description)).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();
    private static final SdkField<String> DOMAIN_ID_FIELD = SdkField.builder(MarshallingType.STRING).memberName("domainId").getter(EnvironmentProfileSummary.getter(EnvironmentProfileSummary::domainId)).setter(EnvironmentProfileSummary.setter(Builder::domainId)).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("domainId").build()).build();
    private static final SdkField<String> ENVIRONMENT_BLUEPRINT_ID_FIELD = SdkField.builder(MarshallingType.STRING).memberName("environmentBlueprintId").getter(EnvironmentProfileSummary.getter(EnvironmentProfileSummary::environmentBlueprintId)).setter(EnvironmentProfileSummary.setter(Builder::environmentBlueprintId)).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("environmentBlueprintId").build()).build();
    private static final SdkField<String> ID_FIELD = SdkField.builder(MarshallingType.STRING).memberName("id").getter(EnvironmentProfileSummary.getter(EnvironmentProfileSummary::id)).setter(EnvironmentProfileSummary.setter(Builder::id)).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder(MarshallingType.STRING).memberName("name").getter(EnvironmentProfileSummary.getter(EnvironmentProfileSummary::name)).setter(EnvironmentProfileSummary.setter(Builder::name)).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();
    private static final SdkField<String> PROJECT_ID_FIELD = SdkField.builder(MarshallingType.STRING).memberName("projectId").getter(EnvironmentProfileSummary.getter(EnvironmentProfileSummary::projectId)).setter(EnvironmentProfileSummary.setter(Builder::projectId)).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("projectId").build()).build();
    private static final SdkField<Instant> UPDATED_AT_FIELD = SdkField.builder(MarshallingType.INSTANT).memberName("updatedAt").getter(EnvironmentProfileSummary.getter(EnvironmentProfileSummary::updatedAt)).setter(EnvironmentProfileSummary.setter(Builder::updatedAt)).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updatedAt").build(), TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AWS_ACCOUNT_ID_FIELD, AWS_ACCOUNT_REGION_FIELD, CREATED_AT_FIELD, CREATED_BY_FIELD, DESCRIPTION_FIELD, DOMAIN_ID_FIELD, ENVIRONMENT_BLUEPRINT_ID_FIELD, ID_FIELD, NAME_FIELD, PROJECT_ID_FIELD, UPDATED_AT_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = EnvironmentProfileSummary.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String awsAccountId;
    private final String awsAccountRegion;
    private final Instant createdAt;
    private final String createdBy;
    private final String description;
    private final String domainId;
    private final String environmentBlueprintId;
    private final String id;
    private final String name;
    private final String projectId;
    private final Instant updatedAt;

    private EnvironmentProfileSummary(BuilderImpl builder) {
        this.awsAccountId = builder.awsAccountId;
        this.awsAccountRegion = builder.awsAccountRegion;
        this.createdAt = builder.createdAt;
        this.createdBy = builder.createdBy;
        this.description = builder.description;
        this.domainId = builder.domainId;
        this.environmentBlueprintId = builder.environmentBlueprintId;
        this.id = builder.id;
        this.name = builder.name;
        this.projectId = builder.projectId;
        this.updatedAt = builder.updatedAt;
    }

    public final String awsAccountId() {
        return this.awsAccountId;
    }

    public final String awsAccountRegion() {
        return this.awsAccountRegion;
    }

    public final Instant createdAt() {
        return this.createdAt;
    }

    public final String createdBy() {
        return this.createdBy;
    }

    public final String description() {
        return this.description;
    }

    public final String domainId() {
        return this.domainId;
    }

    public final String environmentBlueprintId() {
        return this.environmentBlueprintId;
    }

    public final String id() {
        return this.id;
    }

    public final String name() {
        return this.name;
    }

    public final String projectId() {
        return this.projectId;
    }

    public final Instant updatedAt() {
        return this.updatedAt;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.awsAccountId());
        hashCode = 31 * hashCode + Objects.hashCode(this.awsAccountRegion());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdBy());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.domainId());
        hashCode = 31 * hashCode + Objects.hashCode(this.environmentBlueprintId());
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.projectId());
        hashCode = 31 * hashCode + Objects.hashCode(this.updatedAt());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EnvironmentProfileSummary)) {
            return false;
        }
        EnvironmentProfileSummary other = (EnvironmentProfileSummary)obj;
        return Objects.equals(this.awsAccountId(), other.awsAccountId()) && Objects.equals(this.awsAccountRegion(), other.awsAccountRegion()) && Objects.equals(this.createdAt(), other.createdAt()) && Objects.equals(this.createdBy(), other.createdBy()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.domainId(), other.domainId()) && Objects.equals(this.environmentBlueprintId(), other.environmentBlueprintId()) && Objects.equals(this.id(), other.id()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.projectId(), other.projectId()) && Objects.equals(this.updatedAt(), other.updatedAt());
    }

    public final String toString() {
        return ToString.builder("EnvironmentProfileSummary").add("AwsAccountId", this.awsAccountId()).add("AwsAccountRegion", this.awsAccountRegion()).add("CreatedAt", this.createdAt()).add("CreatedBy", this.createdBy()).add("Description", this.description() == null ? null : "*** Sensitive Data Redacted ***").add("DomainId", this.domainId()).add("EnvironmentBlueprintId", this.environmentBlueprintId()).add("Id", this.id()).add("Name", this.name() == null ? null : "*** Sensitive Data Redacted ***").add("ProjectId", this.projectId()).add("UpdatedAt", this.updatedAt()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "awsAccountId": {
                return Optional.ofNullable(clazz.cast(this.awsAccountId()));
            }
            case "awsAccountRegion": {
                return Optional.ofNullable(clazz.cast(this.awsAccountRegion()));
            }
            case "createdAt": {
                return Optional.ofNullable(clazz.cast(this.createdAt()));
            }
            case "createdBy": {
                return Optional.ofNullable(clazz.cast(this.createdBy()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "domainId": {
                return Optional.ofNullable(clazz.cast(this.domainId()));
            }
            case "environmentBlueprintId": {
                return Optional.ofNullable(clazz.cast(this.environmentBlueprintId()));
            }
            case "id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "projectId": {
                return Optional.ofNullable(clazz.cast(this.projectId()));
            }
            case "updatedAt": {
                return Optional.ofNullable(clazz.cast(this.updatedAt()));
            }
        }
        return Optional.empty();
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<Object>> map = new HashMap<String, SdkField<Object>>();
        map.put("awsAccountId", AWS_ACCOUNT_ID_FIELD);
        map.put("awsAccountRegion", AWS_ACCOUNT_REGION_FIELD);
        map.put("createdAt", CREATED_AT_FIELD);
        map.put("createdBy", CREATED_BY_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        map.put("domainId", DOMAIN_ID_FIELD);
        map.put("environmentBlueprintId", ENVIRONMENT_BLUEPRINT_ID_FIELD);
        map.put("id", ID_FIELD);
        map.put("name", NAME_FIELD);
        map.put("projectId", PROJECT_ID_FIELD);
        map.put("updatedAt", UPDATED_AT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<EnvironmentProfileSummary, T> g) {
        return obj -> g.apply((EnvironmentProfileSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String awsAccountId;
        private String awsAccountRegion;
        private Instant createdAt;
        private String createdBy;
        private String description;
        private String domainId;
        private String environmentBlueprintId;
        private String id;
        private String name;
        private String projectId;
        private Instant updatedAt;

        private BuilderImpl() {
        }

        private BuilderImpl(EnvironmentProfileSummary model) {
            this.awsAccountId(model.awsAccountId);
            this.awsAccountRegion(model.awsAccountRegion);
            this.createdAt(model.createdAt);
            this.createdBy(model.createdBy);
            this.description(model.description);
            this.domainId(model.domainId);
            this.environmentBlueprintId(model.environmentBlueprintId);
            this.id(model.id);
            this.name(model.name);
            this.projectId(model.projectId);
            this.updatedAt(model.updatedAt);
        }

        public final String getAwsAccountId() {
            return this.awsAccountId;
        }

        public final void setAwsAccountId(String awsAccountId) {
            this.awsAccountId = awsAccountId;
        }

        @Override
        public final Builder awsAccountId(String awsAccountId) {
            this.awsAccountId = awsAccountId;
            return this;
        }

        public final String getAwsAccountRegion() {
            return this.awsAccountRegion;
        }

        public final void setAwsAccountRegion(String awsAccountRegion) {
            this.awsAccountRegion = awsAccountRegion;
        }

        @Override
        public final Builder awsAccountRegion(String awsAccountRegion) {
            this.awsAccountRegion = awsAccountRegion;
            return this;
        }

        public final Instant getCreatedAt() {
            return this.createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final String getCreatedBy() {
            return this.createdBy;
        }

        public final void setCreatedBy(String createdBy) {
            this.createdBy = createdBy;
        }

        @Override
        public final Builder createdBy(String createdBy) {
            this.createdBy = createdBy;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getDomainId() {
            return this.domainId;
        }

        public final void setDomainId(String domainId) {
            this.domainId = domainId;
        }

        @Override
        public final Builder domainId(String domainId) {
            this.domainId = domainId;
            return this;
        }

        public final String getEnvironmentBlueprintId() {
            return this.environmentBlueprintId;
        }

        public final void setEnvironmentBlueprintId(String environmentBlueprintId) {
            this.environmentBlueprintId = environmentBlueprintId;
        }

        @Override
        public final Builder environmentBlueprintId(String environmentBlueprintId) {
            this.environmentBlueprintId = environmentBlueprintId;
            return this;
        }

        public final String getId() {
            return this.id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getProjectId() {
            return this.projectId;
        }

        public final void setProjectId(String projectId) {
            this.projectId = projectId;
        }

        @Override
        public final Builder projectId(String projectId) {
            this.projectId = projectId;
            return this;
        }

        public final Instant getUpdatedAt() {
            return this.updatedAt;
        }

        public final void setUpdatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
        }

        @Override
        public final Builder updatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        @Override
        public EnvironmentProfileSummary build() {
            return new EnvironmentProfileSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, EnvironmentProfileSummary> {
        public Builder awsAccountId(String var1);

        public Builder awsAccountRegion(String var1);

        public Builder createdAt(Instant var1);

        public Builder createdBy(String var1);

        public Builder description(String var1);

        public Builder domainId(String var1);

        public Builder environmentBlueprintId(String var1);

        public Builder id(String var1);

        public Builder name(String var1);

        public Builder projectId(String var1);

        public Builder updatedAt(Instant var1);
    }
}

