/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.datazone.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.datazone.model.AuthenticationConfiguration;
import software.amazon.awssdk.services.datazone.model.ComputeEnvironments;
import software.amazon.awssdk.services.datazone.model.ComputeEnvironmentsListCopier;
import software.amazon.awssdk.services.datazone.model.ConnectionPropertiesCopier;
import software.amazon.awssdk.services.datazone.model.ConnectionStatus;
import software.amazon.awssdk.services.datazone.model.ConnectionType;
import software.amazon.awssdk.services.datazone.model.MatchCriteriaCopier;
import software.amazon.awssdk.services.datazone.model.PhysicalConnectionRequirements;
import software.amazon.awssdk.services.datazone.model.PropertyMapCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GlueConnection
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, GlueConnection> {
    private static final SdkField<Map<String, String>> ATHENA_PROPERTIES_FIELD = SdkField.builder(MarshallingType.MAP).memberName("athenaProperties").getter(GlueConnection.getter(GlueConnection::athenaProperties)).setter(GlueConnection.setter(Builder::athenaProperties)).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("athenaProperties").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder(MarshallingType.STRING).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()).build()).build()).build();
    private static final SdkField<AuthenticationConfiguration> AUTHENTICATION_CONFIGURATION_FIELD = SdkField.builder(MarshallingType.SDK_POJO).memberName("authenticationConfiguration").getter(GlueConnection.getter(GlueConnection::authenticationConfiguration)).setter(GlueConnection.setter(Builder::authenticationConfiguration)).constructor(AuthenticationConfiguration::builder).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("authenticationConfiguration").build()).build();
    private static final SdkField<List<String>> COMPATIBLE_COMPUTE_ENVIRONMENTS_FIELD = SdkField.builder(MarshallingType.LIST).memberName("compatibleComputeEnvironments").getter(GlueConnection.getter(GlueConnection::compatibleComputeEnvironmentsAsStrings)).setter(GlueConnection.setter(Builder::compatibleComputeEnvironmentsWithStrings)).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("compatibleComputeEnvironments").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder(MarshallingType.STRING).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()).build()).build()).build();
    private static final SdkField<Map<String, String>> CONNECTION_PROPERTIES_FIELD = SdkField.builder(MarshallingType.MAP).memberName("connectionProperties").getter(GlueConnection.getter(GlueConnection::connectionProperties)).setter(GlueConnection.setter(Builder::connectionProperties)).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("connectionProperties").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder(MarshallingType.STRING).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()).build()).build()).build();
    private static final SdkField<Integer> CONNECTION_SCHEMA_VERSION_FIELD = SdkField.builder(MarshallingType.INTEGER).memberName("connectionSchemaVersion").getter(GlueConnection.getter(GlueConnection::connectionSchemaVersion)).setter(GlueConnection.setter(Builder::connectionSchemaVersion)).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("connectionSchemaVersion").build()).build();
    private static final SdkField<String> CONNECTION_TYPE_FIELD = SdkField.builder(MarshallingType.STRING).memberName("connectionType").getter(GlueConnection.getter(GlueConnection::connectionTypeAsString)).setter(GlueConnection.setter(Builder::connectionType)).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("connectionType").build()).build();
    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.builder(MarshallingType.INSTANT).memberName("creationTime").getter(GlueConnection.getter(GlueConnection::creationTime)).setter(GlueConnection.setter(Builder::creationTime)).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("creationTime").build()).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder(MarshallingType.STRING).memberName("description").getter(GlueConnection.getter(GlueConnection::description)).setter(GlueConnection.setter(Builder::description)).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();
    private static final SdkField<Instant> LAST_CONNECTION_VALIDATION_TIME_FIELD = SdkField.builder(MarshallingType.INSTANT).memberName("lastConnectionValidationTime").getter(GlueConnection.getter(GlueConnection::lastConnectionValidationTime)).setter(GlueConnection.setter(Builder::lastConnectionValidationTime)).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastConnectionValidationTime").build()).build();
    private static final SdkField<String> LAST_UPDATED_BY_FIELD = SdkField.builder(MarshallingType.STRING).memberName("lastUpdatedBy").getter(GlueConnection.getter(GlueConnection::lastUpdatedBy)).setter(GlueConnection.setter(Builder::lastUpdatedBy)).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastUpdatedBy").build()).build();
    private static final SdkField<Instant> LAST_UPDATED_TIME_FIELD = SdkField.builder(MarshallingType.INSTANT).memberName("lastUpdatedTime").getter(GlueConnection.getter(GlueConnection::lastUpdatedTime)).setter(GlueConnection.setter(Builder::lastUpdatedTime)).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastUpdatedTime").build()).build();
    private static final SdkField<List<String>> MATCH_CRITERIA_FIELD = SdkField.builder(MarshallingType.LIST).memberName("matchCriteria").getter(GlueConnection.getter(GlueConnection::matchCriteria)).setter(GlueConnection.setter(Builder::matchCriteria)).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("matchCriteria").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder(MarshallingType.STRING).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()).build()).build()).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder(MarshallingType.STRING).memberName("name").getter(GlueConnection.getter(GlueConnection::name)).setter(GlueConnection.setter(Builder::name)).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();
    private static final SdkField<PhysicalConnectionRequirements> PHYSICAL_CONNECTION_REQUIREMENTS_FIELD = SdkField.builder(MarshallingType.SDK_POJO).memberName("physicalConnectionRequirements").getter(GlueConnection.getter(GlueConnection::physicalConnectionRequirements)).setter(GlueConnection.setter(Builder::physicalConnectionRequirements)).constructor(PhysicalConnectionRequirements::builder).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("physicalConnectionRequirements").build()).build();
    private static final SdkField<Map<String, String>> PYTHON_PROPERTIES_FIELD = SdkField.builder(MarshallingType.MAP).memberName("pythonProperties").getter(GlueConnection.getter(GlueConnection::pythonProperties)).setter(GlueConnection.setter(Builder::pythonProperties)).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("pythonProperties").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder(MarshallingType.STRING).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()).build()).build()).build();
    private static final SdkField<Map<String, String>> SPARK_PROPERTIES_FIELD = SdkField.builder(MarshallingType.MAP).memberName("sparkProperties").getter(GlueConnection.getter(GlueConnection::sparkProperties)).setter(GlueConnection.setter(Builder::sparkProperties)).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sparkProperties").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder(MarshallingType.STRING).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()).build()).build()).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder(MarshallingType.STRING).memberName("status").getter(GlueConnection.getter(GlueConnection::statusAsString)).setter(GlueConnection.setter(Builder::status)).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();
    private static final SdkField<String> STATUS_REASON_FIELD = SdkField.builder(MarshallingType.STRING).memberName("statusReason").getter(GlueConnection.getter(GlueConnection::statusReason)).setter(GlueConnection.setter(Builder::statusReason)).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("statusReason").build()).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ATHENA_PROPERTIES_FIELD, AUTHENTICATION_CONFIGURATION_FIELD, COMPATIBLE_COMPUTE_ENVIRONMENTS_FIELD, CONNECTION_PROPERTIES_FIELD, CONNECTION_SCHEMA_VERSION_FIELD, CONNECTION_TYPE_FIELD, CREATION_TIME_FIELD, DESCRIPTION_FIELD, LAST_CONNECTION_VALIDATION_TIME_FIELD, LAST_UPDATED_BY_FIELD, LAST_UPDATED_TIME_FIELD, MATCH_CRITERIA_FIELD, NAME_FIELD, PHYSICAL_CONNECTION_REQUIREMENTS_FIELD, PYTHON_PROPERTIES_FIELD, SPARK_PROPERTIES_FIELD, STATUS_FIELD, STATUS_REASON_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GlueConnection.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final Map<String, String> athenaProperties;
    private final AuthenticationConfiguration authenticationConfiguration;
    private final List<String> compatibleComputeEnvironments;
    private final Map<String, String> connectionProperties;
    private final Integer connectionSchemaVersion;
    private final String connectionType;
    private final Instant creationTime;
    private final String description;
    private final Instant lastConnectionValidationTime;
    private final String lastUpdatedBy;
    private final Instant lastUpdatedTime;
    private final List<String> matchCriteria;
    private final String name;
    private final PhysicalConnectionRequirements physicalConnectionRequirements;
    private final Map<String, String> pythonProperties;
    private final Map<String, String> sparkProperties;
    private final String status;
    private final String statusReason;

    private GlueConnection(BuilderImpl builder) {
        this.athenaProperties = builder.athenaProperties;
        this.authenticationConfiguration = builder.authenticationConfiguration;
        this.compatibleComputeEnvironments = builder.compatibleComputeEnvironments;
        this.connectionProperties = builder.connectionProperties;
        this.connectionSchemaVersion = builder.connectionSchemaVersion;
        this.connectionType = builder.connectionType;
        this.creationTime = builder.creationTime;
        this.description = builder.description;
        this.lastConnectionValidationTime = builder.lastConnectionValidationTime;
        this.lastUpdatedBy = builder.lastUpdatedBy;
        this.lastUpdatedTime = builder.lastUpdatedTime;
        this.matchCriteria = builder.matchCriteria;
        this.name = builder.name;
        this.physicalConnectionRequirements = builder.physicalConnectionRequirements;
        this.pythonProperties = builder.pythonProperties;
        this.sparkProperties = builder.sparkProperties;
        this.status = builder.status;
        this.statusReason = builder.statusReason;
    }

    public final boolean hasAthenaProperties() {
        return this.athenaProperties != null && !(this.athenaProperties instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> athenaProperties() {
        return this.athenaProperties;
    }

    public final AuthenticationConfiguration authenticationConfiguration() {
        return this.authenticationConfiguration;
    }

    public final List<ComputeEnvironments> compatibleComputeEnvironments() {
        return ComputeEnvironmentsListCopier.copyStringToEnum(this.compatibleComputeEnvironments);
    }

    public final boolean hasCompatibleComputeEnvironments() {
        return this.compatibleComputeEnvironments != null && !(this.compatibleComputeEnvironments instanceof SdkAutoConstructList);
    }

    public final List<String> compatibleComputeEnvironmentsAsStrings() {
        return this.compatibleComputeEnvironments;
    }

    public final boolean hasConnectionProperties() {
        return this.connectionProperties != null && !(this.connectionProperties instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> connectionProperties() {
        return this.connectionProperties;
    }

    public final Integer connectionSchemaVersion() {
        return this.connectionSchemaVersion;
    }

    public final ConnectionType connectionType() {
        return ConnectionType.fromValue(this.connectionType);
    }

    public final String connectionTypeAsString() {
        return this.connectionType;
    }

    public final Instant creationTime() {
        return this.creationTime;
    }

    public final String description() {
        return this.description;
    }

    public final Instant lastConnectionValidationTime() {
        return this.lastConnectionValidationTime;
    }

    public final String lastUpdatedBy() {
        return this.lastUpdatedBy;
    }

    public final Instant lastUpdatedTime() {
        return this.lastUpdatedTime;
    }

    public final boolean hasMatchCriteria() {
        return this.matchCriteria != null && !(this.matchCriteria instanceof SdkAutoConstructList);
    }

    public final List<String> matchCriteria() {
        return this.matchCriteria;
    }

    public final String name() {
        return this.name;
    }

    public final PhysicalConnectionRequirements physicalConnectionRequirements() {
        return this.physicalConnectionRequirements;
    }

    public final boolean hasPythonProperties() {
        return this.pythonProperties != null && !(this.pythonProperties instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> pythonProperties() {
        return this.pythonProperties;
    }

    public final boolean hasSparkProperties() {
        return this.sparkProperties != null && !(this.sparkProperties instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> sparkProperties() {
        return this.sparkProperties;
    }

    public final ConnectionStatus status() {
        return ConnectionStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final String statusReason() {
        return this.statusReason;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAthenaProperties() ? this.athenaProperties() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.authenticationConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasCompatibleComputeEnvironments() ? this.compatibleComputeEnvironmentsAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasConnectionProperties() ? this.connectionProperties() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.connectionSchemaVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.connectionTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastConnectionValidationTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastUpdatedBy());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastUpdatedTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasMatchCriteria() ? this.matchCriteria() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.physicalConnectionRequirements());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasPythonProperties() ? this.pythonProperties() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSparkProperties() ? this.sparkProperties() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusReason());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GlueConnection)) {
            return false;
        }
        GlueConnection other = (GlueConnection)obj;
        return this.hasAthenaProperties() == other.hasAthenaProperties() && Objects.equals(this.athenaProperties(), other.athenaProperties()) && Objects.equals(this.authenticationConfiguration(), other.authenticationConfiguration()) && this.hasCompatibleComputeEnvironments() == other.hasCompatibleComputeEnvironments() && Objects.equals(this.compatibleComputeEnvironmentsAsStrings(), other.compatibleComputeEnvironmentsAsStrings()) && this.hasConnectionProperties() == other.hasConnectionProperties() && Objects.equals(this.connectionProperties(), other.connectionProperties()) && Objects.equals(this.connectionSchemaVersion(), other.connectionSchemaVersion()) && Objects.equals(this.connectionTypeAsString(), other.connectionTypeAsString()) && Objects.equals(this.creationTime(), other.creationTime()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.lastConnectionValidationTime(), other.lastConnectionValidationTime()) && Objects.equals(this.lastUpdatedBy(), other.lastUpdatedBy()) && Objects.equals(this.lastUpdatedTime(), other.lastUpdatedTime()) && this.hasMatchCriteria() == other.hasMatchCriteria() && Objects.equals(this.matchCriteria(), other.matchCriteria()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.physicalConnectionRequirements(), other.physicalConnectionRequirements()) && this.hasPythonProperties() == other.hasPythonProperties() && Objects.equals(this.pythonProperties(), other.pythonProperties()) && this.hasSparkProperties() == other.hasSparkProperties() && Objects.equals(this.sparkProperties(), other.sparkProperties()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.statusReason(), other.statusReason());
    }

    public final String toString() {
        return ToString.builder("GlueConnection").add("AthenaProperties", this.hasAthenaProperties() ? this.athenaProperties() : null).add("AuthenticationConfiguration", this.authenticationConfiguration()).add("CompatibleComputeEnvironments", this.hasCompatibleComputeEnvironments() ? this.compatibleComputeEnvironmentsAsStrings() : null).add("ConnectionProperties", this.hasConnectionProperties() ? this.connectionProperties() : null).add("ConnectionSchemaVersion", this.connectionSchemaVersion()).add("ConnectionType", this.connectionTypeAsString()).add("CreationTime", this.creationTime()).add("Description", this.description()).add("LastConnectionValidationTime", this.lastConnectionValidationTime()).add("LastUpdatedBy", this.lastUpdatedBy()).add("LastUpdatedTime", this.lastUpdatedTime()).add("MatchCriteria", this.hasMatchCriteria() ? this.matchCriteria() : null).add("Name", this.name()).add("PhysicalConnectionRequirements", this.physicalConnectionRequirements()).add("PythonProperties", this.hasPythonProperties() ? this.pythonProperties() : null).add("SparkProperties", this.hasSparkProperties() ? this.sparkProperties() : null).add("Status", this.statusAsString()).add("StatusReason", this.statusReason()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "athenaProperties": {
                return Optional.ofNullable(clazz.cast(this.athenaProperties()));
            }
            case "authenticationConfiguration": {
                return Optional.ofNullable(clazz.cast(this.authenticationConfiguration()));
            }
            case "compatibleComputeEnvironments": {
                return Optional.ofNullable(clazz.cast(this.compatibleComputeEnvironmentsAsStrings()));
            }
            case "connectionProperties": {
                return Optional.ofNullable(clazz.cast(this.connectionProperties()));
            }
            case "connectionSchemaVersion": {
                return Optional.ofNullable(clazz.cast(this.connectionSchemaVersion()));
            }
            case "connectionType": {
                return Optional.ofNullable(clazz.cast(this.connectionTypeAsString()));
            }
            case "creationTime": {
                return Optional.ofNullable(clazz.cast(this.creationTime()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "lastConnectionValidationTime": {
                return Optional.ofNullable(clazz.cast(this.lastConnectionValidationTime()));
            }
            case "lastUpdatedBy": {
                return Optional.ofNullable(clazz.cast(this.lastUpdatedBy()));
            }
            case "lastUpdatedTime": {
                return Optional.ofNullable(clazz.cast(this.lastUpdatedTime()));
            }
            case "matchCriteria": {
                return Optional.ofNullable(clazz.cast(this.matchCriteria()));
            }
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "physicalConnectionRequirements": {
                return Optional.ofNullable(clazz.cast(this.physicalConnectionRequirements()));
            }
            case "pythonProperties": {
                return Optional.ofNullable(clazz.cast(this.pythonProperties()));
            }
            case "sparkProperties": {
                return Optional.ofNullable(clazz.cast(this.sparkProperties()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "statusReason": {
                return Optional.ofNullable(clazz.cast(this.statusReason()));
            }
        }
        return Optional.empty();
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<Object>> map = new HashMap<String, SdkField<Object>>();
        map.put("athenaProperties", ATHENA_PROPERTIES_FIELD);
        map.put("authenticationConfiguration", AUTHENTICATION_CONFIGURATION_FIELD);
        map.put("compatibleComputeEnvironments", COMPATIBLE_COMPUTE_ENVIRONMENTS_FIELD);
        map.put("connectionProperties", CONNECTION_PROPERTIES_FIELD);
        map.put("connectionSchemaVersion", CONNECTION_SCHEMA_VERSION_FIELD);
        map.put("connectionType", CONNECTION_TYPE_FIELD);
        map.put("creationTime", CREATION_TIME_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        map.put("lastConnectionValidationTime", LAST_CONNECTION_VALIDATION_TIME_FIELD);
        map.put("lastUpdatedBy", LAST_UPDATED_BY_FIELD);
        map.put("lastUpdatedTime", LAST_UPDATED_TIME_FIELD);
        map.put("matchCriteria", MATCH_CRITERIA_FIELD);
        map.put("name", NAME_FIELD);
        map.put("physicalConnectionRequirements", PHYSICAL_CONNECTION_REQUIREMENTS_FIELD);
        map.put("pythonProperties", PYTHON_PROPERTIES_FIELD);
        map.put("sparkProperties", SPARK_PROPERTIES_FIELD);
        map.put("status", STATUS_FIELD);
        map.put("statusReason", STATUS_REASON_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GlueConnection, T> g) {
        return obj -> g.apply((GlueConnection)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Map<String, String> athenaProperties = DefaultSdkAutoConstructMap.getInstance();
        private AuthenticationConfiguration authenticationConfiguration;
        private List<String> compatibleComputeEnvironments = DefaultSdkAutoConstructList.getInstance();
        private Map<String, String> connectionProperties = DefaultSdkAutoConstructMap.getInstance();
        private Integer connectionSchemaVersion;
        private String connectionType;
        private Instant creationTime;
        private String description;
        private Instant lastConnectionValidationTime;
        private String lastUpdatedBy;
        private Instant lastUpdatedTime;
        private List<String> matchCriteria = DefaultSdkAutoConstructList.getInstance();
        private String name;
        private PhysicalConnectionRequirements physicalConnectionRequirements;
        private Map<String, String> pythonProperties = DefaultSdkAutoConstructMap.getInstance();
        private Map<String, String> sparkProperties = DefaultSdkAutoConstructMap.getInstance();
        private String status;
        private String statusReason;

        private BuilderImpl() {
        }

        private BuilderImpl(GlueConnection model) {
            this.athenaProperties(model.athenaProperties);
            this.authenticationConfiguration(model.authenticationConfiguration);
            this.compatibleComputeEnvironmentsWithStrings(model.compatibleComputeEnvironments);
            this.connectionProperties(model.connectionProperties);
            this.connectionSchemaVersion(model.connectionSchemaVersion);
            this.connectionType(model.connectionType);
            this.creationTime(model.creationTime);
            this.description(model.description);
            this.lastConnectionValidationTime(model.lastConnectionValidationTime);
            this.lastUpdatedBy(model.lastUpdatedBy);
            this.lastUpdatedTime(model.lastUpdatedTime);
            this.matchCriteria(model.matchCriteria);
            this.name(model.name);
            this.physicalConnectionRequirements(model.physicalConnectionRequirements);
            this.pythonProperties(model.pythonProperties);
            this.sparkProperties(model.sparkProperties);
            this.status(model.status);
            this.statusReason(model.statusReason);
        }

        public final Map<String, String> getAthenaProperties() {
            if (this.athenaProperties instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.athenaProperties;
        }

        public final void setAthenaProperties(Map<String, String> athenaProperties) {
            this.athenaProperties = PropertyMapCopier.copy(athenaProperties);
        }

        @Override
        public final Builder athenaProperties(Map<String, String> athenaProperties) {
            this.athenaProperties = PropertyMapCopier.copy(athenaProperties);
            return this;
        }

        public final AuthenticationConfiguration.Builder getAuthenticationConfiguration() {
            return this.authenticationConfiguration != null ? this.authenticationConfiguration.toBuilder() : null;
        }

        public final void setAuthenticationConfiguration(AuthenticationConfiguration.BuilderImpl authenticationConfiguration) {
            this.authenticationConfiguration = authenticationConfiguration != null ? authenticationConfiguration.build() : null;
        }

        @Override
        public final Builder authenticationConfiguration(AuthenticationConfiguration authenticationConfiguration) {
            this.authenticationConfiguration = authenticationConfiguration;
            return this;
        }

        public final Collection<String> getCompatibleComputeEnvironments() {
            if (this.compatibleComputeEnvironments instanceof SdkAutoConstructList) {
                return null;
            }
            return this.compatibleComputeEnvironments;
        }

        public final void setCompatibleComputeEnvironments(Collection<String> compatibleComputeEnvironments) {
            this.compatibleComputeEnvironments = ComputeEnvironmentsListCopier.copy(compatibleComputeEnvironments);
        }

        @Override
        public final Builder compatibleComputeEnvironmentsWithStrings(Collection<String> compatibleComputeEnvironments) {
            this.compatibleComputeEnvironments = ComputeEnvironmentsListCopier.copy(compatibleComputeEnvironments);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder compatibleComputeEnvironmentsWithStrings(String ... compatibleComputeEnvironments) {
            this.compatibleComputeEnvironmentsWithStrings(Arrays.asList(compatibleComputeEnvironments));
            return this;
        }

        @Override
        public final Builder compatibleComputeEnvironments(Collection<ComputeEnvironments> compatibleComputeEnvironments) {
            this.compatibleComputeEnvironments = ComputeEnvironmentsListCopier.copyEnumToString(compatibleComputeEnvironments);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder compatibleComputeEnvironments(ComputeEnvironments ... compatibleComputeEnvironments) {
            this.compatibleComputeEnvironments(Arrays.asList(compatibleComputeEnvironments));
            return this;
        }

        public final Map<String, String> getConnectionProperties() {
            if (this.connectionProperties instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.connectionProperties;
        }

        public final void setConnectionProperties(Map<String, String> connectionProperties) {
            this.connectionProperties = ConnectionPropertiesCopier.copy(connectionProperties);
        }

        @Override
        public final Builder connectionProperties(Map<String, String> connectionProperties) {
            this.connectionProperties = ConnectionPropertiesCopier.copy(connectionProperties);
            return this;
        }

        public final Integer getConnectionSchemaVersion() {
            return this.connectionSchemaVersion;
        }

        public final void setConnectionSchemaVersion(Integer connectionSchemaVersion) {
            this.connectionSchemaVersion = connectionSchemaVersion;
        }

        @Override
        public final Builder connectionSchemaVersion(Integer connectionSchemaVersion) {
            this.connectionSchemaVersion = connectionSchemaVersion;
            return this;
        }

        public final String getConnectionType() {
            return this.connectionType;
        }

        public final void setConnectionType(String connectionType) {
            this.connectionType = connectionType;
        }

        @Override
        public final Builder connectionType(String connectionType) {
            this.connectionType = connectionType;
            return this;
        }

        @Override
        public final Builder connectionType(ConnectionType connectionType) {
            this.connectionType(connectionType == null ? null : connectionType.toString());
            return this;
        }

        public final Instant getCreationTime() {
            return this.creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final Instant getLastConnectionValidationTime() {
            return this.lastConnectionValidationTime;
        }

        public final void setLastConnectionValidationTime(Instant lastConnectionValidationTime) {
            this.lastConnectionValidationTime = lastConnectionValidationTime;
        }

        @Override
        public final Builder lastConnectionValidationTime(Instant lastConnectionValidationTime) {
            this.lastConnectionValidationTime = lastConnectionValidationTime;
            return this;
        }

        public final String getLastUpdatedBy() {
            return this.lastUpdatedBy;
        }

        public final void setLastUpdatedBy(String lastUpdatedBy) {
            this.lastUpdatedBy = lastUpdatedBy;
        }

        @Override
        public final Builder lastUpdatedBy(String lastUpdatedBy) {
            this.lastUpdatedBy = lastUpdatedBy;
            return this;
        }

        public final Instant getLastUpdatedTime() {
            return this.lastUpdatedTime;
        }

        public final void setLastUpdatedTime(Instant lastUpdatedTime) {
            this.lastUpdatedTime = lastUpdatedTime;
        }

        @Override
        public final Builder lastUpdatedTime(Instant lastUpdatedTime) {
            this.lastUpdatedTime = lastUpdatedTime;
            return this;
        }

        public final Collection<String> getMatchCriteria() {
            if (this.matchCriteria instanceof SdkAutoConstructList) {
                return null;
            }
            return this.matchCriteria;
        }

        public final void setMatchCriteria(Collection<String> matchCriteria) {
            this.matchCriteria = MatchCriteriaCopier.copy(matchCriteria);
        }

        @Override
        public final Builder matchCriteria(Collection<String> matchCriteria) {
            this.matchCriteria = MatchCriteriaCopier.copy(matchCriteria);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder matchCriteria(String ... matchCriteria) {
            this.matchCriteria(Arrays.asList(matchCriteria));
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final PhysicalConnectionRequirements.Builder getPhysicalConnectionRequirements() {
            return this.physicalConnectionRequirements != null ? this.physicalConnectionRequirements.toBuilder() : null;
        }

        public final void setPhysicalConnectionRequirements(PhysicalConnectionRequirements.BuilderImpl physicalConnectionRequirements) {
            this.physicalConnectionRequirements = physicalConnectionRequirements != null ? physicalConnectionRequirements.build() : null;
        }

        @Override
        public final Builder physicalConnectionRequirements(PhysicalConnectionRequirements physicalConnectionRequirements) {
            this.physicalConnectionRequirements = physicalConnectionRequirements;
            return this;
        }

        public final Map<String, String> getPythonProperties() {
            if (this.pythonProperties instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.pythonProperties;
        }

        public final void setPythonProperties(Map<String, String> pythonProperties) {
            this.pythonProperties = PropertyMapCopier.copy(pythonProperties);
        }

        @Override
        public final Builder pythonProperties(Map<String, String> pythonProperties) {
            this.pythonProperties = PropertyMapCopier.copy(pythonProperties);
            return this;
        }

        public final Map<String, String> getSparkProperties() {
            if (this.sparkProperties instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.sparkProperties;
        }

        public final void setSparkProperties(Map<String, String> sparkProperties) {
            this.sparkProperties = PropertyMapCopier.copy(sparkProperties);
        }

        @Override
        public final Builder sparkProperties(Map<String, String> sparkProperties) {
            this.sparkProperties = PropertyMapCopier.copy(sparkProperties);
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(ConnectionStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getStatusReason() {
            return this.statusReason;
        }

        public final void setStatusReason(String statusReason) {
            this.statusReason = statusReason;
        }

        @Override
        public final Builder statusReason(String statusReason) {
            this.statusReason = statusReason;
            return this;
        }

        @Override
        public GlueConnection build() {
            return new GlueConnection(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, GlueConnection> {
        public Builder athenaProperties(Map<String, String> var1);

        public Builder authenticationConfiguration(AuthenticationConfiguration var1);

        default public Builder authenticationConfiguration(Consumer<AuthenticationConfiguration.Builder> authenticationConfiguration) {
            return this.authenticationConfiguration((AuthenticationConfiguration)AuthenticationConfiguration.builder().applyMutation(authenticationConfiguration).build());
        }

        public Builder compatibleComputeEnvironmentsWithStrings(Collection<String> var1);

        public Builder compatibleComputeEnvironmentsWithStrings(String ... var1);

        public Builder compatibleComputeEnvironments(Collection<ComputeEnvironments> var1);

        public Builder compatibleComputeEnvironments(ComputeEnvironments ... var1);

        public Builder connectionProperties(Map<String, String> var1);

        public Builder connectionSchemaVersion(Integer var1);

        public Builder connectionType(String var1);

        public Builder connectionType(ConnectionType var1);

        public Builder creationTime(Instant var1);

        public Builder description(String var1);

        public Builder lastConnectionValidationTime(Instant var1);

        public Builder lastUpdatedBy(String var1);

        public Builder lastUpdatedTime(Instant var1);

        public Builder matchCriteria(Collection<String> var1);

        public Builder matchCriteria(String ... var1);

        public Builder name(String var1);

        public Builder physicalConnectionRequirements(PhysicalConnectionRequirements var1);

        default public Builder physicalConnectionRequirements(Consumer<PhysicalConnectionRequirements.Builder> physicalConnectionRequirements) {
            return this.physicalConnectionRequirements((PhysicalConnectionRequirements)PhysicalConnectionRequirements.builder().applyMutation(physicalConnectionRequirements).build());
        }

        public Builder pythonProperties(Map<String, String> var1);

        public Builder sparkProperties(Map<String, String> var1);

        public Builder status(String var1);

        public Builder status(ConnectionStatus var1);

        public Builder statusReason(String var1);
    }
}

