/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.datazone.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GlueOAuth2Credentials
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, GlueOAuth2Credentials> {
    private static final SdkField<String> ACCESS_TOKEN_FIELD = SdkField.builder(MarshallingType.STRING).memberName("accessToken").getter(GlueOAuth2Credentials.getter(GlueOAuth2Credentials::accessToken)).setter(GlueOAuth2Credentials.setter(Builder::accessToken)).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("accessToken").build()).build();
    private static final SdkField<String> JWT_TOKEN_FIELD = SdkField.builder(MarshallingType.STRING).memberName("jwtToken").getter(GlueOAuth2Credentials.getter(GlueOAuth2Credentials::jwtToken)).setter(GlueOAuth2Credentials.setter(Builder::jwtToken)).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("jwtToken").build()).build();
    private static final SdkField<String> REFRESH_TOKEN_FIELD = SdkField.builder(MarshallingType.STRING).memberName("refreshToken").getter(GlueOAuth2Credentials.getter(GlueOAuth2Credentials::refreshToken)).setter(GlueOAuth2Credentials.setter(Builder::refreshToken)).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("refreshToken").build()).build();
    private static final SdkField<String> USER_MANAGED_CLIENT_APPLICATION_CLIENT_SECRET_FIELD = SdkField.builder(MarshallingType.STRING).memberName("userManagedClientApplicationClientSecret").getter(GlueOAuth2Credentials.getter(GlueOAuth2Credentials::userManagedClientApplicationClientSecret)).setter(GlueOAuth2Credentials.setter(Builder::userManagedClientApplicationClientSecret)).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("userManagedClientApplicationClientSecret").build()).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCESS_TOKEN_FIELD, JWT_TOKEN_FIELD, REFRESH_TOKEN_FIELD, USER_MANAGED_CLIENT_APPLICATION_CLIENT_SECRET_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GlueOAuth2Credentials.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String accessToken;
    private final String jwtToken;
    private final String refreshToken;
    private final String userManagedClientApplicationClientSecret;

    private GlueOAuth2Credentials(BuilderImpl builder) {
        this.accessToken = builder.accessToken;
        this.jwtToken = builder.jwtToken;
        this.refreshToken = builder.refreshToken;
        this.userManagedClientApplicationClientSecret = builder.userManagedClientApplicationClientSecret;
    }

    public final String accessToken() {
        return this.accessToken;
    }

    public final String jwtToken() {
        return this.jwtToken;
    }

    public final String refreshToken() {
        return this.refreshToken;
    }

    public final String userManagedClientApplicationClientSecret() {
        return this.userManagedClientApplicationClientSecret;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.accessToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.jwtToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.refreshToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.userManagedClientApplicationClientSecret());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GlueOAuth2Credentials)) {
            return false;
        }
        GlueOAuth2Credentials other = (GlueOAuth2Credentials)obj;
        return Objects.equals(this.accessToken(), other.accessToken()) && Objects.equals(this.jwtToken(), other.jwtToken()) && Objects.equals(this.refreshToken(), other.refreshToken()) && Objects.equals(this.userManagedClientApplicationClientSecret(), other.userManagedClientApplicationClientSecret());
    }

    public final String toString() {
        return ToString.builder("GlueOAuth2Credentials").add("AccessToken", this.accessToken()).add("JwtToken", this.jwtToken()).add("RefreshToken", this.refreshToken()).add("UserManagedClientApplicationClientSecret", this.userManagedClientApplicationClientSecret()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "accessToken": {
                return Optional.ofNullable(clazz.cast(this.accessToken()));
            }
            case "jwtToken": {
                return Optional.ofNullable(clazz.cast(this.jwtToken()));
            }
            case "refreshToken": {
                return Optional.ofNullable(clazz.cast(this.refreshToken()));
            }
            case "userManagedClientApplicationClientSecret": {
                return Optional.ofNullable(clazz.cast(this.userManagedClientApplicationClientSecret()));
            }
        }
        return Optional.empty();
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("accessToken", ACCESS_TOKEN_FIELD);
        map.put("jwtToken", JWT_TOKEN_FIELD);
        map.put("refreshToken", REFRESH_TOKEN_FIELD);
        map.put("userManagedClientApplicationClientSecret", USER_MANAGED_CLIENT_APPLICATION_CLIENT_SECRET_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GlueOAuth2Credentials, T> g) {
        return obj -> g.apply((GlueOAuth2Credentials)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String accessToken;
        private String jwtToken;
        private String refreshToken;
        private String userManagedClientApplicationClientSecret;

        private BuilderImpl() {
        }

        private BuilderImpl(GlueOAuth2Credentials model) {
            this.accessToken(model.accessToken);
            this.jwtToken(model.jwtToken);
            this.refreshToken(model.refreshToken);
            this.userManagedClientApplicationClientSecret(model.userManagedClientApplicationClientSecret);
        }

        public final String getAccessToken() {
            return this.accessToken;
        }

        public final void setAccessToken(String accessToken) {
            this.accessToken = accessToken;
        }

        @Override
        public final Builder accessToken(String accessToken) {
            this.accessToken = accessToken;
            return this;
        }

        public final String getJwtToken() {
            return this.jwtToken;
        }

        public final void setJwtToken(String jwtToken) {
            this.jwtToken = jwtToken;
        }

        @Override
        public final Builder jwtToken(String jwtToken) {
            this.jwtToken = jwtToken;
            return this;
        }

        public final String getRefreshToken() {
            return this.refreshToken;
        }

        public final void setRefreshToken(String refreshToken) {
            this.refreshToken = refreshToken;
        }

        @Override
        public final Builder refreshToken(String refreshToken) {
            this.refreshToken = refreshToken;
            return this;
        }

        public final String getUserManagedClientApplicationClientSecret() {
            return this.userManagedClientApplicationClientSecret;
        }

        public final void setUserManagedClientApplicationClientSecret(String userManagedClientApplicationClientSecret) {
            this.userManagedClientApplicationClientSecret = userManagedClientApplicationClientSecret;
        }

        @Override
        public final Builder userManagedClientApplicationClientSecret(String userManagedClientApplicationClientSecret) {
            this.userManagedClientApplicationClientSecret = userManagedClientApplicationClientSecret;
            return this;
        }

        @Override
        public GlueOAuth2Credentials build() {
            return new GlueOAuth2Credentials(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, GlueOAuth2Credentials> {
        public Builder accessToken(String var1);

        public Builder jwtToken(String var1);

        public Builder refreshToken(String var1);

        public Builder userManagedClientApplicationClientSecret(String var1);
    }
}

