/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.datazone.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.services.datazone.model.DataZoneRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListEnvironmentBlueprintsRequest
extends DataZoneRequest
implements ToCopyableBuilder<Builder, ListEnvironmentBlueprintsRequest> {
    private static final SdkField<String> DOMAIN_IDENTIFIER_FIELD = SdkField.builder(MarshallingType.STRING).memberName("domainIdentifier").getter(ListEnvironmentBlueprintsRequest.getter(ListEnvironmentBlueprintsRequest::domainIdentifier)).setter(ListEnvironmentBlueprintsRequest.setter(Builder::domainIdentifier)).traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("domainIdentifier").build()).build();
    private static final SdkField<Boolean> MANAGED_FIELD = SdkField.builder(MarshallingType.BOOLEAN).memberName("managed").getter(ListEnvironmentBlueprintsRequest.getter(ListEnvironmentBlueprintsRequest::managed)).setter(ListEnvironmentBlueprintsRequest.setter(Builder::managed)).traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("managed").build()).build();
    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.builder(MarshallingType.INTEGER).memberName("maxResults").getter(ListEnvironmentBlueprintsRequest.getter(ListEnvironmentBlueprintsRequest::maxResults)).setter(ListEnvironmentBlueprintsRequest.setter(Builder::maxResults)).traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("maxResults").build()).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder(MarshallingType.STRING).memberName("name").getter(ListEnvironmentBlueprintsRequest.getter(ListEnvironmentBlueprintsRequest::name)).setter(ListEnvironmentBlueprintsRequest.setter(Builder::name)).traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("name").build()).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder(MarshallingType.STRING).memberName("nextToken").getter(ListEnvironmentBlueprintsRequest.getter(ListEnvironmentBlueprintsRequest::nextToken)).setter(ListEnvironmentBlueprintsRequest.setter(Builder::nextToken)).traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("nextToken").build()).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DOMAIN_IDENTIFIER_FIELD, MANAGED_FIELD, MAX_RESULTS_FIELD, NAME_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListEnvironmentBlueprintsRequest.memberNameToFieldInitializer();
    private final String domainIdentifier;
    private final Boolean managed;
    private final Integer maxResults;
    private final String name;
    private final String nextToken;

    private ListEnvironmentBlueprintsRequest(BuilderImpl builder) {
        super(builder);
        this.domainIdentifier = builder.domainIdentifier;
        this.managed = builder.managed;
        this.maxResults = builder.maxResults;
        this.name = builder.name;
        this.nextToken = builder.nextToken;
    }

    public final String domainIdentifier() {
        return this.domainIdentifier;
    }

    public final Boolean managed() {
        return this.managed;
    }

    public final Integer maxResults() {
        return this.maxResults;
    }

    public final String name() {
        return this.name;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.domainIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.managed());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListEnvironmentBlueprintsRequest)) {
            return false;
        }
        ListEnvironmentBlueprintsRequest other = (ListEnvironmentBlueprintsRequest)obj;
        return Objects.equals(this.domainIdentifier(), other.domainIdentifier()) && Objects.equals(this.managed(), other.managed()) && Objects.equals(this.maxResults(), other.maxResults()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder("ListEnvironmentBlueprintsRequest").add("DomainIdentifier", this.domainIdentifier()).add("Managed", this.managed()).add("MaxResults", this.maxResults()).add("Name", this.name()).add("NextToken", this.nextToken()).build();
    }

    @Override
    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "domainIdentifier": {
                return Optional.ofNullable(clazz.cast(this.domainIdentifier()));
            }
            case "managed": {
                return Optional.ofNullable(clazz.cast(this.managed()));
            }
            case "maxResults": {
                return Optional.ofNullable(clazz.cast(this.maxResults()));
            }
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<Object>> map = new HashMap<String, SdkField<Object>>();
        map.put("domainIdentifier", DOMAIN_IDENTIFIER_FIELD);
        map.put("managed", MANAGED_FIELD);
        map.put("maxResults", MAX_RESULTS_FIELD);
        map.put("name", NAME_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListEnvironmentBlueprintsRequest, T> g) {
        return obj -> g.apply((ListEnvironmentBlueprintsRequest)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends DataZoneRequest.BuilderImpl
    implements Builder {
        private String domainIdentifier;
        private Boolean managed;
        private Integer maxResults;
        private String name;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListEnvironmentBlueprintsRequest model) {
            super(model);
            this.domainIdentifier(model.domainIdentifier);
            this.managed(model.managed);
            this.maxResults(model.maxResults);
            this.name(model.name);
            this.nextToken(model.nextToken);
        }

        public final String getDomainIdentifier() {
            return this.domainIdentifier;
        }

        public final void setDomainIdentifier(String domainIdentifier) {
            this.domainIdentifier = domainIdentifier;
        }

        @Override
        public final Builder domainIdentifier(String domainIdentifier) {
            this.domainIdentifier = domainIdentifier;
            return this;
        }

        public final Boolean getManaged() {
            return this.managed;
        }

        public final void setManaged(Boolean managed) {
            this.managed = managed;
        }

        @Override
        public final Builder managed(Boolean managed) {
            this.managed = managed;
            return this;
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListEnvironmentBlueprintsRequest build() {
            return new ListEnvironmentBlueprintsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends DataZoneRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListEnvironmentBlueprintsRequest> {
        public Builder domainIdentifier(String var1);

        public Builder managed(Boolean var1);

        public Builder maxResults(Integer var1);

        public Builder name(String var1);

        public Builder nextToken(String var1);

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

