/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.datazone.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.services.datazone.model.DataZoneRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListEnvironmentProfilesRequest
extends DataZoneRequest
implements ToCopyableBuilder<Builder, ListEnvironmentProfilesRequest> {
    private static final SdkField<String> AWS_ACCOUNT_ID_FIELD = SdkField.builder(MarshallingType.STRING).memberName("awsAccountId").getter(ListEnvironmentProfilesRequest.getter(ListEnvironmentProfilesRequest::awsAccountId)).setter(ListEnvironmentProfilesRequest.setter(Builder::awsAccountId)).traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("awsAccountId").build()).build();
    private static final SdkField<String> AWS_ACCOUNT_REGION_FIELD = SdkField.builder(MarshallingType.STRING).memberName("awsAccountRegion").getter(ListEnvironmentProfilesRequest.getter(ListEnvironmentProfilesRequest::awsAccountRegion)).setter(ListEnvironmentProfilesRequest.setter(Builder::awsAccountRegion)).traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("awsAccountRegion").build()).build();
    private static final SdkField<String> DOMAIN_IDENTIFIER_FIELD = SdkField.builder(MarshallingType.STRING).memberName("domainIdentifier").getter(ListEnvironmentProfilesRequest.getter(ListEnvironmentProfilesRequest::domainIdentifier)).setter(ListEnvironmentProfilesRequest.setter(Builder::domainIdentifier)).traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("domainIdentifier").build()).build();
    private static final SdkField<String> ENVIRONMENT_BLUEPRINT_IDENTIFIER_FIELD = SdkField.builder(MarshallingType.STRING).memberName("environmentBlueprintIdentifier").getter(ListEnvironmentProfilesRequest.getter(ListEnvironmentProfilesRequest::environmentBlueprintIdentifier)).setter(ListEnvironmentProfilesRequest.setter(Builder::environmentBlueprintIdentifier)).traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("environmentBlueprintIdentifier").build()).build();
    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.builder(MarshallingType.INTEGER).memberName("maxResults").getter(ListEnvironmentProfilesRequest.getter(ListEnvironmentProfilesRequest::maxResults)).setter(ListEnvironmentProfilesRequest.setter(Builder::maxResults)).traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("maxResults").build()).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder(MarshallingType.STRING).memberName("name").getter(ListEnvironmentProfilesRequest.getter(ListEnvironmentProfilesRequest::name)).setter(ListEnvironmentProfilesRequest.setter(Builder::name)).traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("name").build()).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder(MarshallingType.STRING).memberName("nextToken").getter(ListEnvironmentProfilesRequest.getter(ListEnvironmentProfilesRequest::nextToken)).setter(ListEnvironmentProfilesRequest.setter(Builder::nextToken)).traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("nextToken").build()).build();
    private static final SdkField<String> PROJECT_IDENTIFIER_FIELD = SdkField.builder(MarshallingType.STRING).memberName("projectIdentifier").getter(ListEnvironmentProfilesRequest.getter(ListEnvironmentProfilesRequest::projectIdentifier)).setter(ListEnvironmentProfilesRequest.setter(Builder::projectIdentifier)).traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("projectIdentifier").build()).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AWS_ACCOUNT_ID_FIELD, AWS_ACCOUNT_REGION_FIELD, DOMAIN_IDENTIFIER_FIELD, ENVIRONMENT_BLUEPRINT_IDENTIFIER_FIELD, MAX_RESULTS_FIELD, NAME_FIELD, NEXT_TOKEN_FIELD, PROJECT_IDENTIFIER_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListEnvironmentProfilesRequest.memberNameToFieldInitializer();
    private final String awsAccountId;
    private final String awsAccountRegion;
    private final String domainIdentifier;
    private final String environmentBlueprintIdentifier;
    private final Integer maxResults;
    private final String name;
    private final String nextToken;
    private final String projectIdentifier;

    private ListEnvironmentProfilesRequest(BuilderImpl builder) {
        super(builder);
        this.awsAccountId = builder.awsAccountId;
        this.awsAccountRegion = builder.awsAccountRegion;
        this.domainIdentifier = builder.domainIdentifier;
        this.environmentBlueprintIdentifier = builder.environmentBlueprintIdentifier;
        this.maxResults = builder.maxResults;
        this.name = builder.name;
        this.nextToken = builder.nextToken;
        this.projectIdentifier = builder.projectIdentifier;
    }

    public final String awsAccountId() {
        return this.awsAccountId;
    }

    public final String awsAccountRegion() {
        return this.awsAccountRegion;
    }

    public final String domainIdentifier() {
        return this.domainIdentifier;
    }

    public final String environmentBlueprintIdentifier() {
        return this.environmentBlueprintIdentifier;
    }

    public final Integer maxResults() {
        return this.maxResults;
    }

    public final String name() {
        return this.name;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final String projectIdentifier() {
        return this.projectIdentifier;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.awsAccountId());
        hashCode = 31 * hashCode + Objects.hashCode(this.awsAccountRegion());
        hashCode = 31 * hashCode + Objects.hashCode(this.domainIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.environmentBlueprintIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.projectIdentifier());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListEnvironmentProfilesRequest)) {
            return false;
        }
        ListEnvironmentProfilesRequest other = (ListEnvironmentProfilesRequest)obj;
        return Objects.equals(this.awsAccountId(), other.awsAccountId()) && Objects.equals(this.awsAccountRegion(), other.awsAccountRegion()) && Objects.equals(this.domainIdentifier(), other.domainIdentifier()) && Objects.equals(this.environmentBlueprintIdentifier(), other.environmentBlueprintIdentifier()) && Objects.equals(this.maxResults(), other.maxResults()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.nextToken(), other.nextToken()) && Objects.equals(this.projectIdentifier(), other.projectIdentifier());
    }

    public final String toString() {
        return ToString.builder("ListEnvironmentProfilesRequest").add("AwsAccountId", this.awsAccountId()).add("AwsAccountRegion", this.awsAccountRegion()).add("DomainIdentifier", this.domainIdentifier()).add("EnvironmentBlueprintIdentifier", this.environmentBlueprintIdentifier()).add("MaxResults", this.maxResults()).add("Name", this.name() == null ? null : "*** Sensitive Data Redacted ***").add("NextToken", this.nextToken()).add("ProjectIdentifier", this.projectIdentifier()).build();
    }

    @Override
    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "awsAccountId": {
                return Optional.ofNullable(clazz.cast(this.awsAccountId()));
            }
            case "awsAccountRegion": {
                return Optional.ofNullable(clazz.cast(this.awsAccountRegion()));
            }
            case "domainIdentifier": {
                return Optional.ofNullable(clazz.cast(this.domainIdentifier()));
            }
            case "environmentBlueprintIdentifier": {
                return Optional.ofNullable(clazz.cast(this.environmentBlueprintIdentifier()));
            }
            case "maxResults": {
                return Optional.ofNullable(clazz.cast(this.maxResults()));
            }
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "projectIdentifier": {
                return Optional.ofNullable(clazz.cast(this.projectIdentifier()));
            }
        }
        return Optional.empty();
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<Object>> map = new HashMap<String, SdkField<Object>>();
        map.put("awsAccountId", AWS_ACCOUNT_ID_FIELD);
        map.put("awsAccountRegion", AWS_ACCOUNT_REGION_FIELD);
        map.put("domainIdentifier", DOMAIN_IDENTIFIER_FIELD);
        map.put("environmentBlueprintIdentifier", ENVIRONMENT_BLUEPRINT_IDENTIFIER_FIELD);
        map.put("maxResults", MAX_RESULTS_FIELD);
        map.put("name", NAME_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        map.put("projectIdentifier", PROJECT_IDENTIFIER_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListEnvironmentProfilesRequest, T> g) {
        return obj -> g.apply((ListEnvironmentProfilesRequest)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends DataZoneRequest.BuilderImpl
    implements Builder {
        private String awsAccountId;
        private String awsAccountRegion;
        private String domainIdentifier;
        private String environmentBlueprintIdentifier;
        private Integer maxResults;
        private String name;
        private String nextToken;
        private String projectIdentifier;

        private BuilderImpl() {
        }

        private BuilderImpl(ListEnvironmentProfilesRequest model) {
            super(model);
            this.awsAccountId(model.awsAccountId);
            this.awsAccountRegion(model.awsAccountRegion);
            this.domainIdentifier(model.domainIdentifier);
            this.environmentBlueprintIdentifier(model.environmentBlueprintIdentifier);
            this.maxResults(model.maxResults);
            this.name(model.name);
            this.nextToken(model.nextToken);
            this.projectIdentifier(model.projectIdentifier);
        }

        public final String getAwsAccountId() {
            return this.awsAccountId;
        }

        public final void setAwsAccountId(String awsAccountId) {
            this.awsAccountId = awsAccountId;
        }

        @Override
        public final Builder awsAccountId(String awsAccountId) {
            this.awsAccountId = awsAccountId;
            return this;
        }

        public final String getAwsAccountRegion() {
            return this.awsAccountRegion;
        }

        public final void setAwsAccountRegion(String awsAccountRegion) {
            this.awsAccountRegion = awsAccountRegion;
        }

        @Override
        public final Builder awsAccountRegion(String awsAccountRegion) {
            this.awsAccountRegion = awsAccountRegion;
            return this;
        }

        public final String getDomainIdentifier() {
            return this.domainIdentifier;
        }

        public final void setDomainIdentifier(String domainIdentifier) {
            this.domainIdentifier = domainIdentifier;
        }

        @Override
        public final Builder domainIdentifier(String domainIdentifier) {
            this.domainIdentifier = domainIdentifier;
            return this;
        }

        public final String getEnvironmentBlueprintIdentifier() {
            return this.environmentBlueprintIdentifier;
        }

        public final void setEnvironmentBlueprintIdentifier(String environmentBlueprintIdentifier) {
            this.environmentBlueprintIdentifier = environmentBlueprintIdentifier;
        }

        @Override
        public final Builder environmentBlueprintIdentifier(String environmentBlueprintIdentifier) {
            this.environmentBlueprintIdentifier = environmentBlueprintIdentifier;
            return this;
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final String getProjectIdentifier() {
            return this.projectIdentifier;
        }

        public final void setProjectIdentifier(String projectIdentifier) {
            this.projectIdentifier = projectIdentifier;
        }

        @Override
        public final Builder projectIdentifier(String projectIdentifier) {
            this.projectIdentifier = projectIdentifier;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListEnvironmentProfilesRequest build() {
            return new ListEnvironmentProfilesRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends DataZoneRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListEnvironmentProfilesRequest> {
        public Builder awsAccountId(String var1);

        public Builder awsAccountRegion(String var1);

        public Builder domainIdentifier(String var1);

        public Builder environmentBlueprintIdentifier(String var1);

        public Builder maxResults(Integer var1);

        public Builder name(String var1);

        public Builder nextToken(String var1);

        public Builder projectIdentifier(String var1);

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

