/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.datazone.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class MetadataFormReference
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, MetadataFormReference> {
    private static final SdkField<String> TYPE_IDENTIFIER_FIELD = SdkField.builder(MarshallingType.STRING).memberName("typeIdentifier").getter(MetadataFormReference.getter(MetadataFormReference::typeIdentifier)).setter(MetadataFormReference.setter(Builder::typeIdentifier)).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("typeIdentifier").build()).build();
    private static final SdkField<String> TYPE_REVISION_FIELD = SdkField.builder(MarshallingType.STRING).memberName("typeRevision").getter(MetadataFormReference.getter(MetadataFormReference::typeRevision)).setter(MetadataFormReference.setter(Builder::typeRevision)).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("typeRevision").build()).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TYPE_IDENTIFIER_FIELD, TYPE_REVISION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = MetadataFormReference.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String typeIdentifier;
    private final String typeRevision;

    private MetadataFormReference(BuilderImpl builder) {
        this.typeIdentifier = builder.typeIdentifier;
        this.typeRevision = builder.typeRevision;
    }

    public final String typeIdentifier() {
        return this.typeIdentifier;
    }

    public final String typeRevision() {
        return this.typeRevision;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.typeIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.typeRevision());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MetadataFormReference)) {
            return false;
        }
        MetadataFormReference other = (MetadataFormReference)obj;
        return Objects.equals(this.typeIdentifier(), other.typeIdentifier()) && Objects.equals(this.typeRevision(), other.typeRevision());
    }

    public final String toString() {
        return ToString.builder("MetadataFormReference").add("TypeIdentifier", this.typeIdentifier()).add("TypeRevision", this.typeRevision()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "typeIdentifier": {
                return Optional.ofNullable(clazz.cast(this.typeIdentifier()));
            }
            case "typeRevision": {
                return Optional.ofNullable(clazz.cast(this.typeRevision()));
            }
        }
        return Optional.empty();
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("typeIdentifier", TYPE_IDENTIFIER_FIELD);
        map.put("typeRevision", TYPE_REVISION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<MetadataFormReference, T> g) {
        return obj -> g.apply((MetadataFormReference)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String typeIdentifier;
        private String typeRevision;

        private BuilderImpl() {
        }

        private BuilderImpl(MetadataFormReference model) {
            this.typeIdentifier(model.typeIdentifier);
            this.typeRevision(model.typeRevision);
        }

        public final String getTypeIdentifier() {
            return this.typeIdentifier;
        }

        public final void setTypeIdentifier(String typeIdentifier) {
            this.typeIdentifier = typeIdentifier;
        }

        @Override
        public final Builder typeIdentifier(String typeIdentifier) {
            this.typeIdentifier = typeIdentifier;
            return this;
        }

        public final String getTypeRevision() {
            return this.typeRevision;
        }

        public final void setTypeRevision(String typeRevision) {
            this.typeRevision = typeRevision;
        }

        @Override
        public final Builder typeRevision(String typeRevision) {
            this.typeRevision = typeRevision;
            return this;
        }

        @Override
        public MetadataFormReference build() {
            return new MetadataFormReference(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, MetadataFormReference> {
        public Builder typeIdentifier(String var1);

        public Builder typeRevision(String var1);
    }
}

