/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.datazone.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Model
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Model> {
    private static final SdkField<String> SMITHY_FIELD = SdkField.builder(MarshallingType.STRING).memberName("smithy").getter(Model.getter(Model::smithy)).setter(Model.setter(Builder::smithy)).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("smithy").build()).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SMITHY_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Model.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String smithy;
    private final Type type;

    private Model(BuilderImpl builder) {
        this.smithy = builder.smithy;
        this.type = builder.type;
    }

    public final String smithy() {
        return this.smithy;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.smithy());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Model)) {
            return false;
        }
        Model other = (Model)obj;
        return Objects.equals(this.smithy(), other.smithy());
    }

    public final String toString() {
        return ToString.builder("Model").add("Smithy", this.smithy()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "smithy": {
                return Optional.ofNullable(clazz.cast(this.smithy()));
            }
        }
        return Optional.empty();
    }

    public static Model fromSmithy(String smithy) {
        return (Model)Model.builder().smithy(smithy).build();
    }

    public Type type() {
        return this.type;
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("smithy", SMITHY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Model, T> g) {
        return obj -> g.apply((Model)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String smithy;
        private Type type = Type.UNKNOWN_TO_SDK_VERSION;
        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(Model model) {
            this.smithy(model.smithy);
        }

        public final String getSmithy() {
            return this.smithy;
        }

        public final void setSmithy(String smithy) {
            String oldValue = this.smithy;
            this.smithy = smithy;
            this.handleUnionValueChange(Type.SMITHY, oldValue, this.smithy);
        }

        @Override
        public final Builder smithy(String smithy) {
            String oldValue = this.smithy;
            this.smithy = smithy;
            this.handleUnionValueChange(Type.SMITHY, oldValue, this.smithy);
            return this;
        }

        @Override
        public Model build() {
            return new Model(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                this.setTypes.remove((Object)type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                this.setTypes.add(type);
            }
            this.type = this.setTypes.size() == 1 ? this.setTypes.iterator().next() : (this.setTypes.isEmpty() ? Type.UNKNOWN_TO_SDK_VERSION : null);
        }
    }

    public static enum Type {
        SMITHY,
        UNKNOWN_TO_SDK_VERSION;

    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Model> {
        public Builder smithy(String var1);
    }
}

