/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.datazone.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.services.datazone.model.AssetScope;
import software.amazon.awssdk.services.datazone.model.FailureCause;
import software.amazon.awssdk.services.datazone.model.Permissions;
import software.amazon.awssdk.services.datazone.model.SubscriptionGrantStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SubscribedAsset
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, SubscribedAsset> {
    private static final SdkField<String> ASSET_ID_FIELD = SdkField.builder(MarshallingType.STRING).memberName("assetId").getter(SubscribedAsset.getter(SubscribedAsset::assetId)).setter(SubscribedAsset.setter(Builder::assetId)).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("assetId").build()).build();
    private static final SdkField<String> ASSET_REVISION_FIELD = SdkField.builder(MarshallingType.STRING).memberName("assetRevision").getter(SubscribedAsset.getter(SubscribedAsset::assetRevision)).setter(SubscribedAsset.setter(Builder::assetRevision)).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("assetRevision").build()).build();
    private static final SdkField<AssetScope> ASSET_SCOPE_FIELD = SdkField.builder(MarshallingType.SDK_POJO).memberName("assetScope").getter(SubscribedAsset.getter(SubscribedAsset::assetScope)).setter(SubscribedAsset.setter(Builder::assetScope)).constructor(AssetScope::builder).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("assetScope").build()).build();
    private static final SdkField<FailureCause> FAILURE_CAUSE_FIELD = SdkField.builder(MarshallingType.SDK_POJO).memberName("failureCause").getter(SubscribedAsset.getter(SubscribedAsset::failureCause)).setter(SubscribedAsset.setter(Builder::failureCause)).constructor(FailureCause::builder).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("failureCause").build()).build();
    private static final SdkField<Instant> FAILURE_TIMESTAMP_FIELD = SdkField.builder(MarshallingType.INSTANT).memberName("failureTimestamp").getter(SubscribedAsset.getter(SubscribedAsset::failureTimestamp)).setter(SubscribedAsset.setter(Builder::failureTimestamp)).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("failureTimestamp").build()).build();
    private static final SdkField<Instant> GRANTED_TIMESTAMP_FIELD = SdkField.builder(MarshallingType.INSTANT).memberName("grantedTimestamp").getter(SubscribedAsset.getter(SubscribedAsset::grantedTimestamp)).setter(SubscribedAsset.setter(Builder::grantedTimestamp)).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("grantedTimestamp").build()).build();
    private static final SdkField<Permissions> PERMISSIONS_FIELD = SdkField.builder(MarshallingType.SDK_POJO).memberName("permissions").getter(SubscribedAsset.getter(SubscribedAsset::permissions)).setter(SubscribedAsset.setter(Builder::permissions)).constructor(Permissions::builder).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("permissions").build()).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder(MarshallingType.STRING).memberName("status").getter(SubscribedAsset.getter(SubscribedAsset::statusAsString)).setter(SubscribedAsset.setter(Builder::status)).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();
    private static final SdkField<String> TARGET_NAME_FIELD = SdkField.builder(MarshallingType.STRING).memberName("targetName").getter(SubscribedAsset.getter(SubscribedAsset::targetName)).setter(SubscribedAsset.setter(Builder::targetName)).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("targetName").build()).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ASSET_ID_FIELD, ASSET_REVISION_FIELD, ASSET_SCOPE_FIELD, FAILURE_CAUSE_FIELD, FAILURE_TIMESTAMP_FIELD, GRANTED_TIMESTAMP_FIELD, PERMISSIONS_FIELD, STATUS_FIELD, TARGET_NAME_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = SubscribedAsset.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String assetId;
    private final String assetRevision;
    private final AssetScope assetScope;
    private final FailureCause failureCause;
    private final Instant failureTimestamp;
    private final Instant grantedTimestamp;
    private final Permissions permissions;
    private final String status;
    private final String targetName;

    private SubscribedAsset(BuilderImpl builder) {
        this.assetId = builder.assetId;
        this.assetRevision = builder.assetRevision;
        this.assetScope = builder.assetScope;
        this.failureCause = builder.failureCause;
        this.failureTimestamp = builder.failureTimestamp;
        this.grantedTimestamp = builder.grantedTimestamp;
        this.permissions = builder.permissions;
        this.status = builder.status;
        this.targetName = builder.targetName;
    }

    public final String assetId() {
        return this.assetId;
    }

    public final String assetRevision() {
        return this.assetRevision;
    }

    public final AssetScope assetScope() {
        return this.assetScope;
    }

    public final FailureCause failureCause() {
        return this.failureCause;
    }

    public final Instant failureTimestamp() {
        return this.failureTimestamp;
    }

    public final Instant grantedTimestamp() {
        return this.grantedTimestamp;
    }

    public final Permissions permissions() {
        return this.permissions;
    }

    public final SubscriptionGrantStatus status() {
        return SubscriptionGrantStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final String targetName() {
        return this.targetName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.assetId());
        hashCode = 31 * hashCode + Objects.hashCode(this.assetRevision());
        hashCode = 31 * hashCode + Objects.hashCode(this.assetScope());
        hashCode = 31 * hashCode + Objects.hashCode(this.failureCause());
        hashCode = 31 * hashCode + Objects.hashCode(this.failureTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(this.grantedTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(this.permissions());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.targetName());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SubscribedAsset)) {
            return false;
        }
        SubscribedAsset other = (SubscribedAsset)obj;
        return Objects.equals(this.assetId(), other.assetId()) && Objects.equals(this.assetRevision(), other.assetRevision()) && Objects.equals(this.assetScope(), other.assetScope()) && Objects.equals(this.failureCause(), other.failureCause()) && Objects.equals(this.failureTimestamp(), other.failureTimestamp()) && Objects.equals(this.grantedTimestamp(), other.grantedTimestamp()) && Objects.equals(this.permissions(), other.permissions()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.targetName(), other.targetName());
    }

    public final String toString() {
        return ToString.builder("SubscribedAsset").add("AssetId", this.assetId()).add("AssetRevision", this.assetRevision()).add("AssetScope", this.assetScope()).add("FailureCause", this.failureCause()).add("FailureTimestamp", this.failureTimestamp()).add("GrantedTimestamp", this.grantedTimestamp()).add("Permissions", this.permissions()).add("Status", this.statusAsString()).add("TargetName", this.targetName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "assetId": {
                return Optional.ofNullable(clazz.cast(this.assetId()));
            }
            case "assetRevision": {
                return Optional.ofNullable(clazz.cast(this.assetRevision()));
            }
            case "assetScope": {
                return Optional.ofNullable(clazz.cast(this.assetScope()));
            }
            case "failureCause": {
                return Optional.ofNullable(clazz.cast(this.failureCause()));
            }
            case "failureTimestamp": {
                return Optional.ofNullable(clazz.cast(this.failureTimestamp()));
            }
            case "grantedTimestamp": {
                return Optional.ofNullable(clazz.cast(this.grantedTimestamp()));
            }
            case "permissions": {
                return Optional.ofNullable(clazz.cast(this.permissions()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "targetName": {
                return Optional.ofNullable(clazz.cast(this.targetName()));
            }
        }
        return Optional.empty();
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<Object>> map = new HashMap<String, SdkField<Object>>();
        map.put("assetId", ASSET_ID_FIELD);
        map.put("assetRevision", ASSET_REVISION_FIELD);
        map.put("assetScope", ASSET_SCOPE_FIELD);
        map.put("failureCause", FAILURE_CAUSE_FIELD);
        map.put("failureTimestamp", FAILURE_TIMESTAMP_FIELD);
        map.put("grantedTimestamp", GRANTED_TIMESTAMP_FIELD);
        map.put("permissions", PERMISSIONS_FIELD);
        map.put("status", STATUS_FIELD);
        map.put("targetName", TARGET_NAME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SubscribedAsset, T> g) {
        return obj -> g.apply((SubscribedAsset)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String assetId;
        private String assetRevision;
        private AssetScope assetScope;
        private FailureCause failureCause;
        private Instant failureTimestamp;
        private Instant grantedTimestamp;
        private Permissions permissions;
        private String status;
        private String targetName;

        private BuilderImpl() {
        }

        private BuilderImpl(SubscribedAsset model) {
            this.assetId(model.assetId);
            this.assetRevision(model.assetRevision);
            this.assetScope(model.assetScope);
            this.failureCause(model.failureCause);
            this.failureTimestamp(model.failureTimestamp);
            this.grantedTimestamp(model.grantedTimestamp);
            this.permissions(model.permissions);
            this.status(model.status);
            this.targetName(model.targetName);
        }

        public final String getAssetId() {
            return this.assetId;
        }

        public final void setAssetId(String assetId) {
            this.assetId = assetId;
        }

        @Override
        public final Builder assetId(String assetId) {
            this.assetId = assetId;
            return this;
        }

        public final String getAssetRevision() {
            return this.assetRevision;
        }

        public final void setAssetRevision(String assetRevision) {
            this.assetRevision = assetRevision;
        }

        @Override
        public final Builder assetRevision(String assetRevision) {
            this.assetRevision = assetRevision;
            return this;
        }

        public final AssetScope.Builder getAssetScope() {
            return this.assetScope != null ? this.assetScope.toBuilder() : null;
        }

        public final void setAssetScope(AssetScope.BuilderImpl assetScope) {
            this.assetScope = assetScope != null ? assetScope.build() : null;
        }

        @Override
        public final Builder assetScope(AssetScope assetScope) {
            this.assetScope = assetScope;
            return this;
        }

        public final FailureCause.Builder getFailureCause() {
            return this.failureCause != null ? this.failureCause.toBuilder() : null;
        }

        public final void setFailureCause(FailureCause.BuilderImpl failureCause) {
            this.failureCause = failureCause != null ? failureCause.build() : null;
        }

        @Override
        public final Builder failureCause(FailureCause failureCause) {
            this.failureCause = failureCause;
            return this;
        }

        public final Instant getFailureTimestamp() {
            return this.failureTimestamp;
        }

        public final void setFailureTimestamp(Instant failureTimestamp) {
            this.failureTimestamp = failureTimestamp;
        }

        @Override
        public final Builder failureTimestamp(Instant failureTimestamp) {
            this.failureTimestamp = failureTimestamp;
            return this;
        }

        public final Instant getGrantedTimestamp() {
            return this.grantedTimestamp;
        }

        public final void setGrantedTimestamp(Instant grantedTimestamp) {
            this.grantedTimestamp = grantedTimestamp;
        }

        @Override
        public final Builder grantedTimestamp(Instant grantedTimestamp) {
            this.grantedTimestamp = grantedTimestamp;
            return this;
        }

        public final Permissions.Builder getPermissions() {
            return this.permissions != null ? this.permissions.toBuilder() : null;
        }

        public final void setPermissions(Permissions.BuilderImpl permissions) {
            this.permissions = permissions != null ? permissions.build() : null;
        }

        @Override
        public final Builder permissions(Permissions permissions) {
            this.permissions = permissions;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(SubscriptionGrantStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getTargetName() {
            return this.targetName;
        }

        public final void setTargetName(String targetName) {
            this.targetName = targetName;
        }

        @Override
        public final Builder targetName(String targetName) {
            this.targetName = targetName;
            return this;
        }

        @Override
        public SubscribedAsset build() {
            return new SubscribedAsset(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, SubscribedAsset> {
        public Builder assetId(String var1);

        public Builder assetRevision(String var1);

        public Builder assetScope(AssetScope var1);

        default public Builder assetScope(Consumer<AssetScope.Builder> assetScope) {
            return this.assetScope((AssetScope)AssetScope.builder().applyMutation(assetScope).build());
        }

        public Builder failureCause(FailureCause var1);

        default public Builder failureCause(Consumer<FailureCause.Builder> failureCause) {
            return this.failureCause((FailureCause)FailureCause.builder().applyMutation(failureCause).build());
        }

        public Builder failureTimestamp(Instant var1);

        public Builder grantedTimestamp(Instant var1);

        public Builder permissions(Permissions var1);

        default public Builder permissions(Consumer<Permissions.Builder> permissions) {
            return this.permissions((Permissions)Permissions.builder().applyMutation(permissions).build());
        }

        public Builder status(String var1);

        public Builder status(SubscriptionGrantStatus var1);

        public Builder targetName(String var1);
    }
}

