/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.datazone.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.datazone.model.SubscribedGroupInput;
import software.amazon.awssdk.services.datazone.model.SubscribedProjectInput;
import software.amazon.awssdk.services.datazone.model.SubscribedUserInput;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SubscribedPrincipalInput
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, SubscribedPrincipalInput> {
    private static final SdkField<SubscribedGroupInput> GROUP_FIELD = SdkField.builder(MarshallingType.SDK_POJO).memberName("group").getter(SubscribedPrincipalInput.getter(SubscribedPrincipalInput::group)).setter(SubscribedPrincipalInput.setter(Builder::group)).constructor(SubscribedGroupInput::builder).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("group").build()).build();
    private static final SdkField<SubscribedProjectInput> PROJECT_FIELD = SdkField.builder(MarshallingType.SDK_POJO).memberName("project").getter(SubscribedPrincipalInput.getter(SubscribedPrincipalInput::project)).setter(SubscribedPrincipalInput.setter(Builder::project)).constructor(SubscribedProjectInput::builder).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("project").build()).build();
    private static final SdkField<SubscribedUserInput> USER_FIELD = SdkField.builder(MarshallingType.SDK_POJO).memberName("user").getter(SubscribedPrincipalInput.getter(SubscribedPrincipalInput::user)).setter(SubscribedPrincipalInput.setter(Builder::user)).constructor(SubscribedUserInput::builder).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("user").build()).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GROUP_FIELD, PROJECT_FIELD, USER_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = SubscribedPrincipalInput.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final SubscribedGroupInput group;
    private final SubscribedProjectInput project;
    private final SubscribedUserInput user;
    private final Type type;

    private SubscribedPrincipalInput(BuilderImpl builder) {
        this.group = builder.group;
        this.project = builder.project;
        this.user = builder.user;
        this.type = builder.type;
    }

    public final SubscribedGroupInput group() {
        return this.group;
    }

    public final SubscribedProjectInput project() {
        return this.project;
    }

    public final SubscribedUserInput user() {
        return this.user;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.group());
        hashCode = 31 * hashCode + Objects.hashCode(this.project());
        hashCode = 31 * hashCode + Objects.hashCode(this.user());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SubscribedPrincipalInput)) {
            return false;
        }
        SubscribedPrincipalInput other = (SubscribedPrincipalInput)obj;
        return Objects.equals(this.group(), other.group()) && Objects.equals(this.project(), other.project()) && Objects.equals(this.user(), other.user());
    }

    public final String toString() {
        return ToString.builder("SubscribedPrincipalInput").add("Group", this.group()).add("Project", this.project()).add("User", this.user()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "group": {
                return Optional.ofNullable(clazz.cast(this.group()));
            }
            case "project": {
                return Optional.ofNullable(clazz.cast(this.project()));
            }
            case "user": {
                return Optional.ofNullable(clazz.cast(this.user()));
            }
        }
        return Optional.empty();
    }

    public static SubscribedPrincipalInput fromGroup(SubscribedGroupInput group) {
        return (SubscribedPrincipalInput)SubscribedPrincipalInput.builder().group(group).build();
    }

    public static SubscribedPrincipalInput fromGroup(Consumer<SubscribedGroupInput.Builder> group) {
        SubscribedGroupInput.Builder builder = SubscribedGroupInput.builder();
        group.accept(builder);
        return SubscribedPrincipalInput.fromGroup((SubscribedGroupInput)builder.build());
    }

    public static SubscribedPrincipalInput fromProject(SubscribedProjectInput project) {
        return (SubscribedPrincipalInput)SubscribedPrincipalInput.builder().project(project).build();
    }

    public static SubscribedPrincipalInput fromProject(Consumer<SubscribedProjectInput.Builder> project) {
        SubscribedProjectInput.Builder builder = SubscribedProjectInput.builder();
        project.accept(builder);
        return SubscribedPrincipalInput.fromProject((SubscribedProjectInput)builder.build());
    }

    public static SubscribedPrincipalInput fromUser(SubscribedUserInput user) {
        return (SubscribedPrincipalInput)SubscribedPrincipalInput.builder().user(user).build();
    }

    public static SubscribedPrincipalInput fromUser(Consumer<SubscribedUserInput.Builder> user) {
        SubscribedUserInput.Builder builder = SubscribedUserInput.builder();
        user.accept(builder);
        return SubscribedPrincipalInput.fromUser((SubscribedUserInput)builder.build());
    }

    public Type type() {
        return this.type;
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<SdkPojo>> map = new HashMap<String, SdkField<SdkPojo>>();
        map.put("group", GROUP_FIELD);
        map.put("project", PROJECT_FIELD);
        map.put("user", USER_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SubscribedPrincipalInput, T> g) {
        return obj -> g.apply((SubscribedPrincipalInput)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private SubscribedGroupInput group;
        private SubscribedProjectInput project;
        private SubscribedUserInput user;
        private Type type = Type.UNKNOWN_TO_SDK_VERSION;
        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(SubscribedPrincipalInput model) {
            this.group(model.group);
            this.project(model.project);
            this.user(model.user);
        }

        public final SubscribedGroupInput.Builder getGroup() {
            return this.group != null ? this.group.toBuilder() : null;
        }

        public final void setGroup(SubscribedGroupInput.BuilderImpl group) {
            SubscribedGroupInput oldValue = this.group;
            this.group = group != null ? group.build() : null;
            this.handleUnionValueChange(Type.GROUP, oldValue, this.group);
        }

        @Override
        public final Builder group(SubscribedGroupInput group) {
            SubscribedGroupInput oldValue = this.group;
            this.group = group;
            this.handleUnionValueChange(Type.GROUP, oldValue, this.group);
            return this;
        }

        public final SubscribedProjectInput.Builder getProject() {
            return this.project != null ? this.project.toBuilder() : null;
        }

        public final void setProject(SubscribedProjectInput.BuilderImpl project) {
            SubscribedProjectInput oldValue = this.project;
            this.project = project != null ? project.build() : null;
            this.handleUnionValueChange(Type.PROJECT, oldValue, this.project);
        }

        @Override
        public final Builder project(SubscribedProjectInput project) {
            SubscribedProjectInput oldValue = this.project;
            this.project = project;
            this.handleUnionValueChange(Type.PROJECT, oldValue, this.project);
            return this;
        }

        public final SubscribedUserInput.Builder getUser() {
            return this.user != null ? this.user.toBuilder() : null;
        }

        public final void setUser(SubscribedUserInput.BuilderImpl user) {
            SubscribedUserInput oldValue = this.user;
            this.user = user != null ? user.build() : null;
            this.handleUnionValueChange(Type.USER, oldValue, this.user);
        }

        @Override
        public final Builder user(SubscribedUserInput user) {
            SubscribedUserInput oldValue = this.user;
            this.user = user;
            this.handleUnionValueChange(Type.USER, oldValue, this.user);
            return this;
        }

        @Override
        public SubscribedPrincipalInput build() {
            return new SubscribedPrincipalInput(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                this.setTypes.remove((Object)type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                this.setTypes.add(type);
            }
            this.type = this.setTypes.size() == 1 ? this.setTypes.iterator().next() : (this.setTypes.isEmpty() ? Type.UNKNOWN_TO_SDK_VERSION : null);
        }
    }

    public static enum Type {
        GROUP,
        PROJECT,
        USER,
        UNKNOWN_TO_SDK_VERSION;

    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, SubscribedPrincipalInput> {
        public Builder group(SubscribedGroupInput var1);

        default public Builder group(Consumer<SubscribedGroupInput.Builder> group) {
            return this.group((SubscribedGroupInput)SubscribedGroupInput.builder().applyMutation(group).build());
        }

        public Builder project(SubscribedProjectInput var1);

        default public Builder project(Consumer<SubscribedProjectInput.Builder> project) {
            return this.project((SubscribedProjectInput)SubscribedProjectInput.builder().applyMutation(project).build());
        }

        public Builder user(SubscribedUserInput var1);

        default public Builder user(Consumer<SubscribedUserInput.Builder> user) {
            return this.user((SubscribedUserInput)SubscribedUserInput.builder().applyMutation(user).build());
        }
    }
}

