/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.datazone.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.datazone.model.MetadataFormSummary;
import software.amazon.awssdk.services.datazone.model.MetadataFormsSummaryCopier;
import software.amazon.awssdk.services.datazone.model.SubscribedListing;
import software.amazon.awssdk.services.datazone.model.SubscribedPrincipal;
import software.amazon.awssdk.services.datazone.model.SubscriptionRequestStatus;
import software.amazon.awssdk.services.datazone.model.SubscriptionRequestSummarySubscribedListingsListCopier;
import software.amazon.awssdk.services.datazone.model.SubscriptionRequestSummarySubscribedPrincipalsListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SubscriptionRequestSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, SubscriptionRequestSummary> {
    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.builder(MarshallingType.INSTANT).memberName("createdAt").getter(SubscriptionRequestSummary.getter(SubscriptionRequestSummary::createdAt)).setter(SubscriptionRequestSummary.setter(Builder::createdAt)).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build()).build();
    private static final SdkField<String> CREATED_BY_FIELD = SdkField.builder(MarshallingType.STRING).memberName("createdBy").getter(SubscriptionRequestSummary.getter(SubscriptionRequestSummary::createdBy)).setter(SubscriptionRequestSummary.setter(Builder::createdBy)).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdBy").build()).build();
    private static final SdkField<String> DECISION_COMMENT_FIELD = SdkField.builder(MarshallingType.STRING).memberName("decisionComment").getter(SubscriptionRequestSummary.getter(SubscriptionRequestSummary::decisionComment)).setter(SubscriptionRequestSummary.setter(Builder::decisionComment)).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("decisionComment").build()).build();
    private static final SdkField<String> DOMAIN_ID_FIELD = SdkField.builder(MarshallingType.STRING).memberName("domainId").getter(SubscriptionRequestSummary.getter(SubscriptionRequestSummary::domainId)).setter(SubscriptionRequestSummary.setter(Builder::domainId)).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("domainId").build()).build();
    private static final SdkField<String> EXISTING_SUBSCRIPTION_ID_FIELD = SdkField.builder(MarshallingType.STRING).memberName("existingSubscriptionId").getter(SubscriptionRequestSummary.getter(SubscriptionRequestSummary::existingSubscriptionId)).setter(SubscriptionRequestSummary.setter(Builder::existingSubscriptionId)).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("existingSubscriptionId").build()).build();
    private static final SdkField<String> ID_FIELD = SdkField.builder(MarshallingType.STRING).memberName("id").getter(SubscriptionRequestSummary.getter(SubscriptionRequestSummary::id)).setter(SubscriptionRequestSummary.setter(Builder::id)).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()).build();
    private static final SdkField<List<MetadataFormSummary>> METADATA_FORMS_SUMMARY_FIELD = SdkField.builder(MarshallingType.LIST).memberName("metadataFormsSummary").getter(SubscriptionRequestSummary.getter(SubscriptionRequestSummary::metadataFormsSummary)).setter(SubscriptionRequestSummary.setter(Builder::metadataFormsSummary)).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("metadataFormsSummary").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder(MarshallingType.SDK_POJO).constructor(MetadataFormSummary::builder).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()).build()).build()).build();
    private static final SdkField<String> REQUEST_REASON_FIELD = SdkField.builder(MarshallingType.STRING).memberName("requestReason").getter(SubscriptionRequestSummary.getter(SubscriptionRequestSummary::requestReason)).setter(SubscriptionRequestSummary.setter(Builder::requestReason)).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("requestReason").build()).build();
    private static final SdkField<String> REVIEWER_ID_FIELD = SdkField.builder(MarshallingType.STRING).memberName("reviewerId").getter(SubscriptionRequestSummary.getter(SubscriptionRequestSummary::reviewerId)).setter(SubscriptionRequestSummary.setter(Builder::reviewerId)).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("reviewerId").build()).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder(MarshallingType.STRING).memberName("status").getter(SubscriptionRequestSummary.getter(SubscriptionRequestSummary::statusAsString)).setter(SubscriptionRequestSummary.setter(Builder::status)).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();
    private static final SdkField<List<SubscribedListing>> SUBSCRIBED_LISTINGS_FIELD = SdkField.builder(MarshallingType.LIST).memberName("subscribedListings").getter(SubscriptionRequestSummary.getter(SubscriptionRequestSummary::subscribedListings)).setter(SubscriptionRequestSummary.setter(Builder::subscribedListings)).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("subscribedListings").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder(MarshallingType.SDK_POJO).constructor(SubscribedListing::builder).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()).build()).build()).build();
    private static final SdkField<List<SubscribedPrincipal>> SUBSCRIBED_PRINCIPALS_FIELD = SdkField.builder(MarshallingType.LIST).memberName("subscribedPrincipals").getter(SubscriptionRequestSummary.getter(SubscriptionRequestSummary::subscribedPrincipals)).setter(SubscriptionRequestSummary.setter(Builder::subscribedPrincipals)).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("subscribedPrincipals").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder(MarshallingType.SDK_POJO).constructor(SubscribedPrincipal::builder).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()).build()).build()).build();
    private static final SdkField<Instant> UPDATED_AT_FIELD = SdkField.builder(MarshallingType.INSTANT).memberName("updatedAt").getter(SubscriptionRequestSummary.getter(SubscriptionRequestSummary::updatedAt)).setter(SubscriptionRequestSummary.setter(Builder::updatedAt)).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updatedAt").build()).build();
    private static final SdkField<String> UPDATED_BY_FIELD = SdkField.builder(MarshallingType.STRING).memberName("updatedBy").getter(SubscriptionRequestSummary.getter(SubscriptionRequestSummary::updatedBy)).setter(SubscriptionRequestSummary.setter(Builder::updatedBy)).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updatedBy").build()).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CREATED_AT_FIELD, CREATED_BY_FIELD, DECISION_COMMENT_FIELD, DOMAIN_ID_FIELD, EXISTING_SUBSCRIPTION_ID_FIELD, ID_FIELD, METADATA_FORMS_SUMMARY_FIELD, REQUEST_REASON_FIELD, REVIEWER_ID_FIELD, STATUS_FIELD, SUBSCRIBED_LISTINGS_FIELD, SUBSCRIBED_PRINCIPALS_FIELD, UPDATED_AT_FIELD, UPDATED_BY_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = SubscriptionRequestSummary.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final Instant createdAt;
    private final String createdBy;
    private final String decisionComment;
    private final String domainId;
    private final String existingSubscriptionId;
    private final String id;
    private final List<MetadataFormSummary> metadataFormsSummary;
    private final String requestReason;
    private final String reviewerId;
    private final String status;
    private final List<SubscribedListing> subscribedListings;
    private final List<SubscribedPrincipal> subscribedPrincipals;
    private final Instant updatedAt;
    private final String updatedBy;

    private SubscriptionRequestSummary(BuilderImpl builder) {
        this.createdAt = builder.createdAt;
        this.createdBy = builder.createdBy;
        this.decisionComment = builder.decisionComment;
        this.domainId = builder.domainId;
        this.existingSubscriptionId = builder.existingSubscriptionId;
        this.id = builder.id;
        this.metadataFormsSummary = builder.metadataFormsSummary;
        this.requestReason = builder.requestReason;
        this.reviewerId = builder.reviewerId;
        this.status = builder.status;
        this.subscribedListings = builder.subscribedListings;
        this.subscribedPrincipals = builder.subscribedPrincipals;
        this.updatedAt = builder.updatedAt;
        this.updatedBy = builder.updatedBy;
    }

    public final Instant createdAt() {
        return this.createdAt;
    }

    public final String createdBy() {
        return this.createdBy;
    }

    public final String decisionComment() {
        return this.decisionComment;
    }

    public final String domainId() {
        return this.domainId;
    }

    public final String existingSubscriptionId() {
        return this.existingSubscriptionId;
    }

    public final String id() {
        return this.id;
    }

    public final boolean hasMetadataFormsSummary() {
        return this.metadataFormsSummary != null && !(this.metadataFormsSummary instanceof SdkAutoConstructList);
    }

    public final List<MetadataFormSummary> metadataFormsSummary() {
        return this.metadataFormsSummary;
    }

    public final String requestReason() {
        return this.requestReason;
    }

    public final String reviewerId() {
        return this.reviewerId;
    }

    public final SubscriptionRequestStatus status() {
        return SubscriptionRequestStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final boolean hasSubscribedListings() {
        return this.subscribedListings != null && !(this.subscribedListings instanceof SdkAutoConstructList);
    }

    public final List<SubscribedListing> subscribedListings() {
        return this.subscribedListings;
    }

    public final boolean hasSubscribedPrincipals() {
        return this.subscribedPrincipals != null && !(this.subscribedPrincipals instanceof SdkAutoConstructList);
    }

    public final List<SubscribedPrincipal> subscribedPrincipals() {
        return this.subscribedPrincipals;
    }

    public final Instant updatedAt() {
        return this.updatedAt;
    }

    public final String updatedBy() {
        return this.updatedBy;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdBy());
        hashCode = 31 * hashCode + Objects.hashCode(this.decisionComment());
        hashCode = 31 * hashCode + Objects.hashCode(this.domainId());
        hashCode = 31 * hashCode + Objects.hashCode(this.existingSubscriptionId());
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasMetadataFormsSummary() ? this.metadataFormsSummary() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.requestReason());
        hashCode = 31 * hashCode + Objects.hashCode(this.reviewerId());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSubscribedListings() ? this.subscribedListings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSubscribedPrincipals() ? this.subscribedPrincipals() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.updatedAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.updatedBy());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SubscriptionRequestSummary)) {
            return false;
        }
        SubscriptionRequestSummary other = (SubscriptionRequestSummary)obj;
        return Objects.equals(this.createdAt(), other.createdAt()) && Objects.equals(this.createdBy(), other.createdBy()) && Objects.equals(this.decisionComment(), other.decisionComment()) && Objects.equals(this.domainId(), other.domainId()) && Objects.equals(this.existingSubscriptionId(), other.existingSubscriptionId()) && Objects.equals(this.id(), other.id()) && this.hasMetadataFormsSummary() == other.hasMetadataFormsSummary() && Objects.equals(this.metadataFormsSummary(), other.metadataFormsSummary()) && Objects.equals(this.requestReason(), other.requestReason()) && Objects.equals(this.reviewerId(), other.reviewerId()) && Objects.equals(this.statusAsString(), other.statusAsString()) && this.hasSubscribedListings() == other.hasSubscribedListings() && Objects.equals(this.subscribedListings(), other.subscribedListings()) && this.hasSubscribedPrincipals() == other.hasSubscribedPrincipals() && Objects.equals(this.subscribedPrincipals(), other.subscribedPrincipals()) && Objects.equals(this.updatedAt(), other.updatedAt()) && Objects.equals(this.updatedBy(), other.updatedBy());
    }

    public final String toString() {
        return ToString.builder("SubscriptionRequestSummary").add("CreatedAt", this.createdAt()).add("CreatedBy", this.createdBy()).add("DecisionComment", this.decisionComment() == null ? null : "*** Sensitive Data Redacted ***").add("DomainId", this.domainId()).add("ExistingSubscriptionId", this.existingSubscriptionId()).add("Id", this.id()).add("MetadataFormsSummary", this.hasMetadataFormsSummary() ? this.metadataFormsSummary() : null).add("RequestReason", this.requestReason() == null ? null : "*** Sensitive Data Redacted ***").add("ReviewerId", this.reviewerId()).add("Status", this.statusAsString()).add("SubscribedListings", this.hasSubscribedListings() ? this.subscribedListings() : null).add("SubscribedPrincipals", this.hasSubscribedPrincipals() ? this.subscribedPrincipals() : null).add("UpdatedAt", this.updatedAt()).add("UpdatedBy", this.updatedBy()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "createdAt": {
                return Optional.ofNullable(clazz.cast(this.createdAt()));
            }
            case "createdBy": {
                return Optional.ofNullable(clazz.cast(this.createdBy()));
            }
            case "decisionComment": {
                return Optional.ofNullable(clazz.cast(this.decisionComment()));
            }
            case "domainId": {
                return Optional.ofNullable(clazz.cast(this.domainId()));
            }
            case "existingSubscriptionId": {
                return Optional.ofNullable(clazz.cast(this.existingSubscriptionId()));
            }
            case "id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "metadataFormsSummary": {
                return Optional.ofNullable(clazz.cast(this.metadataFormsSummary()));
            }
            case "requestReason": {
                return Optional.ofNullable(clazz.cast(this.requestReason()));
            }
            case "reviewerId": {
                return Optional.ofNullable(clazz.cast(this.reviewerId()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "subscribedListings": {
                return Optional.ofNullable(clazz.cast(this.subscribedListings()));
            }
            case "subscribedPrincipals": {
                return Optional.ofNullable(clazz.cast(this.subscribedPrincipals()));
            }
            case "updatedAt": {
                return Optional.ofNullable(clazz.cast(this.updatedAt()));
            }
            case "updatedBy": {
                return Optional.ofNullable(clazz.cast(this.updatedBy()));
            }
        }
        return Optional.empty();
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<Object>> map = new HashMap<String, SdkField<Object>>();
        map.put("createdAt", CREATED_AT_FIELD);
        map.put("createdBy", CREATED_BY_FIELD);
        map.put("decisionComment", DECISION_COMMENT_FIELD);
        map.put("domainId", DOMAIN_ID_FIELD);
        map.put("existingSubscriptionId", EXISTING_SUBSCRIPTION_ID_FIELD);
        map.put("id", ID_FIELD);
        map.put("metadataFormsSummary", METADATA_FORMS_SUMMARY_FIELD);
        map.put("requestReason", REQUEST_REASON_FIELD);
        map.put("reviewerId", REVIEWER_ID_FIELD);
        map.put("status", STATUS_FIELD);
        map.put("subscribedListings", SUBSCRIBED_LISTINGS_FIELD);
        map.put("subscribedPrincipals", SUBSCRIBED_PRINCIPALS_FIELD);
        map.put("updatedAt", UPDATED_AT_FIELD);
        map.put("updatedBy", UPDATED_BY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SubscriptionRequestSummary, T> g) {
        return obj -> g.apply((SubscriptionRequestSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Instant createdAt;
        private String createdBy;
        private String decisionComment;
        private String domainId;
        private String existingSubscriptionId;
        private String id;
        private List<MetadataFormSummary> metadataFormsSummary = DefaultSdkAutoConstructList.getInstance();
        private String requestReason;
        private String reviewerId;
        private String status;
        private List<SubscribedListing> subscribedListings = DefaultSdkAutoConstructList.getInstance();
        private List<SubscribedPrincipal> subscribedPrincipals = DefaultSdkAutoConstructList.getInstance();
        private Instant updatedAt;
        private String updatedBy;

        private BuilderImpl() {
        }

        private BuilderImpl(SubscriptionRequestSummary model) {
            this.createdAt(model.createdAt);
            this.createdBy(model.createdBy);
            this.decisionComment(model.decisionComment);
            this.domainId(model.domainId);
            this.existingSubscriptionId(model.existingSubscriptionId);
            this.id(model.id);
            this.metadataFormsSummary(model.metadataFormsSummary);
            this.requestReason(model.requestReason);
            this.reviewerId(model.reviewerId);
            this.status(model.status);
            this.subscribedListings(model.subscribedListings);
            this.subscribedPrincipals(model.subscribedPrincipals);
            this.updatedAt(model.updatedAt);
            this.updatedBy(model.updatedBy);
        }

        public final Instant getCreatedAt() {
            return this.createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final String getCreatedBy() {
            return this.createdBy;
        }

        public final void setCreatedBy(String createdBy) {
            this.createdBy = createdBy;
        }

        @Override
        public final Builder createdBy(String createdBy) {
            this.createdBy = createdBy;
            return this;
        }

        public final String getDecisionComment() {
            return this.decisionComment;
        }

        public final void setDecisionComment(String decisionComment) {
            this.decisionComment = decisionComment;
        }

        @Override
        public final Builder decisionComment(String decisionComment) {
            this.decisionComment = decisionComment;
            return this;
        }

        public final String getDomainId() {
            return this.domainId;
        }

        public final void setDomainId(String domainId) {
            this.domainId = domainId;
        }

        @Override
        public final Builder domainId(String domainId) {
            this.domainId = domainId;
            return this;
        }

        public final String getExistingSubscriptionId() {
            return this.existingSubscriptionId;
        }

        public final void setExistingSubscriptionId(String existingSubscriptionId) {
            this.existingSubscriptionId = existingSubscriptionId;
        }

        @Override
        public final Builder existingSubscriptionId(String existingSubscriptionId) {
            this.existingSubscriptionId = existingSubscriptionId;
            return this;
        }

        public final String getId() {
            return this.id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final List<MetadataFormSummary.Builder> getMetadataFormsSummary() {
            List<MetadataFormSummary.Builder> result = MetadataFormsSummaryCopier.copyToBuilder(this.metadataFormsSummary);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setMetadataFormsSummary(Collection<MetadataFormSummary.BuilderImpl> metadataFormsSummary) {
            this.metadataFormsSummary = MetadataFormsSummaryCopier.copyFromBuilder(metadataFormsSummary);
        }

        @Override
        public final Builder metadataFormsSummary(Collection<MetadataFormSummary> metadataFormsSummary) {
            this.metadataFormsSummary = MetadataFormsSummaryCopier.copy(metadataFormsSummary);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder metadataFormsSummary(MetadataFormSummary ... metadataFormsSummary) {
            this.metadataFormsSummary(Arrays.asList(metadataFormsSummary));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder metadataFormsSummary(Consumer<MetadataFormSummary.Builder> ... metadataFormsSummary) {
            this.metadataFormsSummary(Stream.of(metadataFormsSummary).map(c -> (MetadataFormSummary)((MetadataFormSummary.Builder)MetadataFormSummary.builder().applyMutation(c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getRequestReason() {
            return this.requestReason;
        }

        public final void setRequestReason(String requestReason) {
            this.requestReason = requestReason;
        }

        @Override
        public final Builder requestReason(String requestReason) {
            this.requestReason = requestReason;
            return this;
        }

        public final String getReviewerId() {
            return this.reviewerId;
        }

        public final void setReviewerId(String reviewerId) {
            this.reviewerId = reviewerId;
        }

        @Override
        public final Builder reviewerId(String reviewerId) {
            this.reviewerId = reviewerId;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(SubscriptionRequestStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final List<SubscribedListing.Builder> getSubscribedListings() {
            List<SubscribedListing.Builder> result = SubscriptionRequestSummarySubscribedListingsListCopier.copyToBuilder(this.subscribedListings);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSubscribedListings(Collection<SubscribedListing.BuilderImpl> subscribedListings) {
            this.subscribedListings = SubscriptionRequestSummarySubscribedListingsListCopier.copyFromBuilder(subscribedListings);
        }

        @Override
        public final Builder subscribedListings(Collection<SubscribedListing> subscribedListings) {
            this.subscribedListings = SubscriptionRequestSummarySubscribedListingsListCopier.copy(subscribedListings);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder subscribedListings(SubscribedListing ... subscribedListings) {
            this.subscribedListings(Arrays.asList(subscribedListings));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder subscribedListings(Consumer<SubscribedListing.Builder> ... subscribedListings) {
            this.subscribedListings(Stream.of(subscribedListings).map(c -> (SubscribedListing)((SubscribedListing.Builder)SubscribedListing.builder().applyMutation(c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<SubscribedPrincipal.Builder> getSubscribedPrincipals() {
            List<SubscribedPrincipal.Builder> result = SubscriptionRequestSummarySubscribedPrincipalsListCopier.copyToBuilder(this.subscribedPrincipals);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSubscribedPrincipals(Collection<SubscribedPrincipal.BuilderImpl> subscribedPrincipals) {
            this.subscribedPrincipals = SubscriptionRequestSummarySubscribedPrincipalsListCopier.copyFromBuilder(subscribedPrincipals);
        }

        @Override
        public final Builder subscribedPrincipals(Collection<SubscribedPrincipal> subscribedPrincipals) {
            this.subscribedPrincipals = SubscriptionRequestSummarySubscribedPrincipalsListCopier.copy(subscribedPrincipals);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder subscribedPrincipals(SubscribedPrincipal ... subscribedPrincipals) {
            this.subscribedPrincipals(Arrays.asList(subscribedPrincipals));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder subscribedPrincipals(Consumer<SubscribedPrincipal.Builder> ... subscribedPrincipals) {
            this.subscribedPrincipals(Stream.of(subscribedPrincipals).map(c -> (SubscribedPrincipal)((SubscribedPrincipal.Builder)SubscribedPrincipal.builder().applyMutation(c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Instant getUpdatedAt() {
            return this.updatedAt;
        }

        public final void setUpdatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
        }

        @Override
        public final Builder updatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        public final String getUpdatedBy() {
            return this.updatedBy;
        }

        public final void setUpdatedBy(String updatedBy) {
            this.updatedBy = updatedBy;
        }

        @Override
        public final Builder updatedBy(String updatedBy) {
            this.updatedBy = updatedBy;
            return this;
        }

        @Override
        public SubscriptionRequestSummary build() {
            return new SubscriptionRequestSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, SubscriptionRequestSummary> {
        public Builder createdAt(Instant var1);

        public Builder createdBy(String var1);

        public Builder decisionComment(String var1);

        public Builder domainId(String var1);

        public Builder existingSubscriptionId(String var1);

        public Builder id(String var1);

        public Builder metadataFormsSummary(Collection<MetadataFormSummary> var1);

        public Builder metadataFormsSummary(MetadataFormSummary ... var1);

        public Builder metadataFormsSummary(Consumer<MetadataFormSummary.Builder> ... var1);

        public Builder requestReason(String var1);

        public Builder reviewerId(String var1);

        public Builder status(String var1);

        public Builder status(SubscriptionRequestStatus var1);

        public Builder subscribedListings(Collection<SubscribedListing> var1);

        public Builder subscribedListings(SubscribedListing ... var1);

        public Builder subscribedListings(Consumer<SubscribedListing.Builder> ... var1);

        public Builder subscribedPrincipals(Collection<SubscribedPrincipal> var1);

        public Builder subscribedPrincipals(SubscribedPrincipal ... var1);

        public Builder subscribedPrincipals(Consumer<SubscribedPrincipal.Builder> ... var1);

        public Builder updatedAt(Instant var1);

        public Builder updatedBy(String var1);
    }
}

