/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.datazone.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.services.datazone.model.AccountSource;
import software.amazon.awssdk.services.datazone.model.DataZoneResponse;
import software.amazon.awssdk.services.datazone.model.ResolutionStrategy;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateAccountPoolResponse
extends DataZoneResponse
implements ToCopyableBuilder<Builder, UpdateAccountPoolResponse> {
    private static final SdkField<AccountSource> ACCOUNT_SOURCE_FIELD = SdkField.builder(MarshallingType.SDK_POJO).memberName("accountSource").getter(UpdateAccountPoolResponse.getter(UpdateAccountPoolResponse::accountSource)).setter(UpdateAccountPoolResponse.setter(Builder::accountSource)).constructor(AccountSource::builder).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("accountSource").build()).build();
    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.builder(MarshallingType.INSTANT).memberName("createdAt").getter(UpdateAccountPoolResponse.getter(UpdateAccountPoolResponse::createdAt)).setter(UpdateAccountPoolResponse.setter(Builder::createdAt)).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build(), TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();
    private static final SdkField<String> CREATED_BY_FIELD = SdkField.builder(MarshallingType.STRING).memberName("createdBy").getter(UpdateAccountPoolResponse.getter(UpdateAccountPoolResponse::createdBy)).setter(UpdateAccountPoolResponse.setter(Builder::createdBy)).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdBy").build()).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder(MarshallingType.STRING).memberName("description").getter(UpdateAccountPoolResponse.getter(UpdateAccountPoolResponse::description)).setter(UpdateAccountPoolResponse.setter(Builder::description)).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();
    private static final SdkField<String> DOMAIN_ID_FIELD = SdkField.builder(MarshallingType.STRING).memberName("domainId").getter(UpdateAccountPoolResponse.getter(UpdateAccountPoolResponse::domainId)).setter(UpdateAccountPoolResponse.setter(Builder::domainId)).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("domainId").build()).build();
    private static final SdkField<String> DOMAIN_UNIT_ID_FIELD = SdkField.builder(MarshallingType.STRING).memberName("domainUnitId").getter(UpdateAccountPoolResponse.getter(UpdateAccountPoolResponse::domainUnitId)).setter(UpdateAccountPoolResponse.setter(Builder::domainUnitId)).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("domainUnitId").build()).build();
    private static final SdkField<String> ID_FIELD = SdkField.builder(MarshallingType.STRING).memberName("id").getter(UpdateAccountPoolResponse.getter(UpdateAccountPoolResponse::id)).setter(UpdateAccountPoolResponse.setter(Builder::id)).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()).build();
    private static final SdkField<Instant> LAST_UPDATED_AT_FIELD = SdkField.builder(MarshallingType.INSTANT).memberName("lastUpdatedAt").getter(UpdateAccountPoolResponse.getter(UpdateAccountPoolResponse::lastUpdatedAt)).setter(UpdateAccountPoolResponse.setter(Builder::lastUpdatedAt)).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastUpdatedAt").build(), TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder(MarshallingType.STRING).memberName("name").getter(UpdateAccountPoolResponse.getter(UpdateAccountPoolResponse::name)).setter(UpdateAccountPoolResponse.setter(Builder::name)).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();
    private static final SdkField<String> RESOLUTION_STRATEGY_FIELD = SdkField.builder(MarshallingType.STRING).memberName("resolutionStrategy").getter(UpdateAccountPoolResponse.getter(UpdateAccountPoolResponse::resolutionStrategyAsString)).setter(UpdateAccountPoolResponse.setter(Builder::resolutionStrategy)).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resolutionStrategy").build()).build();
    private static final SdkField<String> UPDATED_BY_FIELD = SdkField.builder(MarshallingType.STRING).memberName("updatedBy").getter(UpdateAccountPoolResponse.getter(UpdateAccountPoolResponse::updatedBy)).setter(UpdateAccountPoolResponse.setter(Builder::updatedBy)).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updatedBy").build()).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCOUNT_SOURCE_FIELD, CREATED_AT_FIELD, CREATED_BY_FIELD, DESCRIPTION_FIELD, DOMAIN_ID_FIELD, DOMAIN_UNIT_ID_FIELD, ID_FIELD, LAST_UPDATED_AT_FIELD, NAME_FIELD, RESOLUTION_STRATEGY_FIELD, UPDATED_BY_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = UpdateAccountPoolResponse.memberNameToFieldInitializer();
    private final AccountSource accountSource;
    private final Instant createdAt;
    private final String createdBy;
    private final String description;
    private final String domainId;
    private final String domainUnitId;
    private final String id;
    private final Instant lastUpdatedAt;
    private final String name;
    private final String resolutionStrategy;
    private final String updatedBy;

    private UpdateAccountPoolResponse(BuilderImpl builder) {
        super(builder);
        this.accountSource = builder.accountSource;
        this.createdAt = builder.createdAt;
        this.createdBy = builder.createdBy;
        this.description = builder.description;
        this.domainId = builder.domainId;
        this.domainUnitId = builder.domainUnitId;
        this.id = builder.id;
        this.lastUpdatedAt = builder.lastUpdatedAt;
        this.name = builder.name;
        this.resolutionStrategy = builder.resolutionStrategy;
        this.updatedBy = builder.updatedBy;
    }

    public final AccountSource accountSource() {
        return this.accountSource;
    }

    public final Instant createdAt() {
        return this.createdAt;
    }

    public final String createdBy() {
        return this.createdBy;
    }

    public final String description() {
        return this.description;
    }

    public final String domainId() {
        return this.domainId;
    }

    public final String domainUnitId() {
        return this.domainUnitId;
    }

    public final String id() {
        return this.id;
    }

    public final Instant lastUpdatedAt() {
        return this.lastUpdatedAt;
    }

    public final String name() {
        return this.name;
    }

    public final ResolutionStrategy resolutionStrategy() {
        return ResolutionStrategy.fromValue(this.resolutionStrategy);
    }

    public final String resolutionStrategyAsString() {
        return this.resolutionStrategy;
    }

    public final String updatedBy() {
        return this.updatedBy;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.accountSource());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdBy());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.domainId());
        hashCode = 31 * hashCode + Objects.hashCode(this.domainUnitId());
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastUpdatedAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.resolutionStrategyAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.updatedBy());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateAccountPoolResponse)) {
            return false;
        }
        UpdateAccountPoolResponse other = (UpdateAccountPoolResponse)obj;
        return Objects.equals(this.accountSource(), other.accountSource()) && Objects.equals(this.createdAt(), other.createdAt()) && Objects.equals(this.createdBy(), other.createdBy()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.domainId(), other.domainId()) && Objects.equals(this.domainUnitId(), other.domainUnitId()) && Objects.equals(this.id(), other.id()) && Objects.equals(this.lastUpdatedAt(), other.lastUpdatedAt()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.resolutionStrategyAsString(), other.resolutionStrategyAsString()) && Objects.equals(this.updatedBy(), other.updatedBy());
    }

    public final String toString() {
        return ToString.builder("UpdateAccountPoolResponse").add("AccountSource", this.accountSource()).add("CreatedAt", this.createdAt()).add("CreatedBy", this.createdBy()).add("Description", this.description() == null ? null : "*** Sensitive Data Redacted ***").add("DomainId", this.domainId()).add("DomainUnitId", this.domainUnitId()).add("Id", this.id()).add("LastUpdatedAt", this.lastUpdatedAt()).add("Name", this.name() == null ? null : "*** Sensitive Data Redacted ***").add("ResolutionStrategy", this.resolutionStrategyAsString()).add("UpdatedBy", this.updatedBy()).build();
    }

    @Override
    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "accountSource": {
                return Optional.ofNullable(clazz.cast(this.accountSource()));
            }
            case "createdAt": {
                return Optional.ofNullable(clazz.cast(this.createdAt()));
            }
            case "createdBy": {
                return Optional.ofNullable(clazz.cast(this.createdBy()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "domainId": {
                return Optional.ofNullable(clazz.cast(this.domainId()));
            }
            case "domainUnitId": {
                return Optional.ofNullable(clazz.cast(this.domainUnitId()));
            }
            case "id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "lastUpdatedAt": {
                return Optional.ofNullable(clazz.cast(this.lastUpdatedAt()));
            }
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "resolutionStrategy": {
                return Optional.ofNullable(clazz.cast(this.resolutionStrategyAsString()));
            }
            case "updatedBy": {
                return Optional.ofNullable(clazz.cast(this.updatedBy()));
            }
        }
        return Optional.empty();
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<Object>> map = new HashMap<String, SdkField<Object>>();
        map.put("accountSource", ACCOUNT_SOURCE_FIELD);
        map.put("createdAt", CREATED_AT_FIELD);
        map.put("createdBy", CREATED_BY_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        map.put("domainId", DOMAIN_ID_FIELD);
        map.put("domainUnitId", DOMAIN_UNIT_ID_FIELD);
        map.put("id", ID_FIELD);
        map.put("lastUpdatedAt", LAST_UPDATED_AT_FIELD);
        map.put("name", NAME_FIELD);
        map.put("resolutionStrategy", RESOLUTION_STRATEGY_FIELD);
        map.put("updatedBy", UPDATED_BY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateAccountPoolResponse, T> g) {
        return obj -> g.apply((UpdateAccountPoolResponse)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends DataZoneResponse.BuilderImpl
    implements Builder {
        private AccountSource accountSource;
        private Instant createdAt;
        private String createdBy;
        private String description;
        private String domainId;
        private String domainUnitId;
        private String id;
        private Instant lastUpdatedAt;
        private String name;
        private String resolutionStrategy;
        private String updatedBy;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateAccountPoolResponse model) {
            super(model);
            this.accountSource(model.accountSource);
            this.createdAt(model.createdAt);
            this.createdBy(model.createdBy);
            this.description(model.description);
            this.domainId(model.domainId);
            this.domainUnitId(model.domainUnitId);
            this.id(model.id);
            this.lastUpdatedAt(model.lastUpdatedAt);
            this.name(model.name);
            this.resolutionStrategy(model.resolutionStrategy);
            this.updatedBy(model.updatedBy);
        }

        public final AccountSource.Builder getAccountSource() {
            return this.accountSource != null ? this.accountSource.toBuilder() : null;
        }

        public final void setAccountSource(AccountSource.BuilderImpl accountSource) {
            this.accountSource = accountSource != null ? accountSource.build() : null;
        }

        @Override
        public final Builder accountSource(AccountSource accountSource) {
            this.accountSource = accountSource;
            return this;
        }

        public final Instant getCreatedAt() {
            return this.createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final String getCreatedBy() {
            return this.createdBy;
        }

        public final void setCreatedBy(String createdBy) {
            this.createdBy = createdBy;
        }

        @Override
        public final Builder createdBy(String createdBy) {
            this.createdBy = createdBy;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getDomainId() {
            return this.domainId;
        }

        public final void setDomainId(String domainId) {
            this.domainId = domainId;
        }

        @Override
        public final Builder domainId(String domainId) {
            this.domainId = domainId;
            return this;
        }

        public final String getDomainUnitId() {
            return this.domainUnitId;
        }

        public final void setDomainUnitId(String domainUnitId) {
            this.domainUnitId = domainUnitId;
        }

        @Override
        public final Builder domainUnitId(String domainUnitId) {
            this.domainUnitId = domainUnitId;
            return this;
        }

        public final String getId() {
            return this.id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final Instant getLastUpdatedAt() {
            return this.lastUpdatedAt;
        }

        public final void setLastUpdatedAt(Instant lastUpdatedAt) {
            this.lastUpdatedAt = lastUpdatedAt;
        }

        @Override
        public final Builder lastUpdatedAt(Instant lastUpdatedAt) {
            this.lastUpdatedAt = lastUpdatedAt;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getResolutionStrategy() {
            return this.resolutionStrategy;
        }

        public final void setResolutionStrategy(String resolutionStrategy) {
            this.resolutionStrategy = resolutionStrategy;
        }

        @Override
        public final Builder resolutionStrategy(String resolutionStrategy) {
            this.resolutionStrategy = resolutionStrategy;
            return this;
        }

        @Override
        public final Builder resolutionStrategy(ResolutionStrategy resolutionStrategy) {
            this.resolutionStrategy(resolutionStrategy == null ? null : resolutionStrategy.toString());
            return this;
        }

        public final String getUpdatedBy() {
            return this.updatedBy;
        }

        public final void setUpdatedBy(String updatedBy) {
            this.updatedBy = updatedBy;
        }

        @Override
        public final Builder updatedBy(String updatedBy) {
            this.updatedBy = updatedBy;
            return this;
        }

        @Override
        public UpdateAccountPoolResponse build() {
            return new UpdateAccountPoolResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends DataZoneResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateAccountPoolResponse> {
        public Builder accountSource(AccountSource var1);

        default public Builder accountSource(Consumer<AccountSource.Builder> accountSource) {
            return this.accountSource((AccountSource)AccountSource.builder().applyMutation(accountSource).build());
        }

        public Builder createdAt(Instant var1);

        public Builder createdBy(String var1);

        public Builder description(String var1);

        public Builder domainId(String var1);

        public Builder domainUnitId(String var1);

        public Builder id(String var1);

        public Builder lastUpdatedAt(Instant var1);

        public Builder name(String var1);

        public Builder resolutionStrategy(String var1);

        public Builder resolutionStrategy(ResolutionStrategy var1);

        public Builder updatedBy(String var1);
    }
}

