/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.datazone.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.services.datazone.model.DataZoneRequest;
import software.amazon.awssdk.services.datazone.model.UserProfileStatus;
import software.amazon.awssdk.services.datazone.model.UserProfileType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateUserProfileRequest
extends DataZoneRequest
implements ToCopyableBuilder<Builder, UpdateUserProfileRequest> {
    private static final SdkField<String> DOMAIN_IDENTIFIER_FIELD = SdkField.builder(MarshallingType.STRING).memberName("domainIdentifier").getter(UpdateUserProfileRequest.getter(UpdateUserProfileRequest::domainIdentifier)).setter(UpdateUserProfileRequest.setter(Builder::domainIdentifier)).traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("domainIdentifier").build()).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder(MarshallingType.STRING).memberName("status").getter(UpdateUserProfileRequest.getter(UpdateUserProfileRequest::statusAsString)).setter(UpdateUserProfileRequest.setter(Builder::status)).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();
    private static final SdkField<String> TYPE_FIELD = SdkField.builder(MarshallingType.STRING).memberName("type").getter(UpdateUserProfileRequest.getter(UpdateUserProfileRequest::typeAsString)).setter(UpdateUserProfileRequest.setter(Builder::type)).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()).build();
    private static final SdkField<String> USER_IDENTIFIER_FIELD = SdkField.builder(MarshallingType.STRING).memberName("userIdentifier").getter(UpdateUserProfileRequest.getter(UpdateUserProfileRequest::userIdentifier)).setter(UpdateUserProfileRequest.setter(Builder::userIdentifier)).traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("userIdentifier").build()).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DOMAIN_IDENTIFIER_FIELD, STATUS_FIELD, TYPE_FIELD, USER_IDENTIFIER_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = UpdateUserProfileRequest.memberNameToFieldInitializer();
    private final String domainIdentifier;
    private final String status;
    private final String type;
    private final String userIdentifier;

    private UpdateUserProfileRequest(BuilderImpl builder) {
        super(builder);
        this.domainIdentifier = builder.domainIdentifier;
        this.status = builder.status;
        this.type = builder.type;
        this.userIdentifier = builder.userIdentifier;
    }

    public final String domainIdentifier() {
        return this.domainIdentifier;
    }

    public final UserProfileStatus status() {
        return UserProfileStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final UserProfileType type() {
        return UserProfileType.fromValue(this.type);
    }

    public final String typeAsString() {
        return this.type;
    }

    public final String userIdentifier() {
        return this.userIdentifier;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.domainIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.userIdentifier());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateUserProfileRequest)) {
            return false;
        }
        UpdateUserProfileRequest other = (UpdateUserProfileRequest)obj;
        return Objects.equals(this.domainIdentifier(), other.domainIdentifier()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.typeAsString(), other.typeAsString()) && Objects.equals(this.userIdentifier(), other.userIdentifier());
    }

    public final String toString() {
        return ToString.builder("UpdateUserProfileRequest").add("DomainIdentifier", this.domainIdentifier()).add("Status", this.statusAsString()).add("Type", this.typeAsString()).add("UserIdentifier", this.userIdentifier()).build();
    }

    @Override
    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "domainIdentifier": {
                return Optional.ofNullable(clazz.cast(this.domainIdentifier()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "type": {
                return Optional.ofNullable(clazz.cast(this.typeAsString()));
            }
            case "userIdentifier": {
                return Optional.ofNullable(clazz.cast(this.userIdentifier()));
            }
        }
        return Optional.empty();
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("domainIdentifier", DOMAIN_IDENTIFIER_FIELD);
        map.put("status", STATUS_FIELD);
        map.put("type", TYPE_FIELD);
        map.put("userIdentifier", USER_IDENTIFIER_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateUserProfileRequest, T> g) {
        return obj -> g.apply((UpdateUserProfileRequest)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends DataZoneRequest.BuilderImpl
    implements Builder {
        private String domainIdentifier;
        private String status;
        private String type;
        private String userIdentifier;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateUserProfileRequest model) {
            super(model);
            this.domainIdentifier(model.domainIdentifier);
            this.status(model.status);
            this.type(model.type);
            this.userIdentifier(model.userIdentifier);
        }

        public final String getDomainIdentifier() {
            return this.domainIdentifier;
        }

        public final void setDomainIdentifier(String domainIdentifier) {
            this.domainIdentifier = domainIdentifier;
        }

        @Override
        public final Builder domainIdentifier(String domainIdentifier) {
            this.domainIdentifier = domainIdentifier;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(UserProfileStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getType() {
            return this.type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(UserProfileType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final String getUserIdentifier() {
            return this.userIdentifier;
        }

        public final void setUserIdentifier(String userIdentifier) {
            this.userIdentifier = userIdentifier;
        }

        @Override
        public final Builder userIdentifier(String userIdentifier) {
            this.userIdentifier = userIdentifier;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateUserProfileRequest build() {
            return new UpdateUserProfileRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends DataZoneRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateUserProfileRequest> {
        public Builder domainIdentifier(String var1);

        public Builder status(String var1);

        public Builder status(UserProfileStatus var1);

        public Builder type(String var1);

        public Builder type(UserProfileType var1);

        public Builder userIdentifier(String var1);

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

