/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.datazone.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.datazone.DataZoneClient;
import software.amazon.awssdk.services.datazone.internal.UserAgentUtils;
import software.amazon.awssdk.services.datazone.model.AccountInfo;
import software.amazon.awssdk.services.datazone.model.ListAccountsInAccountPoolRequest;
import software.amazon.awssdk.services.datazone.model.ListAccountsInAccountPoolResponse;

public class ListAccountsInAccountPoolIterable
implements SdkIterable<ListAccountsInAccountPoolResponse> {
    private final DataZoneClient client;
    private final ListAccountsInAccountPoolRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListAccountsInAccountPoolIterable(DataZoneClient client, ListAccountsInAccountPoolRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListAccountsInAccountPoolResponseFetcher();
    }

    @Override
    public Iterator<ListAccountsInAccountPoolResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<AccountInfo> items() {
        Function<ListAccountsInAccountPoolResponse, Iterator> getIterator = response -> {
            if (response != null && response.items() != null) {
                return response.items().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable(this).itemIteratorFunction(getIterator).build();
    }

    private class ListAccountsInAccountPoolResponseFetcher
    implements SyncPageFetcher<ListAccountsInAccountPoolResponse> {
        private ListAccountsInAccountPoolResponseFetcher() {
        }

        @Override
        public boolean hasNextPage(ListAccountsInAccountPoolResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable(previousPage.nextToken());
        }

        @Override
        public ListAccountsInAccountPoolResponse nextPage(ListAccountsInAccountPoolResponse previousPage) {
            if (previousPage == null) {
                return ListAccountsInAccountPoolIterable.this.client.listAccountsInAccountPool(ListAccountsInAccountPoolIterable.this.firstRequest);
            }
            return ListAccountsInAccountPoolIterable.this.client.listAccountsInAccountPool((ListAccountsInAccountPoolRequest)ListAccountsInAccountPoolIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build());
        }
    }
}

