/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.datazone.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.datazone.DataZoneClient;
import software.amazon.awssdk.services.datazone.internal.UserAgentUtils;
import software.amazon.awssdk.services.datazone.model.AssetRevision;
import software.amazon.awssdk.services.datazone.model.ListAssetRevisionsRequest;
import software.amazon.awssdk.services.datazone.model.ListAssetRevisionsResponse;

public class ListAssetRevisionsIterable
implements SdkIterable<ListAssetRevisionsResponse> {
    private final DataZoneClient client;
    private final ListAssetRevisionsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListAssetRevisionsIterable(DataZoneClient client, ListAssetRevisionsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListAssetRevisionsResponseFetcher();
    }

    @Override
    public Iterator<ListAssetRevisionsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<AssetRevision> items() {
        Function<ListAssetRevisionsResponse, Iterator> getIterator = response -> {
            if (response != null && response.items() != null) {
                return response.items().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable(this).itemIteratorFunction(getIterator).build();
    }

    private class ListAssetRevisionsResponseFetcher
    implements SyncPageFetcher<ListAssetRevisionsResponse> {
        private ListAssetRevisionsResponseFetcher() {
        }

        @Override
        public boolean hasNextPage(ListAssetRevisionsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable(previousPage.nextToken());
        }

        @Override
        public ListAssetRevisionsResponse nextPage(ListAssetRevisionsResponse previousPage) {
            if (previousPage == null) {
                return ListAssetRevisionsIterable.this.client.listAssetRevisions(ListAssetRevisionsIterable.this.firstRequest);
            }
            return ListAssetRevisionsIterable.this.client.listAssetRevisions((ListAssetRevisionsRequest)ListAssetRevisionsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build());
        }
    }
}

