/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.datazone.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.datazone.DataZoneAsyncClient;
import software.amazon.awssdk.services.datazone.internal.UserAgentUtils;
import software.amazon.awssdk.services.datazone.model.ConnectionSummary;
import software.amazon.awssdk.services.datazone.model.ListConnectionsRequest;
import software.amazon.awssdk.services.datazone.model.ListConnectionsResponse;

public class ListConnectionsPublisher
implements SdkPublisher<ListConnectionsResponse> {
    private final DataZoneAsyncClient client;
    private final ListConnectionsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListConnectionsPublisher(DataZoneAsyncClient client, ListConnectionsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListConnectionsPublisher(DataZoneAsyncClient client, ListConnectionsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListConnectionsResponseFetcher();
    }

    @Override
    public void subscribe(Subscriber<? super ListConnectionsResponse> subscriber) {
        subscriber.onSubscribe(((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<ConnectionSummary> items() {
        Function<ListConnectionsResponse, Iterator> getIterator = response -> {
            if (response != null && response.items() != null) {
                return response.items().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher(new ListConnectionsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListConnectionsResponseFetcher
    implements AsyncPageFetcher<ListConnectionsResponse> {
        private ListConnectionsResponseFetcher() {
        }

        @Override
        public boolean hasNextPage(ListConnectionsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable(previousPage.nextToken());
        }

        @Override
        public CompletableFuture<ListConnectionsResponse> nextPage(ListConnectionsResponse previousPage) {
            if (previousPage == null) {
                return ListConnectionsPublisher.this.client.listConnections(ListConnectionsPublisher.this.firstRequest);
            }
            return ListConnectionsPublisher.this.client.listConnections((ListConnectionsRequest)ListConnectionsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build());
        }
    }
}

