/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.datazone.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.datazone.DataZoneAsyncClient;
import software.amazon.awssdk.services.datazone.internal.UserAgentUtils;
import software.amazon.awssdk.services.datazone.model.DataSourceRunActivity;
import software.amazon.awssdk.services.datazone.model.ListDataSourceRunActivitiesRequest;
import software.amazon.awssdk.services.datazone.model.ListDataSourceRunActivitiesResponse;

public class ListDataSourceRunActivitiesPublisher
implements SdkPublisher<ListDataSourceRunActivitiesResponse> {
    private final DataZoneAsyncClient client;
    private final ListDataSourceRunActivitiesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListDataSourceRunActivitiesPublisher(DataZoneAsyncClient client, ListDataSourceRunActivitiesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListDataSourceRunActivitiesPublisher(DataZoneAsyncClient client, ListDataSourceRunActivitiesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListDataSourceRunActivitiesResponseFetcher();
    }

    @Override
    public void subscribe(Subscriber<? super ListDataSourceRunActivitiesResponse> subscriber) {
        subscriber.onSubscribe(((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<DataSourceRunActivity> items() {
        Function<ListDataSourceRunActivitiesResponse, Iterator> getIterator = response -> {
            if (response != null && response.items() != null) {
                return response.items().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher(new ListDataSourceRunActivitiesResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListDataSourceRunActivitiesResponseFetcher
    implements AsyncPageFetcher<ListDataSourceRunActivitiesResponse> {
        private ListDataSourceRunActivitiesResponseFetcher() {
        }

        @Override
        public boolean hasNextPage(ListDataSourceRunActivitiesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable(previousPage.nextToken());
        }

        @Override
        public CompletableFuture<ListDataSourceRunActivitiesResponse> nextPage(ListDataSourceRunActivitiesResponse previousPage) {
            if (previousPage == null) {
                return ListDataSourceRunActivitiesPublisher.this.client.listDataSourceRunActivities(ListDataSourceRunActivitiesPublisher.this.firstRequest);
            }
            return ListDataSourceRunActivitiesPublisher.this.client.listDataSourceRunActivities((ListDataSourceRunActivitiesRequest)ListDataSourceRunActivitiesPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build());
        }
    }
}

