/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.datazone.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.datazone.DataZoneClient;
import software.amazon.awssdk.services.datazone.internal.UserAgentUtils;
import software.amazon.awssdk.services.datazone.model.ListEntityOwnersRequest;
import software.amazon.awssdk.services.datazone.model.ListEntityOwnersResponse;
import software.amazon.awssdk.services.datazone.model.OwnerPropertiesOutput;

public class ListEntityOwnersIterable
implements SdkIterable<ListEntityOwnersResponse> {
    private final DataZoneClient client;
    private final ListEntityOwnersRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListEntityOwnersIterable(DataZoneClient client, ListEntityOwnersRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListEntityOwnersResponseFetcher();
    }

    @Override
    public Iterator<ListEntityOwnersResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<OwnerPropertiesOutput> owners() {
        Function<ListEntityOwnersResponse, Iterator> getIterator = response -> {
            if (response != null && response.owners() != null) {
                return response.owners().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable(this).itemIteratorFunction(getIterator).build();
    }

    private class ListEntityOwnersResponseFetcher
    implements SyncPageFetcher<ListEntityOwnersResponse> {
        private ListEntityOwnersResponseFetcher() {
        }

        @Override
        public boolean hasNextPage(ListEntityOwnersResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable(previousPage.nextToken());
        }

        @Override
        public ListEntityOwnersResponse nextPage(ListEntityOwnersResponse previousPage) {
            if (previousPage == null) {
                return ListEntityOwnersIterable.this.client.listEntityOwners(ListEntityOwnersIterable.this.firstRequest);
            }
            return ListEntityOwnersIterable.this.client.listEntityOwners((ListEntityOwnersRequest)ListEntityOwnersIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build());
        }
    }
}

