/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.datazone.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.datazone.DataZoneClient;
import software.amazon.awssdk.services.datazone.internal.UserAgentUtils;
import software.amazon.awssdk.services.datazone.model.EnvironmentBlueprintConfigurationItem;
import software.amazon.awssdk.services.datazone.model.ListEnvironmentBlueprintConfigurationsRequest;
import software.amazon.awssdk.services.datazone.model.ListEnvironmentBlueprintConfigurationsResponse;

public class ListEnvironmentBlueprintConfigurationsIterable
implements SdkIterable<ListEnvironmentBlueprintConfigurationsResponse> {
    private final DataZoneClient client;
    private final ListEnvironmentBlueprintConfigurationsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListEnvironmentBlueprintConfigurationsIterable(DataZoneClient client, ListEnvironmentBlueprintConfigurationsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListEnvironmentBlueprintConfigurationsResponseFetcher();
    }

    @Override
    public Iterator<ListEnvironmentBlueprintConfigurationsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<EnvironmentBlueprintConfigurationItem> items() {
        Function<ListEnvironmentBlueprintConfigurationsResponse, Iterator> getIterator = response -> {
            if (response != null && response.items() != null) {
                return response.items().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable(this).itemIteratorFunction(getIterator).build();
    }

    private class ListEnvironmentBlueprintConfigurationsResponseFetcher
    implements SyncPageFetcher<ListEnvironmentBlueprintConfigurationsResponse> {
        private ListEnvironmentBlueprintConfigurationsResponseFetcher() {
        }

        @Override
        public boolean hasNextPage(ListEnvironmentBlueprintConfigurationsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable(previousPage.nextToken());
        }

        @Override
        public ListEnvironmentBlueprintConfigurationsResponse nextPage(ListEnvironmentBlueprintConfigurationsResponse previousPage) {
            if (previousPage == null) {
                return ListEnvironmentBlueprintConfigurationsIterable.this.client.listEnvironmentBlueprintConfigurations(ListEnvironmentBlueprintConfigurationsIterable.this.firstRequest);
            }
            return ListEnvironmentBlueprintConfigurationsIterable.this.client.listEnvironmentBlueprintConfigurations((ListEnvironmentBlueprintConfigurationsRequest)ListEnvironmentBlueprintConfigurationsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build());
        }
    }
}

