/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.datazone.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.datazone.DataZoneAsyncClient;
import software.amazon.awssdk.services.datazone.internal.UserAgentUtils;
import software.amazon.awssdk.services.datazone.model.ListSubscriptionGrantsRequest;
import software.amazon.awssdk.services.datazone.model.ListSubscriptionGrantsResponse;
import software.amazon.awssdk.services.datazone.model.SubscriptionGrantSummary;

public class ListSubscriptionGrantsPublisher
implements SdkPublisher<ListSubscriptionGrantsResponse> {
    private final DataZoneAsyncClient client;
    private final ListSubscriptionGrantsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListSubscriptionGrantsPublisher(DataZoneAsyncClient client, ListSubscriptionGrantsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListSubscriptionGrantsPublisher(DataZoneAsyncClient client, ListSubscriptionGrantsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListSubscriptionGrantsResponseFetcher();
    }

    @Override
    public void subscribe(Subscriber<? super ListSubscriptionGrantsResponse> subscriber) {
        subscriber.onSubscribe(((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<SubscriptionGrantSummary> items() {
        Function<ListSubscriptionGrantsResponse, Iterator> getIterator = response -> {
            if (response != null && response.items() != null) {
                return response.items().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher(new ListSubscriptionGrantsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListSubscriptionGrantsResponseFetcher
    implements AsyncPageFetcher<ListSubscriptionGrantsResponse> {
        private ListSubscriptionGrantsResponseFetcher() {
        }

        @Override
        public boolean hasNextPage(ListSubscriptionGrantsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable(previousPage.nextToken());
        }

        @Override
        public CompletableFuture<ListSubscriptionGrantsResponse> nextPage(ListSubscriptionGrantsResponse previousPage) {
            if (previousPage == null) {
                return ListSubscriptionGrantsPublisher.this.client.listSubscriptionGrants(ListSubscriptionGrantsPublisher.this.firstRequest);
            }
            return ListSubscriptionGrantsPublisher.this.client.listSubscriptionGrants((ListSubscriptionGrantsRequest)ListSubscriptionGrantsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build());
        }
    }
}

