/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.datazone.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.datazone.DataZoneClient;
import software.amazon.awssdk.services.datazone.internal.UserAgentUtils;
import software.amazon.awssdk.services.datazone.model.SearchInventoryResultItem;
import software.amazon.awssdk.services.datazone.model.SearchRequest;
import software.amazon.awssdk.services.datazone.model.SearchResponse;

public class SearchIterable
implements SdkIterable<SearchResponse> {
    private final DataZoneClient client;
    private final SearchRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public SearchIterable(DataZoneClient client, SearchRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new SearchResponseFetcher();
    }

    @Override
    public Iterator<SearchResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<SearchInventoryResultItem> items() {
        Function<SearchResponse, Iterator> getIterator = response -> {
            if (response != null && response.items() != null) {
                return response.items().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable(this).itemIteratorFunction(getIterator).build();
    }

    private class SearchResponseFetcher
    implements SyncPageFetcher<SearchResponse> {
        private SearchResponseFetcher() {
        }

        @Override
        public boolean hasNextPage(SearchResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable(previousPage.nextToken());
        }

        @Override
        public SearchResponse nextPage(SearchResponse previousPage) {
            if (previousPage == null) {
                return SearchIterable.this.client.search(SearchIterable.this.firstRequest);
            }
            return SearchIterable.this.client.search((SearchRequest)SearchIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build());
        }
    }
}

