/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.datazone.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.datazone.DataZoneClient;
import software.amazon.awssdk.services.datazone.internal.UserAgentUtils;
import software.amazon.awssdk.services.datazone.model.SearchTypesRequest;
import software.amazon.awssdk.services.datazone.model.SearchTypesResponse;
import software.amazon.awssdk.services.datazone.model.SearchTypesResultItem;

public class SearchTypesIterable
implements SdkIterable<SearchTypesResponse> {
    private final DataZoneClient client;
    private final SearchTypesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public SearchTypesIterable(DataZoneClient client, SearchTypesRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new SearchTypesResponseFetcher();
    }

    @Override
    public Iterator<SearchTypesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<SearchTypesResultItem> items() {
        Function<SearchTypesResponse, Iterator> getIterator = response -> {
            if (response != null && response.items() != null) {
                return response.items().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable(this).itemIteratorFunction(getIterator).build();
    }

    private class SearchTypesResponseFetcher
    implements SyncPageFetcher<SearchTypesResponse> {
        private SearchTypesResponseFetcher() {
        }

        @Override
        public boolean hasNextPage(SearchTypesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable(previousPage.nextToken());
        }

        @Override
        public SearchTypesResponse nextPage(SearchTypesResponse previousPage) {
            if (previousPage == null) {
                return SearchTypesIterable.this.client.searchTypes(SearchTypesIterable.this.firstRequest);
            }
            return SearchTypesIterable.this.client.searchTypes((SearchTypesRequest)SearchTypesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build());
        }
    }
}

