/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.datazone.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.datazone.DataZoneClient;
import software.amazon.awssdk.services.datazone.internal.UserAgentUtils;
import software.amazon.awssdk.services.datazone.model.SearchUserProfilesRequest;
import software.amazon.awssdk.services.datazone.model.SearchUserProfilesResponse;
import software.amazon.awssdk.services.datazone.model.UserProfileSummary;

public class SearchUserProfilesIterable
implements SdkIterable<SearchUserProfilesResponse> {
    private final DataZoneClient client;
    private final SearchUserProfilesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public SearchUserProfilesIterable(DataZoneClient client, SearchUserProfilesRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new SearchUserProfilesResponseFetcher();
    }

    @Override
    public Iterator<SearchUserProfilesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<UserProfileSummary> items() {
        Function<SearchUserProfilesResponse, Iterator> getIterator = response -> {
            if (response != null && response.items() != null) {
                return response.items().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable(this).itemIteratorFunction(getIterator).build();
    }

    private class SearchUserProfilesResponseFetcher
    implements SyncPageFetcher<SearchUserProfilesResponse> {
        private SearchUserProfilesResponseFetcher() {
        }

        @Override
        public boolean hasNextPage(SearchUserProfilesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable(previousPage.nextToken());
        }

        @Override
        public SearchUserProfilesResponse nextPage(SearchUserProfilesResponse previousPage) {
            if (previousPage == null) {
                return SearchUserProfilesIterable.this.client.searchUserProfiles(SearchUserProfilesIterable.this.firstRequest);
            }
            return SearchUserProfilesIterable.this.client.searchUserProfiles((SearchUserProfilesRequest)SearchUserProfilesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build());
        }
    }
}

