/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lakeformation;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.Consumer;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.handler.AwsAsyncClientHandler;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.awscore.internal.AwsProtocolMetadata;
import software.amazon.awssdk.awscore.internal.AwsServiceProtocol;
import software.amazon.awssdk.awscore.retry.AwsRetryStrategy;
import software.amazon.awssdk.core.RequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkPlugin;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.async.AsyncResponseTransformer;
import software.amazon.awssdk.core.async.AsyncResponseTransformerUtils;
import software.amazon.awssdk.core.client.config.ClientOverrideConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.core.client.handler.AsyncClientHandler;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.metrics.CoreMetric;
import software.amazon.awssdk.core.retry.RetryMode;
import software.amazon.awssdk.metrics.MetricCollector;
import software.amazon.awssdk.metrics.MetricPublisher;
import software.amazon.awssdk.metrics.NoOpMetricCollector;
import software.amazon.awssdk.protocols.core.ExceptionMetadata;
import software.amazon.awssdk.protocols.json.AwsJsonProtocol;
import software.amazon.awssdk.protocols.json.AwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.BaseAwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.JsonOperationMetadata;
import software.amazon.awssdk.retries.api.RetryStrategy;
import software.amazon.awssdk.services.lakeformation.LakeFormationAsyncClient;
import software.amazon.awssdk.services.lakeformation.LakeFormationServiceClientConfiguration;
import software.amazon.awssdk.services.lakeformation.internal.LakeFormationServiceClientConfigurationBuilder;
import software.amazon.awssdk.services.lakeformation.model.AccessDeniedException;
import software.amazon.awssdk.services.lakeformation.model.AddLfTagsToResourceRequest;
import software.amazon.awssdk.services.lakeformation.model.AddLfTagsToResourceResponse;
import software.amazon.awssdk.services.lakeformation.model.AlreadyExistsException;
import software.amazon.awssdk.services.lakeformation.model.AssumeDecoratedRoleWithSamlRequest;
import software.amazon.awssdk.services.lakeformation.model.AssumeDecoratedRoleWithSamlResponse;
import software.amazon.awssdk.services.lakeformation.model.BatchGrantPermissionsRequest;
import software.amazon.awssdk.services.lakeformation.model.BatchGrantPermissionsResponse;
import software.amazon.awssdk.services.lakeformation.model.BatchRevokePermissionsRequest;
import software.amazon.awssdk.services.lakeformation.model.BatchRevokePermissionsResponse;
import software.amazon.awssdk.services.lakeformation.model.CancelTransactionRequest;
import software.amazon.awssdk.services.lakeformation.model.CancelTransactionResponse;
import software.amazon.awssdk.services.lakeformation.model.CommitTransactionRequest;
import software.amazon.awssdk.services.lakeformation.model.CommitTransactionResponse;
import software.amazon.awssdk.services.lakeformation.model.ConcurrentModificationException;
import software.amazon.awssdk.services.lakeformation.model.CreateDataCellsFilterRequest;
import software.amazon.awssdk.services.lakeformation.model.CreateDataCellsFilterResponse;
import software.amazon.awssdk.services.lakeformation.model.CreateLakeFormationIdentityCenterConfigurationRequest;
import software.amazon.awssdk.services.lakeformation.model.CreateLakeFormationIdentityCenterConfigurationResponse;
import software.amazon.awssdk.services.lakeformation.model.CreateLakeFormationOptInRequest;
import software.amazon.awssdk.services.lakeformation.model.CreateLakeFormationOptInResponse;
import software.amazon.awssdk.services.lakeformation.model.CreateLfTagExpressionRequest;
import software.amazon.awssdk.services.lakeformation.model.CreateLfTagExpressionResponse;
import software.amazon.awssdk.services.lakeformation.model.CreateLfTagRequest;
import software.amazon.awssdk.services.lakeformation.model.CreateLfTagResponse;
import software.amazon.awssdk.services.lakeformation.model.DeleteDataCellsFilterRequest;
import software.amazon.awssdk.services.lakeformation.model.DeleteDataCellsFilterResponse;
import software.amazon.awssdk.services.lakeformation.model.DeleteLakeFormationIdentityCenterConfigurationRequest;
import software.amazon.awssdk.services.lakeformation.model.DeleteLakeFormationIdentityCenterConfigurationResponse;
import software.amazon.awssdk.services.lakeformation.model.DeleteLakeFormationOptInRequest;
import software.amazon.awssdk.services.lakeformation.model.DeleteLakeFormationOptInResponse;
import software.amazon.awssdk.services.lakeformation.model.DeleteLfTagExpressionRequest;
import software.amazon.awssdk.services.lakeformation.model.DeleteLfTagExpressionResponse;
import software.amazon.awssdk.services.lakeformation.model.DeleteLfTagRequest;
import software.amazon.awssdk.services.lakeformation.model.DeleteLfTagResponse;
import software.amazon.awssdk.services.lakeformation.model.DeleteObjectsOnCancelRequest;
import software.amazon.awssdk.services.lakeformation.model.DeleteObjectsOnCancelResponse;
import software.amazon.awssdk.services.lakeformation.model.DeregisterResourceRequest;
import software.amazon.awssdk.services.lakeformation.model.DeregisterResourceResponse;
import software.amazon.awssdk.services.lakeformation.model.DescribeLakeFormationIdentityCenterConfigurationRequest;
import software.amazon.awssdk.services.lakeformation.model.DescribeLakeFormationIdentityCenterConfigurationResponse;
import software.amazon.awssdk.services.lakeformation.model.DescribeResourceRequest;
import software.amazon.awssdk.services.lakeformation.model.DescribeResourceResponse;
import software.amazon.awssdk.services.lakeformation.model.DescribeTransactionRequest;
import software.amazon.awssdk.services.lakeformation.model.DescribeTransactionResponse;
import software.amazon.awssdk.services.lakeformation.model.EntityNotFoundException;
import software.amazon.awssdk.services.lakeformation.model.ExpiredException;
import software.amazon.awssdk.services.lakeformation.model.ExtendTransactionRequest;
import software.amazon.awssdk.services.lakeformation.model.ExtendTransactionResponse;
import software.amazon.awssdk.services.lakeformation.model.GetDataCellsFilterRequest;
import software.amazon.awssdk.services.lakeformation.model.GetDataCellsFilterResponse;
import software.amazon.awssdk.services.lakeformation.model.GetDataLakePrincipalRequest;
import software.amazon.awssdk.services.lakeformation.model.GetDataLakePrincipalResponse;
import software.amazon.awssdk.services.lakeformation.model.GetDataLakeSettingsRequest;
import software.amazon.awssdk.services.lakeformation.model.GetDataLakeSettingsResponse;
import software.amazon.awssdk.services.lakeformation.model.GetEffectivePermissionsForPathRequest;
import software.amazon.awssdk.services.lakeformation.model.GetEffectivePermissionsForPathResponse;
import software.amazon.awssdk.services.lakeformation.model.GetLfTagExpressionRequest;
import software.amazon.awssdk.services.lakeformation.model.GetLfTagExpressionResponse;
import software.amazon.awssdk.services.lakeformation.model.GetLfTagRequest;
import software.amazon.awssdk.services.lakeformation.model.GetLfTagResponse;
import software.amazon.awssdk.services.lakeformation.model.GetQueryStateRequest;
import software.amazon.awssdk.services.lakeformation.model.GetQueryStateResponse;
import software.amazon.awssdk.services.lakeformation.model.GetQueryStatisticsRequest;
import software.amazon.awssdk.services.lakeformation.model.GetQueryStatisticsResponse;
import software.amazon.awssdk.services.lakeformation.model.GetResourceLfTagsRequest;
import software.amazon.awssdk.services.lakeformation.model.GetResourceLfTagsResponse;
import software.amazon.awssdk.services.lakeformation.model.GetTableObjectsRequest;
import software.amazon.awssdk.services.lakeformation.model.GetTableObjectsResponse;
import software.amazon.awssdk.services.lakeformation.model.GetTemporaryGluePartitionCredentialsRequest;
import software.amazon.awssdk.services.lakeformation.model.GetTemporaryGluePartitionCredentialsResponse;
import software.amazon.awssdk.services.lakeformation.model.GetTemporaryGlueTableCredentialsRequest;
import software.amazon.awssdk.services.lakeformation.model.GetTemporaryGlueTableCredentialsResponse;
import software.amazon.awssdk.services.lakeformation.model.GetWorkUnitResultsRequest;
import software.amazon.awssdk.services.lakeformation.model.GetWorkUnitResultsResponse;
import software.amazon.awssdk.services.lakeformation.model.GetWorkUnitsRequest;
import software.amazon.awssdk.services.lakeformation.model.GetWorkUnitsResponse;
import software.amazon.awssdk.services.lakeformation.model.GlueEncryptionException;
import software.amazon.awssdk.services.lakeformation.model.GrantPermissionsRequest;
import software.amazon.awssdk.services.lakeformation.model.GrantPermissionsResponse;
import software.amazon.awssdk.services.lakeformation.model.InternalServiceException;
import software.amazon.awssdk.services.lakeformation.model.InvalidInputException;
import software.amazon.awssdk.services.lakeformation.model.LakeFormationException;
import software.amazon.awssdk.services.lakeformation.model.ListDataCellsFilterRequest;
import software.amazon.awssdk.services.lakeformation.model.ListDataCellsFilterResponse;
import software.amazon.awssdk.services.lakeformation.model.ListLakeFormationOptInsRequest;
import software.amazon.awssdk.services.lakeformation.model.ListLakeFormationOptInsResponse;
import software.amazon.awssdk.services.lakeformation.model.ListLfTagExpressionsRequest;
import software.amazon.awssdk.services.lakeformation.model.ListLfTagExpressionsResponse;
import software.amazon.awssdk.services.lakeformation.model.ListLfTagsRequest;
import software.amazon.awssdk.services.lakeformation.model.ListLfTagsResponse;
import software.amazon.awssdk.services.lakeformation.model.ListPermissionsRequest;
import software.amazon.awssdk.services.lakeformation.model.ListPermissionsResponse;
import software.amazon.awssdk.services.lakeformation.model.ListResourcesRequest;
import software.amazon.awssdk.services.lakeformation.model.ListResourcesResponse;
import software.amazon.awssdk.services.lakeformation.model.ListTableStorageOptimizersRequest;
import software.amazon.awssdk.services.lakeformation.model.ListTableStorageOptimizersResponse;
import software.amazon.awssdk.services.lakeformation.model.ListTransactionsRequest;
import software.amazon.awssdk.services.lakeformation.model.ListTransactionsResponse;
import software.amazon.awssdk.services.lakeformation.model.OperationTimeoutException;
import software.amazon.awssdk.services.lakeformation.model.PermissionTypeMismatchException;
import software.amazon.awssdk.services.lakeformation.model.PutDataLakeSettingsRequest;
import software.amazon.awssdk.services.lakeformation.model.PutDataLakeSettingsResponse;
import software.amazon.awssdk.services.lakeformation.model.RegisterResourceRequest;
import software.amazon.awssdk.services.lakeformation.model.RegisterResourceResponse;
import software.amazon.awssdk.services.lakeformation.model.RemoveLfTagsFromResourceRequest;
import software.amazon.awssdk.services.lakeformation.model.RemoveLfTagsFromResourceResponse;
import software.amazon.awssdk.services.lakeformation.model.ResourceNotReadyException;
import software.amazon.awssdk.services.lakeformation.model.ResourceNumberLimitExceededException;
import software.amazon.awssdk.services.lakeformation.model.RevokePermissionsRequest;
import software.amazon.awssdk.services.lakeformation.model.RevokePermissionsResponse;
import software.amazon.awssdk.services.lakeformation.model.SearchDatabasesByLfTagsRequest;
import software.amazon.awssdk.services.lakeformation.model.SearchDatabasesByLfTagsResponse;
import software.amazon.awssdk.services.lakeformation.model.SearchTablesByLfTagsRequest;
import software.amazon.awssdk.services.lakeformation.model.SearchTablesByLfTagsResponse;
import software.amazon.awssdk.services.lakeformation.model.StartQueryPlanningRequest;
import software.amazon.awssdk.services.lakeformation.model.StartQueryPlanningResponse;
import software.amazon.awssdk.services.lakeformation.model.StartTransactionRequest;
import software.amazon.awssdk.services.lakeformation.model.StartTransactionResponse;
import software.amazon.awssdk.services.lakeformation.model.StatisticsNotReadyYetException;
import software.amazon.awssdk.services.lakeformation.model.ThrottledException;
import software.amazon.awssdk.services.lakeformation.model.TransactionCanceledException;
import software.amazon.awssdk.services.lakeformation.model.TransactionCommitInProgressException;
import software.amazon.awssdk.services.lakeformation.model.TransactionCommittedException;
import software.amazon.awssdk.services.lakeformation.model.UpdateDataCellsFilterRequest;
import software.amazon.awssdk.services.lakeformation.model.UpdateDataCellsFilterResponse;
import software.amazon.awssdk.services.lakeformation.model.UpdateLakeFormationIdentityCenterConfigurationRequest;
import software.amazon.awssdk.services.lakeformation.model.UpdateLakeFormationIdentityCenterConfigurationResponse;
import software.amazon.awssdk.services.lakeformation.model.UpdateLfTagExpressionRequest;
import software.amazon.awssdk.services.lakeformation.model.UpdateLfTagExpressionResponse;
import software.amazon.awssdk.services.lakeformation.model.UpdateLfTagRequest;
import software.amazon.awssdk.services.lakeformation.model.UpdateLfTagResponse;
import software.amazon.awssdk.services.lakeformation.model.UpdateResourceRequest;
import software.amazon.awssdk.services.lakeformation.model.UpdateResourceResponse;
import software.amazon.awssdk.services.lakeformation.model.UpdateTableObjectsRequest;
import software.amazon.awssdk.services.lakeformation.model.UpdateTableObjectsResponse;
import software.amazon.awssdk.services.lakeformation.model.UpdateTableStorageOptimizerRequest;
import software.amazon.awssdk.services.lakeformation.model.UpdateTableStorageOptimizerResponse;
import software.amazon.awssdk.services.lakeformation.model.WorkUnitsNotReadyYetException;
import software.amazon.awssdk.services.lakeformation.transform.AddLfTagsToResourceRequestMarshaller;
import software.amazon.awssdk.services.lakeformation.transform.AssumeDecoratedRoleWithSamlRequestMarshaller;
import software.amazon.awssdk.services.lakeformation.transform.BatchGrantPermissionsRequestMarshaller;
import software.amazon.awssdk.services.lakeformation.transform.BatchRevokePermissionsRequestMarshaller;
import software.amazon.awssdk.services.lakeformation.transform.CancelTransactionRequestMarshaller;
import software.amazon.awssdk.services.lakeformation.transform.CommitTransactionRequestMarshaller;
import software.amazon.awssdk.services.lakeformation.transform.CreateDataCellsFilterRequestMarshaller;
import software.amazon.awssdk.services.lakeformation.transform.CreateLakeFormationIdentityCenterConfigurationRequestMarshaller;
import software.amazon.awssdk.services.lakeformation.transform.CreateLakeFormationOptInRequestMarshaller;
import software.amazon.awssdk.services.lakeformation.transform.CreateLfTagExpressionRequestMarshaller;
import software.amazon.awssdk.services.lakeformation.transform.CreateLfTagRequestMarshaller;
import software.amazon.awssdk.services.lakeformation.transform.DeleteDataCellsFilterRequestMarshaller;
import software.amazon.awssdk.services.lakeformation.transform.DeleteLakeFormationIdentityCenterConfigurationRequestMarshaller;
import software.amazon.awssdk.services.lakeformation.transform.DeleteLakeFormationOptInRequestMarshaller;
import software.amazon.awssdk.services.lakeformation.transform.DeleteLfTagExpressionRequestMarshaller;
import software.amazon.awssdk.services.lakeformation.transform.DeleteLfTagRequestMarshaller;
import software.amazon.awssdk.services.lakeformation.transform.DeleteObjectsOnCancelRequestMarshaller;
import software.amazon.awssdk.services.lakeformation.transform.DeregisterResourceRequestMarshaller;
import software.amazon.awssdk.services.lakeformation.transform.DescribeLakeFormationIdentityCenterConfigurationRequestMarshaller;
import software.amazon.awssdk.services.lakeformation.transform.DescribeResourceRequestMarshaller;
import software.amazon.awssdk.services.lakeformation.transform.DescribeTransactionRequestMarshaller;
import software.amazon.awssdk.services.lakeformation.transform.ExtendTransactionRequestMarshaller;
import software.amazon.awssdk.services.lakeformation.transform.GetDataCellsFilterRequestMarshaller;
import software.amazon.awssdk.services.lakeformation.transform.GetDataLakePrincipalRequestMarshaller;
import software.amazon.awssdk.services.lakeformation.transform.GetDataLakeSettingsRequestMarshaller;
import software.amazon.awssdk.services.lakeformation.transform.GetEffectivePermissionsForPathRequestMarshaller;
import software.amazon.awssdk.services.lakeformation.transform.GetLfTagExpressionRequestMarshaller;
import software.amazon.awssdk.services.lakeformation.transform.GetLfTagRequestMarshaller;
import software.amazon.awssdk.services.lakeformation.transform.GetQueryStateRequestMarshaller;
import software.amazon.awssdk.services.lakeformation.transform.GetQueryStatisticsRequestMarshaller;
import software.amazon.awssdk.services.lakeformation.transform.GetResourceLfTagsRequestMarshaller;
import software.amazon.awssdk.services.lakeformation.transform.GetTableObjectsRequestMarshaller;
import software.amazon.awssdk.services.lakeformation.transform.GetTemporaryGluePartitionCredentialsRequestMarshaller;
import software.amazon.awssdk.services.lakeformation.transform.GetTemporaryGlueTableCredentialsRequestMarshaller;
import software.amazon.awssdk.services.lakeformation.transform.GetWorkUnitResultsRequestMarshaller;
import software.amazon.awssdk.services.lakeformation.transform.GetWorkUnitsRequestMarshaller;
import software.amazon.awssdk.services.lakeformation.transform.GrantPermissionsRequestMarshaller;
import software.amazon.awssdk.services.lakeformation.transform.ListDataCellsFilterRequestMarshaller;
import software.amazon.awssdk.services.lakeformation.transform.ListLakeFormationOptInsRequestMarshaller;
import software.amazon.awssdk.services.lakeformation.transform.ListLfTagExpressionsRequestMarshaller;
import software.amazon.awssdk.services.lakeformation.transform.ListLfTagsRequestMarshaller;
import software.amazon.awssdk.services.lakeformation.transform.ListPermissionsRequestMarshaller;
import software.amazon.awssdk.services.lakeformation.transform.ListResourcesRequestMarshaller;
import software.amazon.awssdk.services.lakeformation.transform.ListTableStorageOptimizersRequestMarshaller;
import software.amazon.awssdk.services.lakeformation.transform.ListTransactionsRequestMarshaller;
import software.amazon.awssdk.services.lakeformation.transform.PutDataLakeSettingsRequestMarshaller;
import software.amazon.awssdk.services.lakeformation.transform.RegisterResourceRequestMarshaller;
import software.amazon.awssdk.services.lakeformation.transform.RemoveLfTagsFromResourceRequestMarshaller;
import software.amazon.awssdk.services.lakeformation.transform.RevokePermissionsRequestMarshaller;
import software.amazon.awssdk.services.lakeformation.transform.SearchDatabasesByLfTagsRequestMarshaller;
import software.amazon.awssdk.services.lakeformation.transform.SearchTablesByLfTagsRequestMarshaller;
import software.amazon.awssdk.services.lakeformation.transform.StartQueryPlanningRequestMarshaller;
import software.amazon.awssdk.services.lakeformation.transform.StartTransactionRequestMarshaller;
import software.amazon.awssdk.services.lakeformation.transform.UpdateDataCellsFilterRequestMarshaller;
import software.amazon.awssdk.services.lakeformation.transform.UpdateLakeFormationIdentityCenterConfigurationRequestMarshaller;
import software.amazon.awssdk.services.lakeformation.transform.UpdateLfTagExpressionRequestMarshaller;
import software.amazon.awssdk.services.lakeformation.transform.UpdateLfTagRequestMarshaller;
import software.amazon.awssdk.services.lakeformation.transform.UpdateResourceRequestMarshaller;
import software.amazon.awssdk.services.lakeformation.transform.UpdateTableObjectsRequestMarshaller;
import software.amazon.awssdk.services.lakeformation.transform.UpdateTableStorageOptimizerRequestMarshaller;
import software.amazon.awssdk.utils.CompletableFutureUtils;
import software.amazon.awssdk.utils.FunctionalUtils;
import software.amazon.awssdk.utils.Pair;

@SdkInternalApi
final class DefaultLakeFormationAsyncClient
implements LakeFormationAsyncClient {
    private static final Logger log = LoggerFactory.getLogger(DefaultLakeFormationAsyncClient.class);
    private static final AwsProtocolMetadata protocolMetadata = AwsProtocolMetadata.builder().serviceProtocol(AwsServiceProtocol.REST_JSON).build();
    private final AsyncClientHandler clientHandler;
    private final AwsJsonProtocolFactory protocolFactory;
    private final SdkClientConfiguration clientConfiguration;

    protected DefaultLakeFormationAsyncClient(SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsAsyncClientHandler(clientConfiguration);
        this.clientConfiguration = clientConfiguration.toBuilder().option(SdkClientOption.SDK_CLIENT, this).option(SdkClientOption.API_METADATA, "LakeFormation#2.38.x").build();
        this.protocolFactory = this.init(AwsJsonProtocolFactory.builder()).build();
    }

    @Override
    public CompletableFuture<AddLfTagsToResourceResponse> addLFTagsToResource(AddLfTagsToResourceRequest addLfTagsToResourceRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration(addLfTagsToResourceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultLakeFormationAsyncClient.resolveMetricPublishers(clientConfiguration, addLfTagsToResourceRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "LakeFormation");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "AddLFTagsToResource");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, AddLfTagsToResourceResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "TransactionCommitInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCommitInProgressException").httpStatusCode(400).exceptionBuilderSupplier(TransactionCommitInProgressException::builder).build());
                    }
                    case "ConcurrentModificationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                    }
                    case "ResourceNotReadyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotReadyException").httpStatusCode(400).exceptionBuilderSupplier(ResourceNotReadyException::builder).build());
                    }
                    case "ThrottledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ThrottledException").httpStatusCode(429).exceptionBuilderSupplier(ThrottledException::builder).build());
                    }
                    case "AlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AlreadyExistsException").exceptionBuilderSupplier(AlreadyExistsException::builder).build());
                    }
                    case "TransactionCommittedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCommittedException").httpStatusCode(400).exceptionBuilderSupplier(TransactionCommittedException::builder).build());
                    }
                    case "InternalServiceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceException").httpStatusCode(500).exceptionBuilderSupplier(InternalServiceException::builder).build());
                    }
                    case "ResourceNumberLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNumberLimitExceededException").exceptionBuilderSupplier(ResourceNumberLimitExceededException::builder).build());
                    }
                    case "ExpiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ExpiredException").httpStatusCode(410).exceptionBuilderSupplier(ExpiredException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "InvalidInputException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(400).exceptionBuilderSupplier(InvalidInputException::builder).build());
                    }
                    case "EntityNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EntityNotFoundException").exceptionBuilderSupplier(EntityNotFoundException::builder).build());
                    }
                    case "StatisticsNotReadyYetException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("StatisticsNotReadyYetException").httpStatusCode(420).exceptionBuilderSupplier(StatisticsNotReadyYetException::builder).build());
                    }
                    case "TransactionCanceledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCanceledException").httpStatusCode(400).exceptionBuilderSupplier(TransactionCanceledException::builder).build());
                    }
                    case "GlueEncryptionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("GlueEncryptionException").exceptionBuilderSupplier(GlueEncryptionException::builder).build());
                    }
                    case "PermissionTypeMismatchException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PermissionTypeMismatchException").exceptionBuilderSupplier(PermissionTypeMismatchException::builder).build());
                    }
                    case "WorkUnitsNotReadyYetException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WorkUnitsNotReadyYetException").httpStatusCode(420).exceptionBuilderSupplier(WorkUnitsNotReadyYetException::builder).build());
                    }
                    case "OperationTimeoutException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OperationTimeoutException").exceptionBuilderSupplier(OperationTimeoutException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture<AddLfTagsToResourceResponse> executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("AddLFTagsToResource").withProtocolMetadata(protocolMetadata).withMarshaller(new AddLfTagsToResourceRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector).withInput(addLfTagsToResourceRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((r, e) -> metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect())));
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    @Override
    public CompletableFuture<AssumeDecoratedRoleWithSamlResponse> assumeDecoratedRoleWithSAML(AssumeDecoratedRoleWithSamlRequest assumeDecoratedRoleWithSamlRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration(assumeDecoratedRoleWithSamlRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultLakeFormationAsyncClient.resolveMetricPublishers(clientConfiguration, assumeDecoratedRoleWithSamlRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "LakeFormation");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "AssumeDecoratedRoleWithSAML");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, AssumeDecoratedRoleWithSamlResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "TransactionCommitInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCommitInProgressException").httpStatusCode(400).exceptionBuilderSupplier(TransactionCommitInProgressException::builder).build());
                    }
                    case "ConcurrentModificationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                    }
                    case "ResourceNotReadyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotReadyException").httpStatusCode(400).exceptionBuilderSupplier(ResourceNotReadyException::builder).build());
                    }
                    case "ThrottledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ThrottledException").httpStatusCode(429).exceptionBuilderSupplier(ThrottledException::builder).build());
                    }
                    case "AlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AlreadyExistsException").exceptionBuilderSupplier(AlreadyExistsException::builder).build());
                    }
                    case "TransactionCommittedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCommittedException").httpStatusCode(400).exceptionBuilderSupplier(TransactionCommittedException::builder).build());
                    }
                    case "InternalServiceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceException").httpStatusCode(500).exceptionBuilderSupplier(InternalServiceException::builder).build());
                    }
                    case "ResourceNumberLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNumberLimitExceededException").exceptionBuilderSupplier(ResourceNumberLimitExceededException::builder).build());
                    }
                    case "ExpiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ExpiredException").httpStatusCode(410).exceptionBuilderSupplier(ExpiredException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "InvalidInputException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(400).exceptionBuilderSupplier(InvalidInputException::builder).build());
                    }
                    case "EntityNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EntityNotFoundException").exceptionBuilderSupplier(EntityNotFoundException::builder).build());
                    }
                    case "StatisticsNotReadyYetException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("StatisticsNotReadyYetException").httpStatusCode(420).exceptionBuilderSupplier(StatisticsNotReadyYetException::builder).build());
                    }
                    case "TransactionCanceledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCanceledException").httpStatusCode(400).exceptionBuilderSupplier(TransactionCanceledException::builder).build());
                    }
                    case "GlueEncryptionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("GlueEncryptionException").exceptionBuilderSupplier(GlueEncryptionException::builder).build());
                    }
                    case "PermissionTypeMismatchException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PermissionTypeMismatchException").exceptionBuilderSupplier(PermissionTypeMismatchException::builder).build());
                    }
                    case "WorkUnitsNotReadyYetException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WorkUnitsNotReadyYetException").httpStatusCode(420).exceptionBuilderSupplier(WorkUnitsNotReadyYetException::builder).build());
                    }
                    case "OperationTimeoutException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OperationTimeoutException").exceptionBuilderSupplier(OperationTimeoutException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture<AssumeDecoratedRoleWithSamlResponse> executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("AssumeDecoratedRoleWithSAML").withProtocolMetadata(protocolMetadata).withMarshaller(new AssumeDecoratedRoleWithSamlRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector).withInput(assumeDecoratedRoleWithSamlRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((r, e) -> metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect())));
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    @Override
    public CompletableFuture<BatchGrantPermissionsResponse> batchGrantPermissions(BatchGrantPermissionsRequest batchGrantPermissionsRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration(batchGrantPermissionsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultLakeFormationAsyncClient.resolveMetricPublishers(clientConfiguration, batchGrantPermissionsRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "LakeFormation");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "BatchGrantPermissions");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, BatchGrantPermissionsResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "TransactionCommitInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCommitInProgressException").httpStatusCode(400).exceptionBuilderSupplier(TransactionCommitInProgressException::builder).build());
                    }
                    case "ConcurrentModificationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                    }
                    case "ResourceNotReadyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotReadyException").httpStatusCode(400).exceptionBuilderSupplier(ResourceNotReadyException::builder).build());
                    }
                    case "ThrottledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ThrottledException").httpStatusCode(429).exceptionBuilderSupplier(ThrottledException::builder).build());
                    }
                    case "AlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AlreadyExistsException").exceptionBuilderSupplier(AlreadyExistsException::builder).build());
                    }
                    case "TransactionCommittedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCommittedException").httpStatusCode(400).exceptionBuilderSupplier(TransactionCommittedException::builder).build());
                    }
                    case "InternalServiceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceException").httpStatusCode(500).exceptionBuilderSupplier(InternalServiceException::builder).build());
                    }
                    case "ResourceNumberLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNumberLimitExceededException").exceptionBuilderSupplier(ResourceNumberLimitExceededException::builder).build());
                    }
                    case "ExpiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ExpiredException").httpStatusCode(410).exceptionBuilderSupplier(ExpiredException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "InvalidInputException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(400).exceptionBuilderSupplier(InvalidInputException::builder).build());
                    }
                    case "EntityNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EntityNotFoundException").exceptionBuilderSupplier(EntityNotFoundException::builder).build());
                    }
                    case "StatisticsNotReadyYetException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("StatisticsNotReadyYetException").httpStatusCode(420).exceptionBuilderSupplier(StatisticsNotReadyYetException::builder).build());
                    }
                    case "TransactionCanceledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCanceledException").httpStatusCode(400).exceptionBuilderSupplier(TransactionCanceledException::builder).build());
                    }
                    case "GlueEncryptionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("GlueEncryptionException").exceptionBuilderSupplier(GlueEncryptionException::builder).build());
                    }
                    case "PermissionTypeMismatchException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PermissionTypeMismatchException").exceptionBuilderSupplier(PermissionTypeMismatchException::builder).build());
                    }
                    case "WorkUnitsNotReadyYetException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WorkUnitsNotReadyYetException").httpStatusCode(420).exceptionBuilderSupplier(WorkUnitsNotReadyYetException::builder).build());
                    }
                    case "OperationTimeoutException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OperationTimeoutException").exceptionBuilderSupplier(OperationTimeoutException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture<BatchGrantPermissionsResponse> executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("BatchGrantPermissions").withProtocolMetadata(protocolMetadata).withMarshaller(new BatchGrantPermissionsRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector).withInput(batchGrantPermissionsRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((r, e) -> metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect())));
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    @Override
    public CompletableFuture<BatchRevokePermissionsResponse> batchRevokePermissions(BatchRevokePermissionsRequest batchRevokePermissionsRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration(batchRevokePermissionsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultLakeFormationAsyncClient.resolveMetricPublishers(clientConfiguration, batchRevokePermissionsRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "LakeFormation");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "BatchRevokePermissions");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, BatchRevokePermissionsResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "TransactionCommitInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCommitInProgressException").httpStatusCode(400).exceptionBuilderSupplier(TransactionCommitInProgressException::builder).build());
                    }
                    case "ConcurrentModificationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                    }
                    case "ResourceNotReadyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotReadyException").httpStatusCode(400).exceptionBuilderSupplier(ResourceNotReadyException::builder).build());
                    }
                    case "ThrottledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ThrottledException").httpStatusCode(429).exceptionBuilderSupplier(ThrottledException::builder).build());
                    }
                    case "AlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AlreadyExistsException").exceptionBuilderSupplier(AlreadyExistsException::builder).build());
                    }
                    case "TransactionCommittedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCommittedException").httpStatusCode(400).exceptionBuilderSupplier(TransactionCommittedException::builder).build());
                    }
                    case "InternalServiceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceException").httpStatusCode(500).exceptionBuilderSupplier(InternalServiceException::builder).build());
                    }
                    case "ResourceNumberLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNumberLimitExceededException").exceptionBuilderSupplier(ResourceNumberLimitExceededException::builder).build());
                    }
                    case "ExpiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ExpiredException").httpStatusCode(410).exceptionBuilderSupplier(ExpiredException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "InvalidInputException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(400).exceptionBuilderSupplier(InvalidInputException::builder).build());
                    }
                    case "EntityNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EntityNotFoundException").exceptionBuilderSupplier(EntityNotFoundException::builder).build());
                    }
                    case "StatisticsNotReadyYetException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("StatisticsNotReadyYetException").httpStatusCode(420).exceptionBuilderSupplier(StatisticsNotReadyYetException::builder).build());
                    }
                    case "TransactionCanceledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCanceledException").httpStatusCode(400).exceptionBuilderSupplier(TransactionCanceledException::builder).build());
                    }
                    case "GlueEncryptionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("GlueEncryptionException").exceptionBuilderSupplier(GlueEncryptionException::builder).build());
                    }
                    case "PermissionTypeMismatchException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PermissionTypeMismatchException").exceptionBuilderSupplier(PermissionTypeMismatchException::builder).build());
                    }
                    case "WorkUnitsNotReadyYetException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WorkUnitsNotReadyYetException").httpStatusCode(420).exceptionBuilderSupplier(WorkUnitsNotReadyYetException::builder).build());
                    }
                    case "OperationTimeoutException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OperationTimeoutException").exceptionBuilderSupplier(OperationTimeoutException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture<BatchRevokePermissionsResponse> executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("BatchRevokePermissions").withProtocolMetadata(protocolMetadata).withMarshaller(new BatchRevokePermissionsRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector).withInput(batchRevokePermissionsRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((r, e) -> metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect())));
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    @Override
    public CompletableFuture<CancelTransactionResponse> cancelTransaction(CancelTransactionRequest cancelTransactionRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration(cancelTransactionRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultLakeFormationAsyncClient.resolveMetricPublishers(clientConfiguration, cancelTransactionRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "LakeFormation");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CancelTransaction");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CancelTransactionResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "TransactionCommitInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCommitInProgressException").httpStatusCode(400).exceptionBuilderSupplier(TransactionCommitInProgressException::builder).build());
                    }
                    case "ConcurrentModificationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                    }
                    case "ResourceNotReadyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotReadyException").httpStatusCode(400).exceptionBuilderSupplier(ResourceNotReadyException::builder).build());
                    }
                    case "ThrottledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ThrottledException").httpStatusCode(429).exceptionBuilderSupplier(ThrottledException::builder).build());
                    }
                    case "AlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AlreadyExistsException").exceptionBuilderSupplier(AlreadyExistsException::builder).build());
                    }
                    case "TransactionCommittedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCommittedException").httpStatusCode(400).exceptionBuilderSupplier(TransactionCommittedException::builder).build());
                    }
                    case "InternalServiceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceException").httpStatusCode(500).exceptionBuilderSupplier(InternalServiceException::builder).build());
                    }
                    case "ResourceNumberLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNumberLimitExceededException").exceptionBuilderSupplier(ResourceNumberLimitExceededException::builder).build());
                    }
                    case "ExpiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ExpiredException").httpStatusCode(410).exceptionBuilderSupplier(ExpiredException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "InvalidInputException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(400).exceptionBuilderSupplier(InvalidInputException::builder).build());
                    }
                    case "EntityNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EntityNotFoundException").exceptionBuilderSupplier(EntityNotFoundException::builder).build());
                    }
                    case "StatisticsNotReadyYetException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("StatisticsNotReadyYetException").httpStatusCode(420).exceptionBuilderSupplier(StatisticsNotReadyYetException::builder).build());
                    }
                    case "TransactionCanceledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCanceledException").httpStatusCode(400).exceptionBuilderSupplier(TransactionCanceledException::builder).build());
                    }
                    case "GlueEncryptionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("GlueEncryptionException").exceptionBuilderSupplier(GlueEncryptionException::builder).build());
                    }
                    case "PermissionTypeMismatchException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PermissionTypeMismatchException").exceptionBuilderSupplier(PermissionTypeMismatchException::builder).build());
                    }
                    case "WorkUnitsNotReadyYetException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WorkUnitsNotReadyYetException").httpStatusCode(420).exceptionBuilderSupplier(WorkUnitsNotReadyYetException::builder).build());
                    }
                    case "OperationTimeoutException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OperationTimeoutException").exceptionBuilderSupplier(OperationTimeoutException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture<CancelTransactionResponse> executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("CancelTransaction").withProtocolMetadata(protocolMetadata).withMarshaller(new CancelTransactionRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector).withInput(cancelTransactionRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((r, e) -> metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect())));
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    @Override
    public CompletableFuture<CommitTransactionResponse> commitTransaction(CommitTransactionRequest commitTransactionRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration(commitTransactionRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultLakeFormationAsyncClient.resolveMetricPublishers(clientConfiguration, commitTransactionRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "LakeFormation");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CommitTransaction");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CommitTransactionResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "TransactionCommitInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCommitInProgressException").httpStatusCode(400).exceptionBuilderSupplier(TransactionCommitInProgressException::builder).build());
                    }
                    case "ConcurrentModificationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                    }
                    case "ResourceNotReadyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotReadyException").httpStatusCode(400).exceptionBuilderSupplier(ResourceNotReadyException::builder).build());
                    }
                    case "ThrottledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ThrottledException").httpStatusCode(429).exceptionBuilderSupplier(ThrottledException::builder).build());
                    }
                    case "AlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AlreadyExistsException").exceptionBuilderSupplier(AlreadyExistsException::builder).build());
                    }
                    case "TransactionCommittedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCommittedException").httpStatusCode(400).exceptionBuilderSupplier(TransactionCommittedException::builder).build());
                    }
                    case "InternalServiceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceException").httpStatusCode(500).exceptionBuilderSupplier(InternalServiceException::builder).build());
                    }
                    case "ResourceNumberLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNumberLimitExceededException").exceptionBuilderSupplier(ResourceNumberLimitExceededException::builder).build());
                    }
                    case "ExpiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ExpiredException").httpStatusCode(410).exceptionBuilderSupplier(ExpiredException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "InvalidInputException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(400).exceptionBuilderSupplier(InvalidInputException::builder).build());
                    }
                    case "EntityNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EntityNotFoundException").exceptionBuilderSupplier(EntityNotFoundException::builder).build());
                    }
                    case "StatisticsNotReadyYetException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("StatisticsNotReadyYetException").httpStatusCode(420).exceptionBuilderSupplier(StatisticsNotReadyYetException::builder).build());
                    }
                    case "TransactionCanceledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCanceledException").httpStatusCode(400).exceptionBuilderSupplier(TransactionCanceledException::builder).build());
                    }
                    case "GlueEncryptionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("GlueEncryptionException").exceptionBuilderSupplier(GlueEncryptionException::builder).build());
                    }
                    case "PermissionTypeMismatchException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PermissionTypeMismatchException").exceptionBuilderSupplier(PermissionTypeMismatchException::builder).build());
                    }
                    case "WorkUnitsNotReadyYetException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WorkUnitsNotReadyYetException").httpStatusCode(420).exceptionBuilderSupplier(WorkUnitsNotReadyYetException::builder).build());
                    }
                    case "OperationTimeoutException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OperationTimeoutException").exceptionBuilderSupplier(OperationTimeoutException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture<CommitTransactionResponse> executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("CommitTransaction").withProtocolMetadata(protocolMetadata).withMarshaller(new CommitTransactionRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector).withInput(commitTransactionRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((r, e) -> metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect())));
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    @Override
    public CompletableFuture<CreateDataCellsFilterResponse> createDataCellsFilter(CreateDataCellsFilterRequest createDataCellsFilterRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration(createDataCellsFilterRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultLakeFormationAsyncClient.resolveMetricPublishers(clientConfiguration, createDataCellsFilterRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "LakeFormation");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateDataCellsFilter");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateDataCellsFilterResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "TransactionCommitInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCommitInProgressException").httpStatusCode(400).exceptionBuilderSupplier(TransactionCommitInProgressException::builder).build());
                    }
                    case "ConcurrentModificationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                    }
                    case "ResourceNotReadyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotReadyException").httpStatusCode(400).exceptionBuilderSupplier(ResourceNotReadyException::builder).build());
                    }
                    case "ThrottledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ThrottledException").httpStatusCode(429).exceptionBuilderSupplier(ThrottledException::builder).build());
                    }
                    case "AlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AlreadyExistsException").exceptionBuilderSupplier(AlreadyExistsException::builder).build());
                    }
                    case "TransactionCommittedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCommittedException").httpStatusCode(400).exceptionBuilderSupplier(TransactionCommittedException::builder).build());
                    }
                    case "InternalServiceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceException").httpStatusCode(500).exceptionBuilderSupplier(InternalServiceException::builder).build());
                    }
                    case "ResourceNumberLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNumberLimitExceededException").exceptionBuilderSupplier(ResourceNumberLimitExceededException::builder).build());
                    }
                    case "ExpiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ExpiredException").httpStatusCode(410).exceptionBuilderSupplier(ExpiredException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "InvalidInputException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(400).exceptionBuilderSupplier(InvalidInputException::builder).build());
                    }
                    case "EntityNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EntityNotFoundException").exceptionBuilderSupplier(EntityNotFoundException::builder).build());
                    }
                    case "StatisticsNotReadyYetException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("StatisticsNotReadyYetException").httpStatusCode(420).exceptionBuilderSupplier(StatisticsNotReadyYetException::builder).build());
                    }
                    case "TransactionCanceledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCanceledException").httpStatusCode(400).exceptionBuilderSupplier(TransactionCanceledException::builder).build());
                    }
                    case "GlueEncryptionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("GlueEncryptionException").exceptionBuilderSupplier(GlueEncryptionException::builder).build());
                    }
                    case "PermissionTypeMismatchException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PermissionTypeMismatchException").exceptionBuilderSupplier(PermissionTypeMismatchException::builder).build());
                    }
                    case "WorkUnitsNotReadyYetException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WorkUnitsNotReadyYetException").httpStatusCode(420).exceptionBuilderSupplier(WorkUnitsNotReadyYetException::builder).build());
                    }
                    case "OperationTimeoutException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OperationTimeoutException").exceptionBuilderSupplier(OperationTimeoutException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture<CreateDataCellsFilterResponse> executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateDataCellsFilter").withProtocolMetadata(protocolMetadata).withMarshaller(new CreateDataCellsFilterRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector).withInput(createDataCellsFilterRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((r, e) -> metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect())));
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    @Override
    public CompletableFuture<CreateLfTagResponse> createLFTag(CreateLfTagRequest createLfTagRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration(createLfTagRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultLakeFormationAsyncClient.resolveMetricPublishers(clientConfiguration, createLfTagRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "LakeFormation");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateLFTag");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateLfTagResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "TransactionCommitInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCommitInProgressException").httpStatusCode(400).exceptionBuilderSupplier(TransactionCommitInProgressException::builder).build());
                    }
                    case "ConcurrentModificationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                    }
                    case "ResourceNotReadyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotReadyException").httpStatusCode(400).exceptionBuilderSupplier(ResourceNotReadyException::builder).build());
                    }
                    case "ThrottledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ThrottledException").httpStatusCode(429).exceptionBuilderSupplier(ThrottledException::builder).build());
                    }
                    case "AlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AlreadyExistsException").exceptionBuilderSupplier(AlreadyExistsException::builder).build());
                    }
                    case "TransactionCommittedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCommittedException").httpStatusCode(400).exceptionBuilderSupplier(TransactionCommittedException::builder).build());
                    }
                    case "InternalServiceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceException").httpStatusCode(500).exceptionBuilderSupplier(InternalServiceException::builder).build());
                    }
                    case "ResourceNumberLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNumberLimitExceededException").exceptionBuilderSupplier(ResourceNumberLimitExceededException::builder).build());
                    }
                    case "ExpiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ExpiredException").httpStatusCode(410).exceptionBuilderSupplier(ExpiredException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "InvalidInputException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(400).exceptionBuilderSupplier(InvalidInputException::builder).build());
                    }
                    case "EntityNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EntityNotFoundException").exceptionBuilderSupplier(EntityNotFoundException::builder).build());
                    }
                    case "StatisticsNotReadyYetException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("StatisticsNotReadyYetException").httpStatusCode(420).exceptionBuilderSupplier(StatisticsNotReadyYetException::builder).build());
                    }
                    case "TransactionCanceledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCanceledException").httpStatusCode(400).exceptionBuilderSupplier(TransactionCanceledException::builder).build());
                    }
                    case "GlueEncryptionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("GlueEncryptionException").exceptionBuilderSupplier(GlueEncryptionException::builder).build());
                    }
                    case "PermissionTypeMismatchException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PermissionTypeMismatchException").exceptionBuilderSupplier(PermissionTypeMismatchException::builder).build());
                    }
                    case "WorkUnitsNotReadyYetException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WorkUnitsNotReadyYetException").httpStatusCode(420).exceptionBuilderSupplier(WorkUnitsNotReadyYetException::builder).build());
                    }
                    case "OperationTimeoutException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OperationTimeoutException").exceptionBuilderSupplier(OperationTimeoutException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture<CreateLfTagResponse> executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateLFTag").withProtocolMetadata(protocolMetadata).withMarshaller(new CreateLfTagRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector).withInput(createLfTagRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((r, e) -> metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect())));
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    @Override
    public CompletableFuture<CreateLfTagExpressionResponse> createLFTagExpression(CreateLfTagExpressionRequest createLfTagExpressionRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration(createLfTagExpressionRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultLakeFormationAsyncClient.resolveMetricPublishers(clientConfiguration, createLfTagExpressionRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "LakeFormation");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateLFTagExpression");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateLfTagExpressionResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "TransactionCommitInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCommitInProgressException").httpStatusCode(400).exceptionBuilderSupplier(TransactionCommitInProgressException::builder).build());
                    }
                    case "ConcurrentModificationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                    }
                    case "ResourceNotReadyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotReadyException").httpStatusCode(400).exceptionBuilderSupplier(ResourceNotReadyException::builder).build());
                    }
                    case "ThrottledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ThrottledException").httpStatusCode(429).exceptionBuilderSupplier(ThrottledException::builder).build());
                    }
                    case "AlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AlreadyExistsException").exceptionBuilderSupplier(AlreadyExistsException::builder).build());
                    }
                    case "TransactionCommittedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCommittedException").httpStatusCode(400).exceptionBuilderSupplier(TransactionCommittedException::builder).build());
                    }
                    case "InternalServiceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceException").httpStatusCode(500).exceptionBuilderSupplier(InternalServiceException::builder).build());
                    }
                    case "ResourceNumberLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNumberLimitExceededException").exceptionBuilderSupplier(ResourceNumberLimitExceededException::builder).build());
                    }
                    case "ExpiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ExpiredException").httpStatusCode(410).exceptionBuilderSupplier(ExpiredException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "InvalidInputException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(400).exceptionBuilderSupplier(InvalidInputException::builder).build());
                    }
                    case "EntityNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EntityNotFoundException").exceptionBuilderSupplier(EntityNotFoundException::builder).build());
                    }
                    case "StatisticsNotReadyYetException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("StatisticsNotReadyYetException").httpStatusCode(420).exceptionBuilderSupplier(StatisticsNotReadyYetException::builder).build());
                    }
                    case "TransactionCanceledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCanceledException").httpStatusCode(400).exceptionBuilderSupplier(TransactionCanceledException::builder).build());
                    }
                    case "GlueEncryptionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("GlueEncryptionException").exceptionBuilderSupplier(GlueEncryptionException::builder).build());
                    }
                    case "PermissionTypeMismatchException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PermissionTypeMismatchException").exceptionBuilderSupplier(PermissionTypeMismatchException::builder).build());
                    }
                    case "WorkUnitsNotReadyYetException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WorkUnitsNotReadyYetException").httpStatusCode(420).exceptionBuilderSupplier(WorkUnitsNotReadyYetException::builder).build());
                    }
                    case "OperationTimeoutException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OperationTimeoutException").exceptionBuilderSupplier(OperationTimeoutException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture<CreateLfTagExpressionResponse> executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateLFTagExpression").withProtocolMetadata(protocolMetadata).withMarshaller(new CreateLfTagExpressionRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector).withInput(createLfTagExpressionRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((r, e) -> metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect())));
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    @Override
    public CompletableFuture<CreateLakeFormationIdentityCenterConfigurationResponse> createLakeFormationIdentityCenterConfiguration(CreateLakeFormationIdentityCenterConfigurationRequest createLakeFormationIdentityCenterConfigurationRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration(createLakeFormationIdentityCenterConfigurationRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultLakeFormationAsyncClient.resolveMetricPublishers(clientConfiguration, createLakeFormationIdentityCenterConfigurationRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "LakeFormation");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateLakeFormationIdentityCenterConfiguration");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateLakeFormationIdentityCenterConfigurationResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "TransactionCommitInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCommitInProgressException").httpStatusCode(400).exceptionBuilderSupplier(TransactionCommitInProgressException::builder).build());
                    }
                    case "ConcurrentModificationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                    }
                    case "ResourceNotReadyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotReadyException").httpStatusCode(400).exceptionBuilderSupplier(ResourceNotReadyException::builder).build());
                    }
                    case "ThrottledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ThrottledException").httpStatusCode(429).exceptionBuilderSupplier(ThrottledException::builder).build());
                    }
                    case "AlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AlreadyExistsException").exceptionBuilderSupplier(AlreadyExistsException::builder).build());
                    }
                    case "TransactionCommittedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCommittedException").httpStatusCode(400).exceptionBuilderSupplier(TransactionCommittedException::builder).build());
                    }
                    case "InternalServiceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceException").httpStatusCode(500).exceptionBuilderSupplier(InternalServiceException::builder).build());
                    }
                    case "ResourceNumberLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNumberLimitExceededException").exceptionBuilderSupplier(ResourceNumberLimitExceededException::builder).build());
                    }
                    case "ExpiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ExpiredException").httpStatusCode(410).exceptionBuilderSupplier(ExpiredException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "InvalidInputException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(400).exceptionBuilderSupplier(InvalidInputException::builder).build());
                    }
                    case "EntityNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EntityNotFoundException").exceptionBuilderSupplier(EntityNotFoundException::builder).build());
                    }
                    case "StatisticsNotReadyYetException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("StatisticsNotReadyYetException").httpStatusCode(420).exceptionBuilderSupplier(StatisticsNotReadyYetException::builder).build());
                    }
                    case "TransactionCanceledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCanceledException").httpStatusCode(400).exceptionBuilderSupplier(TransactionCanceledException::builder).build());
                    }
                    case "GlueEncryptionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("GlueEncryptionException").exceptionBuilderSupplier(GlueEncryptionException::builder).build());
                    }
                    case "PermissionTypeMismatchException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PermissionTypeMismatchException").exceptionBuilderSupplier(PermissionTypeMismatchException::builder).build());
                    }
                    case "WorkUnitsNotReadyYetException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WorkUnitsNotReadyYetException").httpStatusCode(420).exceptionBuilderSupplier(WorkUnitsNotReadyYetException::builder).build());
                    }
                    case "OperationTimeoutException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OperationTimeoutException").exceptionBuilderSupplier(OperationTimeoutException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture<CreateLakeFormationIdentityCenterConfigurationResponse> executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateLakeFormationIdentityCenterConfiguration").withProtocolMetadata(protocolMetadata).withMarshaller(new CreateLakeFormationIdentityCenterConfigurationRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector).withInput(createLakeFormationIdentityCenterConfigurationRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((r, e) -> metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect())));
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    @Override
    public CompletableFuture<CreateLakeFormationOptInResponse> createLakeFormationOptIn(CreateLakeFormationOptInRequest createLakeFormationOptInRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration(createLakeFormationOptInRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultLakeFormationAsyncClient.resolveMetricPublishers(clientConfiguration, createLakeFormationOptInRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "LakeFormation");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateLakeFormationOptIn");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateLakeFormationOptInResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "TransactionCommitInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCommitInProgressException").httpStatusCode(400).exceptionBuilderSupplier(TransactionCommitInProgressException::builder).build());
                    }
                    case "ConcurrentModificationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                    }
                    case "ResourceNotReadyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotReadyException").httpStatusCode(400).exceptionBuilderSupplier(ResourceNotReadyException::builder).build());
                    }
                    case "ThrottledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ThrottledException").httpStatusCode(429).exceptionBuilderSupplier(ThrottledException::builder).build());
                    }
                    case "AlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AlreadyExistsException").exceptionBuilderSupplier(AlreadyExistsException::builder).build());
                    }
                    case "TransactionCommittedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCommittedException").httpStatusCode(400).exceptionBuilderSupplier(TransactionCommittedException::builder).build());
                    }
                    case "InternalServiceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceException").httpStatusCode(500).exceptionBuilderSupplier(InternalServiceException::builder).build());
                    }
                    case "ResourceNumberLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNumberLimitExceededException").exceptionBuilderSupplier(ResourceNumberLimitExceededException::builder).build());
                    }
                    case "ExpiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ExpiredException").httpStatusCode(410).exceptionBuilderSupplier(ExpiredException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "InvalidInputException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(400).exceptionBuilderSupplier(InvalidInputException::builder).build());
                    }
                    case "EntityNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EntityNotFoundException").exceptionBuilderSupplier(EntityNotFoundException::builder).build());
                    }
                    case "StatisticsNotReadyYetException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("StatisticsNotReadyYetException").httpStatusCode(420).exceptionBuilderSupplier(StatisticsNotReadyYetException::builder).build());
                    }
                    case "TransactionCanceledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCanceledException").httpStatusCode(400).exceptionBuilderSupplier(TransactionCanceledException::builder).build());
                    }
                    case "GlueEncryptionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("GlueEncryptionException").exceptionBuilderSupplier(GlueEncryptionException::builder).build());
                    }
                    case "PermissionTypeMismatchException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PermissionTypeMismatchException").exceptionBuilderSupplier(PermissionTypeMismatchException::builder).build());
                    }
                    case "WorkUnitsNotReadyYetException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WorkUnitsNotReadyYetException").httpStatusCode(420).exceptionBuilderSupplier(WorkUnitsNotReadyYetException::builder).build());
                    }
                    case "OperationTimeoutException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OperationTimeoutException").exceptionBuilderSupplier(OperationTimeoutException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture<CreateLakeFormationOptInResponse> executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateLakeFormationOptIn").withProtocolMetadata(protocolMetadata).withMarshaller(new CreateLakeFormationOptInRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector).withInput(createLakeFormationOptInRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((r, e) -> metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect())));
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    @Override
    public CompletableFuture<DeleteDataCellsFilterResponse> deleteDataCellsFilter(DeleteDataCellsFilterRequest deleteDataCellsFilterRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration(deleteDataCellsFilterRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultLakeFormationAsyncClient.resolveMetricPublishers(clientConfiguration, deleteDataCellsFilterRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "LakeFormation");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteDataCellsFilter");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteDataCellsFilterResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "TransactionCommitInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCommitInProgressException").httpStatusCode(400).exceptionBuilderSupplier(TransactionCommitInProgressException::builder).build());
                    }
                    case "ConcurrentModificationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                    }
                    case "ResourceNotReadyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotReadyException").httpStatusCode(400).exceptionBuilderSupplier(ResourceNotReadyException::builder).build());
                    }
                    case "ThrottledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ThrottledException").httpStatusCode(429).exceptionBuilderSupplier(ThrottledException::builder).build());
                    }
                    case "AlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AlreadyExistsException").exceptionBuilderSupplier(AlreadyExistsException::builder).build());
                    }
                    case "TransactionCommittedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCommittedException").httpStatusCode(400).exceptionBuilderSupplier(TransactionCommittedException::builder).build());
                    }
                    case "InternalServiceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceException").httpStatusCode(500).exceptionBuilderSupplier(InternalServiceException::builder).build());
                    }
                    case "ResourceNumberLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNumberLimitExceededException").exceptionBuilderSupplier(ResourceNumberLimitExceededException::builder).build());
                    }
                    case "ExpiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ExpiredException").httpStatusCode(410).exceptionBuilderSupplier(ExpiredException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "InvalidInputException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(400).exceptionBuilderSupplier(InvalidInputException::builder).build());
                    }
                    case "EntityNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EntityNotFoundException").exceptionBuilderSupplier(EntityNotFoundException::builder).build());
                    }
                    case "StatisticsNotReadyYetException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("StatisticsNotReadyYetException").httpStatusCode(420).exceptionBuilderSupplier(StatisticsNotReadyYetException::builder).build());
                    }
                    case "TransactionCanceledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCanceledException").httpStatusCode(400).exceptionBuilderSupplier(TransactionCanceledException::builder).build());
                    }
                    case "GlueEncryptionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("GlueEncryptionException").exceptionBuilderSupplier(GlueEncryptionException::builder).build());
                    }
                    case "PermissionTypeMismatchException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PermissionTypeMismatchException").exceptionBuilderSupplier(PermissionTypeMismatchException::builder).build());
                    }
                    case "WorkUnitsNotReadyYetException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WorkUnitsNotReadyYetException").httpStatusCode(420).exceptionBuilderSupplier(WorkUnitsNotReadyYetException::builder).build());
                    }
                    case "OperationTimeoutException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OperationTimeoutException").exceptionBuilderSupplier(OperationTimeoutException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture<DeleteDataCellsFilterResponse> executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteDataCellsFilter").withProtocolMetadata(protocolMetadata).withMarshaller(new DeleteDataCellsFilterRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector).withInput(deleteDataCellsFilterRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((r, e) -> metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect())));
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    @Override
    public CompletableFuture<DeleteLfTagResponse> deleteLFTag(DeleteLfTagRequest deleteLfTagRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration(deleteLfTagRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultLakeFormationAsyncClient.resolveMetricPublishers(clientConfiguration, deleteLfTagRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "LakeFormation");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteLFTag");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteLfTagResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "TransactionCommitInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCommitInProgressException").httpStatusCode(400).exceptionBuilderSupplier(TransactionCommitInProgressException::builder).build());
                    }
                    case "ConcurrentModificationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                    }
                    case "ResourceNotReadyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotReadyException").httpStatusCode(400).exceptionBuilderSupplier(ResourceNotReadyException::builder).build());
                    }
                    case "ThrottledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ThrottledException").httpStatusCode(429).exceptionBuilderSupplier(ThrottledException::builder).build());
                    }
                    case "AlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AlreadyExistsException").exceptionBuilderSupplier(AlreadyExistsException::builder).build());
                    }
                    case "TransactionCommittedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCommittedException").httpStatusCode(400).exceptionBuilderSupplier(TransactionCommittedException::builder).build());
                    }
                    case "InternalServiceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceException").httpStatusCode(500).exceptionBuilderSupplier(InternalServiceException::builder).build());
                    }
                    case "ResourceNumberLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNumberLimitExceededException").exceptionBuilderSupplier(ResourceNumberLimitExceededException::builder).build());
                    }
                    case "ExpiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ExpiredException").httpStatusCode(410).exceptionBuilderSupplier(ExpiredException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "InvalidInputException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(400).exceptionBuilderSupplier(InvalidInputException::builder).build());
                    }
                    case "EntityNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EntityNotFoundException").exceptionBuilderSupplier(EntityNotFoundException::builder).build());
                    }
                    case "StatisticsNotReadyYetException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("StatisticsNotReadyYetException").httpStatusCode(420).exceptionBuilderSupplier(StatisticsNotReadyYetException::builder).build());
                    }
                    case "TransactionCanceledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCanceledException").httpStatusCode(400).exceptionBuilderSupplier(TransactionCanceledException::builder).build());
                    }
                    case "GlueEncryptionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("GlueEncryptionException").exceptionBuilderSupplier(GlueEncryptionException::builder).build());
                    }
                    case "PermissionTypeMismatchException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PermissionTypeMismatchException").exceptionBuilderSupplier(PermissionTypeMismatchException::builder).build());
                    }
                    case "WorkUnitsNotReadyYetException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WorkUnitsNotReadyYetException").httpStatusCode(420).exceptionBuilderSupplier(WorkUnitsNotReadyYetException::builder).build());
                    }
                    case "OperationTimeoutException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OperationTimeoutException").exceptionBuilderSupplier(OperationTimeoutException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture<DeleteLfTagResponse> executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteLFTag").withProtocolMetadata(protocolMetadata).withMarshaller(new DeleteLfTagRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector).withInput(deleteLfTagRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((r, e) -> metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect())));
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    @Override
    public CompletableFuture<DeleteLfTagExpressionResponse> deleteLFTagExpression(DeleteLfTagExpressionRequest deleteLfTagExpressionRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration(deleteLfTagExpressionRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultLakeFormationAsyncClient.resolveMetricPublishers(clientConfiguration, deleteLfTagExpressionRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "LakeFormation");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteLFTagExpression");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteLfTagExpressionResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "TransactionCommitInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCommitInProgressException").httpStatusCode(400).exceptionBuilderSupplier(TransactionCommitInProgressException::builder).build());
                    }
                    case "ConcurrentModificationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                    }
                    case "ResourceNotReadyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotReadyException").httpStatusCode(400).exceptionBuilderSupplier(ResourceNotReadyException::builder).build());
                    }
                    case "ThrottledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ThrottledException").httpStatusCode(429).exceptionBuilderSupplier(ThrottledException::builder).build());
                    }
                    case "AlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AlreadyExistsException").exceptionBuilderSupplier(AlreadyExistsException::builder).build());
                    }
                    case "TransactionCommittedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCommittedException").httpStatusCode(400).exceptionBuilderSupplier(TransactionCommittedException::builder).build());
                    }
                    case "InternalServiceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceException").httpStatusCode(500).exceptionBuilderSupplier(InternalServiceException::builder).build());
                    }
                    case "ResourceNumberLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNumberLimitExceededException").exceptionBuilderSupplier(ResourceNumberLimitExceededException::builder).build());
                    }
                    case "ExpiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ExpiredException").httpStatusCode(410).exceptionBuilderSupplier(ExpiredException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "InvalidInputException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(400).exceptionBuilderSupplier(InvalidInputException::builder).build());
                    }
                    case "EntityNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EntityNotFoundException").exceptionBuilderSupplier(EntityNotFoundException::builder).build());
                    }
                    case "StatisticsNotReadyYetException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("StatisticsNotReadyYetException").httpStatusCode(420).exceptionBuilderSupplier(StatisticsNotReadyYetException::builder).build());
                    }
                    case "TransactionCanceledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCanceledException").httpStatusCode(400).exceptionBuilderSupplier(TransactionCanceledException::builder).build());
                    }
                    case "GlueEncryptionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("GlueEncryptionException").exceptionBuilderSupplier(GlueEncryptionException::builder).build());
                    }
                    case "PermissionTypeMismatchException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PermissionTypeMismatchException").exceptionBuilderSupplier(PermissionTypeMismatchException::builder).build());
                    }
                    case "WorkUnitsNotReadyYetException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WorkUnitsNotReadyYetException").httpStatusCode(420).exceptionBuilderSupplier(WorkUnitsNotReadyYetException::builder).build());
                    }
                    case "OperationTimeoutException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OperationTimeoutException").exceptionBuilderSupplier(OperationTimeoutException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture<DeleteLfTagExpressionResponse> executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteLFTagExpression").withProtocolMetadata(protocolMetadata).withMarshaller(new DeleteLfTagExpressionRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector).withInput(deleteLfTagExpressionRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((r, e) -> metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect())));
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    @Override
    public CompletableFuture<DeleteLakeFormationIdentityCenterConfigurationResponse> deleteLakeFormationIdentityCenterConfiguration(DeleteLakeFormationIdentityCenterConfigurationRequest deleteLakeFormationIdentityCenterConfigurationRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration(deleteLakeFormationIdentityCenterConfigurationRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultLakeFormationAsyncClient.resolveMetricPublishers(clientConfiguration, deleteLakeFormationIdentityCenterConfigurationRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "LakeFormation");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteLakeFormationIdentityCenterConfiguration");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteLakeFormationIdentityCenterConfigurationResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "TransactionCommitInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCommitInProgressException").httpStatusCode(400).exceptionBuilderSupplier(TransactionCommitInProgressException::builder).build());
                    }
                    case "ConcurrentModificationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                    }
                    case "ResourceNotReadyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotReadyException").httpStatusCode(400).exceptionBuilderSupplier(ResourceNotReadyException::builder).build());
                    }
                    case "ThrottledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ThrottledException").httpStatusCode(429).exceptionBuilderSupplier(ThrottledException::builder).build());
                    }
                    case "AlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AlreadyExistsException").exceptionBuilderSupplier(AlreadyExistsException::builder).build());
                    }
                    case "TransactionCommittedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCommittedException").httpStatusCode(400).exceptionBuilderSupplier(TransactionCommittedException::builder).build());
                    }
                    case "InternalServiceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceException").httpStatusCode(500).exceptionBuilderSupplier(InternalServiceException::builder).build());
                    }
                    case "ResourceNumberLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNumberLimitExceededException").exceptionBuilderSupplier(ResourceNumberLimitExceededException::builder).build());
                    }
                    case "ExpiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ExpiredException").httpStatusCode(410).exceptionBuilderSupplier(ExpiredException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "InvalidInputException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(400).exceptionBuilderSupplier(InvalidInputException::builder).build());
                    }
                    case "EntityNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EntityNotFoundException").exceptionBuilderSupplier(EntityNotFoundException::builder).build());
                    }
                    case "StatisticsNotReadyYetException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("StatisticsNotReadyYetException").httpStatusCode(420).exceptionBuilderSupplier(StatisticsNotReadyYetException::builder).build());
                    }
                    case "TransactionCanceledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCanceledException").httpStatusCode(400).exceptionBuilderSupplier(TransactionCanceledException::builder).build());
                    }
                    case "GlueEncryptionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("GlueEncryptionException").exceptionBuilderSupplier(GlueEncryptionException::builder).build());
                    }
                    case "PermissionTypeMismatchException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PermissionTypeMismatchException").exceptionBuilderSupplier(PermissionTypeMismatchException::builder).build());
                    }
                    case "WorkUnitsNotReadyYetException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WorkUnitsNotReadyYetException").httpStatusCode(420).exceptionBuilderSupplier(WorkUnitsNotReadyYetException::builder).build());
                    }
                    case "OperationTimeoutException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OperationTimeoutException").exceptionBuilderSupplier(OperationTimeoutException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture<DeleteLakeFormationIdentityCenterConfigurationResponse> executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteLakeFormationIdentityCenterConfiguration").withProtocolMetadata(protocolMetadata).withMarshaller(new DeleteLakeFormationIdentityCenterConfigurationRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector).withInput(deleteLakeFormationIdentityCenterConfigurationRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((r, e) -> metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect())));
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    @Override
    public CompletableFuture<DeleteLakeFormationOptInResponse> deleteLakeFormationOptIn(DeleteLakeFormationOptInRequest deleteLakeFormationOptInRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration(deleteLakeFormationOptInRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultLakeFormationAsyncClient.resolveMetricPublishers(clientConfiguration, deleteLakeFormationOptInRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "LakeFormation");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteLakeFormationOptIn");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteLakeFormationOptInResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "TransactionCommitInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCommitInProgressException").httpStatusCode(400).exceptionBuilderSupplier(TransactionCommitInProgressException::builder).build());
                    }
                    case "ConcurrentModificationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                    }
                    case "ResourceNotReadyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotReadyException").httpStatusCode(400).exceptionBuilderSupplier(ResourceNotReadyException::builder).build());
                    }
                    case "ThrottledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ThrottledException").httpStatusCode(429).exceptionBuilderSupplier(ThrottledException::builder).build());
                    }
                    case "AlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AlreadyExistsException").exceptionBuilderSupplier(AlreadyExistsException::builder).build());
                    }
                    case "TransactionCommittedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCommittedException").httpStatusCode(400).exceptionBuilderSupplier(TransactionCommittedException::builder).build());
                    }
                    case "InternalServiceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceException").httpStatusCode(500).exceptionBuilderSupplier(InternalServiceException::builder).build());
                    }
                    case "ResourceNumberLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNumberLimitExceededException").exceptionBuilderSupplier(ResourceNumberLimitExceededException::builder).build());
                    }
                    case "ExpiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ExpiredException").httpStatusCode(410).exceptionBuilderSupplier(ExpiredException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "InvalidInputException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(400).exceptionBuilderSupplier(InvalidInputException::builder).build());
                    }
                    case "EntityNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EntityNotFoundException").exceptionBuilderSupplier(EntityNotFoundException::builder).build());
                    }
                    case "StatisticsNotReadyYetException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("StatisticsNotReadyYetException").httpStatusCode(420).exceptionBuilderSupplier(StatisticsNotReadyYetException::builder).build());
                    }
                    case "TransactionCanceledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCanceledException").httpStatusCode(400).exceptionBuilderSupplier(TransactionCanceledException::builder).build());
                    }
                    case "GlueEncryptionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("GlueEncryptionException").exceptionBuilderSupplier(GlueEncryptionException::builder).build());
                    }
                    case "PermissionTypeMismatchException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PermissionTypeMismatchException").exceptionBuilderSupplier(PermissionTypeMismatchException::builder).build());
                    }
                    case "WorkUnitsNotReadyYetException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WorkUnitsNotReadyYetException").httpStatusCode(420).exceptionBuilderSupplier(WorkUnitsNotReadyYetException::builder).build());
                    }
                    case "OperationTimeoutException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OperationTimeoutException").exceptionBuilderSupplier(OperationTimeoutException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture<DeleteLakeFormationOptInResponse> executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteLakeFormationOptIn").withProtocolMetadata(protocolMetadata).withMarshaller(new DeleteLakeFormationOptInRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector).withInput(deleteLakeFormationOptInRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((r, e) -> metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect())));
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    @Override
    public CompletableFuture<DeleteObjectsOnCancelResponse> deleteObjectsOnCancel(DeleteObjectsOnCancelRequest deleteObjectsOnCancelRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration(deleteObjectsOnCancelRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultLakeFormationAsyncClient.resolveMetricPublishers(clientConfiguration, deleteObjectsOnCancelRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "LakeFormation");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteObjectsOnCancel");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteObjectsOnCancelResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "TransactionCommitInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCommitInProgressException").httpStatusCode(400).exceptionBuilderSupplier(TransactionCommitInProgressException::builder).build());
                    }
                    case "ConcurrentModificationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                    }
                    case "ResourceNotReadyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotReadyException").httpStatusCode(400).exceptionBuilderSupplier(ResourceNotReadyException::builder).build());
                    }
                    case "ThrottledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ThrottledException").httpStatusCode(429).exceptionBuilderSupplier(ThrottledException::builder).build());
                    }
                    case "AlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AlreadyExistsException").exceptionBuilderSupplier(AlreadyExistsException::builder).build());
                    }
                    case "TransactionCommittedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCommittedException").httpStatusCode(400).exceptionBuilderSupplier(TransactionCommittedException::builder).build());
                    }
                    case "InternalServiceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceException").httpStatusCode(500).exceptionBuilderSupplier(InternalServiceException::builder).build());
                    }
                    case "ResourceNumberLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNumberLimitExceededException").exceptionBuilderSupplier(ResourceNumberLimitExceededException::builder).build());
                    }
                    case "ExpiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ExpiredException").httpStatusCode(410).exceptionBuilderSupplier(ExpiredException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "InvalidInputException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(400).exceptionBuilderSupplier(InvalidInputException::builder).build());
                    }
                    case "EntityNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EntityNotFoundException").exceptionBuilderSupplier(EntityNotFoundException::builder).build());
                    }
                    case "StatisticsNotReadyYetException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("StatisticsNotReadyYetException").httpStatusCode(420).exceptionBuilderSupplier(StatisticsNotReadyYetException::builder).build());
                    }
                    case "TransactionCanceledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCanceledException").httpStatusCode(400).exceptionBuilderSupplier(TransactionCanceledException::builder).build());
                    }
                    case "GlueEncryptionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("GlueEncryptionException").exceptionBuilderSupplier(GlueEncryptionException::builder).build());
                    }
                    case "PermissionTypeMismatchException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PermissionTypeMismatchException").exceptionBuilderSupplier(PermissionTypeMismatchException::builder).build());
                    }
                    case "WorkUnitsNotReadyYetException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WorkUnitsNotReadyYetException").httpStatusCode(420).exceptionBuilderSupplier(WorkUnitsNotReadyYetException::builder).build());
                    }
                    case "OperationTimeoutException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OperationTimeoutException").exceptionBuilderSupplier(OperationTimeoutException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture<DeleteObjectsOnCancelResponse> executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteObjectsOnCancel").withProtocolMetadata(protocolMetadata).withMarshaller(new DeleteObjectsOnCancelRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector).withInput(deleteObjectsOnCancelRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((r, e) -> metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect())));
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    @Override
    public CompletableFuture<DeregisterResourceResponse> deregisterResource(DeregisterResourceRequest deregisterResourceRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration(deregisterResourceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultLakeFormationAsyncClient.resolveMetricPublishers(clientConfiguration, deregisterResourceRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "LakeFormation");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeregisterResource");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeregisterResourceResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "TransactionCommitInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCommitInProgressException").httpStatusCode(400).exceptionBuilderSupplier(TransactionCommitInProgressException::builder).build());
                    }
                    case "ConcurrentModificationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                    }
                    case "ResourceNotReadyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotReadyException").httpStatusCode(400).exceptionBuilderSupplier(ResourceNotReadyException::builder).build());
                    }
                    case "ThrottledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ThrottledException").httpStatusCode(429).exceptionBuilderSupplier(ThrottledException::builder).build());
                    }
                    case "AlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AlreadyExistsException").exceptionBuilderSupplier(AlreadyExistsException::builder).build());
                    }
                    case "TransactionCommittedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCommittedException").httpStatusCode(400).exceptionBuilderSupplier(TransactionCommittedException::builder).build());
                    }
                    case "InternalServiceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceException").httpStatusCode(500).exceptionBuilderSupplier(InternalServiceException::builder).build());
                    }
                    case "ResourceNumberLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNumberLimitExceededException").exceptionBuilderSupplier(ResourceNumberLimitExceededException::builder).build());
                    }
                    case "ExpiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ExpiredException").httpStatusCode(410).exceptionBuilderSupplier(ExpiredException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "InvalidInputException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(400).exceptionBuilderSupplier(InvalidInputException::builder).build());
                    }
                    case "EntityNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EntityNotFoundException").exceptionBuilderSupplier(EntityNotFoundException::builder).build());
                    }
                    case "StatisticsNotReadyYetException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("StatisticsNotReadyYetException").httpStatusCode(420).exceptionBuilderSupplier(StatisticsNotReadyYetException::builder).build());
                    }
                    case "TransactionCanceledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCanceledException").httpStatusCode(400).exceptionBuilderSupplier(TransactionCanceledException::builder).build());
                    }
                    case "GlueEncryptionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("GlueEncryptionException").exceptionBuilderSupplier(GlueEncryptionException::builder).build());
                    }
                    case "PermissionTypeMismatchException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PermissionTypeMismatchException").exceptionBuilderSupplier(PermissionTypeMismatchException::builder).build());
                    }
                    case "WorkUnitsNotReadyYetException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WorkUnitsNotReadyYetException").httpStatusCode(420).exceptionBuilderSupplier(WorkUnitsNotReadyYetException::builder).build());
                    }
                    case "OperationTimeoutException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OperationTimeoutException").exceptionBuilderSupplier(OperationTimeoutException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture<DeregisterResourceResponse> executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeregisterResource").withProtocolMetadata(protocolMetadata).withMarshaller(new DeregisterResourceRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector).withInput(deregisterResourceRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((r, e) -> metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect())));
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    @Override
    public CompletableFuture<DescribeLakeFormationIdentityCenterConfigurationResponse> describeLakeFormationIdentityCenterConfiguration(DescribeLakeFormationIdentityCenterConfigurationRequest describeLakeFormationIdentityCenterConfigurationRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration(describeLakeFormationIdentityCenterConfigurationRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultLakeFormationAsyncClient.resolveMetricPublishers(clientConfiguration, describeLakeFormationIdentityCenterConfigurationRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "LakeFormation");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeLakeFormationIdentityCenterConfiguration");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeLakeFormationIdentityCenterConfigurationResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "TransactionCommitInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCommitInProgressException").httpStatusCode(400).exceptionBuilderSupplier(TransactionCommitInProgressException::builder).build());
                    }
                    case "ConcurrentModificationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                    }
                    case "ResourceNotReadyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotReadyException").httpStatusCode(400).exceptionBuilderSupplier(ResourceNotReadyException::builder).build());
                    }
                    case "ThrottledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ThrottledException").httpStatusCode(429).exceptionBuilderSupplier(ThrottledException::builder).build());
                    }
                    case "AlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AlreadyExistsException").exceptionBuilderSupplier(AlreadyExistsException::builder).build());
                    }
                    case "TransactionCommittedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCommittedException").httpStatusCode(400).exceptionBuilderSupplier(TransactionCommittedException::builder).build());
                    }
                    case "InternalServiceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceException").httpStatusCode(500).exceptionBuilderSupplier(InternalServiceException::builder).build());
                    }
                    case "ResourceNumberLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNumberLimitExceededException").exceptionBuilderSupplier(ResourceNumberLimitExceededException::builder).build());
                    }
                    case "ExpiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ExpiredException").httpStatusCode(410).exceptionBuilderSupplier(ExpiredException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "InvalidInputException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(400).exceptionBuilderSupplier(InvalidInputException::builder).build());
                    }
                    case "EntityNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EntityNotFoundException").exceptionBuilderSupplier(EntityNotFoundException::builder).build());
                    }
                    case "StatisticsNotReadyYetException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("StatisticsNotReadyYetException").httpStatusCode(420).exceptionBuilderSupplier(StatisticsNotReadyYetException::builder).build());
                    }
                    case "TransactionCanceledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCanceledException").httpStatusCode(400).exceptionBuilderSupplier(TransactionCanceledException::builder).build());
                    }
                    case "GlueEncryptionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("GlueEncryptionException").exceptionBuilderSupplier(GlueEncryptionException::builder).build());
                    }
                    case "PermissionTypeMismatchException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PermissionTypeMismatchException").exceptionBuilderSupplier(PermissionTypeMismatchException::builder).build());
                    }
                    case "WorkUnitsNotReadyYetException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WorkUnitsNotReadyYetException").httpStatusCode(420).exceptionBuilderSupplier(WorkUnitsNotReadyYetException::builder).build());
                    }
                    case "OperationTimeoutException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OperationTimeoutException").exceptionBuilderSupplier(OperationTimeoutException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture<DescribeLakeFormationIdentityCenterConfigurationResponse> executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeLakeFormationIdentityCenterConfiguration").withProtocolMetadata(protocolMetadata).withMarshaller(new DescribeLakeFormationIdentityCenterConfigurationRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector).withInput(describeLakeFormationIdentityCenterConfigurationRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((r, e) -> metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect())));
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    @Override
    public CompletableFuture<DescribeResourceResponse> describeResource(DescribeResourceRequest describeResourceRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration(describeResourceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultLakeFormationAsyncClient.resolveMetricPublishers(clientConfiguration, describeResourceRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "LakeFormation");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeResource");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeResourceResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "TransactionCommitInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCommitInProgressException").httpStatusCode(400).exceptionBuilderSupplier(TransactionCommitInProgressException::builder).build());
                    }
                    case "ConcurrentModificationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                    }
                    case "ResourceNotReadyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotReadyException").httpStatusCode(400).exceptionBuilderSupplier(ResourceNotReadyException::builder).build());
                    }
                    case "ThrottledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ThrottledException").httpStatusCode(429).exceptionBuilderSupplier(ThrottledException::builder).build());
                    }
                    case "AlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AlreadyExistsException").exceptionBuilderSupplier(AlreadyExistsException::builder).build());
                    }
                    case "TransactionCommittedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCommittedException").httpStatusCode(400).exceptionBuilderSupplier(TransactionCommittedException::builder).build());
                    }
                    case "InternalServiceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceException").httpStatusCode(500).exceptionBuilderSupplier(InternalServiceException::builder).build());
                    }
                    case "ResourceNumberLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNumberLimitExceededException").exceptionBuilderSupplier(ResourceNumberLimitExceededException::builder).build());
                    }
                    case "ExpiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ExpiredException").httpStatusCode(410).exceptionBuilderSupplier(ExpiredException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "InvalidInputException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(400).exceptionBuilderSupplier(InvalidInputException::builder).build());
                    }
                    case "EntityNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EntityNotFoundException").exceptionBuilderSupplier(EntityNotFoundException::builder).build());
                    }
                    case "StatisticsNotReadyYetException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("StatisticsNotReadyYetException").httpStatusCode(420).exceptionBuilderSupplier(StatisticsNotReadyYetException::builder).build());
                    }
                    case "TransactionCanceledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCanceledException").httpStatusCode(400).exceptionBuilderSupplier(TransactionCanceledException::builder).build());
                    }
                    case "GlueEncryptionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("GlueEncryptionException").exceptionBuilderSupplier(GlueEncryptionException::builder).build());
                    }
                    case "PermissionTypeMismatchException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PermissionTypeMismatchException").exceptionBuilderSupplier(PermissionTypeMismatchException::builder).build());
                    }
                    case "WorkUnitsNotReadyYetException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WorkUnitsNotReadyYetException").httpStatusCode(420).exceptionBuilderSupplier(WorkUnitsNotReadyYetException::builder).build());
                    }
                    case "OperationTimeoutException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OperationTimeoutException").exceptionBuilderSupplier(OperationTimeoutException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture<DescribeResourceResponse> executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeResource").withProtocolMetadata(protocolMetadata).withMarshaller(new DescribeResourceRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector).withInput(describeResourceRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((r, e) -> metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect())));
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    @Override
    public CompletableFuture<DescribeTransactionResponse> describeTransaction(DescribeTransactionRequest describeTransactionRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration(describeTransactionRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultLakeFormationAsyncClient.resolveMetricPublishers(clientConfiguration, describeTransactionRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "LakeFormation");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeTransaction");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeTransactionResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "TransactionCommitInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCommitInProgressException").httpStatusCode(400).exceptionBuilderSupplier(TransactionCommitInProgressException::builder).build());
                    }
                    case "ConcurrentModificationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                    }
                    case "ResourceNotReadyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotReadyException").httpStatusCode(400).exceptionBuilderSupplier(ResourceNotReadyException::builder).build());
                    }
                    case "ThrottledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ThrottledException").httpStatusCode(429).exceptionBuilderSupplier(ThrottledException::builder).build());
                    }
                    case "AlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AlreadyExistsException").exceptionBuilderSupplier(AlreadyExistsException::builder).build());
                    }
                    case "TransactionCommittedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCommittedException").httpStatusCode(400).exceptionBuilderSupplier(TransactionCommittedException::builder).build());
                    }
                    case "InternalServiceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceException").httpStatusCode(500).exceptionBuilderSupplier(InternalServiceException::builder).build());
                    }
                    case "ResourceNumberLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNumberLimitExceededException").exceptionBuilderSupplier(ResourceNumberLimitExceededException::builder).build());
                    }
                    case "ExpiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ExpiredException").httpStatusCode(410).exceptionBuilderSupplier(ExpiredException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "InvalidInputException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(400).exceptionBuilderSupplier(InvalidInputException::builder).build());
                    }
                    case "EntityNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EntityNotFoundException").exceptionBuilderSupplier(EntityNotFoundException::builder).build());
                    }
                    case "StatisticsNotReadyYetException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("StatisticsNotReadyYetException").httpStatusCode(420).exceptionBuilderSupplier(StatisticsNotReadyYetException::builder).build());
                    }
                    case "TransactionCanceledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCanceledException").httpStatusCode(400).exceptionBuilderSupplier(TransactionCanceledException::builder).build());
                    }
                    case "GlueEncryptionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("GlueEncryptionException").exceptionBuilderSupplier(GlueEncryptionException::builder).build());
                    }
                    case "PermissionTypeMismatchException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PermissionTypeMismatchException").exceptionBuilderSupplier(PermissionTypeMismatchException::builder).build());
                    }
                    case "WorkUnitsNotReadyYetException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WorkUnitsNotReadyYetException").httpStatusCode(420).exceptionBuilderSupplier(WorkUnitsNotReadyYetException::builder).build());
                    }
                    case "OperationTimeoutException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OperationTimeoutException").exceptionBuilderSupplier(OperationTimeoutException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture<DescribeTransactionResponse> executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeTransaction").withProtocolMetadata(protocolMetadata).withMarshaller(new DescribeTransactionRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector).withInput(describeTransactionRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((r, e) -> metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect())));
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    @Override
    public CompletableFuture<ExtendTransactionResponse> extendTransaction(ExtendTransactionRequest extendTransactionRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration(extendTransactionRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultLakeFormationAsyncClient.resolveMetricPublishers(clientConfiguration, extendTransactionRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "LakeFormation");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ExtendTransaction");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ExtendTransactionResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "TransactionCommitInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCommitInProgressException").httpStatusCode(400).exceptionBuilderSupplier(TransactionCommitInProgressException::builder).build());
                    }
                    case "ConcurrentModificationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                    }
                    case "ResourceNotReadyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotReadyException").httpStatusCode(400).exceptionBuilderSupplier(ResourceNotReadyException::builder).build());
                    }
                    case "ThrottledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ThrottledException").httpStatusCode(429).exceptionBuilderSupplier(ThrottledException::builder).build());
                    }
                    case "AlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AlreadyExistsException").exceptionBuilderSupplier(AlreadyExistsException::builder).build());
                    }
                    case "TransactionCommittedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCommittedException").httpStatusCode(400).exceptionBuilderSupplier(TransactionCommittedException::builder).build());
                    }
                    case "InternalServiceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceException").httpStatusCode(500).exceptionBuilderSupplier(InternalServiceException::builder).build());
                    }
                    case "ResourceNumberLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNumberLimitExceededException").exceptionBuilderSupplier(ResourceNumberLimitExceededException::builder).build());
                    }
                    case "ExpiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ExpiredException").httpStatusCode(410).exceptionBuilderSupplier(ExpiredException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "InvalidInputException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(400).exceptionBuilderSupplier(InvalidInputException::builder).build());
                    }
                    case "EntityNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EntityNotFoundException").exceptionBuilderSupplier(EntityNotFoundException::builder).build());
                    }
                    case "StatisticsNotReadyYetException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("StatisticsNotReadyYetException").httpStatusCode(420).exceptionBuilderSupplier(StatisticsNotReadyYetException::builder).build());
                    }
                    case "TransactionCanceledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCanceledException").httpStatusCode(400).exceptionBuilderSupplier(TransactionCanceledException::builder).build());
                    }
                    case "GlueEncryptionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("GlueEncryptionException").exceptionBuilderSupplier(GlueEncryptionException::builder).build());
                    }
                    case "PermissionTypeMismatchException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PermissionTypeMismatchException").exceptionBuilderSupplier(PermissionTypeMismatchException::builder).build());
                    }
                    case "WorkUnitsNotReadyYetException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WorkUnitsNotReadyYetException").httpStatusCode(420).exceptionBuilderSupplier(WorkUnitsNotReadyYetException::builder).build());
                    }
                    case "OperationTimeoutException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OperationTimeoutException").exceptionBuilderSupplier(OperationTimeoutException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture<ExtendTransactionResponse> executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ExtendTransaction").withProtocolMetadata(protocolMetadata).withMarshaller(new ExtendTransactionRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector).withInput(extendTransactionRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((r, e) -> metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect())));
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    @Override
    public CompletableFuture<GetDataCellsFilterResponse> getDataCellsFilter(GetDataCellsFilterRequest getDataCellsFilterRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration(getDataCellsFilterRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultLakeFormationAsyncClient.resolveMetricPublishers(clientConfiguration, getDataCellsFilterRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "LakeFormation");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetDataCellsFilter");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetDataCellsFilterResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "TransactionCommitInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCommitInProgressException").httpStatusCode(400).exceptionBuilderSupplier(TransactionCommitInProgressException::builder).build());
                    }
                    case "ConcurrentModificationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                    }
                    case "ResourceNotReadyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotReadyException").httpStatusCode(400).exceptionBuilderSupplier(ResourceNotReadyException::builder).build());
                    }
                    case "ThrottledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ThrottledException").httpStatusCode(429).exceptionBuilderSupplier(ThrottledException::builder).build());
                    }
                    case "AlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AlreadyExistsException").exceptionBuilderSupplier(AlreadyExistsException::builder).build());
                    }
                    case "TransactionCommittedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCommittedException").httpStatusCode(400).exceptionBuilderSupplier(TransactionCommittedException::builder).build());
                    }
                    case "InternalServiceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceException").httpStatusCode(500).exceptionBuilderSupplier(InternalServiceException::builder).build());
                    }
                    case "ResourceNumberLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNumberLimitExceededException").exceptionBuilderSupplier(ResourceNumberLimitExceededException::builder).build());
                    }
                    case "ExpiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ExpiredException").httpStatusCode(410).exceptionBuilderSupplier(ExpiredException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "InvalidInputException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(400).exceptionBuilderSupplier(InvalidInputException::builder).build());
                    }
                    case "EntityNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EntityNotFoundException").exceptionBuilderSupplier(EntityNotFoundException::builder).build());
                    }
                    case "StatisticsNotReadyYetException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("StatisticsNotReadyYetException").httpStatusCode(420).exceptionBuilderSupplier(StatisticsNotReadyYetException::builder).build());
                    }
                    case "TransactionCanceledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCanceledException").httpStatusCode(400).exceptionBuilderSupplier(TransactionCanceledException::builder).build());
                    }
                    case "GlueEncryptionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("GlueEncryptionException").exceptionBuilderSupplier(GlueEncryptionException::builder).build());
                    }
                    case "PermissionTypeMismatchException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PermissionTypeMismatchException").exceptionBuilderSupplier(PermissionTypeMismatchException::builder).build());
                    }
                    case "WorkUnitsNotReadyYetException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WorkUnitsNotReadyYetException").httpStatusCode(420).exceptionBuilderSupplier(WorkUnitsNotReadyYetException::builder).build());
                    }
                    case "OperationTimeoutException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OperationTimeoutException").exceptionBuilderSupplier(OperationTimeoutException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture<GetDataCellsFilterResponse> executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetDataCellsFilter").withProtocolMetadata(protocolMetadata).withMarshaller(new GetDataCellsFilterRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector).withInput(getDataCellsFilterRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((r, e) -> metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect())));
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    @Override
    public CompletableFuture<GetDataLakePrincipalResponse> getDataLakePrincipal(GetDataLakePrincipalRequest getDataLakePrincipalRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration(getDataLakePrincipalRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultLakeFormationAsyncClient.resolveMetricPublishers(clientConfiguration, getDataLakePrincipalRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "LakeFormation");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetDataLakePrincipal");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetDataLakePrincipalResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "TransactionCommitInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCommitInProgressException").httpStatusCode(400).exceptionBuilderSupplier(TransactionCommitInProgressException::builder).build());
                    }
                    case "ConcurrentModificationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                    }
                    case "ResourceNotReadyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotReadyException").httpStatusCode(400).exceptionBuilderSupplier(ResourceNotReadyException::builder).build());
                    }
                    case "ThrottledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ThrottledException").httpStatusCode(429).exceptionBuilderSupplier(ThrottledException::builder).build());
                    }
                    case "AlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AlreadyExistsException").exceptionBuilderSupplier(AlreadyExistsException::builder).build());
                    }
                    case "TransactionCommittedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCommittedException").httpStatusCode(400).exceptionBuilderSupplier(TransactionCommittedException::builder).build());
                    }
                    case "InternalServiceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceException").httpStatusCode(500).exceptionBuilderSupplier(InternalServiceException::builder).build());
                    }
                    case "ResourceNumberLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNumberLimitExceededException").exceptionBuilderSupplier(ResourceNumberLimitExceededException::builder).build());
                    }
                    case "ExpiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ExpiredException").httpStatusCode(410).exceptionBuilderSupplier(ExpiredException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "InvalidInputException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(400).exceptionBuilderSupplier(InvalidInputException::builder).build());
                    }
                    case "EntityNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EntityNotFoundException").exceptionBuilderSupplier(EntityNotFoundException::builder).build());
                    }
                    case "StatisticsNotReadyYetException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("StatisticsNotReadyYetException").httpStatusCode(420).exceptionBuilderSupplier(StatisticsNotReadyYetException::builder).build());
                    }
                    case "TransactionCanceledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCanceledException").httpStatusCode(400).exceptionBuilderSupplier(TransactionCanceledException::builder).build());
                    }
                    case "GlueEncryptionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("GlueEncryptionException").exceptionBuilderSupplier(GlueEncryptionException::builder).build());
                    }
                    case "PermissionTypeMismatchException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PermissionTypeMismatchException").exceptionBuilderSupplier(PermissionTypeMismatchException::builder).build());
                    }
                    case "WorkUnitsNotReadyYetException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WorkUnitsNotReadyYetException").httpStatusCode(420).exceptionBuilderSupplier(WorkUnitsNotReadyYetException::builder).build());
                    }
                    case "OperationTimeoutException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OperationTimeoutException").exceptionBuilderSupplier(OperationTimeoutException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture<GetDataLakePrincipalResponse> executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetDataLakePrincipal").withProtocolMetadata(protocolMetadata).withMarshaller(new GetDataLakePrincipalRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector).withInput(getDataLakePrincipalRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((r, e) -> metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect())));
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    @Override
    public CompletableFuture<GetDataLakeSettingsResponse> getDataLakeSettings(GetDataLakeSettingsRequest getDataLakeSettingsRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration(getDataLakeSettingsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultLakeFormationAsyncClient.resolveMetricPublishers(clientConfiguration, getDataLakeSettingsRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "LakeFormation");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetDataLakeSettings");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetDataLakeSettingsResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "TransactionCommitInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCommitInProgressException").httpStatusCode(400).exceptionBuilderSupplier(TransactionCommitInProgressException::builder).build());
                    }
                    case "ConcurrentModificationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                    }
                    case "ResourceNotReadyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotReadyException").httpStatusCode(400).exceptionBuilderSupplier(ResourceNotReadyException::builder).build());
                    }
                    case "ThrottledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ThrottledException").httpStatusCode(429).exceptionBuilderSupplier(ThrottledException::builder).build());
                    }
                    case "AlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AlreadyExistsException").exceptionBuilderSupplier(AlreadyExistsException::builder).build());
                    }
                    case "TransactionCommittedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCommittedException").httpStatusCode(400).exceptionBuilderSupplier(TransactionCommittedException::builder).build());
                    }
                    case "InternalServiceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceException").httpStatusCode(500).exceptionBuilderSupplier(InternalServiceException::builder).build());
                    }
                    case "ResourceNumberLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNumberLimitExceededException").exceptionBuilderSupplier(ResourceNumberLimitExceededException::builder).build());
                    }
                    case "ExpiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ExpiredException").httpStatusCode(410).exceptionBuilderSupplier(ExpiredException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "InvalidInputException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(400).exceptionBuilderSupplier(InvalidInputException::builder).build());
                    }
                    case "EntityNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EntityNotFoundException").exceptionBuilderSupplier(EntityNotFoundException::builder).build());
                    }
                    case "StatisticsNotReadyYetException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("StatisticsNotReadyYetException").httpStatusCode(420).exceptionBuilderSupplier(StatisticsNotReadyYetException::builder).build());
                    }
                    case "TransactionCanceledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCanceledException").httpStatusCode(400).exceptionBuilderSupplier(TransactionCanceledException::builder).build());
                    }
                    case "GlueEncryptionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("GlueEncryptionException").exceptionBuilderSupplier(GlueEncryptionException::builder).build());
                    }
                    case "PermissionTypeMismatchException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PermissionTypeMismatchException").exceptionBuilderSupplier(PermissionTypeMismatchException::builder).build());
                    }
                    case "WorkUnitsNotReadyYetException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WorkUnitsNotReadyYetException").httpStatusCode(420).exceptionBuilderSupplier(WorkUnitsNotReadyYetException::builder).build());
                    }
                    case "OperationTimeoutException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OperationTimeoutException").exceptionBuilderSupplier(OperationTimeoutException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture<GetDataLakeSettingsResponse> executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetDataLakeSettings").withProtocolMetadata(protocolMetadata).withMarshaller(new GetDataLakeSettingsRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector).withInput(getDataLakeSettingsRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((r, e) -> metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect())));
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    @Override
    public CompletableFuture<GetEffectivePermissionsForPathResponse> getEffectivePermissionsForPath(GetEffectivePermissionsForPathRequest getEffectivePermissionsForPathRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration(getEffectivePermissionsForPathRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultLakeFormationAsyncClient.resolveMetricPublishers(clientConfiguration, getEffectivePermissionsForPathRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "LakeFormation");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetEffectivePermissionsForPath");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetEffectivePermissionsForPathResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "TransactionCommitInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCommitInProgressException").httpStatusCode(400).exceptionBuilderSupplier(TransactionCommitInProgressException::builder).build());
                    }
                    case "ConcurrentModificationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                    }
                    case "ResourceNotReadyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotReadyException").httpStatusCode(400).exceptionBuilderSupplier(ResourceNotReadyException::builder).build());
                    }
                    case "ThrottledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ThrottledException").httpStatusCode(429).exceptionBuilderSupplier(ThrottledException::builder).build());
                    }
                    case "AlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AlreadyExistsException").exceptionBuilderSupplier(AlreadyExistsException::builder).build());
                    }
                    case "TransactionCommittedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCommittedException").httpStatusCode(400).exceptionBuilderSupplier(TransactionCommittedException::builder).build());
                    }
                    case "InternalServiceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceException").httpStatusCode(500).exceptionBuilderSupplier(InternalServiceException::builder).build());
                    }
                    case "ResourceNumberLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNumberLimitExceededException").exceptionBuilderSupplier(ResourceNumberLimitExceededException::builder).build());
                    }
                    case "ExpiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ExpiredException").httpStatusCode(410).exceptionBuilderSupplier(ExpiredException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "InvalidInputException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(400).exceptionBuilderSupplier(InvalidInputException::builder).build());
                    }
                    case "EntityNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EntityNotFoundException").exceptionBuilderSupplier(EntityNotFoundException::builder).build());
                    }
                    case "StatisticsNotReadyYetException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("StatisticsNotReadyYetException").httpStatusCode(420).exceptionBuilderSupplier(StatisticsNotReadyYetException::builder).build());
                    }
                    case "TransactionCanceledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCanceledException").httpStatusCode(400).exceptionBuilderSupplier(TransactionCanceledException::builder).build());
                    }
                    case "GlueEncryptionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("GlueEncryptionException").exceptionBuilderSupplier(GlueEncryptionException::builder).build());
                    }
                    case "PermissionTypeMismatchException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PermissionTypeMismatchException").exceptionBuilderSupplier(PermissionTypeMismatchException::builder).build());
                    }
                    case "WorkUnitsNotReadyYetException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WorkUnitsNotReadyYetException").httpStatusCode(420).exceptionBuilderSupplier(WorkUnitsNotReadyYetException::builder).build());
                    }
                    case "OperationTimeoutException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OperationTimeoutException").exceptionBuilderSupplier(OperationTimeoutException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture<GetEffectivePermissionsForPathResponse> executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetEffectivePermissionsForPath").withProtocolMetadata(protocolMetadata).withMarshaller(new GetEffectivePermissionsForPathRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector).withInput(getEffectivePermissionsForPathRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((r, e) -> metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect())));
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    @Override
    public CompletableFuture<GetLfTagResponse> getLFTag(GetLfTagRequest getLfTagRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration(getLfTagRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultLakeFormationAsyncClient.resolveMetricPublishers(clientConfiguration, getLfTagRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "LakeFormation");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetLFTag");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetLfTagResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "TransactionCommitInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCommitInProgressException").httpStatusCode(400).exceptionBuilderSupplier(TransactionCommitInProgressException::builder).build());
                    }
                    case "ConcurrentModificationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                    }
                    case "ResourceNotReadyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotReadyException").httpStatusCode(400).exceptionBuilderSupplier(ResourceNotReadyException::builder).build());
                    }
                    case "ThrottledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ThrottledException").httpStatusCode(429).exceptionBuilderSupplier(ThrottledException::builder).build());
                    }
                    case "AlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AlreadyExistsException").exceptionBuilderSupplier(AlreadyExistsException::builder).build());
                    }
                    case "TransactionCommittedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCommittedException").httpStatusCode(400).exceptionBuilderSupplier(TransactionCommittedException::builder).build());
                    }
                    case "InternalServiceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceException").httpStatusCode(500).exceptionBuilderSupplier(InternalServiceException::builder).build());
                    }
                    case "ResourceNumberLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNumberLimitExceededException").exceptionBuilderSupplier(ResourceNumberLimitExceededException::builder).build());
                    }
                    case "ExpiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ExpiredException").httpStatusCode(410).exceptionBuilderSupplier(ExpiredException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "InvalidInputException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(400).exceptionBuilderSupplier(InvalidInputException::builder).build());
                    }
                    case "EntityNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EntityNotFoundException").exceptionBuilderSupplier(EntityNotFoundException::builder).build());
                    }
                    case "StatisticsNotReadyYetException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("StatisticsNotReadyYetException").httpStatusCode(420).exceptionBuilderSupplier(StatisticsNotReadyYetException::builder).build());
                    }
                    case "TransactionCanceledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCanceledException").httpStatusCode(400).exceptionBuilderSupplier(TransactionCanceledException::builder).build());
                    }
                    case "GlueEncryptionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("GlueEncryptionException").exceptionBuilderSupplier(GlueEncryptionException::builder).build());
                    }
                    case "PermissionTypeMismatchException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PermissionTypeMismatchException").exceptionBuilderSupplier(PermissionTypeMismatchException::builder).build());
                    }
                    case "WorkUnitsNotReadyYetException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WorkUnitsNotReadyYetException").httpStatusCode(420).exceptionBuilderSupplier(WorkUnitsNotReadyYetException::builder).build());
                    }
                    case "OperationTimeoutException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OperationTimeoutException").exceptionBuilderSupplier(OperationTimeoutException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture<GetLfTagResponse> executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetLFTag").withProtocolMetadata(protocolMetadata).withMarshaller(new GetLfTagRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector).withInput(getLfTagRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((r, e) -> metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect())));
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    @Override
    public CompletableFuture<GetLfTagExpressionResponse> getLFTagExpression(GetLfTagExpressionRequest getLfTagExpressionRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration(getLfTagExpressionRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultLakeFormationAsyncClient.resolveMetricPublishers(clientConfiguration, getLfTagExpressionRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "LakeFormation");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetLFTagExpression");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetLfTagExpressionResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "TransactionCommitInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCommitInProgressException").httpStatusCode(400).exceptionBuilderSupplier(TransactionCommitInProgressException::builder).build());
                    }
                    case "ConcurrentModificationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                    }
                    case "ResourceNotReadyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotReadyException").httpStatusCode(400).exceptionBuilderSupplier(ResourceNotReadyException::builder).build());
                    }
                    case "ThrottledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ThrottledException").httpStatusCode(429).exceptionBuilderSupplier(ThrottledException::builder).build());
                    }
                    case "AlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AlreadyExistsException").exceptionBuilderSupplier(AlreadyExistsException::builder).build());
                    }
                    case "TransactionCommittedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCommittedException").httpStatusCode(400).exceptionBuilderSupplier(TransactionCommittedException::builder).build());
                    }
                    case "InternalServiceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceException").httpStatusCode(500).exceptionBuilderSupplier(InternalServiceException::builder).build());
                    }
                    case "ResourceNumberLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNumberLimitExceededException").exceptionBuilderSupplier(ResourceNumberLimitExceededException::builder).build());
                    }
                    case "ExpiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ExpiredException").httpStatusCode(410).exceptionBuilderSupplier(ExpiredException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "InvalidInputException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(400).exceptionBuilderSupplier(InvalidInputException::builder).build());
                    }
                    case "EntityNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EntityNotFoundException").exceptionBuilderSupplier(EntityNotFoundException::builder).build());
                    }
                    case "StatisticsNotReadyYetException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("StatisticsNotReadyYetException").httpStatusCode(420).exceptionBuilderSupplier(StatisticsNotReadyYetException::builder).build());
                    }
                    case "TransactionCanceledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCanceledException").httpStatusCode(400).exceptionBuilderSupplier(TransactionCanceledException::builder).build());
                    }
                    case "GlueEncryptionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("GlueEncryptionException").exceptionBuilderSupplier(GlueEncryptionException::builder).build());
                    }
                    case "PermissionTypeMismatchException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PermissionTypeMismatchException").exceptionBuilderSupplier(PermissionTypeMismatchException::builder).build());
                    }
                    case "WorkUnitsNotReadyYetException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WorkUnitsNotReadyYetException").httpStatusCode(420).exceptionBuilderSupplier(WorkUnitsNotReadyYetException::builder).build());
                    }
                    case "OperationTimeoutException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OperationTimeoutException").exceptionBuilderSupplier(OperationTimeoutException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture<GetLfTagExpressionResponse> executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetLFTagExpression").withProtocolMetadata(protocolMetadata).withMarshaller(new GetLfTagExpressionRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector).withInput(getLfTagExpressionRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((r, e) -> metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect())));
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    @Override
    public CompletableFuture<GetQueryStateResponse> getQueryState(GetQueryStateRequest getQueryStateRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration(getQueryStateRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultLakeFormationAsyncClient.resolveMetricPublishers(clientConfiguration, getQueryStateRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "LakeFormation");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetQueryState");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetQueryStateResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "TransactionCommitInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCommitInProgressException").httpStatusCode(400).exceptionBuilderSupplier(TransactionCommitInProgressException::builder).build());
                    }
                    case "ConcurrentModificationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                    }
                    case "ResourceNotReadyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotReadyException").httpStatusCode(400).exceptionBuilderSupplier(ResourceNotReadyException::builder).build());
                    }
                    case "ThrottledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ThrottledException").httpStatusCode(429).exceptionBuilderSupplier(ThrottledException::builder).build());
                    }
                    case "AlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AlreadyExistsException").exceptionBuilderSupplier(AlreadyExistsException::builder).build());
                    }
                    case "TransactionCommittedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCommittedException").httpStatusCode(400).exceptionBuilderSupplier(TransactionCommittedException::builder).build());
                    }
                    case "InternalServiceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceException").httpStatusCode(500).exceptionBuilderSupplier(InternalServiceException::builder).build());
                    }
                    case "ResourceNumberLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNumberLimitExceededException").exceptionBuilderSupplier(ResourceNumberLimitExceededException::builder).build());
                    }
                    case "ExpiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ExpiredException").httpStatusCode(410).exceptionBuilderSupplier(ExpiredException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "InvalidInputException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(400).exceptionBuilderSupplier(InvalidInputException::builder).build());
                    }
                    case "EntityNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EntityNotFoundException").exceptionBuilderSupplier(EntityNotFoundException::builder).build());
                    }
                    case "StatisticsNotReadyYetException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("StatisticsNotReadyYetException").httpStatusCode(420).exceptionBuilderSupplier(StatisticsNotReadyYetException::builder).build());
                    }
                    case "TransactionCanceledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCanceledException").httpStatusCode(400).exceptionBuilderSupplier(TransactionCanceledException::builder).build());
                    }
                    case "GlueEncryptionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("GlueEncryptionException").exceptionBuilderSupplier(GlueEncryptionException::builder).build());
                    }
                    case "PermissionTypeMismatchException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PermissionTypeMismatchException").exceptionBuilderSupplier(PermissionTypeMismatchException::builder).build());
                    }
                    case "WorkUnitsNotReadyYetException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WorkUnitsNotReadyYetException").httpStatusCode(420).exceptionBuilderSupplier(WorkUnitsNotReadyYetException::builder).build());
                    }
                    case "OperationTimeoutException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OperationTimeoutException").exceptionBuilderSupplier(OperationTimeoutException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            String hostPrefix = "query-";
            String resolvedHostExpression = "query-";
            CompletableFuture<GetQueryStateResponse> executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetQueryState").withProtocolMetadata(protocolMetadata).withMarshaller(new GetQueryStateRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector).hostPrefixExpression(resolvedHostExpression).withInput(getQueryStateRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((r, e) -> metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect())));
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    @Override
    public CompletableFuture<GetQueryStatisticsResponse> getQueryStatistics(GetQueryStatisticsRequest getQueryStatisticsRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration(getQueryStatisticsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultLakeFormationAsyncClient.resolveMetricPublishers(clientConfiguration, getQueryStatisticsRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "LakeFormation");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetQueryStatistics");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetQueryStatisticsResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "TransactionCommitInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCommitInProgressException").httpStatusCode(400).exceptionBuilderSupplier(TransactionCommitInProgressException::builder).build());
                    }
                    case "ConcurrentModificationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                    }
                    case "ResourceNotReadyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotReadyException").httpStatusCode(400).exceptionBuilderSupplier(ResourceNotReadyException::builder).build());
                    }
                    case "ThrottledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ThrottledException").httpStatusCode(429).exceptionBuilderSupplier(ThrottledException::builder).build());
                    }
                    case "AlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AlreadyExistsException").exceptionBuilderSupplier(AlreadyExistsException::builder).build());
                    }
                    case "TransactionCommittedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCommittedException").httpStatusCode(400).exceptionBuilderSupplier(TransactionCommittedException::builder).build());
                    }
                    case "InternalServiceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceException").httpStatusCode(500).exceptionBuilderSupplier(InternalServiceException::builder).build());
                    }
                    case "ResourceNumberLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNumberLimitExceededException").exceptionBuilderSupplier(ResourceNumberLimitExceededException::builder).build());
                    }
                    case "ExpiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ExpiredException").httpStatusCode(410).exceptionBuilderSupplier(ExpiredException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "InvalidInputException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(400).exceptionBuilderSupplier(InvalidInputException::builder).build());
                    }
                    case "EntityNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EntityNotFoundException").exceptionBuilderSupplier(EntityNotFoundException::builder).build());
                    }
                    case "StatisticsNotReadyYetException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("StatisticsNotReadyYetException").httpStatusCode(420).exceptionBuilderSupplier(StatisticsNotReadyYetException::builder).build());
                    }
                    case "TransactionCanceledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCanceledException").httpStatusCode(400).exceptionBuilderSupplier(TransactionCanceledException::builder).build());
                    }
                    case "GlueEncryptionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("GlueEncryptionException").exceptionBuilderSupplier(GlueEncryptionException::builder).build());
                    }
                    case "PermissionTypeMismatchException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PermissionTypeMismatchException").exceptionBuilderSupplier(PermissionTypeMismatchException::builder).build());
                    }
                    case "WorkUnitsNotReadyYetException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WorkUnitsNotReadyYetException").httpStatusCode(420).exceptionBuilderSupplier(WorkUnitsNotReadyYetException::builder).build());
                    }
                    case "OperationTimeoutException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OperationTimeoutException").exceptionBuilderSupplier(OperationTimeoutException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            String hostPrefix = "query-";
            String resolvedHostExpression = "query-";
            CompletableFuture<GetQueryStatisticsResponse> executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetQueryStatistics").withProtocolMetadata(protocolMetadata).withMarshaller(new GetQueryStatisticsRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector).hostPrefixExpression(resolvedHostExpression).withInput(getQueryStatisticsRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((r, e) -> metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect())));
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    @Override
    public CompletableFuture<GetResourceLfTagsResponse> getResourceLFTags(GetResourceLfTagsRequest getResourceLfTagsRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration(getResourceLfTagsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultLakeFormationAsyncClient.resolveMetricPublishers(clientConfiguration, getResourceLfTagsRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "LakeFormation");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetResourceLFTags");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetResourceLfTagsResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "TransactionCommitInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCommitInProgressException").httpStatusCode(400).exceptionBuilderSupplier(TransactionCommitInProgressException::builder).build());
                    }
                    case "ConcurrentModificationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                    }
                    case "ResourceNotReadyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotReadyException").httpStatusCode(400).exceptionBuilderSupplier(ResourceNotReadyException::builder).build());
                    }
                    case "ThrottledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ThrottledException").httpStatusCode(429).exceptionBuilderSupplier(ThrottledException::builder).build());
                    }
                    case "AlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AlreadyExistsException").exceptionBuilderSupplier(AlreadyExistsException::builder).build());
                    }
                    case "TransactionCommittedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCommittedException").httpStatusCode(400).exceptionBuilderSupplier(TransactionCommittedException::builder).build());
                    }
                    case "InternalServiceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceException").httpStatusCode(500).exceptionBuilderSupplier(InternalServiceException::builder).build());
                    }
                    case "ResourceNumberLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNumberLimitExceededException").exceptionBuilderSupplier(ResourceNumberLimitExceededException::builder).build());
                    }
                    case "ExpiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ExpiredException").httpStatusCode(410).exceptionBuilderSupplier(ExpiredException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "InvalidInputException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(400).exceptionBuilderSupplier(InvalidInputException::builder).build());
                    }
                    case "EntityNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EntityNotFoundException").exceptionBuilderSupplier(EntityNotFoundException::builder).build());
                    }
                    case "StatisticsNotReadyYetException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("StatisticsNotReadyYetException").httpStatusCode(420).exceptionBuilderSupplier(StatisticsNotReadyYetException::builder).build());
                    }
                    case "TransactionCanceledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCanceledException").httpStatusCode(400).exceptionBuilderSupplier(TransactionCanceledException::builder).build());
                    }
                    case "GlueEncryptionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("GlueEncryptionException").exceptionBuilderSupplier(GlueEncryptionException::builder).build());
                    }
                    case "PermissionTypeMismatchException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PermissionTypeMismatchException").exceptionBuilderSupplier(PermissionTypeMismatchException::builder).build());
                    }
                    case "WorkUnitsNotReadyYetException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WorkUnitsNotReadyYetException").httpStatusCode(420).exceptionBuilderSupplier(WorkUnitsNotReadyYetException::builder).build());
                    }
                    case "OperationTimeoutException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OperationTimeoutException").exceptionBuilderSupplier(OperationTimeoutException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture<GetResourceLfTagsResponse> executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetResourceLFTags").withProtocolMetadata(protocolMetadata).withMarshaller(new GetResourceLfTagsRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector).withInput(getResourceLfTagsRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((r, e) -> metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect())));
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    @Override
    public CompletableFuture<GetTableObjectsResponse> getTableObjects(GetTableObjectsRequest getTableObjectsRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration(getTableObjectsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultLakeFormationAsyncClient.resolveMetricPublishers(clientConfiguration, getTableObjectsRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "LakeFormation");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetTableObjects");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetTableObjectsResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "TransactionCommitInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCommitInProgressException").httpStatusCode(400).exceptionBuilderSupplier(TransactionCommitInProgressException::builder).build());
                    }
                    case "ConcurrentModificationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                    }
                    case "ResourceNotReadyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotReadyException").httpStatusCode(400).exceptionBuilderSupplier(ResourceNotReadyException::builder).build());
                    }
                    case "ThrottledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ThrottledException").httpStatusCode(429).exceptionBuilderSupplier(ThrottledException::builder).build());
                    }
                    case "AlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AlreadyExistsException").exceptionBuilderSupplier(AlreadyExistsException::builder).build());
                    }
                    case "TransactionCommittedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCommittedException").httpStatusCode(400).exceptionBuilderSupplier(TransactionCommittedException::builder).build());
                    }
                    case "InternalServiceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceException").httpStatusCode(500).exceptionBuilderSupplier(InternalServiceException::builder).build());
                    }
                    case "ResourceNumberLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNumberLimitExceededException").exceptionBuilderSupplier(ResourceNumberLimitExceededException::builder).build());
                    }
                    case "ExpiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ExpiredException").httpStatusCode(410).exceptionBuilderSupplier(ExpiredException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "InvalidInputException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(400).exceptionBuilderSupplier(InvalidInputException::builder).build());
                    }
                    case "EntityNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EntityNotFoundException").exceptionBuilderSupplier(EntityNotFoundException::builder).build());
                    }
                    case "StatisticsNotReadyYetException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("StatisticsNotReadyYetException").httpStatusCode(420).exceptionBuilderSupplier(StatisticsNotReadyYetException::builder).build());
                    }
                    case "TransactionCanceledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCanceledException").httpStatusCode(400).exceptionBuilderSupplier(TransactionCanceledException::builder).build());
                    }
                    case "GlueEncryptionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("GlueEncryptionException").exceptionBuilderSupplier(GlueEncryptionException::builder).build());
                    }
                    case "PermissionTypeMismatchException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PermissionTypeMismatchException").exceptionBuilderSupplier(PermissionTypeMismatchException::builder).build());
                    }
                    case "WorkUnitsNotReadyYetException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WorkUnitsNotReadyYetException").httpStatusCode(420).exceptionBuilderSupplier(WorkUnitsNotReadyYetException::builder).build());
                    }
                    case "OperationTimeoutException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OperationTimeoutException").exceptionBuilderSupplier(OperationTimeoutException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture<GetTableObjectsResponse> executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetTableObjects").withProtocolMetadata(protocolMetadata).withMarshaller(new GetTableObjectsRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector).withInput(getTableObjectsRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((r, e) -> metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect())));
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    @Override
    public CompletableFuture<GetTemporaryGluePartitionCredentialsResponse> getTemporaryGluePartitionCredentials(GetTemporaryGluePartitionCredentialsRequest getTemporaryGluePartitionCredentialsRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration(getTemporaryGluePartitionCredentialsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultLakeFormationAsyncClient.resolveMetricPublishers(clientConfiguration, getTemporaryGluePartitionCredentialsRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "LakeFormation");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetTemporaryGluePartitionCredentials");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetTemporaryGluePartitionCredentialsResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "TransactionCommitInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCommitInProgressException").httpStatusCode(400).exceptionBuilderSupplier(TransactionCommitInProgressException::builder).build());
                    }
                    case "ConcurrentModificationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                    }
                    case "ResourceNotReadyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotReadyException").httpStatusCode(400).exceptionBuilderSupplier(ResourceNotReadyException::builder).build());
                    }
                    case "ThrottledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ThrottledException").httpStatusCode(429).exceptionBuilderSupplier(ThrottledException::builder).build());
                    }
                    case "AlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AlreadyExistsException").exceptionBuilderSupplier(AlreadyExistsException::builder).build());
                    }
                    case "TransactionCommittedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCommittedException").httpStatusCode(400).exceptionBuilderSupplier(TransactionCommittedException::builder).build());
                    }
                    case "InternalServiceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceException").httpStatusCode(500).exceptionBuilderSupplier(InternalServiceException::builder).build());
                    }
                    case "ResourceNumberLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNumberLimitExceededException").exceptionBuilderSupplier(ResourceNumberLimitExceededException::builder).build());
                    }
                    case "ExpiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ExpiredException").httpStatusCode(410).exceptionBuilderSupplier(ExpiredException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "InvalidInputException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(400).exceptionBuilderSupplier(InvalidInputException::builder).build());
                    }
                    case "EntityNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EntityNotFoundException").exceptionBuilderSupplier(EntityNotFoundException::builder).build());
                    }
                    case "StatisticsNotReadyYetException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("StatisticsNotReadyYetException").httpStatusCode(420).exceptionBuilderSupplier(StatisticsNotReadyYetException::builder).build());
                    }
                    case "TransactionCanceledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCanceledException").httpStatusCode(400).exceptionBuilderSupplier(TransactionCanceledException::builder).build());
                    }
                    case "GlueEncryptionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("GlueEncryptionException").exceptionBuilderSupplier(GlueEncryptionException::builder).build());
                    }
                    case "PermissionTypeMismatchException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PermissionTypeMismatchException").exceptionBuilderSupplier(PermissionTypeMismatchException::builder).build());
                    }
                    case "WorkUnitsNotReadyYetException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WorkUnitsNotReadyYetException").httpStatusCode(420).exceptionBuilderSupplier(WorkUnitsNotReadyYetException::builder).build());
                    }
                    case "OperationTimeoutException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OperationTimeoutException").exceptionBuilderSupplier(OperationTimeoutException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture<GetTemporaryGluePartitionCredentialsResponse> executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetTemporaryGluePartitionCredentials").withProtocolMetadata(protocolMetadata).withMarshaller(new GetTemporaryGluePartitionCredentialsRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector).withInput(getTemporaryGluePartitionCredentialsRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((r, e) -> metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect())));
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    @Override
    public CompletableFuture<GetTemporaryGlueTableCredentialsResponse> getTemporaryGlueTableCredentials(GetTemporaryGlueTableCredentialsRequest getTemporaryGlueTableCredentialsRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration(getTemporaryGlueTableCredentialsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultLakeFormationAsyncClient.resolveMetricPublishers(clientConfiguration, getTemporaryGlueTableCredentialsRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "LakeFormation");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetTemporaryGlueTableCredentials");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetTemporaryGlueTableCredentialsResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "TransactionCommitInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCommitInProgressException").httpStatusCode(400).exceptionBuilderSupplier(TransactionCommitInProgressException::builder).build());
                    }
                    case "ConcurrentModificationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                    }
                    case "ResourceNotReadyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotReadyException").httpStatusCode(400).exceptionBuilderSupplier(ResourceNotReadyException::builder).build());
                    }
                    case "ThrottledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ThrottledException").httpStatusCode(429).exceptionBuilderSupplier(ThrottledException::builder).build());
                    }
                    case "AlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AlreadyExistsException").exceptionBuilderSupplier(AlreadyExistsException::builder).build());
                    }
                    case "TransactionCommittedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCommittedException").httpStatusCode(400).exceptionBuilderSupplier(TransactionCommittedException::builder).build());
                    }
                    case "InternalServiceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceException").httpStatusCode(500).exceptionBuilderSupplier(InternalServiceException::builder).build());
                    }
                    case "ResourceNumberLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNumberLimitExceededException").exceptionBuilderSupplier(ResourceNumberLimitExceededException::builder).build());
                    }
                    case "ExpiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ExpiredException").httpStatusCode(410).exceptionBuilderSupplier(ExpiredException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "InvalidInputException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(400).exceptionBuilderSupplier(InvalidInputException::builder).build());
                    }
                    case "EntityNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EntityNotFoundException").exceptionBuilderSupplier(EntityNotFoundException::builder).build());
                    }
                    case "StatisticsNotReadyYetException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("StatisticsNotReadyYetException").httpStatusCode(420).exceptionBuilderSupplier(StatisticsNotReadyYetException::builder).build());
                    }
                    case "TransactionCanceledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCanceledException").httpStatusCode(400).exceptionBuilderSupplier(TransactionCanceledException::builder).build());
                    }
                    case "GlueEncryptionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("GlueEncryptionException").exceptionBuilderSupplier(GlueEncryptionException::builder).build());
                    }
                    case "PermissionTypeMismatchException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PermissionTypeMismatchException").exceptionBuilderSupplier(PermissionTypeMismatchException::builder).build());
                    }
                    case "WorkUnitsNotReadyYetException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WorkUnitsNotReadyYetException").httpStatusCode(420).exceptionBuilderSupplier(WorkUnitsNotReadyYetException::builder).build());
                    }
                    case "OperationTimeoutException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OperationTimeoutException").exceptionBuilderSupplier(OperationTimeoutException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture<GetTemporaryGlueTableCredentialsResponse> executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetTemporaryGlueTableCredentials").withProtocolMetadata(protocolMetadata).withMarshaller(new GetTemporaryGlueTableCredentialsRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector).withInput(getTemporaryGlueTableCredentialsRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((r, e) -> metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect())));
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    @Override
    public <ReturnT> CompletableFuture<ReturnT> getWorkUnitResults(GetWorkUnitResultsRequest getWorkUnitResultsRequest, AsyncResponseTransformer<GetWorkUnitResultsResponse, ReturnT> asyncResponseTransformer) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration(getWorkUnitResultsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultLakeFormationAsyncClient.resolveMetricPublishers(clientConfiguration, getWorkUnitResultsRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "LakeFormation");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetWorkUnitResults");
            Pair<AsyncResponseTransformer<GetWorkUnitResultsResponse, ReturnT>, CompletableFuture<Void>> pair = AsyncResponseTransformerUtils.wrapWithEndOfStreamFuture(asyncResponseTransformer);
            asyncResponseTransformer = pair.left();
            CompletableFuture<Void> endOfStreamFuture = pair.right();
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(true).isPayloadJson(false).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetWorkUnitResultsResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "TransactionCommitInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCommitInProgressException").httpStatusCode(400).exceptionBuilderSupplier(TransactionCommitInProgressException::builder).build());
                    }
                    case "ConcurrentModificationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                    }
                    case "ResourceNotReadyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotReadyException").httpStatusCode(400).exceptionBuilderSupplier(ResourceNotReadyException::builder).build());
                    }
                    case "ThrottledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ThrottledException").httpStatusCode(429).exceptionBuilderSupplier(ThrottledException::builder).build());
                    }
                    case "AlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AlreadyExistsException").exceptionBuilderSupplier(AlreadyExistsException::builder).build());
                    }
                    case "TransactionCommittedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCommittedException").httpStatusCode(400).exceptionBuilderSupplier(TransactionCommittedException::builder).build());
                    }
                    case "InternalServiceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceException").httpStatusCode(500).exceptionBuilderSupplier(InternalServiceException::builder).build());
                    }
                    case "ResourceNumberLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNumberLimitExceededException").exceptionBuilderSupplier(ResourceNumberLimitExceededException::builder).build());
                    }
                    case "ExpiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ExpiredException").httpStatusCode(410).exceptionBuilderSupplier(ExpiredException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "InvalidInputException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(400).exceptionBuilderSupplier(InvalidInputException::builder).build());
                    }
                    case "EntityNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EntityNotFoundException").exceptionBuilderSupplier(EntityNotFoundException::builder).build());
                    }
                    case "StatisticsNotReadyYetException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("StatisticsNotReadyYetException").httpStatusCode(420).exceptionBuilderSupplier(StatisticsNotReadyYetException::builder).build());
                    }
                    case "TransactionCanceledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCanceledException").httpStatusCode(400).exceptionBuilderSupplier(TransactionCanceledException::builder).build());
                    }
                    case "GlueEncryptionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("GlueEncryptionException").exceptionBuilderSupplier(GlueEncryptionException::builder).build());
                    }
                    case "PermissionTypeMismatchException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PermissionTypeMismatchException").exceptionBuilderSupplier(PermissionTypeMismatchException::builder).build());
                    }
                    case "WorkUnitsNotReadyYetException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WorkUnitsNotReadyYetException").httpStatusCode(420).exceptionBuilderSupplier(WorkUnitsNotReadyYetException::builder).build());
                    }
                    case "OperationTimeoutException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OperationTimeoutException").exceptionBuilderSupplier(OperationTimeoutException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            String hostPrefix = "data-";
            String resolvedHostExpression = "data-";
            CompletableFuture<Object> executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetWorkUnitResults").withProtocolMetadata(protocolMetadata).withMarshaller(new GetWorkUnitResultsRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector).hostPrefixExpression(resolvedHostExpression).withAsyncResponseTransformer(asyncResponseTransformer).withInput(getWorkUnitResultsRequest), asyncResponseTransformer);
            AsyncResponseTransformer finalAsyncResponseTransformer = asyncResponseTransformer;
            CompletionStage whenCompleted = executeFuture.whenComplete((r, e) -> {
                if (e != null) {
                    FunctionalUtils.runAndLogError(log, "Exception thrown in exceptionOccurred callback, ignoring", () -> finalAsyncResponseTransformer.exceptionOccurred((Throwable)e));
                }
                endOfStreamFuture.whenComplete((r2, e2) -> metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect())));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            AsyncResponseTransformer finalAsyncResponseTransformer = asyncResponseTransformer;
            FunctionalUtils.runAndLogError(log, "Exception thrown in exceptionOccurred callback, ignoring", () -> finalAsyncResponseTransformer.exceptionOccurred(t));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    @Override
    public CompletableFuture<GetWorkUnitsResponse> getWorkUnits(GetWorkUnitsRequest getWorkUnitsRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration(getWorkUnitsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultLakeFormationAsyncClient.resolveMetricPublishers(clientConfiguration, getWorkUnitsRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "LakeFormation");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetWorkUnits");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetWorkUnitsResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "TransactionCommitInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCommitInProgressException").httpStatusCode(400).exceptionBuilderSupplier(TransactionCommitInProgressException::builder).build());
                    }
                    case "ConcurrentModificationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                    }
                    case "ResourceNotReadyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotReadyException").httpStatusCode(400).exceptionBuilderSupplier(ResourceNotReadyException::builder).build());
                    }
                    case "ThrottledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ThrottledException").httpStatusCode(429).exceptionBuilderSupplier(ThrottledException::builder).build());
                    }
                    case "AlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AlreadyExistsException").exceptionBuilderSupplier(AlreadyExistsException::builder).build());
                    }
                    case "TransactionCommittedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCommittedException").httpStatusCode(400).exceptionBuilderSupplier(TransactionCommittedException::builder).build());
                    }
                    case "InternalServiceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceException").httpStatusCode(500).exceptionBuilderSupplier(InternalServiceException::builder).build());
                    }
                    case "ResourceNumberLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNumberLimitExceededException").exceptionBuilderSupplier(ResourceNumberLimitExceededException::builder).build());
                    }
                    case "ExpiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ExpiredException").httpStatusCode(410).exceptionBuilderSupplier(ExpiredException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "InvalidInputException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(400).exceptionBuilderSupplier(InvalidInputException::builder).build());
                    }
                    case "EntityNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EntityNotFoundException").exceptionBuilderSupplier(EntityNotFoundException::builder).build());
                    }
                    case "StatisticsNotReadyYetException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("StatisticsNotReadyYetException").httpStatusCode(420).exceptionBuilderSupplier(StatisticsNotReadyYetException::builder).build());
                    }
                    case "TransactionCanceledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCanceledException").httpStatusCode(400).exceptionBuilderSupplier(TransactionCanceledException::builder).build());
                    }
                    case "GlueEncryptionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("GlueEncryptionException").exceptionBuilderSupplier(GlueEncryptionException::builder).build());
                    }
                    case "PermissionTypeMismatchException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PermissionTypeMismatchException").exceptionBuilderSupplier(PermissionTypeMismatchException::builder).build());
                    }
                    case "WorkUnitsNotReadyYetException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WorkUnitsNotReadyYetException").httpStatusCode(420).exceptionBuilderSupplier(WorkUnitsNotReadyYetException::builder).build());
                    }
                    case "OperationTimeoutException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OperationTimeoutException").exceptionBuilderSupplier(OperationTimeoutException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            String hostPrefix = "query-";
            String resolvedHostExpression = "query-";
            CompletableFuture<GetWorkUnitsResponse> executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetWorkUnits").withProtocolMetadata(protocolMetadata).withMarshaller(new GetWorkUnitsRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector).hostPrefixExpression(resolvedHostExpression).withInput(getWorkUnitsRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((r, e) -> metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect())));
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    @Override
    public CompletableFuture<GrantPermissionsResponse> grantPermissions(GrantPermissionsRequest grantPermissionsRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration(grantPermissionsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultLakeFormationAsyncClient.resolveMetricPublishers(clientConfiguration, grantPermissionsRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "LakeFormation");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GrantPermissions");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GrantPermissionsResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "TransactionCommitInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCommitInProgressException").httpStatusCode(400).exceptionBuilderSupplier(TransactionCommitInProgressException::builder).build());
                    }
                    case "ConcurrentModificationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                    }
                    case "ResourceNotReadyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotReadyException").httpStatusCode(400).exceptionBuilderSupplier(ResourceNotReadyException::builder).build());
                    }
                    case "ThrottledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ThrottledException").httpStatusCode(429).exceptionBuilderSupplier(ThrottledException::builder).build());
                    }
                    case "AlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AlreadyExistsException").exceptionBuilderSupplier(AlreadyExistsException::builder).build());
                    }
                    case "TransactionCommittedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCommittedException").httpStatusCode(400).exceptionBuilderSupplier(TransactionCommittedException::builder).build());
                    }
                    case "InternalServiceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceException").httpStatusCode(500).exceptionBuilderSupplier(InternalServiceException::builder).build());
                    }
                    case "ResourceNumberLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNumberLimitExceededException").exceptionBuilderSupplier(ResourceNumberLimitExceededException::builder).build());
                    }
                    case "ExpiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ExpiredException").httpStatusCode(410).exceptionBuilderSupplier(ExpiredException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "InvalidInputException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(400).exceptionBuilderSupplier(InvalidInputException::builder).build());
                    }
                    case "EntityNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EntityNotFoundException").exceptionBuilderSupplier(EntityNotFoundException::builder).build());
                    }
                    case "StatisticsNotReadyYetException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("StatisticsNotReadyYetException").httpStatusCode(420).exceptionBuilderSupplier(StatisticsNotReadyYetException::builder).build());
                    }
                    case "TransactionCanceledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCanceledException").httpStatusCode(400).exceptionBuilderSupplier(TransactionCanceledException::builder).build());
                    }
                    case "GlueEncryptionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("GlueEncryptionException").exceptionBuilderSupplier(GlueEncryptionException::builder).build());
                    }
                    case "PermissionTypeMismatchException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PermissionTypeMismatchException").exceptionBuilderSupplier(PermissionTypeMismatchException::builder).build());
                    }
                    case "WorkUnitsNotReadyYetException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WorkUnitsNotReadyYetException").httpStatusCode(420).exceptionBuilderSupplier(WorkUnitsNotReadyYetException::builder).build());
                    }
                    case "OperationTimeoutException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OperationTimeoutException").exceptionBuilderSupplier(OperationTimeoutException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture<GrantPermissionsResponse> executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GrantPermissions").withProtocolMetadata(protocolMetadata).withMarshaller(new GrantPermissionsRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector).withInput(grantPermissionsRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((r, e) -> metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect())));
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    @Override
    public CompletableFuture<ListDataCellsFilterResponse> listDataCellsFilter(ListDataCellsFilterRequest listDataCellsFilterRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration(listDataCellsFilterRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultLakeFormationAsyncClient.resolveMetricPublishers(clientConfiguration, listDataCellsFilterRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "LakeFormation");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListDataCellsFilter");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListDataCellsFilterResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "TransactionCommitInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCommitInProgressException").httpStatusCode(400).exceptionBuilderSupplier(TransactionCommitInProgressException::builder).build());
                    }
                    case "ConcurrentModificationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                    }
                    case "ResourceNotReadyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotReadyException").httpStatusCode(400).exceptionBuilderSupplier(ResourceNotReadyException::builder).build());
                    }
                    case "ThrottledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ThrottledException").httpStatusCode(429).exceptionBuilderSupplier(ThrottledException::builder).build());
                    }
                    case "AlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AlreadyExistsException").exceptionBuilderSupplier(AlreadyExistsException::builder).build());
                    }
                    case "TransactionCommittedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCommittedException").httpStatusCode(400).exceptionBuilderSupplier(TransactionCommittedException::builder).build());
                    }
                    case "InternalServiceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceException").httpStatusCode(500).exceptionBuilderSupplier(InternalServiceException::builder).build());
                    }
                    case "ResourceNumberLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNumberLimitExceededException").exceptionBuilderSupplier(ResourceNumberLimitExceededException::builder).build());
                    }
                    case "ExpiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ExpiredException").httpStatusCode(410).exceptionBuilderSupplier(ExpiredException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "InvalidInputException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(400).exceptionBuilderSupplier(InvalidInputException::builder).build());
                    }
                    case "EntityNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EntityNotFoundException").exceptionBuilderSupplier(EntityNotFoundException::builder).build());
                    }
                    case "StatisticsNotReadyYetException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("StatisticsNotReadyYetException").httpStatusCode(420).exceptionBuilderSupplier(StatisticsNotReadyYetException::builder).build());
                    }
                    case "TransactionCanceledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCanceledException").httpStatusCode(400).exceptionBuilderSupplier(TransactionCanceledException::builder).build());
                    }
                    case "GlueEncryptionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("GlueEncryptionException").exceptionBuilderSupplier(GlueEncryptionException::builder).build());
                    }
                    case "PermissionTypeMismatchException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PermissionTypeMismatchException").exceptionBuilderSupplier(PermissionTypeMismatchException::builder).build());
                    }
                    case "WorkUnitsNotReadyYetException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WorkUnitsNotReadyYetException").httpStatusCode(420).exceptionBuilderSupplier(WorkUnitsNotReadyYetException::builder).build());
                    }
                    case "OperationTimeoutException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OperationTimeoutException").exceptionBuilderSupplier(OperationTimeoutException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture<ListDataCellsFilterResponse> executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListDataCellsFilter").withProtocolMetadata(protocolMetadata).withMarshaller(new ListDataCellsFilterRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector).withInput(listDataCellsFilterRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((r, e) -> metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect())));
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    @Override
    public CompletableFuture<ListLfTagExpressionsResponse> listLFTagExpressions(ListLfTagExpressionsRequest listLfTagExpressionsRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration(listLfTagExpressionsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultLakeFormationAsyncClient.resolveMetricPublishers(clientConfiguration, listLfTagExpressionsRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "LakeFormation");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListLFTagExpressions");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListLfTagExpressionsResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "TransactionCommitInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCommitInProgressException").httpStatusCode(400).exceptionBuilderSupplier(TransactionCommitInProgressException::builder).build());
                    }
                    case "ConcurrentModificationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                    }
                    case "ResourceNotReadyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotReadyException").httpStatusCode(400).exceptionBuilderSupplier(ResourceNotReadyException::builder).build());
                    }
                    case "ThrottledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ThrottledException").httpStatusCode(429).exceptionBuilderSupplier(ThrottledException::builder).build());
                    }
                    case "AlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AlreadyExistsException").exceptionBuilderSupplier(AlreadyExistsException::builder).build());
                    }
                    case "TransactionCommittedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCommittedException").httpStatusCode(400).exceptionBuilderSupplier(TransactionCommittedException::builder).build());
                    }
                    case "InternalServiceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceException").httpStatusCode(500).exceptionBuilderSupplier(InternalServiceException::builder).build());
                    }
                    case "ResourceNumberLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNumberLimitExceededException").exceptionBuilderSupplier(ResourceNumberLimitExceededException::builder).build());
                    }
                    case "ExpiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ExpiredException").httpStatusCode(410).exceptionBuilderSupplier(ExpiredException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "InvalidInputException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(400).exceptionBuilderSupplier(InvalidInputException::builder).build());
                    }
                    case "EntityNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EntityNotFoundException").exceptionBuilderSupplier(EntityNotFoundException::builder).build());
                    }
                    case "StatisticsNotReadyYetException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("StatisticsNotReadyYetException").httpStatusCode(420).exceptionBuilderSupplier(StatisticsNotReadyYetException::builder).build());
                    }
                    case "TransactionCanceledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCanceledException").httpStatusCode(400).exceptionBuilderSupplier(TransactionCanceledException::builder).build());
                    }
                    case "GlueEncryptionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("GlueEncryptionException").exceptionBuilderSupplier(GlueEncryptionException::builder).build());
                    }
                    case "PermissionTypeMismatchException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PermissionTypeMismatchException").exceptionBuilderSupplier(PermissionTypeMismatchException::builder).build());
                    }
                    case "WorkUnitsNotReadyYetException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WorkUnitsNotReadyYetException").httpStatusCode(420).exceptionBuilderSupplier(WorkUnitsNotReadyYetException::builder).build());
                    }
                    case "OperationTimeoutException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OperationTimeoutException").exceptionBuilderSupplier(OperationTimeoutException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture<ListLfTagExpressionsResponse> executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListLFTagExpressions").withProtocolMetadata(protocolMetadata).withMarshaller(new ListLfTagExpressionsRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector).withInput(listLfTagExpressionsRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((r, e) -> metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect())));
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    @Override
    public CompletableFuture<ListLfTagsResponse> listLFTags(ListLfTagsRequest listLfTagsRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration(listLfTagsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultLakeFormationAsyncClient.resolveMetricPublishers(clientConfiguration, listLfTagsRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "LakeFormation");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListLFTags");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListLfTagsResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "TransactionCommitInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCommitInProgressException").httpStatusCode(400).exceptionBuilderSupplier(TransactionCommitInProgressException::builder).build());
                    }
                    case "ConcurrentModificationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                    }
                    case "ResourceNotReadyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotReadyException").httpStatusCode(400).exceptionBuilderSupplier(ResourceNotReadyException::builder).build());
                    }
                    case "ThrottledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ThrottledException").httpStatusCode(429).exceptionBuilderSupplier(ThrottledException::builder).build());
                    }
                    case "AlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AlreadyExistsException").exceptionBuilderSupplier(AlreadyExistsException::builder).build());
                    }
                    case "TransactionCommittedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCommittedException").httpStatusCode(400).exceptionBuilderSupplier(TransactionCommittedException::builder).build());
                    }
                    case "InternalServiceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceException").httpStatusCode(500).exceptionBuilderSupplier(InternalServiceException::builder).build());
                    }
                    case "ResourceNumberLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNumberLimitExceededException").exceptionBuilderSupplier(ResourceNumberLimitExceededException::builder).build());
                    }
                    case "ExpiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ExpiredException").httpStatusCode(410).exceptionBuilderSupplier(ExpiredException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "InvalidInputException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(400).exceptionBuilderSupplier(InvalidInputException::builder).build());
                    }
                    case "EntityNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EntityNotFoundException").exceptionBuilderSupplier(EntityNotFoundException::builder).build());
                    }
                    case "StatisticsNotReadyYetException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("StatisticsNotReadyYetException").httpStatusCode(420).exceptionBuilderSupplier(StatisticsNotReadyYetException::builder).build());
                    }
                    case "TransactionCanceledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCanceledException").httpStatusCode(400).exceptionBuilderSupplier(TransactionCanceledException::builder).build());
                    }
                    case "GlueEncryptionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("GlueEncryptionException").exceptionBuilderSupplier(GlueEncryptionException::builder).build());
                    }
                    case "PermissionTypeMismatchException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PermissionTypeMismatchException").exceptionBuilderSupplier(PermissionTypeMismatchException::builder).build());
                    }
                    case "WorkUnitsNotReadyYetException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WorkUnitsNotReadyYetException").httpStatusCode(420).exceptionBuilderSupplier(WorkUnitsNotReadyYetException::builder).build());
                    }
                    case "OperationTimeoutException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OperationTimeoutException").exceptionBuilderSupplier(OperationTimeoutException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture<ListLfTagsResponse> executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListLFTags").withProtocolMetadata(protocolMetadata).withMarshaller(new ListLfTagsRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector).withInput(listLfTagsRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((r, e) -> metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect())));
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    @Override
    public CompletableFuture<ListLakeFormationOptInsResponse> listLakeFormationOptIns(ListLakeFormationOptInsRequest listLakeFormationOptInsRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration(listLakeFormationOptInsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultLakeFormationAsyncClient.resolveMetricPublishers(clientConfiguration, listLakeFormationOptInsRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "LakeFormation");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListLakeFormationOptIns");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListLakeFormationOptInsResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "TransactionCommitInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCommitInProgressException").httpStatusCode(400).exceptionBuilderSupplier(TransactionCommitInProgressException::builder).build());
                    }
                    case "ConcurrentModificationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                    }
                    case "ResourceNotReadyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotReadyException").httpStatusCode(400).exceptionBuilderSupplier(ResourceNotReadyException::builder).build());
                    }
                    case "ThrottledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ThrottledException").httpStatusCode(429).exceptionBuilderSupplier(ThrottledException::builder).build());
                    }
                    case "AlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AlreadyExistsException").exceptionBuilderSupplier(AlreadyExistsException::builder).build());
                    }
                    case "TransactionCommittedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCommittedException").httpStatusCode(400).exceptionBuilderSupplier(TransactionCommittedException::builder).build());
                    }
                    case "InternalServiceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceException").httpStatusCode(500).exceptionBuilderSupplier(InternalServiceException::builder).build());
                    }
                    case "ResourceNumberLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNumberLimitExceededException").exceptionBuilderSupplier(ResourceNumberLimitExceededException::builder).build());
                    }
                    case "ExpiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ExpiredException").httpStatusCode(410).exceptionBuilderSupplier(ExpiredException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "InvalidInputException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(400).exceptionBuilderSupplier(InvalidInputException::builder).build());
                    }
                    case "EntityNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EntityNotFoundException").exceptionBuilderSupplier(EntityNotFoundException::builder).build());
                    }
                    case "StatisticsNotReadyYetException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("StatisticsNotReadyYetException").httpStatusCode(420).exceptionBuilderSupplier(StatisticsNotReadyYetException::builder).build());
                    }
                    case "TransactionCanceledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCanceledException").httpStatusCode(400).exceptionBuilderSupplier(TransactionCanceledException::builder).build());
                    }
                    case "GlueEncryptionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("GlueEncryptionException").exceptionBuilderSupplier(GlueEncryptionException::builder).build());
                    }
                    case "PermissionTypeMismatchException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PermissionTypeMismatchException").exceptionBuilderSupplier(PermissionTypeMismatchException::builder).build());
                    }
                    case "WorkUnitsNotReadyYetException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WorkUnitsNotReadyYetException").httpStatusCode(420).exceptionBuilderSupplier(WorkUnitsNotReadyYetException::builder).build());
                    }
                    case "OperationTimeoutException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OperationTimeoutException").exceptionBuilderSupplier(OperationTimeoutException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture<ListLakeFormationOptInsResponse> executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListLakeFormationOptIns").withProtocolMetadata(protocolMetadata).withMarshaller(new ListLakeFormationOptInsRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector).withInput(listLakeFormationOptInsRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((r, e) -> metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect())));
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    @Override
    public CompletableFuture<ListPermissionsResponse> listPermissions(ListPermissionsRequest listPermissionsRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration(listPermissionsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultLakeFormationAsyncClient.resolveMetricPublishers(clientConfiguration, listPermissionsRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "LakeFormation");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListPermissions");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListPermissionsResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "TransactionCommitInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCommitInProgressException").httpStatusCode(400).exceptionBuilderSupplier(TransactionCommitInProgressException::builder).build());
                    }
                    case "ConcurrentModificationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                    }
                    case "ResourceNotReadyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotReadyException").httpStatusCode(400).exceptionBuilderSupplier(ResourceNotReadyException::builder).build());
                    }
                    case "ThrottledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ThrottledException").httpStatusCode(429).exceptionBuilderSupplier(ThrottledException::builder).build());
                    }
                    case "AlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AlreadyExistsException").exceptionBuilderSupplier(AlreadyExistsException::builder).build());
                    }
                    case "TransactionCommittedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCommittedException").httpStatusCode(400).exceptionBuilderSupplier(TransactionCommittedException::builder).build());
                    }
                    case "InternalServiceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceException").httpStatusCode(500).exceptionBuilderSupplier(InternalServiceException::builder).build());
                    }
                    case "ResourceNumberLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNumberLimitExceededException").exceptionBuilderSupplier(ResourceNumberLimitExceededException::builder).build());
                    }
                    case "ExpiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ExpiredException").httpStatusCode(410).exceptionBuilderSupplier(ExpiredException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "InvalidInputException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(400).exceptionBuilderSupplier(InvalidInputException::builder).build());
                    }
                    case "EntityNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EntityNotFoundException").exceptionBuilderSupplier(EntityNotFoundException::builder).build());
                    }
                    case "StatisticsNotReadyYetException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("StatisticsNotReadyYetException").httpStatusCode(420).exceptionBuilderSupplier(StatisticsNotReadyYetException::builder).build());
                    }
                    case "TransactionCanceledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCanceledException").httpStatusCode(400).exceptionBuilderSupplier(TransactionCanceledException::builder).build());
                    }
                    case "GlueEncryptionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("GlueEncryptionException").exceptionBuilderSupplier(GlueEncryptionException::builder).build());
                    }
                    case "PermissionTypeMismatchException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PermissionTypeMismatchException").exceptionBuilderSupplier(PermissionTypeMismatchException::builder).build());
                    }
                    case "WorkUnitsNotReadyYetException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WorkUnitsNotReadyYetException").httpStatusCode(420).exceptionBuilderSupplier(WorkUnitsNotReadyYetException::builder).build());
                    }
                    case "OperationTimeoutException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OperationTimeoutException").exceptionBuilderSupplier(OperationTimeoutException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture<ListPermissionsResponse> executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListPermissions").withProtocolMetadata(protocolMetadata).withMarshaller(new ListPermissionsRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector).withInput(listPermissionsRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((r, e) -> metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect())));
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    @Override
    public CompletableFuture<ListResourcesResponse> listResources(ListResourcesRequest listResourcesRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration(listResourcesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultLakeFormationAsyncClient.resolveMetricPublishers(clientConfiguration, listResourcesRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "LakeFormation");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListResources");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListResourcesResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "TransactionCommitInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCommitInProgressException").httpStatusCode(400).exceptionBuilderSupplier(TransactionCommitInProgressException::builder).build());
                    }
                    case "ConcurrentModificationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                    }
                    case "ResourceNotReadyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotReadyException").httpStatusCode(400).exceptionBuilderSupplier(ResourceNotReadyException::builder).build());
                    }
                    case "ThrottledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ThrottledException").httpStatusCode(429).exceptionBuilderSupplier(ThrottledException::builder).build());
                    }
                    case "AlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AlreadyExistsException").exceptionBuilderSupplier(AlreadyExistsException::builder).build());
                    }
                    case "TransactionCommittedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCommittedException").httpStatusCode(400).exceptionBuilderSupplier(TransactionCommittedException::builder).build());
                    }
                    case "InternalServiceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceException").httpStatusCode(500).exceptionBuilderSupplier(InternalServiceException::builder).build());
                    }
                    case "ResourceNumberLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNumberLimitExceededException").exceptionBuilderSupplier(ResourceNumberLimitExceededException::builder).build());
                    }
                    case "ExpiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ExpiredException").httpStatusCode(410).exceptionBuilderSupplier(ExpiredException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "InvalidInputException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(400).exceptionBuilderSupplier(InvalidInputException::builder).build());
                    }
                    case "EntityNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EntityNotFoundException").exceptionBuilderSupplier(EntityNotFoundException::builder).build());
                    }
                    case "StatisticsNotReadyYetException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("StatisticsNotReadyYetException").httpStatusCode(420).exceptionBuilderSupplier(StatisticsNotReadyYetException::builder).build());
                    }
                    case "TransactionCanceledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCanceledException").httpStatusCode(400).exceptionBuilderSupplier(TransactionCanceledException::builder).build());
                    }
                    case "GlueEncryptionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("GlueEncryptionException").exceptionBuilderSupplier(GlueEncryptionException::builder).build());
                    }
                    case "PermissionTypeMismatchException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PermissionTypeMismatchException").exceptionBuilderSupplier(PermissionTypeMismatchException::builder).build());
                    }
                    case "WorkUnitsNotReadyYetException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WorkUnitsNotReadyYetException").httpStatusCode(420).exceptionBuilderSupplier(WorkUnitsNotReadyYetException::builder).build());
                    }
                    case "OperationTimeoutException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OperationTimeoutException").exceptionBuilderSupplier(OperationTimeoutException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture<ListResourcesResponse> executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListResources").withProtocolMetadata(protocolMetadata).withMarshaller(new ListResourcesRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector).withInput(listResourcesRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((r, e) -> metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect())));
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    @Override
    public CompletableFuture<ListTableStorageOptimizersResponse> listTableStorageOptimizers(ListTableStorageOptimizersRequest listTableStorageOptimizersRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration(listTableStorageOptimizersRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultLakeFormationAsyncClient.resolveMetricPublishers(clientConfiguration, listTableStorageOptimizersRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "LakeFormation");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListTableStorageOptimizers");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListTableStorageOptimizersResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "TransactionCommitInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCommitInProgressException").httpStatusCode(400).exceptionBuilderSupplier(TransactionCommitInProgressException::builder).build());
                    }
                    case "ConcurrentModificationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                    }
                    case "ResourceNotReadyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotReadyException").httpStatusCode(400).exceptionBuilderSupplier(ResourceNotReadyException::builder).build());
                    }
                    case "ThrottledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ThrottledException").httpStatusCode(429).exceptionBuilderSupplier(ThrottledException::builder).build());
                    }
                    case "AlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AlreadyExistsException").exceptionBuilderSupplier(AlreadyExistsException::builder).build());
                    }
                    case "TransactionCommittedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCommittedException").httpStatusCode(400).exceptionBuilderSupplier(TransactionCommittedException::builder).build());
                    }
                    case "InternalServiceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceException").httpStatusCode(500).exceptionBuilderSupplier(InternalServiceException::builder).build());
                    }
                    case "ResourceNumberLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNumberLimitExceededException").exceptionBuilderSupplier(ResourceNumberLimitExceededException::builder).build());
                    }
                    case "ExpiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ExpiredException").httpStatusCode(410).exceptionBuilderSupplier(ExpiredException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "InvalidInputException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(400).exceptionBuilderSupplier(InvalidInputException::builder).build());
                    }
                    case "EntityNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EntityNotFoundException").exceptionBuilderSupplier(EntityNotFoundException::builder).build());
                    }
                    case "StatisticsNotReadyYetException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("StatisticsNotReadyYetException").httpStatusCode(420).exceptionBuilderSupplier(StatisticsNotReadyYetException::builder).build());
                    }
                    case "TransactionCanceledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCanceledException").httpStatusCode(400).exceptionBuilderSupplier(TransactionCanceledException::builder).build());
                    }
                    case "GlueEncryptionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("GlueEncryptionException").exceptionBuilderSupplier(GlueEncryptionException::builder).build());
                    }
                    case "PermissionTypeMismatchException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PermissionTypeMismatchException").exceptionBuilderSupplier(PermissionTypeMismatchException::builder).build());
                    }
                    case "WorkUnitsNotReadyYetException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WorkUnitsNotReadyYetException").httpStatusCode(420).exceptionBuilderSupplier(WorkUnitsNotReadyYetException::builder).build());
                    }
                    case "OperationTimeoutException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OperationTimeoutException").exceptionBuilderSupplier(OperationTimeoutException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture<ListTableStorageOptimizersResponse> executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListTableStorageOptimizers").withProtocolMetadata(protocolMetadata).withMarshaller(new ListTableStorageOptimizersRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector).withInput(listTableStorageOptimizersRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((r, e) -> metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect())));
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    @Override
    public CompletableFuture<ListTransactionsResponse> listTransactions(ListTransactionsRequest listTransactionsRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration(listTransactionsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultLakeFormationAsyncClient.resolveMetricPublishers(clientConfiguration, listTransactionsRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "LakeFormation");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListTransactions");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListTransactionsResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "TransactionCommitInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCommitInProgressException").httpStatusCode(400).exceptionBuilderSupplier(TransactionCommitInProgressException::builder).build());
                    }
                    case "ConcurrentModificationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                    }
                    case "ResourceNotReadyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotReadyException").httpStatusCode(400).exceptionBuilderSupplier(ResourceNotReadyException::builder).build());
                    }
                    case "ThrottledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ThrottledException").httpStatusCode(429).exceptionBuilderSupplier(ThrottledException::builder).build());
                    }
                    case "AlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AlreadyExistsException").exceptionBuilderSupplier(AlreadyExistsException::builder).build());
                    }
                    case "TransactionCommittedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCommittedException").httpStatusCode(400).exceptionBuilderSupplier(TransactionCommittedException::builder).build());
                    }
                    case "InternalServiceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceException").httpStatusCode(500).exceptionBuilderSupplier(InternalServiceException::builder).build());
                    }
                    case "ResourceNumberLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNumberLimitExceededException").exceptionBuilderSupplier(ResourceNumberLimitExceededException::builder).build());
                    }
                    case "ExpiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ExpiredException").httpStatusCode(410).exceptionBuilderSupplier(ExpiredException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "InvalidInputException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(400).exceptionBuilderSupplier(InvalidInputException::builder).build());
                    }
                    case "EntityNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EntityNotFoundException").exceptionBuilderSupplier(EntityNotFoundException::builder).build());
                    }
                    case "StatisticsNotReadyYetException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("StatisticsNotReadyYetException").httpStatusCode(420).exceptionBuilderSupplier(StatisticsNotReadyYetException::builder).build());
                    }
                    case "TransactionCanceledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCanceledException").httpStatusCode(400).exceptionBuilderSupplier(TransactionCanceledException::builder).build());
                    }
                    case "GlueEncryptionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("GlueEncryptionException").exceptionBuilderSupplier(GlueEncryptionException::builder).build());
                    }
                    case "PermissionTypeMismatchException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PermissionTypeMismatchException").exceptionBuilderSupplier(PermissionTypeMismatchException::builder).build());
                    }
                    case "WorkUnitsNotReadyYetException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WorkUnitsNotReadyYetException").httpStatusCode(420).exceptionBuilderSupplier(WorkUnitsNotReadyYetException::builder).build());
                    }
                    case "OperationTimeoutException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OperationTimeoutException").exceptionBuilderSupplier(OperationTimeoutException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture<ListTransactionsResponse> executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListTransactions").withProtocolMetadata(protocolMetadata).withMarshaller(new ListTransactionsRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector).withInput(listTransactionsRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((r, e) -> metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect())));
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    @Override
    public CompletableFuture<PutDataLakeSettingsResponse> putDataLakeSettings(PutDataLakeSettingsRequest putDataLakeSettingsRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration(putDataLakeSettingsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultLakeFormationAsyncClient.resolveMetricPublishers(clientConfiguration, putDataLakeSettingsRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "LakeFormation");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "PutDataLakeSettings");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, PutDataLakeSettingsResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "TransactionCommitInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCommitInProgressException").httpStatusCode(400).exceptionBuilderSupplier(TransactionCommitInProgressException::builder).build());
                    }
                    case "ConcurrentModificationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                    }
                    case "ResourceNotReadyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotReadyException").httpStatusCode(400).exceptionBuilderSupplier(ResourceNotReadyException::builder).build());
                    }
                    case "ThrottledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ThrottledException").httpStatusCode(429).exceptionBuilderSupplier(ThrottledException::builder).build());
                    }
                    case "AlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AlreadyExistsException").exceptionBuilderSupplier(AlreadyExistsException::builder).build());
                    }
                    case "TransactionCommittedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCommittedException").httpStatusCode(400).exceptionBuilderSupplier(TransactionCommittedException::builder).build());
                    }
                    case "InternalServiceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceException").httpStatusCode(500).exceptionBuilderSupplier(InternalServiceException::builder).build());
                    }
                    case "ResourceNumberLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNumberLimitExceededException").exceptionBuilderSupplier(ResourceNumberLimitExceededException::builder).build());
                    }
                    case "ExpiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ExpiredException").httpStatusCode(410).exceptionBuilderSupplier(ExpiredException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "InvalidInputException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(400).exceptionBuilderSupplier(InvalidInputException::builder).build());
                    }
                    case "EntityNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EntityNotFoundException").exceptionBuilderSupplier(EntityNotFoundException::builder).build());
                    }
                    case "StatisticsNotReadyYetException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("StatisticsNotReadyYetException").httpStatusCode(420).exceptionBuilderSupplier(StatisticsNotReadyYetException::builder).build());
                    }
                    case "TransactionCanceledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCanceledException").httpStatusCode(400).exceptionBuilderSupplier(TransactionCanceledException::builder).build());
                    }
                    case "GlueEncryptionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("GlueEncryptionException").exceptionBuilderSupplier(GlueEncryptionException::builder).build());
                    }
                    case "PermissionTypeMismatchException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PermissionTypeMismatchException").exceptionBuilderSupplier(PermissionTypeMismatchException::builder).build());
                    }
                    case "WorkUnitsNotReadyYetException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WorkUnitsNotReadyYetException").httpStatusCode(420).exceptionBuilderSupplier(WorkUnitsNotReadyYetException::builder).build());
                    }
                    case "OperationTimeoutException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OperationTimeoutException").exceptionBuilderSupplier(OperationTimeoutException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture<PutDataLakeSettingsResponse> executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("PutDataLakeSettings").withProtocolMetadata(protocolMetadata).withMarshaller(new PutDataLakeSettingsRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector).withInput(putDataLakeSettingsRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((r, e) -> metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect())));
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    @Override
    public CompletableFuture<RegisterResourceResponse> registerResource(RegisterResourceRequest registerResourceRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration(registerResourceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultLakeFormationAsyncClient.resolveMetricPublishers(clientConfiguration, registerResourceRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "LakeFormation");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "RegisterResource");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, RegisterResourceResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "TransactionCommitInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCommitInProgressException").httpStatusCode(400).exceptionBuilderSupplier(TransactionCommitInProgressException::builder).build());
                    }
                    case "ConcurrentModificationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                    }
                    case "ResourceNotReadyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotReadyException").httpStatusCode(400).exceptionBuilderSupplier(ResourceNotReadyException::builder).build());
                    }
                    case "ThrottledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ThrottledException").httpStatusCode(429).exceptionBuilderSupplier(ThrottledException::builder).build());
                    }
                    case "AlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AlreadyExistsException").exceptionBuilderSupplier(AlreadyExistsException::builder).build());
                    }
                    case "TransactionCommittedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCommittedException").httpStatusCode(400).exceptionBuilderSupplier(TransactionCommittedException::builder).build());
                    }
                    case "InternalServiceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceException").httpStatusCode(500).exceptionBuilderSupplier(InternalServiceException::builder).build());
                    }
                    case "ResourceNumberLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNumberLimitExceededException").exceptionBuilderSupplier(ResourceNumberLimitExceededException::builder).build());
                    }
                    case "ExpiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ExpiredException").httpStatusCode(410).exceptionBuilderSupplier(ExpiredException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "InvalidInputException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(400).exceptionBuilderSupplier(InvalidInputException::builder).build());
                    }
                    case "EntityNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EntityNotFoundException").exceptionBuilderSupplier(EntityNotFoundException::builder).build());
                    }
                    case "StatisticsNotReadyYetException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("StatisticsNotReadyYetException").httpStatusCode(420).exceptionBuilderSupplier(StatisticsNotReadyYetException::builder).build());
                    }
                    case "TransactionCanceledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCanceledException").httpStatusCode(400).exceptionBuilderSupplier(TransactionCanceledException::builder).build());
                    }
                    case "GlueEncryptionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("GlueEncryptionException").exceptionBuilderSupplier(GlueEncryptionException::builder).build());
                    }
                    case "PermissionTypeMismatchException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PermissionTypeMismatchException").exceptionBuilderSupplier(PermissionTypeMismatchException::builder).build());
                    }
                    case "WorkUnitsNotReadyYetException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WorkUnitsNotReadyYetException").httpStatusCode(420).exceptionBuilderSupplier(WorkUnitsNotReadyYetException::builder).build());
                    }
                    case "OperationTimeoutException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OperationTimeoutException").exceptionBuilderSupplier(OperationTimeoutException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture<RegisterResourceResponse> executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("RegisterResource").withProtocolMetadata(protocolMetadata).withMarshaller(new RegisterResourceRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector).withInput(registerResourceRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((r, e) -> metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect())));
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    @Override
    public CompletableFuture<RemoveLfTagsFromResourceResponse> removeLFTagsFromResource(RemoveLfTagsFromResourceRequest removeLfTagsFromResourceRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration(removeLfTagsFromResourceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultLakeFormationAsyncClient.resolveMetricPublishers(clientConfiguration, removeLfTagsFromResourceRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "LakeFormation");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "RemoveLFTagsFromResource");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, RemoveLfTagsFromResourceResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "TransactionCommitInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCommitInProgressException").httpStatusCode(400).exceptionBuilderSupplier(TransactionCommitInProgressException::builder).build());
                    }
                    case "ConcurrentModificationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                    }
                    case "ResourceNotReadyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotReadyException").httpStatusCode(400).exceptionBuilderSupplier(ResourceNotReadyException::builder).build());
                    }
                    case "ThrottledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ThrottledException").httpStatusCode(429).exceptionBuilderSupplier(ThrottledException::builder).build());
                    }
                    case "AlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AlreadyExistsException").exceptionBuilderSupplier(AlreadyExistsException::builder).build());
                    }
                    case "TransactionCommittedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCommittedException").httpStatusCode(400).exceptionBuilderSupplier(TransactionCommittedException::builder).build());
                    }
                    case "InternalServiceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceException").httpStatusCode(500).exceptionBuilderSupplier(InternalServiceException::builder).build());
                    }
                    case "ResourceNumberLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNumberLimitExceededException").exceptionBuilderSupplier(ResourceNumberLimitExceededException::builder).build());
                    }
                    case "ExpiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ExpiredException").httpStatusCode(410).exceptionBuilderSupplier(ExpiredException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "InvalidInputException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(400).exceptionBuilderSupplier(InvalidInputException::builder).build());
                    }
                    case "EntityNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EntityNotFoundException").exceptionBuilderSupplier(EntityNotFoundException::builder).build());
                    }
                    case "StatisticsNotReadyYetException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("StatisticsNotReadyYetException").httpStatusCode(420).exceptionBuilderSupplier(StatisticsNotReadyYetException::builder).build());
                    }
                    case "TransactionCanceledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCanceledException").httpStatusCode(400).exceptionBuilderSupplier(TransactionCanceledException::builder).build());
                    }
                    case "GlueEncryptionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("GlueEncryptionException").exceptionBuilderSupplier(GlueEncryptionException::builder).build());
                    }
                    case "PermissionTypeMismatchException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PermissionTypeMismatchException").exceptionBuilderSupplier(PermissionTypeMismatchException::builder).build());
                    }
                    case "WorkUnitsNotReadyYetException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WorkUnitsNotReadyYetException").httpStatusCode(420).exceptionBuilderSupplier(WorkUnitsNotReadyYetException::builder).build());
                    }
                    case "OperationTimeoutException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OperationTimeoutException").exceptionBuilderSupplier(OperationTimeoutException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture<RemoveLfTagsFromResourceResponse> executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("RemoveLFTagsFromResource").withProtocolMetadata(protocolMetadata).withMarshaller(new RemoveLfTagsFromResourceRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector).withInput(removeLfTagsFromResourceRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((r, e) -> metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect())));
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    @Override
    public CompletableFuture<RevokePermissionsResponse> revokePermissions(RevokePermissionsRequest revokePermissionsRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration(revokePermissionsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultLakeFormationAsyncClient.resolveMetricPublishers(clientConfiguration, revokePermissionsRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "LakeFormation");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "RevokePermissions");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, RevokePermissionsResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "TransactionCommitInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCommitInProgressException").httpStatusCode(400).exceptionBuilderSupplier(TransactionCommitInProgressException::builder).build());
                    }
                    case "ConcurrentModificationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                    }
                    case "ResourceNotReadyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotReadyException").httpStatusCode(400).exceptionBuilderSupplier(ResourceNotReadyException::builder).build());
                    }
                    case "ThrottledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ThrottledException").httpStatusCode(429).exceptionBuilderSupplier(ThrottledException::builder).build());
                    }
                    case "AlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AlreadyExistsException").exceptionBuilderSupplier(AlreadyExistsException::builder).build());
                    }
                    case "TransactionCommittedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCommittedException").httpStatusCode(400).exceptionBuilderSupplier(TransactionCommittedException::builder).build());
                    }
                    case "InternalServiceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceException").httpStatusCode(500).exceptionBuilderSupplier(InternalServiceException::builder).build());
                    }
                    case "ResourceNumberLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNumberLimitExceededException").exceptionBuilderSupplier(ResourceNumberLimitExceededException::builder).build());
                    }
                    case "ExpiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ExpiredException").httpStatusCode(410).exceptionBuilderSupplier(ExpiredException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "InvalidInputException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(400).exceptionBuilderSupplier(InvalidInputException::builder).build());
                    }
                    case "EntityNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EntityNotFoundException").exceptionBuilderSupplier(EntityNotFoundException::builder).build());
                    }
                    case "StatisticsNotReadyYetException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("StatisticsNotReadyYetException").httpStatusCode(420).exceptionBuilderSupplier(StatisticsNotReadyYetException::builder).build());
                    }
                    case "TransactionCanceledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCanceledException").httpStatusCode(400).exceptionBuilderSupplier(TransactionCanceledException::builder).build());
                    }
                    case "GlueEncryptionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("GlueEncryptionException").exceptionBuilderSupplier(GlueEncryptionException::builder).build());
                    }
                    case "PermissionTypeMismatchException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PermissionTypeMismatchException").exceptionBuilderSupplier(PermissionTypeMismatchException::builder).build());
                    }
                    case "WorkUnitsNotReadyYetException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WorkUnitsNotReadyYetException").httpStatusCode(420).exceptionBuilderSupplier(WorkUnitsNotReadyYetException::builder).build());
                    }
                    case "OperationTimeoutException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OperationTimeoutException").exceptionBuilderSupplier(OperationTimeoutException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture<RevokePermissionsResponse> executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("RevokePermissions").withProtocolMetadata(protocolMetadata).withMarshaller(new RevokePermissionsRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector).withInput(revokePermissionsRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((r, e) -> metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect())));
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    @Override
    public CompletableFuture<SearchDatabasesByLfTagsResponse> searchDatabasesByLFTags(SearchDatabasesByLfTagsRequest searchDatabasesByLfTagsRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration(searchDatabasesByLfTagsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultLakeFormationAsyncClient.resolveMetricPublishers(clientConfiguration, searchDatabasesByLfTagsRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "LakeFormation");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "SearchDatabasesByLFTags");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, SearchDatabasesByLfTagsResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "TransactionCommitInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCommitInProgressException").httpStatusCode(400).exceptionBuilderSupplier(TransactionCommitInProgressException::builder).build());
                    }
                    case "ConcurrentModificationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                    }
                    case "ResourceNotReadyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotReadyException").httpStatusCode(400).exceptionBuilderSupplier(ResourceNotReadyException::builder).build());
                    }
                    case "ThrottledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ThrottledException").httpStatusCode(429).exceptionBuilderSupplier(ThrottledException::builder).build());
                    }
                    case "AlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AlreadyExistsException").exceptionBuilderSupplier(AlreadyExistsException::builder).build());
                    }
                    case "TransactionCommittedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCommittedException").httpStatusCode(400).exceptionBuilderSupplier(TransactionCommittedException::builder).build());
                    }
                    case "InternalServiceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceException").httpStatusCode(500).exceptionBuilderSupplier(InternalServiceException::builder).build());
                    }
                    case "ResourceNumberLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNumberLimitExceededException").exceptionBuilderSupplier(ResourceNumberLimitExceededException::builder).build());
                    }
                    case "ExpiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ExpiredException").httpStatusCode(410).exceptionBuilderSupplier(ExpiredException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "InvalidInputException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(400).exceptionBuilderSupplier(InvalidInputException::builder).build());
                    }
                    case "EntityNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EntityNotFoundException").exceptionBuilderSupplier(EntityNotFoundException::builder).build());
                    }
                    case "StatisticsNotReadyYetException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("StatisticsNotReadyYetException").httpStatusCode(420).exceptionBuilderSupplier(StatisticsNotReadyYetException::builder).build());
                    }
                    case "TransactionCanceledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCanceledException").httpStatusCode(400).exceptionBuilderSupplier(TransactionCanceledException::builder).build());
                    }
                    case "GlueEncryptionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("GlueEncryptionException").exceptionBuilderSupplier(GlueEncryptionException::builder).build());
                    }
                    case "PermissionTypeMismatchException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PermissionTypeMismatchException").exceptionBuilderSupplier(PermissionTypeMismatchException::builder).build());
                    }
                    case "WorkUnitsNotReadyYetException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WorkUnitsNotReadyYetException").httpStatusCode(420).exceptionBuilderSupplier(WorkUnitsNotReadyYetException::builder).build());
                    }
                    case "OperationTimeoutException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OperationTimeoutException").exceptionBuilderSupplier(OperationTimeoutException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture<SearchDatabasesByLfTagsResponse> executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("SearchDatabasesByLFTags").withProtocolMetadata(protocolMetadata).withMarshaller(new SearchDatabasesByLfTagsRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector).withInput(searchDatabasesByLfTagsRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((r, e) -> metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect())));
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    @Override
    public CompletableFuture<SearchTablesByLfTagsResponse> searchTablesByLFTags(SearchTablesByLfTagsRequest searchTablesByLfTagsRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration(searchTablesByLfTagsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultLakeFormationAsyncClient.resolveMetricPublishers(clientConfiguration, searchTablesByLfTagsRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "LakeFormation");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "SearchTablesByLFTags");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, SearchTablesByLfTagsResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "TransactionCommitInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCommitInProgressException").httpStatusCode(400).exceptionBuilderSupplier(TransactionCommitInProgressException::builder).build());
                    }
                    case "ConcurrentModificationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                    }
                    case "ResourceNotReadyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotReadyException").httpStatusCode(400).exceptionBuilderSupplier(ResourceNotReadyException::builder).build());
                    }
                    case "ThrottledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ThrottledException").httpStatusCode(429).exceptionBuilderSupplier(ThrottledException::builder).build());
                    }
                    case "AlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AlreadyExistsException").exceptionBuilderSupplier(AlreadyExistsException::builder).build());
                    }
                    case "TransactionCommittedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCommittedException").httpStatusCode(400).exceptionBuilderSupplier(TransactionCommittedException::builder).build());
                    }
                    case "InternalServiceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceException").httpStatusCode(500).exceptionBuilderSupplier(InternalServiceException::builder).build());
                    }
                    case "ResourceNumberLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNumberLimitExceededException").exceptionBuilderSupplier(ResourceNumberLimitExceededException::builder).build());
                    }
                    case "ExpiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ExpiredException").httpStatusCode(410).exceptionBuilderSupplier(ExpiredException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "InvalidInputException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(400).exceptionBuilderSupplier(InvalidInputException::builder).build());
                    }
                    case "EntityNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EntityNotFoundException").exceptionBuilderSupplier(EntityNotFoundException::builder).build());
                    }
                    case "StatisticsNotReadyYetException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("StatisticsNotReadyYetException").httpStatusCode(420).exceptionBuilderSupplier(StatisticsNotReadyYetException::builder).build());
                    }
                    case "TransactionCanceledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCanceledException").httpStatusCode(400).exceptionBuilderSupplier(TransactionCanceledException::builder).build());
                    }
                    case "GlueEncryptionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("GlueEncryptionException").exceptionBuilderSupplier(GlueEncryptionException::builder).build());
                    }
                    case "PermissionTypeMismatchException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PermissionTypeMismatchException").exceptionBuilderSupplier(PermissionTypeMismatchException::builder).build());
                    }
                    case "WorkUnitsNotReadyYetException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WorkUnitsNotReadyYetException").httpStatusCode(420).exceptionBuilderSupplier(WorkUnitsNotReadyYetException::builder).build());
                    }
                    case "OperationTimeoutException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OperationTimeoutException").exceptionBuilderSupplier(OperationTimeoutException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture<SearchTablesByLfTagsResponse> executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("SearchTablesByLFTags").withProtocolMetadata(protocolMetadata).withMarshaller(new SearchTablesByLfTagsRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector).withInput(searchTablesByLfTagsRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((r, e) -> metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect())));
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    @Override
    public CompletableFuture<StartQueryPlanningResponse> startQueryPlanning(StartQueryPlanningRequest startQueryPlanningRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration(startQueryPlanningRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultLakeFormationAsyncClient.resolveMetricPublishers(clientConfiguration, startQueryPlanningRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "LakeFormation");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "StartQueryPlanning");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, StartQueryPlanningResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "TransactionCommitInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCommitInProgressException").httpStatusCode(400).exceptionBuilderSupplier(TransactionCommitInProgressException::builder).build());
                    }
                    case "ConcurrentModificationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                    }
                    case "ResourceNotReadyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotReadyException").httpStatusCode(400).exceptionBuilderSupplier(ResourceNotReadyException::builder).build());
                    }
                    case "ThrottledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ThrottledException").httpStatusCode(429).exceptionBuilderSupplier(ThrottledException::builder).build());
                    }
                    case "AlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AlreadyExistsException").exceptionBuilderSupplier(AlreadyExistsException::builder).build());
                    }
                    case "TransactionCommittedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCommittedException").httpStatusCode(400).exceptionBuilderSupplier(TransactionCommittedException::builder).build());
                    }
                    case "InternalServiceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceException").httpStatusCode(500).exceptionBuilderSupplier(InternalServiceException::builder).build());
                    }
                    case "ResourceNumberLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNumberLimitExceededException").exceptionBuilderSupplier(ResourceNumberLimitExceededException::builder).build());
                    }
                    case "ExpiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ExpiredException").httpStatusCode(410).exceptionBuilderSupplier(ExpiredException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "InvalidInputException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(400).exceptionBuilderSupplier(InvalidInputException::builder).build());
                    }
                    case "EntityNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EntityNotFoundException").exceptionBuilderSupplier(EntityNotFoundException::builder).build());
                    }
                    case "StatisticsNotReadyYetException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("StatisticsNotReadyYetException").httpStatusCode(420).exceptionBuilderSupplier(StatisticsNotReadyYetException::builder).build());
                    }
                    case "TransactionCanceledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCanceledException").httpStatusCode(400).exceptionBuilderSupplier(TransactionCanceledException::builder).build());
                    }
                    case "GlueEncryptionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("GlueEncryptionException").exceptionBuilderSupplier(GlueEncryptionException::builder).build());
                    }
                    case "PermissionTypeMismatchException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PermissionTypeMismatchException").exceptionBuilderSupplier(PermissionTypeMismatchException::builder).build());
                    }
                    case "WorkUnitsNotReadyYetException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WorkUnitsNotReadyYetException").httpStatusCode(420).exceptionBuilderSupplier(WorkUnitsNotReadyYetException::builder).build());
                    }
                    case "OperationTimeoutException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OperationTimeoutException").exceptionBuilderSupplier(OperationTimeoutException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            String hostPrefix = "query-";
            String resolvedHostExpression = "query-";
            CompletableFuture<StartQueryPlanningResponse> executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("StartQueryPlanning").withProtocolMetadata(protocolMetadata).withMarshaller(new StartQueryPlanningRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector).hostPrefixExpression(resolvedHostExpression).withInput(startQueryPlanningRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((r, e) -> metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect())));
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    @Override
    public CompletableFuture<StartTransactionResponse> startTransaction(StartTransactionRequest startTransactionRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration(startTransactionRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultLakeFormationAsyncClient.resolveMetricPublishers(clientConfiguration, startTransactionRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "LakeFormation");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "StartTransaction");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, StartTransactionResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "TransactionCommitInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCommitInProgressException").httpStatusCode(400).exceptionBuilderSupplier(TransactionCommitInProgressException::builder).build());
                    }
                    case "ConcurrentModificationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                    }
                    case "ResourceNotReadyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotReadyException").httpStatusCode(400).exceptionBuilderSupplier(ResourceNotReadyException::builder).build());
                    }
                    case "ThrottledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ThrottledException").httpStatusCode(429).exceptionBuilderSupplier(ThrottledException::builder).build());
                    }
                    case "AlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AlreadyExistsException").exceptionBuilderSupplier(AlreadyExistsException::builder).build());
                    }
                    case "TransactionCommittedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCommittedException").httpStatusCode(400).exceptionBuilderSupplier(TransactionCommittedException::builder).build());
                    }
                    case "InternalServiceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceException").httpStatusCode(500).exceptionBuilderSupplier(InternalServiceException::builder).build());
                    }
                    case "ResourceNumberLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNumberLimitExceededException").exceptionBuilderSupplier(ResourceNumberLimitExceededException::builder).build());
                    }
                    case "ExpiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ExpiredException").httpStatusCode(410).exceptionBuilderSupplier(ExpiredException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "InvalidInputException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(400).exceptionBuilderSupplier(InvalidInputException::builder).build());
                    }
                    case "EntityNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EntityNotFoundException").exceptionBuilderSupplier(EntityNotFoundException::builder).build());
                    }
                    case "StatisticsNotReadyYetException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("StatisticsNotReadyYetException").httpStatusCode(420).exceptionBuilderSupplier(StatisticsNotReadyYetException::builder).build());
                    }
                    case "TransactionCanceledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCanceledException").httpStatusCode(400).exceptionBuilderSupplier(TransactionCanceledException::builder).build());
                    }
                    case "GlueEncryptionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("GlueEncryptionException").exceptionBuilderSupplier(GlueEncryptionException::builder).build());
                    }
                    case "PermissionTypeMismatchException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PermissionTypeMismatchException").exceptionBuilderSupplier(PermissionTypeMismatchException::builder).build());
                    }
                    case "WorkUnitsNotReadyYetException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WorkUnitsNotReadyYetException").httpStatusCode(420).exceptionBuilderSupplier(WorkUnitsNotReadyYetException::builder).build());
                    }
                    case "OperationTimeoutException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OperationTimeoutException").exceptionBuilderSupplier(OperationTimeoutException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture<StartTransactionResponse> executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("StartTransaction").withProtocolMetadata(protocolMetadata).withMarshaller(new StartTransactionRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector).withInput(startTransactionRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((r, e) -> metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect())));
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    @Override
    public CompletableFuture<UpdateDataCellsFilterResponse> updateDataCellsFilter(UpdateDataCellsFilterRequest updateDataCellsFilterRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration(updateDataCellsFilterRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultLakeFormationAsyncClient.resolveMetricPublishers(clientConfiguration, updateDataCellsFilterRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "LakeFormation");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateDataCellsFilter");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateDataCellsFilterResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "TransactionCommitInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCommitInProgressException").httpStatusCode(400).exceptionBuilderSupplier(TransactionCommitInProgressException::builder).build());
                    }
                    case "ConcurrentModificationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                    }
                    case "ResourceNotReadyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotReadyException").httpStatusCode(400).exceptionBuilderSupplier(ResourceNotReadyException::builder).build());
                    }
                    case "ThrottledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ThrottledException").httpStatusCode(429).exceptionBuilderSupplier(ThrottledException::builder).build());
                    }
                    case "AlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AlreadyExistsException").exceptionBuilderSupplier(AlreadyExistsException::builder).build());
                    }
                    case "TransactionCommittedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCommittedException").httpStatusCode(400).exceptionBuilderSupplier(TransactionCommittedException::builder).build());
                    }
                    case "InternalServiceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceException").httpStatusCode(500).exceptionBuilderSupplier(InternalServiceException::builder).build());
                    }
                    case "ResourceNumberLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNumberLimitExceededException").exceptionBuilderSupplier(ResourceNumberLimitExceededException::builder).build());
                    }
                    case "ExpiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ExpiredException").httpStatusCode(410).exceptionBuilderSupplier(ExpiredException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "InvalidInputException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(400).exceptionBuilderSupplier(InvalidInputException::builder).build());
                    }
                    case "EntityNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EntityNotFoundException").exceptionBuilderSupplier(EntityNotFoundException::builder).build());
                    }
                    case "StatisticsNotReadyYetException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("StatisticsNotReadyYetException").httpStatusCode(420).exceptionBuilderSupplier(StatisticsNotReadyYetException::builder).build());
                    }
                    case "TransactionCanceledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCanceledException").httpStatusCode(400).exceptionBuilderSupplier(TransactionCanceledException::builder).build());
                    }
                    case "GlueEncryptionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("GlueEncryptionException").exceptionBuilderSupplier(GlueEncryptionException::builder).build());
                    }
                    case "PermissionTypeMismatchException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PermissionTypeMismatchException").exceptionBuilderSupplier(PermissionTypeMismatchException::builder).build());
                    }
                    case "WorkUnitsNotReadyYetException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WorkUnitsNotReadyYetException").httpStatusCode(420).exceptionBuilderSupplier(WorkUnitsNotReadyYetException::builder).build());
                    }
                    case "OperationTimeoutException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OperationTimeoutException").exceptionBuilderSupplier(OperationTimeoutException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture<UpdateDataCellsFilterResponse> executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateDataCellsFilter").withProtocolMetadata(protocolMetadata).withMarshaller(new UpdateDataCellsFilterRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector).withInput(updateDataCellsFilterRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((r, e) -> metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect())));
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    @Override
    public CompletableFuture<UpdateLfTagResponse> updateLFTag(UpdateLfTagRequest updateLfTagRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration(updateLfTagRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultLakeFormationAsyncClient.resolveMetricPublishers(clientConfiguration, updateLfTagRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "LakeFormation");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateLFTag");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateLfTagResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "TransactionCommitInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCommitInProgressException").httpStatusCode(400).exceptionBuilderSupplier(TransactionCommitInProgressException::builder).build());
                    }
                    case "ConcurrentModificationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                    }
                    case "ResourceNotReadyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotReadyException").httpStatusCode(400).exceptionBuilderSupplier(ResourceNotReadyException::builder).build());
                    }
                    case "ThrottledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ThrottledException").httpStatusCode(429).exceptionBuilderSupplier(ThrottledException::builder).build());
                    }
                    case "AlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AlreadyExistsException").exceptionBuilderSupplier(AlreadyExistsException::builder).build());
                    }
                    case "TransactionCommittedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCommittedException").httpStatusCode(400).exceptionBuilderSupplier(TransactionCommittedException::builder).build());
                    }
                    case "InternalServiceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceException").httpStatusCode(500).exceptionBuilderSupplier(InternalServiceException::builder).build());
                    }
                    case "ResourceNumberLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNumberLimitExceededException").exceptionBuilderSupplier(ResourceNumberLimitExceededException::builder).build());
                    }
                    case "ExpiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ExpiredException").httpStatusCode(410).exceptionBuilderSupplier(ExpiredException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "InvalidInputException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(400).exceptionBuilderSupplier(InvalidInputException::builder).build());
                    }
                    case "EntityNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EntityNotFoundException").exceptionBuilderSupplier(EntityNotFoundException::builder).build());
                    }
                    case "StatisticsNotReadyYetException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("StatisticsNotReadyYetException").httpStatusCode(420).exceptionBuilderSupplier(StatisticsNotReadyYetException::builder).build());
                    }
                    case "TransactionCanceledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCanceledException").httpStatusCode(400).exceptionBuilderSupplier(TransactionCanceledException::builder).build());
                    }
                    case "GlueEncryptionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("GlueEncryptionException").exceptionBuilderSupplier(GlueEncryptionException::builder).build());
                    }
                    case "PermissionTypeMismatchException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PermissionTypeMismatchException").exceptionBuilderSupplier(PermissionTypeMismatchException::builder).build());
                    }
                    case "WorkUnitsNotReadyYetException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WorkUnitsNotReadyYetException").httpStatusCode(420).exceptionBuilderSupplier(WorkUnitsNotReadyYetException::builder).build());
                    }
                    case "OperationTimeoutException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OperationTimeoutException").exceptionBuilderSupplier(OperationTimeoutException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture<UpdateLfTagResponse> executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateLFTag").withProtocolMetadata(protocolMetadata).withMarshaller(new UpdateLfTagRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector).withInput(updateLfTagRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((r, e) -> metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect())));
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    @Override
    public CompletableFuture<UpdateLfTagExpressionResponse> updateLFTagExpression(UpdateLfTagExpressionRequest updateLfTagExpressionRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration(updateLfTagExpressionRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultLakeFormationAsyncClient.resolveMetricPublishers(clientConfiguration, updateLfTagExpressionRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "LakeFormation");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateLFTagExpression");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateLfTagExpressionResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "TransactionCommitInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCommitInProgressException").httpStatusCode(400).exceptionBuilderSupplier(TransactionCommitInProgressException::builder).build());
                    }
                    case "ConcurrentModificationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                    }
                    case "ResourceNotReadyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotReadyException").httpStatusCode(400).exceptionBuilderSupplier(ResourceNotReadyException::builder).build());
                    }
                    case "ThrottledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ThrottledException").httpStatusCode(429).exceptionBuilderSupplier(ThrottledException::builder).build());
                    }
                    case "AlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AlreadyExistsException").exceptionBuilderSupplier(AlreadyExistsException::builder).build());
                    }
                    case "TransactionCommittedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCommittedException").httpStatusCode(400).exceptionBuilderSupplier(TransactionCommittedException::builder).build());
                    }
                    case "InternalServiceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceException").httpStatusCode(500).exceptionBuilderSupplier(InternalServiceException::builder).build());
                    }
                    case "ResourceNumberLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNumberLimitExceededException").exceptionBuilderSupplier(ResourceNumberLimitExceededException::builder).build());
                    }
                    case "ExpiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ExpiredException").httpStatusCode(410).exceptionBuilderSupplier(ExpiredException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "InvalidInputException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(400).exceptionBuilderSupplier(InvalidInputException::builder).build());
                    }
                    case "EntityNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EntityNotFoundException").exceptionBuilderSupplier(EntityNotFoundException::builder).build());
                    }
                    case "StatisticsNotReadyYetException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("StatisticsNotReadyYetException").httpStatusCode(420).exceptionBuilderSupplier(StatisticsNotReadyYetException::builder).build());
                    }
                    case "TransactionCanceledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCanceledException").httpStatusCode(400).exceptionBuilderSupplier(TransactionCanceledException::builder).build());
                    }
                    case "GlueEncryptionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("GlueEncryptionException").exceptionBuilderSupplier(GlueEncryptionException::builder).build());
                    }
                    case "PermissionTypeMismatchException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PermissionTypeMismatchException").exceptionBuilderSupplier(PermissionTypeMismatchException::builder).build());
                    }
                    case "WorkUnitsNotReadyYetException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WorkUnitsNotReadyYetException").httpStatusCode(420).exceptionBuilderSupplier(WorkUnitsNotReadyYetException::builder).build());
                    }
                    case "OperationTimeoutException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OperationTimeoutException").exceptionBuilderSupplier(OperationTimeoutException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture<UpdateLfTagExpressionResponse> executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateLFTagExpression").withProtocolMetadata(protocolMetadata).withMarshaller(new UpdateLfTagExpressionRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector).withInput(updateLfTagExpressionRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((r, e) -> metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect())));
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    @Override
    public CompletableFuture<UpdateLakeFormationIdentityCenterConfigurationResponse> updateLakeFormationIdentityCenterConfiguration(UpdateLakeFormationIdentityCenterConfigurationRequest updateLakeFormationIdentityCenterConfigurationRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration(updateLakeFormationIdentityCenterConfigurationRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultLakeFormationAsyncClient.resolveMetricPublishers(clientConfiguration, updateLakeFormationIdentityCenterConfigurationRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "LakeFormation");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateLakeFormationIdentityCenterConfiguration");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateLakeFormationIdentityCenterConfigurationResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "TransactionCommitInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCommitInProgressException").httpStatusCode(400).exceptionBuilderSupplier(TransactionCommitInProgressException::builder).build());
                    }
                    case "ConcurrentModificationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                    }
                    case "ResourceNotReadyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotReadyException").httpStatusCode(400).exceptionBuilderSupplier(ResourceNotReadyException::builder).build());
                    }
                    case "ThrottledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ThrottledException").httpStatusCode(429).exceptionBuilderSupplier(ThrottledException::builder).build());
                    }
                    case "AlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AlreadyExistsException").exceptionBuilderSupplier(AlreadyExistsException::builder).build());
                    }
                    case "TransactionCommittedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCommittedException").httpStatusCode(400).exceptionBuilderSupplier(TransactionCommittedException::builder).build());
                    }
                    case "InternalServiceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceException").httpStatusCode(500).exceptionBuilderSupplier(InternalServiceException::builder).build());
                    }
                    case "ResourceNumberLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNumberLimitExceededException").exceptionBuilderSupplier(ResourceNumberLimitExceededException::builder).build());
                    }
                    case "ExpiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ExpiredException").httpStatusCode(410).exceptionBuilderSupplier(ExpiredException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "InvalidInputException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(400).exceptionBuilderSupplier(InvalidInputException::builder).build());
                    }
                    case "EntityNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EntityNotFoundException").exceptionBuilderSupplier(EntityNotFoundException::builder).build());
                    }
                    case "StatisticsNotReadyYetException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("StatisticsNotReadyYetException").httpStatusCode(420).exceptionBuilderSupplier(StatisticsNotReadyYetException::builder).build());
                    }
                    case "TransactionCanceledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCanceledException").httpStatusCode(400).exceptionBuilderSupplier(TransactionCanceledException::builder).build());
                    }
                    case "GlueEncryptionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("GlueEncryptionException").exceptionBuilderSupplier(GlueEncryptionException::builder).build());
                    }
                    case "PermissionTypeMismatchException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PermissionTypeMismatchException").exceptionBuilderSupplier(PermissionTypeMismatchException::builder).build());
                    }
                    case "WorkUnitsNotReadyYetException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WorkUnitsNotReadyYetException").httpStatusCode(420).exceptionBuilderSupplier(WorkUnitsNotReadyYetException::builder).build());
                    }
                    case "OperationTimeoutException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OperationTimeoutException").exceptionBuilderSupplier(OperationTimeoutException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture<UpdateLakeFormationIdentityCenterConfigurationResponse> executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateLakeFormationIdentityCenterConfiguration").withProtocolMetadata(protocolMetadata).withMarshaller(new UpdateLakeFormationIdentityCenterConfigurationRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector).withInput(updateLakeFormationIdentityCenterConfigurationRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((r, e) -> metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect())));
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    @Override
    public CompletableFuture<UpdateResourceResponse> updateResource(UpdateResourceRequest updateResourceRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration(updateResourceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultLakeFormationAsyncClient.resolveMetricPublishers(clientConfiguration, updateResourceRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "LakeFormation");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateResource");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateResourceResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "TransactionCommitInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCommitInProgressException").httpStatusCode(400).exceptionBuilderSupplier(TransactionCommitInProgressException::builder).build());
                    }
                    case "ConcurrentModificationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                    }
                    case "ResourceNotReadyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotReadyException").httpStatusCode(400).exceptionBuilderSupplier(ResourceNotReadyException::builder).build());
                    }
                    case "ThrottledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ThrottledException").httpStatusCode(429).exceptionBuilderSupplier(ThrottledException::builder).build());
                    }
                    case "AlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AlreadyExistsException").exceptionBuilderSupplier(AlreadyExistsException::builder).build());
                    }
                    case "TransactionCommittedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCommittedException").httpStatusCode(400).exceptionBuilderSupplier(TransactionCommittedException::builder).build());
                    }
                    case "InternalServiceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceException").httpStatusCode(500).exceptionBuilderSupplier(InternalServiceException::builder).build());
                    }
                    case "ResourceNumberLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNumberLimitExceededException").exceptionBuilderSupplier(ResourceNumberLimitExceededException::builder).build());
                    }
                    case "ExpiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ExpiredException").httpStatusCode(410).exceptionBuilderSupplier(ExpiredException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "InvalidInputException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(400).exceptionBuilderSupplier(InvalidInputException::builder).build());
                    }
                    case "EntityNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EntityNotFoundException").exceptionBuilderSupplier(EntityNotFoundException::builder).build());
                    }
                    case "StatisticsNotReadyYetException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("StatisticsNotReadyYetException").httpStatusCode(420).exceptionBuilderSupplier(StatisticsNotReadyYetException::builder).build());
                    }
                    case "TransactionCanceledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCanceledException").httpStatusCode(400).exceptionBuilderSupplier(TransactionCanceledException::builder).build());
                    }
                    case "GlueEncryptionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("GlueEncryptionException").exceptionBuilderSupplier(GlueEncryptionException::builder).build());
                    }
                    case "PermissionTypeMismatchException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PermissionTypeMismatchException").exceptionBuilderSupplier(PermissionTypeMismatchException::builder).build());
                    }
                    case "WorkUnitsNotReadyYetException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WorkUnitsNotReadyYetException").httpStatusCode(420).exceptionBuilderSupplier(WorkUnitsNotReadyYetException::builder).build());
                    }
                    case "OperationTimeoutException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OperationTimeoutException").exceptionBuilderSupplier(OperationTimeoutException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture<UpdateResourceResponse> executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateResource").withProtocolMetadata(protocolMetadata).withMarshaller(new UpdateResourceRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector).withInput(updateResourceRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((r, e) -> metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect())));
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    @Override
    public CompletableFuture<UpdateTableObjectsResponse> updateTableObjects(UpdateTableObjectsRequest updateTableObjectsRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration(updateTableObjectsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultLakeFormationAsyncClient.resolveMetricPublishers(clientConfiguration, updateTableObjectsRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "LakeFormation");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateTableObjects");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateTableObjectsResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "TransactionCommitInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCommitInProgressException").httpStatusCode(400).exceptionBuilderSupplier(TransactionCommitInProgressException::builder).build());
                    }
                    case "ConcurrentModificationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                    }
                    case "ResourceNotReadyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotReadyException").httpStatusCode(400).exceptionBuilderSupplier(ResourceNotReadyException::builder).build());
                    }
                    case "ThrottledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ThrottledException").httpStatusCode(429).exceptionBuilderSupplier(ThrottledException::builder).build());
                    }
                    case "AlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AlreadyExistsException").exceptionBuilderSupplier(AlreadyExistsException::builder).build());
                    }
                    case "TransactionCommittedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCommittedException").httpStatusCode(400).exceptionBuilderSupplier(TransactionCommittedException::builder).build());
                    }
                    case "InternalServiceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceException").httpStatusCode(500).exceptionBuilderSupplier(InternalServiceException::builder).build());
                    }
                    case "ResourceNumberLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNumberLimitExceededException").exceptionBuilderSupplier(ResourceNumberLimitExceededException::builder).build());
                    }
                    case "ExpiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ExpiredException").httpStatusCode(410).exceptionBuilderSupplier(ExpiredException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "InvalidInputException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(400).exceptionBuilderSupplier(InvalidInputException::builder).build());
                    }
                    case "EntityNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EntityNotFoundException").exceptionBuilderSupplier(EntityNotFoundException::builder).build());
                    }
                    case "StatisticsNotReadyYetException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("StatisticsNotReadyYetException").httpStatusCode(420).exceptionBuilderSupplier(StatisticsNotReadyYetException::builder).build());
                    }
                    case "TransactionCanceledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCanceledException").httpStatusCode(400).exceptionBuilderSupplier(TransactionCanceledException::builder).build());
                    }
                    case "GlueEncryptionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("GlueEncryptionException").exceptionBuilderSupplier(GlueEncryptionException::builder).build());
                    }
                    case "PermissionTypeMismatchException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PermissionTypeMismatchException").exceptionBuilderSupplier(PermissionTypeMismatchException::builder).build());
                    }
                    case "WorkUnitsNotReadyYetException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WorkUnitsNotReadyYetException").httpStatusCode(420).exceptionBuilderSupplier(WorkUnitsNotReadyYetException::builder).build());
                    }
                    case "OperationTimeoutException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OperationTimeoutException").exceptionBuilderSupplier(OperationTimeoutException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture<UpdateTableObjectsResponse> executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateTableObjects").withProtocolMetadata(protocolMetadata).withMarshaller(new UpdateTableObjectsRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector).withInput(updateTableObjectsRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((r, e) -> metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect())));
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    @Override
    public CompletableFuture<UpdateTableStorageOptimizerResponse> updateTableStorageOptimizer(UpdateTableStorageOptimizerRequest updateTableStorageOptimizerRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration(updateTableStorageOptimizerRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultLakeFormationAsyncClient.resolveMetricPublishers(clientConfiguration, updateTableStorageOptimizerRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "LakeFormation");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateTableStorageOptimizer");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateTableStorageOptimizerResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "TransactionCommitInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCommitInProgressException").httpStatusCode(400).exceptionBuilderSupplier(TransactionCommitInProgressException::builder).build());
                    }
                    case "ConcurrentModificationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                    }
                    case "ResourceNotReadyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotReadyException").httpStatusCode(400).exceptionBuilderSupplier(ResourceNotReadyException::builder).build());
                    }
                    case "ThrottledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ThrottledException").httpStatusCode(429).exceptionBuilderSupplier(ThrottledException::builder).build());
                    }
                    case "AlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AlreadyExistsException").exceptionBuilderSupplier(AlreadyExistsException::builder).build());
                    }
                    case "TransactionCommittedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCommittedException").httpStatusCode(400).exceptionBuilderSupplier(TransactionCommittedException::builder).build());
                    }
                    case "InternalServiceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceException").httpStatusCode(500).exceptionBuilderSupplier(InternalServiceException::builder).build());
                    }
                    case "ResourceNumberLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNumberLimitExceededException").exceptionBuilderSupplier(ResourceNumberLimitExceededException::builder).build());
                    }
                    case "ExpiredException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ExpiredException").httpStatusCode(410).exceptionBuilderSupplier(ExpiredException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "InvalidInputException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInputException").httpStatusCode(400).exceptionBuilderSupplier(InvalidInputException::builder).build());
                    }
                    case "EntityNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EntityNotFoundException").exceptionBuilderSupplier(EntityNotFoundException::builder).build());
                    }
                    case "StatisticsNotReadyYetException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("StatisticsNotReadyYetException").httpStatusCode(420).exceptionBuilderSupplier(StatisticsNotReadyYetException::builder).build());
                    }
                    case "TransactionCanceledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCanceledException").httpStatusCode(400).exceptionBuilderSupplier(TransactionCanceledException::builder).build());
                    }
                    case "GlueEncryptionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("GlueEncryptionException").exceptionBuilderSupplier(GlueEncryptionException::builder).build());
                    }
                    case "PermissionTypeMismatchException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PermissionTypeMismatchException").exceptionBuilderSupplier(PermissionTypeMismatchException::builder).build());
                    }
                    case "WorkUnitsNotReadyYetException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("WorkUnitsNotReadyYetException").httpStatusCode(420).exceptionBuilderSupplier(WorkUnitsNotReadyYetException::builder).build());
                    }
                    case "OperationTimeoutException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OperationTimeoutException").exceptionBuilderSupplier(OperationTimeoutException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture<UpdateTableStorageOptimizerResponse> executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateTableStorageOptimizer").withProtocolMetadata(protocolMetadata).withMarshaller(new UpdateTableStorageOptimizerRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector).withInput(updateTableStorageOptimizerRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((r, e) -> metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect())));
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    @Override
    public final LakeFormationServiceClientConfiguration serviceClientConfiguration() {
        return new LakeFormationServiceClientConfigurationBuilder(this.clientConfiguration.toBuilder()).build();
    }

    @Override
    public final String serviceName() {
        return "lakeformation";
    }

    private <T extends BaseAwsJsonProtocolFactory.Builder<T>> T init(T builder) {
        return ((BaseAwsJsonProtocolFactory.Builder)((BaseAwsJsonProtocolFactory.Builder)((BaseAwsJsonProtocolFactory.Builder)builder.clientConfiguration(this.clientConfiguration)).defaultServiceExceptionSupplier(LakeFormationException::builder)).protocol(AwsJsonProtocol.REST_JSON)).protocolVersion("1.1");
    }

    private static List<MetricPublisher> resolveMetricPublishers(SdkClientConfiguration clientConfiguration, RequestOverrideConfiguration requestOverrideConfiguration) {
        List<MetricPublisher> publishers = null;
        if (requestOverrideConfiguration != null) {
            publishers = requestOverrideConfiguration.metricPublishers();
        }
        if (publishers == null || publishers.isEmpty()) {
            publishers = clientConfiguration.option(SdkClientOption.METRIC_PUBLISHERS);
        }
        if (publishers == null) {
            publishers = Collections.emptyList();
        }
        return publishers;
    }

    private void updateRetryStrategyClientConfiguration(SdkClientConfiguration.Builder configuration) {
        ClientOverrideConfiguration.Builder builder = configuration.asOverrideConfigurationBuilder();
        RetryMode retryMode = builder.retryMode();
        if (retryMode != null) {
            configuration.option(SdkClientOption.RETRY_STRATEGY, AwsRetryStrategy.forRetryMode(retryMode));
        } else {
            Consumer<RetryStrategy.Builder<?, ?>> configurator = builder.retryStrategyConfigurator();
            if (configurator != null) {
                RetryStrategy.Builder<?, ?> defaultBuilder = AwsRetryStrategy.defaultRetryStrategy().toBuilder();
                configurator.accept(defaultBuilder);
                configuration.option(SdkClientOption.RETRY_STRATEGY, defaultBuilder.build());
            } else {
                RetryStrategy retryStrategy = builder.retryStrategy();
                if (retryStrategy != null) {
                    configuration.option(SdkClientOption.RETRY_STRATEGY, retryStrategy);
                }
            }
        }
        configuration.option(SdkClientOption.CONFIGURED_RETRY_MODE, null);
        configuration.option(SdkClientOption.CONFIGURED_RETRY_STRATEGY, null);
        configuration.option(SdkClientOption.CONFIGURED_RETRY_CONFIGURATOR, null);
    }

    private SdkClientConfiguration updateSdkClientConfiguration(SdkRequest request, SdkClientConfiguration clientConfiguration) {
        List plugins = request.overrideConfiguration().map(c -> c.plugins()).orElse(Collections.emptyList());
        if (plugins.isEmpty()) {
            return clientConfiguration;
        }
        SdkClientConfiguration.Builder configuration = clientConfiguration.toBuilder();
        LakeFormationServiceClientConfigurationBuilder serviceConfigBuilder = new LakeFormationServiceClientConfigurationBuilder(configuration);
        for (SdkPlugin plugin : plugins) {
            plugin.configureClient(serviceConfigBuilder);
        }
        this.updateRetryStrategyClientConfiguration(configuration);
        return configuration.build();
    }

    private HttpResponseHandler<AwsServiceException> createErrorResponseHandler(BaseAwsJsonProtocolFactory protocolFactory, JsonOperationMetadata operationMetadata, Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper) {
        return protocolFactory.createErrorResponseHandler(operationMetadata, exceptionMetadataMapper);
    }

    @Override
    public void close() {
        this.clientHandler.close();
    }
}

