/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lakeformation;

import java.nio.file.Path;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.AwsClient;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.ResponseBytes;
import software.amazon.awssdk.core.ResponseInputStream;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.sync.ResponseTransformer;
import software.amazon.awssdk.regions.ServiceMetadata;
import software.amazon.awssdk.services.lakeformation.DefaultLakeFormationClientBuilder;
import software.amazon.awssdk.services.lakeformation.LakeFormationClientBuilder;
import software.amazon.awssdk.services.lakeformation.LakeFormationServiceClientConfiguration;
import software.amazon.awssdk.services.lakeformation.model.AccessDeniedException;
import software.amazon.awssdk.services.lakeformation.model.AddLfTagsToResourceRequest;
import software.amazon.awssdk.services.lakeformation.model.AddLfTagsToResourceResponse;
import software.amazon.awssdk.services.lakeformation.model.AlreadyExistsException;
import software.amazon.awssdk.services.lakeformation.model.AssumeDecoratedRoleWithSamlRequest;
import software.amazon.awssdk.services.lakeformation.model.AssumeDecoratedRoleWithSamlResponse;
import software.amazon.awssdk.services.lakeformation.model.BatchGrantPermissionsRequest;
import software.amazon.awssdk.services.lakeformation.model.BatchGrantPermissionsResponse;
import software.amazon.awssdk.services.lakeformation.model.BatchRevokePermissionsRequest;
import software.amazon.awssdk.services.lakeformation.model.BatchRevokePermissionsResponse;
import software.amazon.awssdk.services.lakeformation.model.CancelTransactionRequest;
import software.amazon.awssdk.services.lakeformation.model.CancelTransactionResponse;
import software.amazon.awssdk.services.lakeformation.model.CommitTransactionRequest;
import software.amazon.awssdk.services.lakeformation.model.CommitTransactionResponse;
import software.amazon.awssdk.services.lakeformation.model.ConcurrentModificationException;
import software.amazon.awssdk.services.lakeformation.model.CreateDataCellsFilterRequest;
import software.amazon.awssdk.services.lakeformation.model.CreateDataCellsFilterResponse;
import software.amazon.awssdk.services.lakeformation.model.CreateLakeFormationIdentityCenterConfigurationRequest;
import software.amazon.awssdk.services.lakeformation.model.CreateLakeFormationIdentityCenterConfigurationResponse;
import software.amazon.awssdk.services.lakeformation.model.CreateLakeFormationOptInRequest;
import software.amazon.awssdk.services.lakeformation.model.CreateLakeFormationOptInResponse;
import software.amazon.awssdk.services.lakeformation.model.CreateLfTagExpressionRequest;
import software.amazon.awssdk.services.lakeformation.model.CreateLfTagExpressionResponse;
import software.amazon.awssdk.services.lakeformation.model.CreateLfTagRequest;
import software.amazon.awssdk.services.lakeformation.model.CreateLfTagResponse;
import software.amazon.awssdk.services.lakeformation.model.DeleteDataCellsFilterRequest;
import software.amazon.awssdk.services.lakeformation.model.DeleteDataCellsFilterResponse;
import software.amazon.awssdk.services.lakeformation.model.DeleteLakeFormationIdentityCenterConfigurationRequest;
import software.amazon.awssdk.services.lakeformation.model.DeleteLakeFormationIdentityCenterConfigurationResponse;
import software.amazon.awssdk.services.lakeformation.model.DeleteLakeFormationOptInRequest;
import software.amazon.awssdk.services.lakeformation.model.DeleteLakeFormationOptInResponse;
import software.amazon.awssdk.services.lakeformation.model.DeleteLfTagExpressionRequest;
import software.amazon.awssdk.services.lakeformation.model.DeleteLfTagExpressionResponse;
import software.amazon.awssdk.services.lakeformation.model.DeleteLfTagRequest;
import software.amazon.awssdk.services.lakeformation.model.DeleteLfTagResponse;
import software.amazon.awssdk.services.lakeformation.model.DeleteObjectsOnCancelRequest;
import software.amazon.awssdk.services.lakeformation.model.DeleteObjectsOnCancelResponse;
import software.amazon.awssdk.services.lakeformation.model.DeregisterResourceRequest;
import software.amazon.awssdk.services.lakeformation.model.DeregisterResourceResponse;
import software.amazon.awssdk.services.lakeformation.model.DescribeLakeFormationIdentityCenterConfigurationRequest;
import software.amazon.awssdk.services.lakeformation.model.DescribeLakeFormationIdentityCenterConfigurationResponse;
import software.amazon.awssdk.services.lakeformation.model.DescribeResourceRequest;
import software.amazon.awssdk.services.lakeformation.model.DescribeResourceResponse;
import software.amazon.awssdk.services.lakeformation.model.DescribeTransactionRequest;
import software.amazon.awssdk.services.lakeformation.model.DescribeTransactionResponse;
import software.amazon.awssdk.services.lakeformation.model.EntityNotFoundException;
import software.amazon.awssdk.services.lakeformation.model.ExpiredException;
import software.amazon.awssdk.services.lakeformation.model.ExtendTransactionRequest;
import software.amazon.awssdk.services.lakeformation.model.ExtendTransactionResponse;
import software.amazon.awssdk.services.lakeformation.model.GetDataCellsFilterRequest;
import software.amazon.awssdk.services.lakeformation.model.GetDataCellsFilterResponse;
import software.amazon.awssdk.services.lakeformation.model.GetDataLakePrincipalRequest;
import software.amazon.awssdk.services.lakeformation.model.GetDataLakePrincipalResponse;
import software.amazon.awssdk.services.lakeformation.model.GetDataLakeSettingsRequest;
import software.amazon.awssdk.services.lakeformation.model.GetDataLakeSettingsResponse;
import software.amazon.awssdk.services.lakeformation.model.GetEffectivePermissionsForPathRequest;
import software.amazon.awssdk.services.lakeformation.model.GetEffectivePermissionsForPathResponse;
import software.amazon.awssdk.services.lakeformation.model.GetLfTagExpressionRequest;
import software.amazon.awssdk.services.lakeformation.model.GetLfTagExpressionResponse;
import software.amazon.awssdk.services.lakeformation.model.GetLfTagRequest;
import software.amazon.awssdk.services.lakeformation.model.GetLfTagResponse;
import software.amazon.awssdk.services.lakeformation.model.GetQueryStateRequest;
import software.amazon.awssdk.services.lakeformation.model.GetQueryStateResponse;
import software.amazon.awssdk.services.lakeformation.model.GetQueryStatisticsRequest;
import software.amazon.awssdk.services.lakeformation.model.GetQueryStatisticsResponse;
import software.amazon.awssdk.services.lakeformation.model.GetResourceLfTagsRequest;
import software.amazon.awssdk.services.lakeformation.model.GetResourceLfTagsResponse;
import software.amazon.awssdk.services.lakeformation.model.GetTableObjectsRequest;
import software.amazon.awssdk.services.lakeformation.model.GetTableObjectsResponse;
import software.amazon.awssdk.services.lakeformation.model.GetTemporaryGluePartitionCredentialsRequest;
import software.amazon.awssdk.services.lakeformation.model.GetTemporaryGluePartitionCredentialsResponse;
import software.amazon.awssdk.services.lakeformation.model.GetTemporaryGlueTableCredentialsRequest;
import software.amazon.awssdk.services.lakeformation.model.GetTemporaryGlueTableCredentialsResponse;
import software.amazon.awssdk.services.lakeformation.model.GetWorkUnitResultsRequest;
import software.amazon.awssdk.services.lakeformation.model.GetWorkUnitResultsResponse;
import software.amazon.awssdk.services.lakeformation.model.GetWorkUnitsRequest;
import software.amazon.awssdk.services.lakeformation.model.GetWorkUnitsResponse;
import software.amazon.awssdk.services.lakeformation.model.GlueEncryptionException;
import software.amazon.awssdk.services.lakeformation.model.GrantPermissionsRequest;
import software.amazon.awssdk.services.lakeformation.model.GrantPermissionsResponse;
import software.amazon.awssdk.services.lakeformation.model.InternalServiceException;
import software.amazon.awssdk.services.lakeformation.model.InvalidInputException;
import software.amazon.awssdk.services.lakeformation.model.LakeFormationException;
import software.amazon.awssdk.services.lakeformation.model.ListDataCellsFilterRequest;
import software.amazon.awssdk.services.lakeformation.model.ListDataCellsFilterResponse;
import software.amazon.awssdk.services.lakeformation.model.ListLakeFormationOptInsRequest;
import software.amazon.awssdk.services.lakeformation.model.ListLakeFormationOptInsResponse;
import software.amazon.awssdk.services.lakeformation.model.ListLfTagExpressionsRequest;
import software.amazon.awssdk.services.lakeformation.model.ListLfTagExpressionsResponse;
import software.amazon.awssdk.services.lakeformation.model.ListLfTagsRequest;
import software.amazon.awssdk.services.lakeformation.model.ListLfTagsResponse;
import software.amazon.awssdk.services.lakeformation.model.ListPermissionsRequest;
import software.amazon.awssdk.services.lakeformation.model.ListPermissionsResponse;
import software.amazon.awssdk.services.lakeformation.model.ListResourcesRequest;
import software.amazon.awssdk.services.lakeformation.model.ListResourcesResponse;
import software.amazon.awssdk.services.lakeformation.model.ListTableStorageOptimizersRequest;
import software.amazon.awssdk.services.lakeformation.model.ListTableStorageOptimizersResponse;
import software.amazon.awssdk.services.lakeformation.model.ListTransactionsRequest;
import software.amazon.awssdk.services.lakeformation.model.ListTransactionsResponse;
import software.amazon.awssdk.services.lakeformation.model.OperationTimeoutException;
import software.amazon.awssdk.services.lakeformation.model.PermissionTypeMismatchException;
import software.amazon.awssdk.services.lakeformation.model.PutDataLakeSettingsRequest;
import software.amazon.awssdk.services.lakeformation.model.PutDataLakeSettingsResponse;
import software.amazon.awssdk.services.lakeformation.model.RegisterResourceRequest;
import software.amazon.awssdk.services.lakeformation.model.RegisterResourceResponse;
import software.amazon.awssdk.services.lakeformation.model.RemoveLfTagsFromResourceRequest;
import software.amazon.awssdk.services.lakeformation.model.RemoveLfTagsFromResourceResponse;
import software.amazon.awssdk.services.lakeformation.model.ResourceNotReadyException;
import software.amazon.awssdk.services.lakeformation.model.ResourceNumberLimitExceededException;
import software.amazon.awssdk.services.lakeformation.model.RevokePermissionsRequest;
import software.amazon.awssdk.services.lakeformation.model.RevokePermissionsResponse;
import software.amazon.awssdk.services.lakeformation.model.SearchDatabasesByLfTagsRequest;
import software.amazon.awssdk.services.lakeformation.model.SearchDatabasesByLfTagsResponse;
import software.amazon.awssdk.services.lakeformation.model.SearchTablesByLfTagsRequest;
import software.amazon.awssdk.services.lakeformation.model.SearchTablesByLfTagsResponse;
import software.amazon.awssdk.services.lakeformation.model.StartQueryPlanningRequest;
import software.amazon.awssdk.services.lakeformation.model.StartQueryPlanningResponse;
import software.amazon.awssdk.services.lakeformation.model.StartTransactionRequest;
import software.amazon.awssdk.services.lakeformation.model.StartTransactionResponse;
import software.amazon.awssdk.services.lakeformation.model.StatisticsNotReadyYetException;
import software.amazon.awssdk.services.lakeformation.model.ThrottledException;
import software.amazon.awssdk.services.lakeformation.model.TransactionCanceledException;
import software.amazon.awssdk.services.lakeformation.model.TransactionCommitInProgressException;
import software.amazon.awssdk.services.lakeformation.model.TransactionCommittedException;
import software.amazon.awssdk.services.lakeformation.model.UpdateDataCellsFilterRequest;
import software.amazon.awssdk.services.lakeformation.model.UpdateDataCellsFilterResponse;
import software.amazon.awssdk.services.lakeformation.model.UpdateLakeFormationIdentityCenterConfigurationRequest;
import software.amazon.awssdk.services.lakeformation.model.UpdateLakeFormationIdentityCenterConfigurationResponse;
import software.amazon.awssdk.services.lakeformation.model.UpdateLfTagExpressionRequest;
import software.amazon.awssdk.services.lakeformation.model.UpdateLfTagExpressionResponse;
import software.amazon.awssdk.services.lakeformation.model.UpdateLfTagRequest;
import software.amazon.awssdk.services.lakeformation.model.UpdateLfTagResponse;
import software.amazon.awssdk.services.lakeformation.model.UpdateResourceRequest;
import software.amazon.awssdk.services.lakeformation.model.UpdateResourceResponse;
import software.amazon.awssdk.services.lakeformation.model.UpdateTableObjectsRequest;
import software.amazon.awssdk.services.lakeformation.model.UpdateTableObjectsResponse;
import software.amazon.awssdk.services.lakeformation.model.UpdateTableStorageOptimizerRequest;
import software.amazon.awssdk.services.lakeformation.model.UpdateTableStorageOptimizerResponse;
import software.amazon.awssdk.services.lakeformation.model.WorkUnitsNotReadyYetException;
import software.amazon.awssdk.services.lakeformation.paginators.GetEffectivePermissionsForPathIterable;
import software.amazon.awssdk.services.lakeformation.paginators.GetTableObjectsIterable;
import software.amazon.awssdk.services.lakeformation.paginators.GetWorkUnitsIterable;
import software.amazon.awssdk.services.lakeformation.paginators.ListDataCellsFilterIterable;
import software.amazon.awssdk.services.lakeformation.paginators.ListLFTagExpressionsIterable;
import software.amazon.awssdk.services.lakeformation.paginators.ListLFTagsIterable;
import software.amazon.awssdk.services.lakeformation.paginators.ListLakeFormationOptInsIterable;
import software.amazon.awssdk.services.lakeformation.paginators.ListPermissionsIterable;
import software.amazon.awssdk.services.lakeformation.paginators.ListResourcesIterable;
import software.amazon.awssdk.services.lakeformation.paginators.ListTableStorageOptimizersIterable;
import software.amazon.awssdk.services.lakeformation.paginators.ListTransactionsIterable;
import software.amazon.awssdk.services.lakeformation.paginators.SearchDatabasesByLFTagsIterable;
import software.amazon.awssdk.services.lakeformation.paginators.SearchTablesByLFTagsIterable;

@SdkPublicApi
@ThreadSafe
public interface LakeFormationClient
extends AwsClient {
    public static final String SERVICE_NAME = "lakeformation";
    public static final String SERVICE_METADATA_ID = "lakeformation";

    default public AddLfTagsToResourceResponse addLFTagsToResource(AddLfTagsToResourceRequest addLfTagsToResourceRequest) throws EntityNotFoundException, InvalidInputException, InternalServiceException, OperationTimeoutException, AccessDeniedException, ConcurrentModificationException, AwsServiceException, SdkClientException, LakeFormationException {
        throw new UnsupportedOperationException();
    }

    default public AddLfTagsToResourceResponse addLFTagsToResource(Consumer<AddLfTagsToResourceRequest.Builder> addLfTagsToResourceRequest) throws EntityNotFoundException, InvalidInputException, InternalServiceException, OperationTimeoutException, AccessDeniedException, ConcurrentModificationException, AwsServiceException, SdkClientException, LakeFormationException {
        return this.addLFTagsToResource((AddLfTagsToResourceRequest)AddLfTagsToResourceRequest.builder().applyMutation(addLfTagsToResourceRequest).build());
    }

    default public AssumeDecoratedRoleWithSamlResponse assumeDecoratedRoleWithSAML(AssumeDecoratedRoleWithSamlRequest assumeDecoratedRoleWithSamlRequest) throws InvalidInputException, InternalServiceException, OperationTimeoutException, EntityNotFoundException, AccessDeniedException, AwsServiceException, SdkClientException, LakeFormationException {
        throw new UnsupportedOperationException();
    }

    default public AssumeDecoratedRoleWithSamlResponse assumeDecoratedRoleWithSAML(Consumer<AssumeDecoratedRoleWithSamlRequest.Builder> assumeDecoratedRoleWithSamlRequest) throws InvalidInputException, InternalServiceException, OperationTimeoutException, EntityNotFoundException, AccessDeniedException, AwsServiceException, SdkClientException, LakeFormationException {
        return this.assumeDecoratedRoleWithSAML((AssumeDecoratedRoleWithSamlRequest)AssumeDecoratedRoleWithSamlRequest.builder().applyMutation(assumeDecoratedRoleWithSamlRequest).build());
    }

    default public BatchGrantPermissionsResponse batchGrantPermissions(BatchGrantPermissionsRequest batchGrantPermissionsRequest) throws InvalidInputException, OperationTimeoutException, AwsServiceException, SdkClientException, LakeFormationException {
        throw new UnsupportedOperationException();
    }

    default public BatchGrantPermissionsResponse batchGrantPermissions(Consumer<BatchGrantPermissionsRequest.Builder> batchGrantPermissionsRequest) throws InvalidInputException, OperationTimeoutException, AwsServiceException, SdkClientException, LakeFormationException {
        return this.batchGrantPermissions((BatchGrantPermissionsRequest)BatchGrantPermissionsRequest.builder().applyMutation(batchGrantPermissionsRequest).build());
    }

    default public BatchRevokePermissionsResponse batchRevokePermissions(BatchRevokePermissionsRequest batchRevokePermissionsRequest) throws InvalidInputException, OperationTimeoutException, AwsServiceException, SdkClientException, LakeFormationException {
        throw new UnsupportedOperationException();
    }

    default public BatchRevokePermissionsResponse batchRevokePermissions(Consumer<BatchRevokePermissionsRequest.Builder> batchRevokePermissionsRequest) throws InvalidInputException, OperationTimeoutException, AwsServiceException, SdkClientException, LakeFormationException {
        return this.batchRevokePermissions((BatchRevokePermissionsRequest)BatchRevokePermissionsRequest.builder().applyMutation(batchRevokePermissionsRequest).build());
    }

    default public CancelTransactionResponse cancelTransaction(CancelTransactionRequest cancelTransactionRequest) throws InvalidInputException, EntityNotFoundException, InternalServiceException, OperationTimeoutException, TransactionCommittedException, TransactionCommitInProgressException, ConcurrentModificationException, AwsServiceException, SdkClientException, LakeFormationException {
        throw new UnsupportedOperationException();
    }

    default public CancelTransactionResponse cancelTransaction(Consumer<CancelTransactionRequest.Builder> cancelTransactionRequest) throws InvalidInputException, EntityNotFoundException, InternalServiceException, OperationTimeoutException, TransactionCommittedException, TransactionCommitInProgressException, ConcurrentModificationException, AwsServiceException, SdkClientException, LakeFormationException {
        return this.cancelTransaction((CancelTransactionRequest)CancelTransactionRequest.builder().applyMutation(cancelTransactionRequest).build());
    }

    default public CommitTransactionResponse commitTransaction(CommitTransactionRequest commitTransactionRequest) throws InvalidInputException, EntityNotFoundException, InternalServiceException, OperationTimeoutException, TransactionCanceledException, ConcurrentModificationException, AwsServiceException, SdkClientException, LakeFormationException {
        throw new UnsupportedOperationException();
    }

    default public CommitTransactionResponse commitTransaction(Consumer<CommitTransactionRequest.Builder> commitTransactionRequest) throws InvalidInputException, EntityNotFoundException, InternalServiceException, OperationTimeoutException, TransactionCanceledException, ConcurrentModificationException, AwsServiceException, SdkClientException, LakeFormationException {
        return this.commitTransaction((CommitTransactionRequest)CommitTransactionRequest.builder().applyMutation(commitTransactionRequest).build());
    }

    default public CreateDataCellsFilterResponse createDataCellsFilter(CreateDataCellsFilterRequest createDataCellsFilterRequest) throws AlreadyExistsException, InvalidInputException, EntityNotFoundException, ResourceNumberLimitExceededException, InternalServiceException, OperationTimeoutException, AccessDeniedException, AwsServiceException, SdkClientException, LakeFormationException {
        throw new UnsupportedOperationException();
    }

    default public CreateDataCellsFilterResponse createDataCellsFilter(Consumer<CreateDataCellsFilterRequest.Builder> createDataCellsFilterRequest) throws AlreadyExistsException, InvalidInputException, EntityNotFoundException, ResourceNumberLimitExceededException, InternalServiceException, OperationTimeoutException, AccessDeniedException, AwsServiceException, SdkClientException, LakeFormationException {
        return this.createDataCellsFilter((CreateDataCellsFilterRequest)CreateDataCellsFilterRequest.builder().applyMutation(createDataCellsFilterRequest).build());
    }

    default public CreateLfTagResponse createLFTag(CreateLfTagRequest createLfTagRequest) throws EntityNotFoundException, InvalidInputException, ResourceNumberLimitExceededException, InternalServiceException, OperationTimeoutException, AccessDeniedException, AwsServiceException, SdkClientException, LakeFormationException {
        throw new UnsupportedOperationException();
    }

    default public CreateLfTagResponse createLFTag(Consumer<CreateLfTagRequest.Builder> createLfTagRequest) throws EntityNotFoundException, InvalidInputException, ResourceNumberLimitExceededException, InternalServiceException, OperationTimeoutException, AccessDeniedException, AwsServiceException, SdkClientException, LakeFormationException {
        return this.createLFTag((CreateLfTagRequest)CreateLfTagRequest.builder().applyMutation(createLfTagRequest).build());
    }

    default public CreateLfTagExpressionResponse createLFTagExpression(CreateLfTagExpressionRequest createLfTagExpressionRequest) throws InvalidInputException, ResourceNumberLimitExceededException, InternalServiceException, OperationTimeoutException, AccessDeniedException, EntityNotFoundException, AwsServiceException, SdkClientException, LakeFormationException {
        throw new UnsupportedOperationException();
    }

    default public CreateLfTagExpressionResponse createLFTagExpression(Consumer<CreateLfTagExpressionRequest.Builder> createLfTagExpressionRequest) throws InvalidInputException, ResourceNumberLimitExceededException, InternalServiceException, OperationTimeoutException, AccessDeniedException, EntityNotFoundException, AwsServiceException, SdkClientException, LakeFormationException {
        return this.createLFTagExpression((CreateLfTagExpressionRequest)CreateLfTagExpressionRequest.builder().applyMutation(createLfTagExpressionRequest).build());
    }

    default public CreateLakeFormationIdentityCenterConfigurationResponse createLakeFormationIdentityCenterConfiguration(CreateLakeFormationIdentityCenterConfigurationRequest createLakeFormationIdentityCenterConfigurationRequest) throws InvalidInputException, AlreadyExistsException, InternalServiceException, OperationTimeoutException, AccessDeniedException, ConcurrentModificationException, AwsServiceException, SdkClientException, LakeFormationException {
        throw new UnsupportedOperationException();
    }

    default public CreateLakeFormationIdentityCenterConfigurationResponse createLakeFormationIdentityCenterConfiguration(Consumer<CreateLakeFormationIdentityCenterConfigurationRequest.Builder> createLakeFormationIdentityCenterConfigurationRequest) throws InvalidInputException, AlreadyExistsException, InternalServiceException, OperationTimeoutException, AccessDeniedException, ConcurrentModificationException, AwsServiceException, SdkClientException, LakeFormationException {
        return this.createLakeFormationIdentityCenterConfiguration((CreateLakeFormationIdentityCenterConfigurationRequest)CreateLakeFormationIdentityCenterConfigurationRequest.builder().applyMutation(createLakeFormationIdentityCenterConfigurationRequest).build());
    }

    default public CreateLakeFormationOptInResponse createLakeFormationOptIn(CreateLakeFormationOptInRequest createLakeFormationOptInRequest) throws InvalidInputException, InternalServiceException, OperationTimeoutException, EntityNotFoundException, AccessDeniedException, ConcurrentModificationException, ResourceNumberLimitExceededException, AwsServiceException, SdkClientException, LakeFormationException {
        throw new UnsupportedOperationException();
    }

    default public CreateLakeFormationOptInResponse createLakeFormationOptIn(Consumer<CreateLakeFormationOptInRequest.Builder> createLakeFormationOptInRequest) throws InvalidInputException, InternalServiceException, OperationTimeoutException, EntityNotFoundException, AccessDeniedException, ConcurrentModificationException, ResourceNumberLimitExceededException, AwsServiceException, SdkClientException, LakeFormationException {
        return this.createLakeFormationOptIn((CreateLakeFormationOptInRequest)CreateLakeFormationOptInRequest.builder().applyMutation(createLakeFormationOptInRequest).build());
    }

    default public DeleteDataCellsFilterResponse deleteDataCellsFilter(DeleteDataCellsFilterRequest deleteDataCellsFilterRequest) throws InvalidInputException, EntityNotFoundException, InternalServiceException, OperationTimeoutException, AccessDeniedException, AwsServiceException, SdkClientException, LakeFormationException {
        throw new UnsupportedOperationException();
    }

    default public DeleteDataCellsFilterResponse deleteDataCellsFilter(Consumer<DeleteDataCellsFilterRequest.Builder> deleteDataCellsFilterRequest) throws InvalidInputException, EntityNotFoundException, InternalServiceException, OperationTimeoutException, AccessDeniedException, AwsServiceException, SdkClientException, LakeFormationException {
        return this.deleteDataCellsFilter((DeleteDataCellsFilterRequest)DeleteDataCellsFilterRequest.builder().applyMutation(deleteDataCellsFilterRequest).build());
    }

    default public DeleteLfTagResponse deleteLFTag(DeleteLfTagRequest deleteLfTagRequest) throws EntityNotFoundException, InvalidInputException, InternalServiceException, OperationTimeoutException, AccessDeniedException, AwsServiceException, SdkClientException, LakeFormationException {
        throw new UnsupportedOperationException();
    }

    default public DeleteLfTagResponse deleteLFTag(Consumer<DeleteLfTagRequest.Builder> deleteLfTagRequest) throws EntityNotFoundException, InvalidInputException, InternalServiceException, OperationTimeoutException, AccessDeniedException, AwsServiceException, SdkClientException, LakeFormationException {
        return this.deleteLFTag((DeleteLfTagRequest)DeleteLfTagRequest.builder().applyMutation(deleteLfTagRequest).build());
    }

    default public DeleteLfTagExpressionResponse deleteLFTagExpression(DeleteLfTagExpressionRequest deleteLfTagExpressionRequest) throws EntityNotFoundException, InvalidInputException, InternalServiceException, OperationTimeoutException, AccessDeniedException, AwsServiceException, SdkClientException, LakeFormationException {
        throw new UnsupportedOperationException();
    }

    default public DeleteLfTagExpressionResponse deleteLFTagExpression(Consumer<DeleteLfTagExpressionRequest.Builder> deleteLfTagExpressionRequest) throws EntityNotFoundException, InvalidInputException, InternalServiceException, OperationTimeoutException, AccessDeniedException, AwsServiceException, SdkClientException, LakeFormationException {
        return this.deleteLFTagExpression((DeleteLfTagExpressionRequest)DeleteLfTagExpressionRequest.builder().applyMutation(deleteLfTagExpressionRequest).build());
    }

    default public DeleteLakeFormationIdentityCenterConfigurationResponse deleteLakeFormationIdentityCenterConfiguration(DeleteLakeFormationIdentityCenterConfigurationRequest deleteLakeFormationIdentityCenterConfigurationRequest) throws InvalidInputException, EntityNotFoundException, InternalServiceException, OperationTimeoutException, AccessDeniedException, ConcurrentModificationException, AwsServiceException, SdkClientException, LakeFormationException {
        throw new UnsupportedOperationException();
    }

    default public DeleteLakeFormationIdentityCenterConfigurationResponse deleteLakeFormationIdentityCenterConfiguration(Consumer<DeleteLakeFormationIdentityCenterConfigurationRequest.Builder> deleteLakeFormationIdentityCenterConfigurationRequest) throws InvalidInputException, EntityNotFoundException, InternalServiceException, OperationTimeoutException, AccessDeniedException, ConcurrentModificationException, AwsServiceException, SdkClientException, LakeFormationException {
        return this.deleteLakeFormationIdentityCenterConfiguration((DeleteLakeFormationIdentityCenterConfigurationRequest)DeleteLakeFormationIdentityCenterConfigurationRequest.builder().applyMutation(deleteLakeFormationIdentityCenterConfigurationRequest).build());
    }

    default public DeleteLakeFormationOptInResponse deleteLakeFormationOptIn(DeleteLakeFormationOptInRequest deleteLakeFormationOptInRequest) throws InvalidInputException, InternalServiceException, OperationTimeoutException, EntityNotFoundException, AccessDeniedException, ConcurrentModificationException, AwsServiceException, SdkClientException, LakeFormationException {
        throw new UnsupportedOperationException();
    }

    default public DeleteLakeFormationOptInResponse deleteLakeFormationOptIn(Consumer<DeleteLakeFormationOptInRequest.Builder> deleteLakeFormationOptInRequest) throws InvalidInputException, InternalServiceException, OperationTimeoutException, EntityNotFoundException, AccessDeniedException, ConcurrentModificationException, AwsServiceException, SdkClientException, LakeFormationException {
        return this.deleteLakeFormationOptIn((DeleteLakeFormationOptInRequest)DeleteLakeFormationOptInRequest.builder().applyMutation(deleteLakeFormationOptInRequest).build());
    }

    default public DeleteObjectsOnCancelResponse deleteObjectsOnCancel(DeleteObjectsOnCancelRequest deleteObjectsOnCancelRequest) throws InternalServiceException, InvalidInputException, OperationTimeoutException, EntityNotFoundException, TransactionCommittedException, TransactionCanceledException, ResourceNotReadyException, ConcurrentModificationException, AwsServiceException, SdkClientException, LakeFormationException {
        throw new UnsupportedOperationException();
    }

    default public DeleteObjectsOnCancelResponse deleteObjectsOnCancel(Consumer<DeleteObjectsOnCancelRequest.Builder> deleteObjectsOnCancelRequest) throws InternalServiceException, InvalidInputException, OperationTimeoutException, EntityNotFoundException, TransactionCommittedException, TransactionCanceledException, ResourceNotReadyException, ConcurrentModificationException, AwsServiceException, SdkClientException, LakeFormationException {
        return this.deleteObjectsOnCancel((DeleteObjectsOnCancelRequest)DeleteObjectsOnCancelRequest.builder().applyMutation(deleteObjectsOnCancelRequest).build());
    }

    default public DeregisterResourceResponse deregisterResource(DeregisterResourceRequest deregisterResourceRequest) throws InvalidInputException, InternalServiceException, OperationTimeoutException, EntityNotFoundException, AwsServiceException, SdkClientException, LakeFormationException {
        throw new UnsupportedOperationException();
    }

    default public DeregisterResourceResponse deregisterResource(Consumer<DeregisterResourceRequest.Builder> deregisterResourceRequest) throws InvalidInputException, InternalServiceException, OperationTimeoutException, EntityNotFoundException, AwsServiceException, SdkClientException, LakeFormationException {
        return this.deregisterResource((DeregisterResourceRequest)DeregisterResourceRequest.builder().applyMutation(deregisterResourceRequest).build());
    }

    default public DescribeLakeFormationIdentityCenterConfigurationResponse describeLakeFormationIdentityCenterConfiguration(DescribeLakeFormationIdentityCenterConfigurationRequest describeLakeFormationIdentityCenterConfigurationRequest) throws InvalidInputException, EntityNotFoundException, InternalServiceException, OperationTimeoutException, AccessDeniedException, AwsServiceException, SdkClientException, LakeFormationException {
        throw new UnsupportedOperationException();
    }

    default public DescribeLakeFormationIdentityCenterConfigurationResponse describeLakeFormationIdentityCenterConfiguration(Consumer<DescribeLakeFormationIdentityCenterConfigurationRequest.Builder> describeLakeFormationIdentityCenterConfigurationRequest) throws InvalidInputException, EntityNotFoundException, InternalServiceException, OperationTimeoutException, AccessDeniedException, AwsServiceException, SdkClientException, LakeFormationException {
        return this.describeLakeFormationIdentityCenterConfiguration((DescribeLakeFormationIdentityCenterConfigurationRequest)DescribeLakeFormationIdentityCenterConfigurationRequest.builder().applyMutation(describeLakeFormationIdentityCenterConfigurationRequest).build());
    }

    default public DescribeResourceResponse describeResource(DescribeResourceRequest describeResourceRequest) throws InvalidInputException, InternalServiceException, OperationTimeoutException, EntityNotFoundException, AwsServiceException, SdkClientException, LakeFormationException {
        throw new UnsupportedOperationException();
    }

    default public DescribeResourceResponse describeResource(Consumer<DescribeResourceRequest.Builder> describeResourceRequest) throws InvalidInputException, InternalServiceException, OperationTimeoutException, EntityNotFoundException, AwsServiceException, SdkClientException, LakeFormationException {
        return this.describeResource((DescribeResourceRequest)DescribeResourceRequest.builder().applyMutation(describeResourceRequest).build());
    }

    default public DescribeTransactionResponse describeTransaction(DescribeTransactionRequest describeTransactionRequest) throws EntityNotFoundException, InvalidInputException, InternalServiceException, OperationTimeoutException, AwsServiceException, SdkClientException, LakeFormationException {
        throw new UnsupportedOperationException();
    }

    default public DescribeTransactionResponse describeTransaction(Consumer<DescribeTransactionRequest.Builder> describeTransactionRequest) throws EntityNotFoundException, InvalidInputException, InternalServiceException, OperationTimeoutException, AwsServiceException, SdkClientException, LakeFormationException {
        return this.describeTransaction((DescribeTransactionRequest)DescribeTransactionRequest.builder().applyMutation(describeTransactionRequest).build());
    }

    default public ExtendTransactionResponse extendTransaction(ExtendTransactionRequest extendTransactionRequest) throws InvalidInputException, EntityNotFoundException, InternalServiceException, OperationTimeoutException, TransactionCommittedException, TransactionCanceledException, TransactionCommitInProgressException, AwsServiceException, SdkClientException, LakeFormationException {
        throw new UnsupportedOperationException();
    }

    default public ExtendTransactionResponse extendTransaction(Consumer<ExtendTransactionRequest.Builder> extendTransactionRequest) throws InvalidInputException, EntityNotFoundException, InternalServiceException, OperationTimeoutException, TransactionCommittedException, TransactionCanceledException, TransactionCommitInProgressException, AwsServiceException, SdkClientException, LakeFormationException {
        return this.extendTransaction((ExtendTransactionRequest)ExtendTransactionRequest.builder().applyMutation(extendTransactionRequest).build());
    }

    default public GetDataCellsFilterResponse getDataCellsFilter(GetDataCellsFilterRequest getDataCellsFilterRequest) throws EntityNotFoundException, InvalidInputException, OperationTimeoutException, InternalServiceException, AccessDeniedException, AwsServiceException, SdkClientException, LakeFormationException {
        throw new UnsupportedOperationException();
    }

    default public GetDataCellsFilterResponse getDataCellsFilter(Consumer<GetDataCellsFilterRequest.Builder> getDataCellsFilterRequest) throws EntityNotFoundException, InvalidInputException, OperationTimeoutException, InternalServiceException, AccessDeniedException, AwsServiceException, SdkClientException, LakeFormationException {
        return this.getDataCellsFilter((GetDataCellsFilterRequest)GetDataCellsFilterRequest.builder().applyMutation(getDataCellsFilterRequest).build());
    }

    default public GetDataLakePrincipalResponse getDataLakePrincipal(GetDataLakePrincipalRequest getDataLakePrincipalRequest) throws InternalServiceException, OperationTimeoutException, AccessDeniedException, AwsServiceException, SdkClientException, LakeFormationException {
        throw new UnsupportedOperationException();
    }

    default public GetDataLakePrincipalResponse getDataLakePrincipal(Consumer<GetDataLakePrincipalRequest.Builder> getDataLakePrincipalRequest) throws InternalServiceException, OperationTimeoutException, AccessDeniedException, AwsServiceException, SdkClientException, LakeFormationException {
        return this.getDataLakePrincipal((GetDataLakePrincipalRequest)GetDataLakePrincipalRequest.builder().applyMutation(getDataLakePrincipalRequest).build());
    }

    default public GetDataLakeSettingsResponse getDataLakeSettings(GetDataLakeSettingsRequest getDataLakeSettingsRequest) throws InternalServiceException, InvalidInputException, EntityNotFoundException, AwsServiceException, SdkClientException, LakeFormationException {
        throw new UnsupportedOperationException();
    }

    default public GetDataLakeSettingsResponse getDataLakeSettings(Consumer<GetDataLakeSettingsRequest.Builder> getDataLakeSettingsRequest) throws InternalServiceException, InvalidInputException, EntityNotFoundException, AwsServiceException, SdkClientException, LakeFormationException {
        return this.getDataLakeSettings((GetDataLakeSettingsRequest)GetDataLakeSettingsRequest.builder().applyMutation(getDataLakeSettingsRequest).build());
    }

    default public GetEffectivePermissionsForPathResponse getEffectivePermissionsForPath(GetEffectivePermissionsForPathRequest getEffectivePermissionsForPathRequest) throws InvalidInputException, EntityNotFoundException, OperationTimeoutException, InternalServiceException, AwsServiceException, SdkClientException, LakeFormationException {
        throw new UnsupportedOperationException();
    }

    default public GetEffectivePermissionsForPathResponse getEffectivePermissionsForPath(Consumer<GetEffectivePermissionsForPathRequest.Builder> getEffectivePermissionsForPathRequest) throws InvalidInputException, EntityNotFoundException, OperationTimeoutException, InternalServiceException, AwsServiceException, SdkClientException, LakeFormationException {
        return this.getEffectivePermissionsForPath((GetEffectivePermissionsForPathRequest)GetEffectivePermissionsForPathRequest.builder().applyMutation(getEffectivePermissionsForPathRequest).build());
    }

    default public GetEffectivePermissionsForPathIterable getEffectivePermissionsForPathPaginator(GetEffectivePermissionsForPathRequest getEffectivePermissionsForPathRequest) throws InvalidInputException, EntityNotFoundException, OperationTimeoutException, InternalServiceException, AwsServiceException, SdkClientException, LakeFormationException {
        return new GetEffectivePermissionsForPathIterable(this, getEffectivePermissionsForPathRequest);
    }

    default public GetEffectivePermissionsForPathIterable getEffectivePermissionsForPathPaginator(Consumer<GetEffectivePermissionsForPathRequest.Builder> getEffectivePermissionsForPathRequest) throws InvalidInputException, EntityNotFoundException, OperationTimeoutException, InternalServiceException, AwsServiceException, SdkClientException, LakeFormationException {
        return this.getEffectivePermissionsForPathPaginator((GetEffectivePermissionsForPathRequest)GetEffectivePermissionsForPathRequest.builder().applyMutation(getEffectivePermissionsForPathRequest).build());
    }

    default public GetLfTagResponse getLFTag(GetLfTagRequest getLfTagRequest) throws EntityNotFoundException, InvalidInputException, InternalServiceException, OperationTimeoutException, AccessDeniedException, AwsServiceException, SdkClientException, LakeFormationException {
        throw new UnsupportedOperationException();
    }

    default public GetLfTagResponse getLFTag(Consumer<GetLfTagRequest.Builder> getLfTagRequest) throws EntityNotFoundException, InvalidInputException, InternalServiceException, OperationTimeoutException, AccessDeniedException, AwsServiceException, SdkClientException, LakeFormationException {
        return this.getLFTag((GetLfTagRequest)GetLfTagRequest.builder().applyMutation(getLfTagRequest).build());
    }

    default public GetLfTagExpressionResponse getLFTagExpression(GetLfTagExpressionRequest getLfTagExpressionRequest) throws EntityNotFoundException, InvalidInputException, InternalServiceException, OperationTimeoutException, AccessDeniedException, AwsServiceException, SdkClientException, LakeFormationException {
        throw new UnsupportedOperationException();
    }

    default public GetLfTagExpressionResponse getLFTagExpression(Consumer<GetLfTagExpressionRequest.Builder> getLfTagExpressionRequest) throws EntityNotFoundException, InvalidInputException, InternalServiceException, OperationTimeoutException, AccessDeniedException, AwsServiceException, SdkClientException, LakeFormationException {
        return this.getLFTagExpression((GetLfTagExpressionRequest)GetLfTagExpressionRequest.builder().applyMutation(getLfTagExpressionRequest).build());
    }

    default public GetQueryStateResponse getQueryState(GetQueryStateRequest getQueryStateRequest) throws InternalServiceException, InvalidInputException, AccessDeniedException, AwsServiceException, SdkClientException, LakeFormationException {
        throw new UnsupportedOperationException();
    }

    default public GetQueryStateResponse getQueryState(Consumer<GetQueryStateRequest.Builder> getQueryStateRequest) throws InternalServiceException, InvalidInputException, AccessDeniedException, AwsServiceException, SdkClientException, LakeFormationException {
        return this.getQueryState((GetQueryStateRequest)GetQueryStateRequest.builder().applyMutation(getQueryStateRequest).build());
    }

    default public GetQueryStatisticsResponse getQueryStatistics(GetQueryStatisticsRequest getQueryStatisticsRequest) throws StatisticsNotReadyYetException, InternalServiceException, InvalidInputException, AccessDeniedException, ExpiredException, ThrottledException, AwsServiceException, SdkClientException, LakeFormationException {
        throw new UnsupportedOperationException();
    }

    default public GetQueryStatisticsResponse getQueryStatistics(Consumer<GetQueryStatisticsRequest.Builder> getQueryStatisticsRequest) throws StatisticsNotReadyYetException, InternalServiceException, InvalidInputException, AccessDeniedException, ExpiredException, ThrottledException, AwsServiceException, SdkClientException, LakeFormationException {
        return this.getQueryStatistics((GetQueryStatisticsRequest)GetQueryStatisticsRequest.builder().applyMutation(getQueryStatisticsRequest).build());
    }

    default public GetResourceLfTagsResponse getResourceLFTags(GetResourceLfTagsRequest getResourceLfTagsRequest) throws EntityNotFoundException, InvalidInputException, InternalServiceException, OperationTimeoutException, GlueEncryptionException, AccessDeniedException, AwsServiceException, SdkClientException, LakeFormationException {
        throw new UnsupportedOperationException();
    }

    default public GetResourceLfTagsResponse getResourceLFTags(Consumer<GetResourceLfTagsRequest.Builder> getResourceLfTagsRequest) throws EntityNotFoundException, InvalidInputException, InternalServiceException, OperationTimeoutException, GlueEncryptionException, AccessDeniedException, AwsServiceException, SdkClientException, LakeFormationException {
        return this.getResourceLFTags((GetResourceLfTagsRequest)GetResourceLfTagsRequest.builder().applyMutation(getResourceLfTagsRequest).build());
    }

    default public GetTableObjectsResponse getTableObjects(GetTableObjectsRequest getTableObjectsRequest) throws EntityNotFoundException, InternalServiceException, InvalidInputException, OperationTimeoutException, TransactionCommittedException, TransactionCanceledException, ResourceNotReadyException, AwsServiceException, SdkClientException, LakeFormationException {
        throw new UnsupportedOperationException();
    }

    default public GetTableObjectsResponse getTableObjects(Consumer<GetTableObjectsRequest.Builder> getTableObjectsRequest) throws EntityNotFoundException, InternalServiceException, InvalidInputException, OperationTimeoutException, TransactionCommittedException, TransactionCanceledException, ResourceNotReadyException, AwsServiceException, SdkClientException, LakeFormationException {
        return this.getTableObjects((GetTableObjectsRequest)GetTableObjectsRequest.builder().applyMutation(getTableObjectsRequest).build());
    }

    default public GetTableObjectsIterable getTableObjectsPaginator(GetTableObjectsRequest getTableObjectsRequest) throws EntityNotFoundException, InternalServiceException, InvalidInputException, OperationTimeoutException, TransactionCommittedException, TransactionCanceledException, ResourceNotReadyException, AwsServiceException, SdkClientException, LakeFormationException {
        return new GetTableObjectsIterable(this, getTableObjectsRequest);
    }

    default public GetTableObjectsIterable getTableObjectsPaginator(Consumer<GetTableObjectsRequest.Builder> getTableObjectsRequest) throws EntityNotFoundException, InternalServiceException, InvalidInputException, OperationTimeoutException, TransactionCommittedException, TransactionCanceledException, ResourceNotReadyException, AwsServiceException, SdkClientException, LakeFormationException {
        return this.getTableObjectsPaginator((GetTableObjectsRequest)GetTableObjectsRequest.builder().applyMutation(getTableObjectsRequest).build());
    }

    default public GetTemporaryGluePartitionCredentialsResponse getTemporaryGluePartitionCredentials(GetTemporaryGluePartitionCredentialsRequest getTemporaryGluePartitionCredentialsRequest) throws InvalidInputException, InternalServiceException, OperationTimeoutException, EntityNotFoundException, AccessDeniedException, PermissionTypeMismatchException, AwsServiceException, SdkClientException, LakeFormationException {
        throw new UnsupportedOperationException();
    }

    default public GetTemporaryGluePartitionCredentialsResponse getTemporaryGluePartitionCredentials(Consumer<GetTemporaryGluePartitionCredentialsRequest.Builder> getTemporaryGluePartitionCredentialsRequest) throws InvalidInputException, InternalServiceException, OperationTimeoutException, EntityNotFoundException, AccessDeniedException, PermissionTypeMismatchException, AwsServiceException, SdkClientException, LakeFormationException {
        return this.getTemporaryGluePartitionCredentials((GetTemporaryGluePartitionCredentialsRequest)GetTemporaryGluePartitionCredentialsRequest.builder().applyMutation(getTemporaryGluePartitionCredentialsRequest).build());
    }

    default public GetTemporaryGlueTableCredentialsResponse getTemporaryGlueTableCredentials(GetTemporaryGlueTableCredentialsRequest getTemporaryGlueTableCredentialsRequest) throws InvalidInputException, InternalServiceException, OperationTimeoutException, EntityNotFoundException, AccessDeniedException, PermissionTypeMismatchException, AwsServiceException, SdkClientException, LakeFormationException {
        throw new UnsupportedOperationException();
    }

    default public GetTemporaryGlueTableCredentialsResponse getTemporaryGlueTableCredentials(Consumer<GetTemporaryGlueTableCredentialsRequest.Builder> getTemporaryGlueTableCredentialsRequest) throws InvalidInputException, InternalServiceException, OperationTimeoutException, EntityNotFoundException, AccessDeniedException, PermissionTypeMismatchException, AwsServiceException, SdkClientException, LakeFormationException {
        return this.getTemporaryGlueTableCredentials((GetTemporaryGlueTableCredentialsRequest)GetTemporaryGlueTableCredentialsRequest.builder().applyMutation(getTemporaryGlueTableCredentialsRequest).build());
    }

    default public <ReturnT> ReturnT getWorkUnitResults(GetWorkUnitResultsRequest getWorkUnitResultsRequest, ResponseTransformer<GetWorkUnitResultsResponse, ReturnT> responseTransformer) throws InternalServiceException, InvalidInputException, AccessDeniedException, ExpiredException, ThrottledException, AwsServiceException, SdkClientException, LakeFormationException {
        throw new UnsupportedOperationException();
    }

    default public <ReturnT> ReturnT getWorkUnitResults(Consumer<GetWorkUnitResultsRequest.Builder> getWorkUnitResultsRequest, ResponseTransformer<GetWorkUnitResultsResponse, ReturnT> responseTransformer) throws InternalServiceException, InvalidInputException, AccessDeniedException, ExpiredException, ThrottledException, AwsServiceException, SdkClientException, LakeFormationException {
        return this.getWorkUnitResults((GetWorkUnitResultsRequest)GetWorkUnitResultsRequest.builder().applyMutation(getWorkUnitResultsRequest).build(), responseTransformer);
    }

    default public GetWorkUnitResultsResponse getWorkUnitResults(GetWorkUnitResultsRequest getWorkUnitResultsRequest, Path destinationPath) throws InternalServiceException, InvalidInputException, AccessDeniedException, ExpiredException, ThrottledException, AwsServiceException, SdkClientException, LakeFormationException {
        return (GetWorkUnitResultsResponse)this.getWorkUnitResults(getWorkUnitResultsRequest, ResponseTransformer.toFile(destinationPath));
    }

    default public GetWorkUnitResultsResponse getWorkUnitResults(Consumer<GetWorkUnitResultsRequest.Builder> getWorkUnitResultsRequest, Path destinationPath) throws InternalServiceException, InvalidInputException, AccessDeniedException, ExpiredException, ThrottledException, AwsServiceException, SdkClientException, LakeFormationException {
        return this.getWorkUnitResults((GetWorkUnitResultsRequest)GetWorkUnitResultsRequest.builder().applyMutation(getWorkUnitResultsRequest).build(), destinationPath);
    }

    default public ResponseInputStream<GetWorkUnitResultsResponse> getWorkUnitResults(GetWorkUnitResultsRequest getWorkUnitResultsRequest) throws InternalServiceException, InvalidInputException, AccessDeniedException, ExpiredException, ThrottledException, AwsServiceException, SdkClientException, LakeFormationException {
        return this.getWorkUnitResults(getWorkUnitResultsRequest, ResponseTransformer.toInputStream());
    }

    default public ResponseInputStream<GetWorkUnitResultsResponse> getWorkUnitResults(Consumer<GetWorkUnitResultsRequest.Builder> getWorkUnitResultsRequest) throws InternalServiceException, InvalidInputException, AccessDeniedException, ExpiredException, ThrottledException, AwsServiceException, SdkClientException, LakeFormationException {
        return this.getWorkUnitResults((GetWorkUnitResultsRequest)GetWorkUnitResultsRequest.builder().applyMutation(getWorkUnitResultsRequest).build());
    }

    default public ResponseBytes<GetWorkUnitResultsResponse> getWorkUnitResultsAsBytes(GetWorkUnitResultsRequest getWorkUnitResultsRequest) throws InternalServiceException, InvalidInputException, AccessDeniedException, ExpiredException, ThrottledException, AwsServiceException, SdkClientException, LakeFormationException {
        return this.getWorkUnitResults(getWorkUnitResultsRequest, ResponseTransformer.toBytes());
    }

    default public ResponseBytes<GetWorkUnitResultsResponse> getWorkUnitResultsAsBytes(Consumer<GetWorkUnitResultsRequest.Builder> getWorkUnitResultsRequest) throws InternalServiceException, InvalidInputException, AccessDeniedException, ExpiredException, ThrottledException, AwsServiceException, SdkClientException, LakeFormationException {
        return this.getWorkUnitResultsAsBytes((GetWorkUnitResultsRequest)GetWorkUnitResultsRequest.builder().applyMutation(getWorkUnitResultsRequest).build());
    }

    default public GetWorkUnitsResponse getWorkUnits(GetWorkUnitsRequest getWorkUnitsRequest) throws WorkUnitsNotReadyYetException, InternalServiceException, InvalidInputException, AccessDeniedException, ExpiredException, AwsServiceException, SdkClientException, LakeFormationException {
        throw new UnsupportedOperationException();
    }

    default public GetWorkUnitsResponse getWorkUnits(Consumer<GetWorkUnitsRequest.Builder> getWorkUnitsRequest) throws WorkUnitsNotReadyYetException, InternalServiceException, InvalidInputException, AccessDeniedException, ExpiredException, AwsServiceException, SdkClientException, LakeFormationException {
        return this.getWorkUnits((GetWorkUnitsRequest)GetWorkUnitsRequest.builder().applyMutation(getWorkUnitsRequest).build());
    }

    default public GetWorkUnitsIterable getWorkUnitsPaginator(GetWorkUnitsRequest getWorkUnitsRequest) throws WorkUnitsNotReadyYetException, InternalServiceException, InvalidInputException, AccessDeniedException, ExpiredException, AwsServiceException, SdkClientException, LakeFormationException {
        return new GetWorkUnitsIterable(this, getWorkUnitsRequest);
    }

    default public GetWorkUnitsIterable getWorkUnitsPaginator(Consumer<GetWorkUnitsRequest.Builder> getWorkUnitsRequest) throws WorkUnitsNotReadyYetException, InternalServiceException, InvalidInputException, AccessDeniedException, ExpiredException, AwsServiceException, SdkClientException, LakeFormationException {
        return this.getWorkUnitsPaginator((GetWorkUnitsRequest)GetWorkUnitsRequest.builder().applyMutation(getWorkUnitsRequest).build());
    }

    default public GrantPermissionsResponse grantPermissions(GrantPermissionsRequest grantPermissionsRequest) throws ConcurrentModificationException, EntityNotFoundException, InvalidInputException, AwsServiceException, SdkClientException, LakeFormationException {
        throw new UnsupportedOperationException();
    }

    default public GrantPermissionsResponse grantPermissions(Consumer<GrantPermissionsRequest.Builder> grantPermissionsRequest) throws ConcurrentModificationException, EntityNotFoundException, InvalidInputException, AwsServiceException, SdkClientException, LakeFormationException {
        return this.grantPermissions((GrantPermissionsRequest)GrantPermissionsRequest.builder().applyMutation(grantPermissionsRequest).build());
    }

    default public ListDataCellsFilterResponse listDataCellsFilter(ListDataCellsFilterRequest listDataCellsFilterRequest) throws InvalidInputException, OperationTimeoutException, InternalServiceException, AccessDeniedException, AwsServiceException, SdkClientException, LakeFormationException {
        throw new UnsupportedOperationException();
    }

    default public ListDataCellsFilterResponse listDataCellsFilter(Consumer<ListDataCellsFilterRequest.Builder> listDataCellsFilterRequest) throws InvalidInputException, OperationTimeoutException, InternalServiceException, AccessDeniedException, AwsServiceException, SdkClientException, LakeFormationException {
        return this.listDataCellsFilter((ListDataCellsFilterRequest)ListDataCellsFilterRequest.builder().applyMutation(listDataCellsFilterRequest).build());
    }

    default public ListDataCellsFilterIterable listDataCellsFilterPaginator(ListDataCellsFilterRequest listDataCellsFilterRequest) throws InvalidInputException, OperationTimeoutException, InternalServiceException, AccessDeniedException, AwsServiceException, SdkClientException, LakeFormationException {
        return new ListDataCellsFilterIterable(this, listDataCellsFilterRequest);
    }

    default public ListDataCellsFilterIterable listDataCellsFilterPaginator(Consumer<ListDataCellsFilterRequest.Builder> listDataCellsFilterRequest) throws InvalidInputException, OperationTimeoutException, InternalServiceException, AccessDeniedException, AwsServiceException, SdkClientException, LakeFormationException {
        return this.listDataCellsFilterPaginator((ListDataCellsFilterRequest)ListDataCellsFilterRequest.builder().applyMutation(listDataCellsFilterRequest).build());
    }

    default public ListLfTagExpressionsResponse listLFTagExpressions(ListLfTagExpressionsRequest listLfTagExpressionsRequest) throws EntityNotFoundException, InvalidInputException, InternalServiceException, OperationTimeoutException, AccessDeniedException, AwsServiceException, SdkClientException, LakeFormationException {
        throw new UnsupportedOperationException();
    }

    default public ListLfTagExpressionsResponse listLFTagExpressions(Consumer<ListLfTagExpressionsRequest.Builder> listLfTagExpressionsRequest) throws EntityNotFoundException, InvalidInputException, InternalServiceException, OperationTimeoutException, AccessDeniedException, AwsServiceException, SdkClientException, LakeFormationException {
        return this.listLFTagExpressions((ListLfTagExpressionsRequest)ListLfTagExpressionsRequest.builder().applyMutation(listLfTagExpressionsRequest).build());
    }

    default public ListLFTagExpressionsIterable listLFTagExpressionsPaginator(ListLfTagExpressionsRequest listLfTagExpressionsRequest) throws EntityNotFoundException, InvalidInputException, InternalServiceException, OperationTimeoutException, AccessDeniedException, AwsServiceException, SdkClientException, LakeFormationException {
        return new ListLFTagExpressionsIterable(this, listLfTagExpressionsRequest);
    }

    default public ListLFTagExpressionsIterable listLFTagExpressionsPaginator(Consumer<ListLfTagExpressionsRequest.Builder> listLfTagExpressionsRequest) throws EntityNotFoundException, InvalidInputException, InternalServiceException, OperationTimeoutException, AccessDeniedException, AwsServiceException, SdkClientException, LakeFormationException {
        return this.listLFTagExpressionsPaginator((ListLfTagExpressionsRequest)ListLfTagExpressionsRequest.builder().applyMutation(listLfTagExpressionsRequest).build());
    }

    default public ListLfTagsResponse listLFTags(ListLfTagsRequest listLfTagsRequest) throws EntityNotFoundException, InvalidInputException, InternalServiceException, OperationTimeoutException, AccessDeniedException, AwsServiceException, SdkClientException, LakeFormationException {
        throw new UnsupportedOperationException();
    }

    default public ListLfTagsResponse listLFTags(Consumer<ListLfTagsRequest.Builder> listLfTagsRequest) throws EntityNotFoundException, InvalidInputException, InternalServiceException, OperationTimeoutException, AccessDeniedException, AwsServiceException, SdkClientException, LakeFormationException {
        return this.listLFTags((ListLfTagsRequest)ListLfTagsRequest.builder().applyMutation(listLfTagsRequest).build());
    }

    default public ListLFTagsIterable listLFTagsPaginator(ListLfTagsRequest listLfTagsRequest) throws EntityNotFoundException, InvalidInputException, InternalServiceException, OperationTimeoutException, AccessDeniedException, AwsServiceException, SdkClientException, LakeFormationException {
        return new ListLFTagsIterable(this, listLfTagsRequest);
    }

    default public ListLFTagsIterable listLFTagsPaginator(Consumer<ListLfTagsRequest.Builder> listLfTagsRequest) throws EntityNotFoundException, InvalidInputException, InternalServiceException, OperationTimeoutException, AccessDeniedException, AwsServiceException, SdkClientException, LakeFormationException {
        return this.listLFTagsPaginator((ListLfTagsRequest)ListLfTagsRequest.builder().applyMutation(listLfTagsRequest).build());
    }

    default public ListLakeFormationOptInsResponse listLakeFormationOptIns(ListLakeFormationOptInsRequest listLakeFormationOptInsRequest) throws InvalidInputException, InternalServiceException, OperationTimeoutException, AccessDeniedException, AwsServiceException, SdkClientException, LakeFormationException {
        throw new UnsupportedOperationException();
    }

    default public ListLakeFormationOptInsResponse listLakeFormationOptIns(Consumer<ListLakeFormationOptInsRequest.Builder> listLakeFormationOptInsRequest) throws InvalidInputException, InternalServiceException, OperationTimeoutException, AccessDeniedException, AwsServiceException, SdkClientException, LakeFormationException {
        return this.listLakeFormationOptIns((ListLakeFormationOptInsRequest)ListLakeFormationOptInsRequest.builder().applyMutation(listLakeFormationOptInsRequest).build());
    }

    default public ListLakeFormationOptInsIterable listLakeFormationOptInsPaginator(ListLakeFormationOptInsRequest listLakeFormationOptInsRequest) throws InvalidInputException, InternalServiceException, OperationTimeoutException, AccessDeniedException, AwsServiceException, SdkClientException, LakeFormationException {
        return new ListLakeFormationOptInsIterable(this, listLakeFormationOptInsRequest);
    }

    default public ListLakeFormationOptInsIterable listLakeFormationOptInsPaginator(Consumer<ListLakeFormationOptInsRequest.Builder> listLakeFormationOptInsRequest) throws InvalidInputException, InternalServiceException, OperationTimeoutException, AccessDeniedException, AwsServiceException, SdkClientException, LakeFormationException {
        return this.listLakeFormationOptInsPaginator((ListLakeFormationOptInsRequest)ListLakeFormationOptInsRequest.builder().applyMutation(listLakeFormationOptInsRequest).build());
    }

    default public ListPermissionsResponse listPermissions(ListPermissionsRequest listPermissionsRequest) throws InvalidInputException, OperationTimeoutException, InternalServiceException, AwsServiceException, SdkClientException, LakeFormationException {
        throw new UnsupportedOperationException();
    }

    default public ListPermissionsResponse listPermissions(Consumer<ListPermissionsRequest.Builder> listPermissionsRequest) throws InvalidInputException, OperationTimeoutException, InternalServiceException, AwsServiceException, SdkClientException, LakeFormationException {
        return this.listPermissions((ListPermissionsRequest)ListPermissionsRequest.builder().applyMutation(listPermissionsRequest).build());
    }

    default public ListPermissionsIterable listPermissionsPaginator(ListPermissionsRequest listPermissionsRequest) throws InvalidInputException, OperationTimeoutException, InternalServiceException, AwsServiceException, SdkClientException, LakeFormationException {
        return new ListPermissionsIterable(this, listPermissionsRequest);
    }

    default public ListPermissionsIterable listPermissionsPaginator(Consumer<ListPermissionsRequest.Builder> listPermissionsRequest) throws InvalidInputException, OperationTimeoutException, InternalServiceException, AwsServiceException, SdkClientException, LakeFormationException {
        return this.listPermissionsPaginator((ListPermissionsRequest)ListPermissionsRequest.builder().applyMutation(listPermissionsRequest).build());
    }

    default public ListResourcesResponse listResources(ListResourcesRequest listResourcesRequest) throws InvalidInputException, InternalServiceException, OperationTimeoutException, AwsServiceException, SdkClientException, LakeFormationException {
        throw new UnsupportedOperationException();
    }

    default public ListResourcesResponse listResources(Consumer<ListResourcesRequest.Builder> listResourcesRequest) throws InvalidInputException, InternalServiceException, OperationTimeoutException, AwsServiceException, SdkClientException, LakeFormationException {
        return this.listResources((ListResourcesRequest)ListResourcesRequest.builder().applyMutation(listResourcesRequest).build());
    }

    default public ListResourcesIterable listResourcesPaginator(ListResourcesRequest listResourcesRequest) throws InvalidInputException, InternalServiceException, OperationTimeoutException, AwsServiceException, SdkClientException, LakeFormationException {
        return new ListResourcesIterable(this, listResourcesRequest);
    }

    default public ListResourcesIterable listResourcesPaginator(Consumer<ListResourcesRequest.Builder> listResourcesRequest) throws InvalidInputException, InternalServiceException, OperationTimeoutException, AwsServiceException, SdkClientException, LakeFormationException {
        return this.listResourcesPaginator((ListResourcesRequest)ListResourcesRequest.builder().applyMutation(listResourcesRequest).build());
    }

    default public ListTableStorageOptimizersResponse listTableStorageOptimizers(ListTableStorageOptimizersRequest listTableStorageOptimizersRequest) throws EntityNotFoundException, InvalidInputException, AccessDeniedException, InternalServiceException, AwsServiceException, SdkClientException, LakeFormationException {
        throw new UnsupportedOperationException();
    }

    default public ListTableStorageOptimizersResponse listTableStorageOptimizers(Consumer<ListTableStorageOptimizersRequest.Builder> listTableStorageOptimizersRequest) throws EntityNotFoundException, InvalidInputException, AccessDeniedException, InternalServiceException, AwsServiceException, SdkClientException, LakeFormationException {
        return this.listTableStorageOptimizers((ListTableStorageOptimizersRequest)ListTableStorageOptimizersRequest.builder().applyMutation(listTableStorageOptimizersRequest).build());
    }

    default public ListTableStorageOptimizersIterable listTableStorageOptimizersPaginator(ListTableStorageOptimizersRequest listTableStorageOptimizersRequest) throws EntityNotFoundException, InvalidInputException, AccessDeniedException, InternalServiceException, AwsServiceException, SdkClientException, LakeFormationException {
        return new ListTableStorageOptimizersIterable(this, listTableStorageOptimizersRequest);
    }

    default public ListTableStorageOptimizersIterable listTableStorageOptimizersPaginator(Consumer<ListTableStorageOptimizersRequest.Builder> listTableStorageOptimizersRequest) throws EntityNotFoundException, InvalidInputException, AccessDeniedException, InternalServiceException, AwsServiceException, SdkClientException, LakeFormationException {
        return this.listTableStorageOptimizersPaginator((ListTableStorageOptimizersRequest)ListTableStorageOptimizersRequest.builder().applyMutation(listTableStorageOptimizersRequest).build());
    }

    default public ListTransactionsResponse listTransactions(ListTransactionsRequest listTransactionsRequest) throws InvalidInputException, InternalServiceException, OperationTimeoutException, AwsServiceException, SdkClientException, LakeFormationException {
        throw new UnsupportedOperationException();
    }

    default public ListTransactionsResponse listTransactions(Consumer<ListTransactionsRequest.Builder> listTransactionsRequest) throws InvalidInputException, InternalServiceException, OperationTimeoutException, AwsServiceException, SdkClientException, LakeFormationException {
        return this.listTransactions((ListTransactionsRequest)ListTransactionsRequest.builder().applyMutation(listTransactionsRequest).build());
    }

    default public ListTransactionsIterable listTransactionsPaginator(ListTransactionsRequest listTransactionsRequest) throws InvalidInputException, InternalServiceException, OperationTimeoutException, AwsServiceException, SdkClientException, LakeFormationException {
        return new ListTransactionsIterable(this, listTransactionsRequest);
    }

    default public ListTransactionsIterable listTransactionsPaginator(Consumer<ListTransactionsRequest.Builder> listTransactionsRequest) throws InvalidInputException, InternalServiceException, OperationTimeoutException, AwsServiceException, SdkClientException, LakeFormationException {
        return this.listTransactionsPaginator((ListTransactionsRequest)ListTransactionsRequest.builder().applyMutation(listTransactionsRequest).build());
    }

    default public PutDataLakeSettingsResponse putDataLakeSettings(PutDataLakeSettingsRequest putDataLakeSettingsRequest) throws InternalServiceException, InvalidInputException, AwsServiceException, SdkClientException, LakeFormationException {
        throw new UnsupportedOperationException();
    }

    default public PutDataLakeSettingsResponse putDataLakeSettings(Consumer<PutDataLakeSettingsRequest.Builder> putDataLakeSettingsRequest) throws InternalServiceException, InvalidInputException, AwsServiceException, SdkClientException, LakeFormationException {
        return this.putDataLakeSettings((PutDataLakeSettingsRequest)PutDataLakeSettingsRequest.builder().applyMutation(putDataLakeSettingsRequest).build());
    }

    default public RegisterResourceResponse registerResource(RegisterResourceRequest registerResourceRequest) throws InvalidInputException, InternalServiceException, OperationTimeoutException, AlreadyExistsException, EntityNotFoundException, ResourceNumberLimitExceededException, AccessDeniedException, AwsServiceException, SdkClientException, LakeFormationException {
        throw new UnsupportedOperationException();
    }

    default public RegisterResourceResponse registerResource(Consumer<RegisterResourceRequest.Builder> registerResourceRequest) throws InvalidInputException, InternalServiceException, OperationTimeoutException, AlreadyExistsException, EntityNotFoundException, ResourceNumberLimitExceededException, AccessDeniedException, AwsServiceException, SdkClientException, LakeFormationException {
        return this.registerResource((RegisterResourceRequest)RegisterResourceRequest.builder().applyMutation(registerResourceRequest).build());
    }

    default public RemoveLfTagsFromResourceResponse removeLFTagsFromResource(RemoveLfTagsFromResourceRequest removeLfTagsFromResourceRequest) throws EntityNotFoundException, InvalidInputException, InternalServiceException, OperationTimeoutException, GlueEncryptionException, AccessDeniedException, ConcurrentModificationException, AwsServiceException, SdkClientException, LakeFormationException {
        throw new UnsupportedOperationException();
    }

    default public RemoveLfTagsFromResourceResponse removeLFTagsFromResource(Consumer<RemoveLfTagsFromResourceRequest.Builder> removeLfTagsFromResourceRequest) throws EntityNotFoundException, InvalidInputException, InternalServiceException, OperationTimeoutException, GlueEncryptionException, AccessDeniedException, ConcurrentModificationException, AwsServiceException, SdkClientException, LakeFormationException {
        return this.removeLFTagsFromResource((RemoveLfTagsFromResourceRequest)RemoveLfTagsFromResourceRequest.builder().applyMutation(removeLfTagsFromResourceRequest).build());
    }

    default public RevokePermissionsResponse revokePermissions(RevokePermissionsRequest revokePermissionsRequest) throws ConcurrentModificationException, EntityNotFoundException, InvalidInputException, AwsServiceException, SdkClientException, LakeFormationException {
        throw new UnsupportedOperationException();
    }

    default public RevokePermissionsResponse revokePermissions(Consumer<RevokePermissionsRequest.Builder> revokePermissionsRequest) throws ConcurrentModificationException, EntityNotFoundException, InvalidInputException, AwsServiceException, SdkClientException, LakeFormationException {
        return this.revokePermissions((RevokePermissionsRequest)RevokePermissionsRequest.builder().applyMutation(revokePermissionsRequest).build());
    }

    default public SearchDatabasesByLfTagsResponse searchDatabasesByLFTags(SearchDatabasesByLfTagsRequest searchDatabasesByLfTagsRequest) throws EntityNotFoundException, InternalServiceException, InvalidInputException, OperationTimeoutException, GlueEncryptionException, AccessDeniedException, AwsServiceException, SdkClientException, LakeFormationException {
        throw new UnsupportedOperationException();
    }

    default public SearchDatabasesByLfTagsResponse searchDatabasesByLFTags(Consumer<SearchDatabasesByLfTagsRequest.Builder> searchDatabasesByLfTagsRequest) throws EntityNotFoundException, InternalServiceException, InvalidInputException, OperationTimeoutException, GlueEncryptionException, AccessDeniedException, AwsServiceException, SdkClientException, LakeFormationException {
        return this.searchDatabasesByLFTags((SearchDatabasesByLfTagsRequest)SearchDatabasesByLfTagsRequest.builder().applyMutation(searchDatabasesByLfTagsRequest).build());
    }

    default public SearchDatabasesByLFTagsIterable searchDatabasesByLFTagsPaginator(SearchDatabasesByLfTagsRequest searchDatabasesByLfTagsRequest) throws EntityNotFoundException, InternalServiceException, InvalidInputException, OperationTimeoutException, GlueEncryptionException, AccessDeniedException, AwsServiceException, SdkClientException, LakeFormationException {
        return new SearchDatabasesByLFTagsIterable(this, searchDatabasesByLfTagsRequest);
    }

    default public SearchDatabasesByLFTagsIterable searchDatabasesByLFTagsPaginator(Consumer<SearchDatabasesByLfTagsRequest.Builder> searchDatabasesByLfTagsRequest) throws EntityNotFoundException, InternalServiceException, InvalidInputException, OperationTimeoutException, GlueEncryptionException, AccessDeniedException, AwsServiceException, SdkClientException, LakeFormationException {
        return this.searchDatabasesByLFTagsPaginator((SearchDatabasesByLfTagsRequest)SearchDatabasesByLfTagsRequest.builder().applyMutation(searchDatabasesByLfTagsRequest).build());
    }

    default public SearchTablesByLfTagsResponse searchTablesByLFTags(SearchTablesByLfTagsRequest searchTablesByLfTagsRequest) throws EntityNotFoundException, InternalServiceException, InvalidInputException, OperationTimeoutException, GlueEncryptionException, AccessDeniedException, AwsServiceException, SdkClientException, LakeFormationException {
        throw new UnsupportedOperationException();
    }

    default public SearchTablesByLfTagsResponse searchTablesByLFTags(Consumer<SearchTablesByLfTagsRequest.Builder> searchTablesByLfTagsRequest) throws EntityNotFoundException, InternalServiceException, InvalidInputException, OperationTimeoutException, GlueEncryptionException, AccessDeniedException, AwsServiceException, SdkClientException, LakeFormationException {
        return this.searchTablesByLFTags((SearchTablesByLfTagsRequest)SearchTablesByLfTagsRequest.builder().applyMutation(searchTablesByLfTagsRequest).build());
    }

    default public SearchTablesByLFTagsIterable searchTablesByLFTagsPaginator(SearchTablesByLfTagsRequest searchTablesByLfTagsRequest) throws EntityNotFoundException, InternalServiceException, InvalidInputException, OperationTimeoutException, GlueEncryptionException, AccessDeniedException, AwsServiceException, SdkClientException, LakeFormationException {
        return new SearchTablesByLFTagsIterable(this, searchTablesByLfTagsRequest);
    }

    default public SearchTablesByLFTagsIterable searchTablesByLFTagsPaginator(Consumer<SearchTablesByLfTagsRequest.Builder> searchTablesByLfTagsRequest) throws EntityNotFoundException, InternalServiceException, InvalidInputException, OperationTimeoutException, GlueEncryptionException, AccessDeniedException, AwsServiceException, SdkClientException, LakeFormationException {
        return this.searchTablesByLFTagsPaginator((SearchTablesByLfTagsRequest)SearchTablesByLfTagsRequest.builder().applyMutation(searchTablesByLfTagsRequest).build());
    }

    default public StartQueryPlanningResponse startQueryPlanning(StartQueryPlanningRequest startQueryPlanningRequest) throws InternalServiceException, InvalidInputException, AccessDeniedException, ThrottledException, AwsServiceException, SdkClientException, LakeFormationException {
        throw new UnsupportedOperationException();
    }

    default public StartQueryPlanningResponse startQueryPlanning(Consumer<StartQueryPlanningRequest.Builder> startQueryPlanningRequest) throws InternalServiceException, InvalidInputException, AccessDeniedException, ThrottledException, AwsServiceException, SdkClientException, LakeFormationException {
        return this.startQueryPlanning((StartQueryPlanningRequest)StartQueryPlanningRequest.builder().applyMutation(startQueryPlanningRequest).build());
    }

    default public StartTransactionResponse startTransaction(StartTransactionRequest startTransactionRequest) throws InternalServiceException, OperationTimeoutException, AwsServiceException, SdkClientException, LakeFormationException {
        throw new UnsupportedOperationException();
    }

    default public StartTransactionResponse startTransaction(Consumer<StartTransactionRequest.Builder> startTransactionRequest) throws InternalServiceException, OperationTimeoutException, AwsServiceException, SdkClientException, LakeFormationException {
        return this.startTransaction((StartTransactionRequest)StartTransactionRequest.builder().applyMutation(startTransactionRequest).build());
    }

    default public UpdateDataCellsFilterResponse updateDataCellsFilter(UpdateDataCellsFilterRequest updateDataCellsFilterRequest) throws ConcurrentModificationException, InvalidInputException, EntityNotFoundException, InternalServiceException, OperationTimeoutException, AccessDeniedException, AwsServiceException, SdkClientException, LakeFormationException {
        throw new UnsupportedOperationException();
    }

    default public UpdateDataCellsFilterResponse updateDataCellsFilter(Consumer<UpdateDataCellsFilterRequest.Builder> updateDataCellsFilterRequest) throws ConcurrentModificationException, InvalidInputException, EntityNotFoundException, InternalServiceException, OperationTimeoutException, AccessDeniedException, AwsServiceException, SdkClientException, LakeFormationException {
        return this.updateDataCellsFilter((UpdateDataCellsFilterRequest)UpdateDataCellsFilterRequest.builder().applyMutation(updateDataCellsFilterRequest).build());
    }

    default public UpdateLfTagResponse updateLFTag(UpdateLfTagRequest updateLfTagRequest) throws EntityNotFoundException, InvalidInputException, InternalServiceException, OperationTimeoutException, ConcurrentModificationException, AccessDeniedException, AwsServiceException, SdkClientException, LakeFormationException {
        throw new UnsupportedOperationException();
    }

    default public UpdateLfTagResponse updateLFTag(Consumer<UpdateLfTagRequest.Builder> updateLfTagRequest) throws EntityNotFoundException, InvalidInputException, InternalServiceException, OperationTimeoutException, ConcurrentModificationException, AccessDeniedException, AwsServiceException, SdkClientException, LakeFormationException {
        return this.updateLFTag((UpdateLfTagRequest)UpdateLfTagRequest.builder().applyMutation(updateLfTagRequest).build());
    }

    default public UpdateLfTagExpressionResponse updateLFTagExpression(UpdateLfTagExpressionRequest updateLfTagExpressionRequest) throws EntityNotFoundException, InvalidInputException, ResourceNumberLimitExceededException, InternalServiceException, OperationTimeoutException, AccessDeniedException, AwsServiceException, SdkClientException, LakeFormationException {
        throw new UnsupportedOperationException();
    }

    default public UpdateLfTagExpressionResponse updateLFTagExpression(Consumer<UpdateLfTagExpressionRequest.Builder> updateLfTagExpressionRequest) throws EntityNotFoundException, InvalidInputException, ResourceNumberLimitExceededException, InternalServiceException, OperationTimeoutException, AccessDeniedException, AwsServiceException, SdkClientException, LakeFormationException {
        return this.updateLFTagExpression((UpdateLfTagExpressionRequest)UpdateLfTagExpressionRequest.builder().applyMutation(updateLfTagExpressionRequest).build());
    }

    default public UpdateLakeFormationIdentityCenterConfigurationResponse updateLakeFormationIdentityCenterConfiguration(UpdateLakeFormationIdentityCenterConfigurationRequest updateLakeFormationIdentityCenterConfigurationRequest) throws InvalidInputException, EntityNotFoundException, InternalServiceException, OperationTimeoutException, AccessDeniedException, ConcurrentModificationException, AwsServiceException, SdkClientException, LakeFormationException {
        throw new UnsupportedOperationException();
    }

    default public UpdateLakeFormationIdentityCenterConfigurationResponse updateLakeFormationIdentityCenterConfiguration(Consumer<UpdateLakeFormationIdentityCenterConfigurationRequest.Builder> updateLakeFormationIdentityCenterConfigurationRequest) throws InvalidInputException, EntityNotFoundException, InternalServiceException, OperationTimeoutException, AccessDeniedException, ConcurrentModificationException, AwsServiceException, SdkClientException, LakeFormationException {
        return this.updateLakeFormationIdentityCenterConfiguration((UpdateLakeFormationIdentityCenterConfigurationRequest)UpdateLakeFormationIdentityCenterConfigurationRequest.builder().applyMutation(updateLakeFormationIdentityCenterConfigurationRequest).build());
    }

    default public UpdateResourceResponse updateResource(UpdateResourceRequest updateResourceRequest) throws InvalidInputException, InternalServiceException, OperationTimeoutException, EntityNotFoundException, AwsServiceException, SdkClientException, LakeFormationException {
        throw new UnsupportedOperationException();
    }

    default public UpdateResourceResponse updateResource(Consumer<UpdateResourceRequest.Builder> updateResourceRequest) throws InvalidInputException, InternalServiceException, OperationTimeoutException, EntityNotFoundException, AwsServiceException, SdkClientException, LakeFormationException {
        return this.updateResource((UpdateResourceRequest)UpdateResourceRequest.builder().applyMutation(updateResourceRequest).build());
    }

    default public UpdateTableObjectsResponse updateTableObjects(UpdateTableObjectsRequest updateTableObjectsRequest) throws InternalServiceException, InvalidInputException, OperationTimeoutException, EntityNotFoundException, TransactionCommittedException, TransactionCanceledException, TransactionCommitInProgressException, ResourceNotReadyException, ConcurrentModificationException, AwsServiceException, SdkClientException, LakeFormationException {
        throw new UnsupportedOperationException();
    }

    default public UpdateTableObjectsResponse updateTableObjects(Consumer<UpdateTableObjectsRequest.Builder> updateTableObjectsRequest) throws InternalServiceException, InvalidInputException, OperationTimeoutException, EntityNotFoundException, TransactionCommittedException, TransactionCanceledException, TransactionCommitInProgressException, ResourceNotReadyException, ConcurrentModificationException, AwsServiceException, SdkClientException, LakeFormationException {
        return this.updateTableObjects((UpdateTableObjectsRequest)UpdateTableObjectsRequest.builder().applyMutation(updateTableObjectsRequest).build());
    }

    default public UpdateTableStorageOptimizerResponse updateTableStorageOptimizer(UpdateTableStorageOptimizerRequest updateTableStorageOptimizerRequest) throws EntityNotFoundException, InvalidInputException, AccessDeniedException, InternalServiceException, AwsServiceException, SdkClientException, LakeFormationException {
        throw new UnsupportedOperationException();
    }

    default public UpdateTableStorageOptimizerResponse updateTableStorageOptimizer(Consumer<UpdateTableStorageOptimizerRequest.Builder> updateTableStorageOptimizerRequest) throws EntityNotFoundException, InvalidInputException, AccessDeniedException, InternalServiceException, AwsServiceException, SdkClientException, LakeFormationException {
        return this.updateTableStorageOptimizer((UpdateTableStorageOptimizerRequest)UpdateTableStorageOptimizerRequest.builder().applyMutation(updateTableStorageOptimizerRequest).build());
    }

    public static LakeFormationClient create() {
        return (LakeFormationClient)LakeFormationClient.builder().build();
    }

    public static LakeFormationClientBuilder builder() {
        return new DefaultLakeFormationClientBuilder();
    }

    public static ServiceMetadata serviceMetadata() {
        return ServiceMetadata.of("lakeformation");
    }

    @Override
    default public LakeFormationServiceClientConfiguration serviceClientConfiguration() {
        throw new UnsupportedOperationException();
    }
}

