/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lakeformation.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.services.lakeformation.model.LakeFormationResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AssumeDecoratedRoleWithSamlResponse
extends LakeFormationResponse
implements ToCopyableBuilder<Builder, AssumeDecoratedRoleWithSamlResponse> {
    private static final SdkField<String> ACCESS_KEY_ID_FIELD = SdkField.builder(MarshallingType.STRING).memberName("AccessKeyId").getter(AssumeDecoratedRoleWithSamlResponse.getter(AssumeDecoratedRoleWithSamlResponse::accessKeyId)).setter(AssumeDecoratedRoleWithSamlResponse.setter(Builder::accessKeyId)).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccessKeyId").build()).build();
    private static final SdkField<String> SECRET_ACCESS_KEY_FIELD = SdkField.builder(MarshallingType.STRING).memberName("SecretAccessKey").getter(AssumeDecoratedRoleWithSamlResponse.getter(AssumeDecoratedRoleWithSamlResponse::secretAccessKey)).setter(AssumeDecoratedRoleWithSamlResponse.setter(Builder::secretAccessKey)).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecretAccessKey").build()).build();
    private static final SdkField<String> SESSION_TOKEN_FIELD = SdkField.builder(MarshallingType.STRING).memberName("SessionToken").getter(AssumeDecoratedRoleWithSamlResponse.getter(AssumeDecoratedRoleWithSamlResponse::sessionToken)).setter(AssumeDecoratedRoleWithSamlResponse.setter(Builder::sessionToken)).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SessionToken").build()).build();
    private static final SdkField<Instant> EXPIRATION_FIELD = SdkField.builder(MarshallingType.INSTANT).memberName("Expiration").getter(AssumeDecoratedRoleWithSamlResponse.getter(AssumeDecoratedRoleWithSamlResponse::expiration)).setter(AssumeDecoratedRoleWithSamlResponse.setter(Builder::expiration)).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Expiration").build()).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCESS_KEY_ID_FIELD, SECRET_ACCESS_KEY_FIELD, SESSION_TOKEN_FIELD, EXPIRATION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = AssumeDecoratedRoleWithSamlResponse.memberNameToFieldInitializer();
    private final String accessKeyId;
    private final String secretAccessKey;
    private final String sessionToken;
    private final Instant expiration;

    private AssumeDecoratedRoleWithSamlResponse(BuilderImpl builder) {
        super(builder);
        this.accessKeyId = builder.accessKeyId;
        this.secretAccessKey = builder.secretAccessKey;
        this.sessionToken = builder.sessionToken;
        this.expiration = builder.expiration;
    }

    public final String accessKeyId() {
        return this.accessKeyId;
    }

    public final String secretAccessKey() {
        return this.secretAccessKey;
    }

    public final String sessionToken() {
        return this.sessionToken;
    }

    public final Instant expiration() {
        return this.expiration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.accessKeyId());
        hashCode = 31 * hashCode + Objects.hashCode(this.secretAccessKey());
        hashCode = 31 * hashCode + Objects.hashCode(this.sessionToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.expiration());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AssumeDecoratedRoleWithSamlResponse)) {
            return false;
        }
        AssumeDecoratedRoleWithSamlResponse other = (AssumeDecoratedRoleWithSamlResponse)obj;
        return Objects.equals(this.accessKeyId(), other.accessKeyId()) && Objects.equals(this.secretAccessKey(), other.secretAccessKey()) && Objects.equals(this.sessionToken(), other.sessionToken()) && Objects.equals(this.expiration(), other.expiration());
    }

    public final String toString() {
        return ToString.builder("AssumeDecoratedRoleWithSamlResponse").add("AccessKeyId", this.accessKeyId()).add("SecretAccessKey", this.secretAccessKey()).add("SessionToken", this.sessionToken()).add("Expiration", this.expiration()).build();
    }

    @Override
    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AccessKeyId": {
                return Optional.ofNullable(clazz.cast(this.accessKeyId()));
            }
            case "SecretAccessKey": {
                return Optional.ofNullable(clazz.cast(this.secretAccessKey()));
            }
            case "SessionToken": {
                return Optional.ofNullable(clazz.cast(this.sessionToken()));
            }
            case "Expiration": {
                return Optional.ofNullable(clazz.cast(this.expiration()));
            }
        }
        return Optional.empty();
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<Object>> map = new HashMap<String, SdkField<Object>>();
        map.put("AccessKeyId", ACCESS_KEY_ID_FIELD);
        map.put("SecretAccessKey", SECRET_ACCESS_KEY_FIELD);
        map.put("SessionToken", SESSION_TOKEN_FIELD);
        map.put("Expiration", EXPIRATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AssumeDecoratedRoleWithSamlResponse, T> g) {
        return obj -> g.apply((AssumeDecoratedRoleWithSamlResponse)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends LakeFormationResponse.BuilderImpl
    implements Builder {
        private String accessKeyId;
        private String secretAccessKey;
        private String sessionToken;
        private Instant expiration;

        private BuilderImpl() {
        }

        private BuilderImpl(AssumeDecoratedRoleWithSamlResponse model) {
            super(model);
            this.accessKeyId(model.accessKeyId);
            this.secretAccessKey(model.secretAccessKey);
            this.sessionToken(model.sessionToken);
            this.expiration(model.expiration);
        }

        public final String getAccessKeyId() {
            return this.accessKeyId;
        }

        public final void setAccessKeyId(String accessKeyId) {
            this.accessKeyId = accessKeyId;
        }

        @Override
        public final Builder accessKeyId(String accessKeyId) {
            this.accessKeyId = accessKeyId;
            return this;
        }

        public final String getSecretAccessKey() {
            return this.secretAccessKey;
        }

        public final void setSecretAccessKey(String secretAccessKey) {
            this.secretAccessKey = secretAccessKey;
        }

        @Override
        public final Builder secretAccessKey(String secretAccessKey) {
            this.secretAccessKey = secretAccessKey;
            return this;
        }

        public final String getSessionToken() {
            return this.sessionToken;
        }

        public final void setSessionToken(String sessionToken) {
            this.sessionToken = sessionToken;
        }

        @Override
        public final Builder sessionToken(String sessionToken) {
            this.sessionToken = sessionToken;
            return this;
        }

        public final Instant getExpiration() {
            return this.expiration;
        }

        public final void setExpiration(Instant expiration) {
            this.expiration = expiration;
        }

        @Override
        public final Builder expiration(Instant expiration) {
            this.expiration = expiration;
            return this;
        }

        @Override
        public AssumeDecoratedRoleWithSamlResponse build() {
            return new AssumeDecoratedRoleWithSamlResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends LakeFormationResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, AssumeDecoratedRoleWithSamlResponse> {
        public Builder accessKeyId(String var1);

        public Builder secretAccessKey(String var1);

        public Builder sessionToken(String var1);

        public Builder expiration(Instant var1);
    }
}

