/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lakeformation.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.services.lakeformation.model.LakeFormationRequest;
import software.amazon.awssdk.services.lakeformation.model.Resource;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetResourceLfTagsRequest
extends LakeFormationRequest
implements ToCopyableBuilder<Builder, GetResourceLfTagsRequest> {
    private static final SdkField<String> CATALOG_ID_FIELD = SdkField.builder(MarshallingType.STRING).memberName("CatalogId").getter(GetResourceLfTagsRequest.getter(GetResourceLfTagsRequest::catalogId)).setter(GetResourceLfTagsRequest.setter(Builder::catalogId)).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CatalogId").build()).build();
    private static final SdkField<Resource> RESOURCE_FIELD = SdkField.builder(MarshallingType.SDK_POJO).memberName("Resource").getter(GetResourceLfTagsRequest.getter(GetResourceLfTagsRequest::resource)).setter(GetResourceLfTagsRequest.setter(Builder::resource)).constructor(Resource::builder).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Resource").build()).build();
    private static final SdkField<Boolean> SHOW_ASSIGNED_LF_TAGS_FIELD = SdkField.builder(MarshallingType.BOOLEAN).memberName("ShowAssignedLFTags").getter(GetResourceLfTagsRequest.getter(GetResourceLfTagsRequest::showAssignedLFTags)).setter(GetResourceLfTagsRequest.setter(Builder::showAssignedLFTags)).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ShowAssignedLFTags").build()).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CATALOG_ID_FIELD, RESOURCE_FIELD, SHOW_ASSIGNED_LF_TAGS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GetResourceLfTagsRequest.memberNameToFieldInitializer();
    private final String catalogId;
    private final Resource resource;
    private final Boolean showAssignedLFTags;

    private GetResourceLfTagsRequest(BuilderImpl builder) {
        super(builder);
        this.catalogId = builder.catalogId;
        this.resource = builder.resource;
        this.showAssignedLFTags = builder.showAssignedLFTags;
    }

    public final String catalogId() {
        return this.catalogId;
    }

    public final Resource resource() {
        return this.resource;
    }

    public final Boolean showAssignedLFTags() {
        return this.showAssignedLFTags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.catalogId());
        hashCode = 31 * hashCode + Objects.hashCode(this.resource());
        hashCode = 31 * hashCode + Objects.hashCode(this.showAssignedLFTags());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetResourceLfTagsRequest)) {
            return false;
        }
        GetResourceLfTagsRequest other = (GetResourceLfTagsRequest)obj;
        return Objects.equals(this.catalogId(), other.catalogId()) && Objects.equals(this.resource(), other.resource()) && Objects.equals(this.showAssignedLFTags(), other.showAssignedLFTags());
    }

    public final String toString() {
        return ToString.builder("GetResourceLfTagsRequest").add("CatalogId", this.catalogId()).add("Resource", this.resource()).add("ShowAssignedLFTags", this.showAssignedLFTags()).build();
    }

    @Override
    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CatalogId": {
                return Optional.ofNullable(clazz.cast(this.catalogId()));
            }
            case "Resource": {
                return Optional.ofNullable(clazz.cast(this.resource()));
            }
            case "ShowAssignedLFTags": {
                return Optional.ofNullable(clazz.cast(this.showAssignedLFTags()));
            }
        }
        return Optional.empty();
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<Object>> map = new HashMap<String, SdkField<Object>>();
        map.put("CatalogId", CATALOG_ID_FIELD);
        map.put("Resource", RESOURCE_FIELD);
        map.put("ShowAssignedLFTags", SHOW_ASSIGNED_LF_TAGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetResourceLfTagsRequest, T> g) {
        return obj -> g.apply((GetResourceLfTagsRequest)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends LakeFormationRequest.BuilderImpl
    implements Builder {
        private String catalogId;
        private Resource resource;
        private Boolean showAssignedLFTags;

        private BuilderImpl() {
        }

        private BuilderImpl(GetResourceLfTagsRequest model) {
            super(model);
            this.catalogId(model.catalogId);
            this.resource(model.resource);
            this.showAssignedLFTags(model.showAssignedLFTags);
        }

        public final String getCatalogId() {
            return this.catalogId;
        }

        public final void setCatalogId(String catalogId) {
            this.catalogId = catalogId;
        }

        @Override
        public final Builder catalogId(String catalogId) {
            this.catalogId = catalogId;
            return this;
        }

        public final Resource.Builder getResource() {
            return this.resource != null ? this.resource.toBuilder() : null;
        }

        public final void setResource(Resource.BuilderImpl resource) {
            this.resource = resource != null ? resource.build() : null;
        }

        @Override
        public final Builder resource(Resource resource) {
            this.resource = resource;
            return this;
        }

        public final Boolean getShowAssignedLFTags() {
            return this.showAssignedLFTags;
        }

        public final void setShowAssignedLFTags(Boolean showAssignedLFTags) {
            this.showAssignedLFTags = showAssignedLFTags;
        }

        @Override
        public final Builder showAssignedLFTags(Boolean showAssignedLFTags) {
            this.showAssignedLFTags = showAssignedLFTags;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetResourceLfTagsRequest build() {
            return new GetResourceLfTagsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends LakeFormationRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetResourceLfTagsRequest> {
        public Builder catalogId(String var1);

        public Builder resource(Resource var1);

        default public Builder resource(Consumer<Resource.Builder> resource) {
            return this.resource((Resource)Resource.builder().applyMutation(resource).build());
        }

        public Builder showAssignedLFTags(Boolean var1);

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

