/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lakeformation.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.lakeformation.model.QueryParameterMapCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class QueryPlanningContext
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, QueryPlanningContext> {
    private static final SdkField<String> CATALOG_ID_FIELD = SdkField.builder(MarshallingType.STRING).memberName("CatalogId").getter(QueryPlanningContext.getter(QueryPlanningContext::catalogId)).setter(QueryPlanningContext.setter(Builder::catalogId)).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CatalogId").build()).build();
    private static final SdkField<String> DATABASE_NAME_FIELD = SdkField.builder(MarshallingType.STRING).memberName("DatabaseName").getter(QueryPlanningContext.getter(QueryPlanningContext::databaseName)).setter(QueryPlanningContext.setter(Builder::databaseName)).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DatabaseName").build()).build();
    private static final SdkField<Instant> QUERY_AS_OF_TIME_FIELD = SdkField.builder(MarshallingType.INSTANT).memberName("QueryAsOfTime").getter(QueryPlanningContext.getter(QueryPlanningContext::queryAsOfTime)).setter(QueryPlanningContext.setter(Builder::queryAsOfTime)).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("QueryAsOfTime").build()).build();
    private static final SdkField<Map<String, String>> QUERY_PARAMETERS_FIELD = SdkField.builder(MarshallingType.MAP).memberName("QueryParameters").getter(QueryPlanningContext.getter(QueryPlanningContext::queryParameters)).setter(QueryPlanningContext.setter(Builder::queryParameters)).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("QueryParameters").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder(MarshallingType.STRING).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()).build()).build()).build();
    private static final SdkField<String> TRANSACTION_ID_FIELD = SdkField.builder(MarshallingType.STRING).memberName("TransactionId").getter(QueryPlanningContext.getter(QueryPlanningContext::transactionId)).setter(QueryPlanningContext.setter(Builder::transactionId)).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TransactionId").build()).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CATALOG_ID_FIELD, DATABASE_NAME_FIELD, QUERY_AS_OF_TIME_FIELD, QUERY_PARAMETERS_FIELD, TRANSACTION_ID_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = QueryPlanningContext.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String catalogId;
    private final String databaseName;
    private final Instant queryAsOfTime;
    private final Map<String, String> queryParameters;
    private final String transactionId;

    private QueryPlanningContext(BuilderImpl builder) {
        this.catalogId = builder.catalogId;
        this.databaseName = builder.databaseName;
        this.queryAsOfTime = builder.queryAsOfTime;
        this.queryParameters = builder.queryParameters;
        this.transactionId = builder.transactionId;
    }

    public final String catalogId() {
        return this.catalogId;
    }

    public final String databaseName() {
        return this.databaseName;
    }

    public final Instant queryAsOfTime() {
        return this.queryAsOfTime;
    }

    public final boolean hasQueryParameters() {
        return this.queryParameters != null && !(this.queryParameters instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> queryParameters() {
        return this.queryParameters;
    }

    public final String transactionId() {
        return this.transactionId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.catalogId());
        hashCode = 31 * hashCode + Objects.hashCode(this.databaseName());
        hashCode = 31 * hashCode + Objects.hashCode(this.queryAsOfTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasQueryParameters() ? this.queryParameters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.transactionId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof QueryPlanningContext)) {
            return false;
        }
        QueryPlanningContext other = (QueryPlanningContext)obj;
        return Objects.equals(this.catalogId(), other.catalogId()) && Objects.equals(this.databaseName(), other.databaseName()) && Objects.equals(this.queryAsOfTime(), other.queryAsOfTime()) && this.hasQueryParameters() == other.hasQueryParameters() && Objects.equals(this.queryParameters(), other.queryParameters()) && Objects.equals(this.transactionId(), other.transactionId());
    }

    public final String toString() {
        return ToString.builder("QueryPlanningContext").add("CatalogId", this.catalogId()).add("DatabaseName", this.databaseName()).add("QueryAsOfTime", this.queryAsOfTime()).add("QueryParameters", this.hasQueryParameters() ? this.queryParameters() : null).add("TransactionId", this.transactionId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CatalogId": {
                return Optional.ofNullable(clazz.cast(this.catalogId()));
            }
            case "DatabaseName": {
                return Optional.ofNullable(clazz.cast(this.databaseName()));
            }
            case "QueryAsOfTime": {
                return Optional.ofNullable(clazz.cast(this.queryAsOfTime()));
            }
            case "QueryParameters": {
                return Optional.ofNullable(clazz.cast(this.queryParameters()));
            }
            case "TransactionId": {
                return Optional.ofNullable(clazz.cast(this.transactionId()));
            }
        }
        return Optional.empty();
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<Object>> map = new HashMap<String, SdkField<Object>>();
        map.put("CatalogId", CATALOG_ID_FIELD);
        map.put("DatabaseName", DATABASE_NAME_FIELD);
        map.put("QueryAsOfTime", QUERY_AS_OF_TIME_FIELD);
        map.put("QueryParameters", QUERY_PARAMETERS_FIELD);
        map.put("TransactionId", TRANSACTION_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<QueryPlanningContext, T> g) {
        return obj -> g.apply((QueryPlanningContext)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String catalogId;
        private String databaseName;
        private Instant queryAsOfTime;
        private Map<String, String> queryParameters = DefaultSdkAutoConstructMap.getInstance();
        private String transactionId;

        private BuilderImpl() {
        }

        private BuilderImpl(QueryPlanningContext model) {
            this.catalogId(model.catalogId);
            this.databaseName(model.databaseName);
            this.queryAsOfTime(model.queryAsOfTime);
            this.queryParameters(model.queryParameters);
            this.transactionId(model.transactionId);
        }

        public final String getCatalogId() {
            return this.catalogId;
        }

        public final void setCatalogId(String catalogId) {
            this.catalogId = catalogId;
        }

        @Override
        public final Builder catalogId(String catalogId) {
            this.catalogId = catalogId;
            return this;
        }

        public final String getDatabaseName() {
            return this.databaseName;
        }

        public final void setDatabaseName(String databaseName) {
            this.databaseName = databaseName;
        }

        @Override
        public final Builder databaseName(String databaseName) {
            this.databaseName = databaseName;
            return this;
        }

        public final Instant getQueryAsOfTime() {
            return this.queryAsOfTime;
        }

        public final void setQueryAsOfTime(Instant queryAsOfTime) {
            this.queryAsOfTime = queryAsOfTime;
        }

        @Override
        public final Builder queryAsOfTime(Instant queryAsOfTime) {
            this.queryAsOfTime = queryAsOfTime;
            return this;
        }

        public final Map<String, String> getQueryParameters() {
            if (this.queryParameters instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.queryParameters;
        }

        public final void setQueryParameters(Map<String, String> queryParameters) {
            this.queryParameters = QueryParameterMapCopier.copy(queryParameters);
        }

        @Override
        public final Builder queryParameters(Map<String, String> queryParameters) {
            this.queryParameters = QueryParameterMapCopier.copy(queryParameters);
            return this;
        }

        public final String getTransactionId() {
            return this.transactionId;
        }

        public final void setTransactionId(String transactionId) {
            this.transactionId = transactionId;
        }

        @Override
        public final Builder transactionId(String transactionId) {
            this.transactionId = transactionId;
            return this;
        }

        @Override
        public QueryPlanningContext build() {
            return new QueryPlanningContext(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, QueryPlanningContext> {
        public Builder catalogId(String var1);

        public Builder databaseName(String var1);

        public Builder queryAsOfTime(Instant var1);

        public Builder queryParameters(Map<String, String> var1);

        public Builder transactionId(String var1);
    }
}

