/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lakeformation.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.lakeformation.model.DatabaseLFTagsListCopier;
import software.amazon.awssdk.services.lakeformation.model.LakeFormationResponse;
import software.amazon.awssdk.services.lakeformation.model.TaggedDatabase;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SearchDatabasesByLfTagsResponse
extends LakeFormationResponse
implements ToCopyableBuilder<Builder, SearchDatabasesByLfTagsResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder(MarshallingType.STRING).memberName("NextToken").getter(SearchDatabasesByLfTagsResponse.getter(SearchDatabasesByLfTagsResponse::nextToken)).setter(SearchDatabasesByLfTagsResponse.setter(Builder::nextToken)).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();
    private static final SdkField<List<TaggedDatabase>> DATABASE_LIST_FIELD = SdkField.builder(MarshallingType.LIST).memberName("DatabaseList").getter(SearchDatabasesByLfTagsResponse.getter(SearchDatabasesByLfTagsResponse::databaseList)).setter(SearchDatabasesByLfTagsResponse.setter(Builder::databaseList)).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DatabaseList").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder(MarshallingType.SDK_POJO).constructor(TaggedDatabase::builder).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()).build()).build()).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD, DATABASE_LIST_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = SearchDatabasesByLfTagsResponse.memberNameToFieldInitializer();
    private final String nextToken;
    private final List<TaggedDatabase> databaseList;

    private SearchDatabasesByLfTagsResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.databaseList = builder.databaseList;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final boolean hasDatabaseList() {
        return this.databaseList != null && !(this.databaseList instanceof SdkAutoConstructList);
    }

    public final List<TaggedDatabase> databaseList() {
        return this.databaseList;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDatabaseList() ? this.databaseList() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SearchDatabasesByLfTagsResponse)) {
            return false;
        }
        SearchDatabasesByLfTagsResponse other = (SearchDatabasesByLfTagsResponse)obj;
        return Objects.equals(this.nextToken(), other.nextToken()) && this.hasDatabaseList() == other.hasDatabaseList() && Objects.equals(this.databaseList(), other.databaseList());
    }

    public final String toString() {
        return ToString.builder("SearchDatabasesByLfTagsResponse").add("NextToken", this.nextToken()).add("DatabaseList", this.hasDatabaseList() ? this.databaseList() : null).build();
    }

    @Override
    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "DatabaseList": {
                return Optional.ofNullable(clazz.cast(this.databaseList()));
            }
        }
        return Optional.empty();
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<Object>> map = new HashMap<String, SdkField<Object>>();
        map.put("NextToken", NEXT_TOKEN_FIELD);
        map.put("DatabaseList", DATABASE_LIST_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SearchDatabasesByLfTagsResponse, T> g) {
        return obj -> g.apply((SearchDatabasesByLfTagsResponse)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends LakeFormationResponse.BuilderImpl
    implements Builder {
        private String nextToken;
        private List<TaggedDatabase> databaseList = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(SearchDatabasesByLfTagsResponse model) {
            super(model);
            this.nextToken(model.nextToken);
            this.databaseList(model.databaseList);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<TaggedDatabase.Builder> getDatabaseList() {
            List<TaggedDatabase.Builder> result = DatabaseLFTagsListCopier.copyToBuilder(this.databaseList);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDatabaseList(Collection<TaggedDatabase.BuilderImpl> databaseList) {
            this.databaseList = DatabaseLFTagsListCopier.copyFromBuilder(databaseList);
        }

        @Override
        public final Builder databaseList(Collection<TaggedDatabase> databaseList) {
            this.databaseList = DatabaseLFTagsListCopier.copy(databaseList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder databaseList(TaggedDatabase ... databaseList) {
            this.databaseList(Arrays.asList(databaseList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder databaseList(Consumer<TaggedDatabase.Builder> ... databaseList) {
            this.databaseList(Stream.of(databaseList).map(c -> (TaggedDatabase)((TaggedDatabase.Builder)TaggedDatabase.builder().applyMutation(c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public SearchDatabasesByLfTagsResponse build() {
            return new SearchDatabasesByLfTagsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends LakeFormationResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, SearchDatabasesByLfTagsResponse> {
        public Builder nextToken(String var1);

        public Builder databaseList(Collection<TaggedDatabase> var1);

        public Builder databaseList(TaggedDatabase ... var1);

        public Builder databaseList(Consumer<TaggedDatabase.Builder> ... var1);
    }
}

