/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lakeformation.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.lakeformation.LakeFormationAsyncClient;
import software.amazon.awssdk.services.lakeformation.internal.UserAgentUtils;
import software.amazon.awssdk.services.lakeformation.model.DataCellsFilter;
import software.amazon.awssdk.services.lakeformation.model.ListDataCellsFilterRequest;
import software.amazon.awssdk.services.lakeformation.model.ListDataCellsFilterResponse;

public class ListDataCellsFilterPublisher
implements SdkPublisher<ListDataCellsFilterResponse> {
    private final LakeFormationAsyncClient client;
    private final ListDataCellsFilterRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListDataCellsFilterPublisher(LakeFormationAsyncClient client, ListDataCellsFilterRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListDataCellsFilterPublisher(LakeFormationAsyncClient client, ListDataCellsFilterRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListDataCellsFilterResponseFetcher();
    }

    @Override
    public void subscribe(Subscriber<? super ListDataCellsFilterResponse> subscriber) {
        subscriber.onSubscribe(((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<DataCellsFilter> dataCellsFilters() {
        Function<ListDataCellsFilterResponse, Iterator> getIterator = response -> {
            if (response != null && response.dataCellsFilters() != null) {
                return response.dataCellsFilters().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher(new ListDataCellsFilterResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListDataCellsFilterResponseFetcher
    implements AsyncPageFetcher<ListDataCellsFilterResponse> {
        private ListDataCellsFilterResponseFetcher() {
        }

        @Override
        public boolean hasNextPage(ListDataCellsFilterResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable(previousPage.nextToken());
        }

        @Override
        public CompletableFuture<ListDataCellsFilterResponse> nextPage(ListDataCellsFilterResponse previousPage) {
            if (previousPage == null) {
                return ListDataCellsFilterPublisher.this.client.listDataCellsFilter(ListDataCellsFilterPublisher.this.firstRequest);
            }
            return ListDataCellsFilterPublisher.this.client.listDataCellsFilter((ListDataCellsFilterRequest)ListDataCellsFilterPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build());
        }
    }
}

