/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lakeformation.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.lakeformation.LakeFormationAsyncClient;
import software.amazon.awssdk.services.lakeformation.internal.UserAgentUtils;
import software.amazon.awssdk.services.lakeformation.model.ListLakeFormationOptInsRequest;
import software.amazon.awssdk.services.lakeformation.model.ListLakeFormationOptInsResponse;

public class ListLakeFormationOptInsPublisher
implements SdkPublisher<ListLakeFormationOptInsResponse> {
    private final LakeFormationAsyncClient client;
    private final ListLakeFormationOptInsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListLakeFormationOptInsPublisher(LakeFormationAsyncClient client, ListLakeFormationOptInsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListLakeFormationOptInsPublisher(LakeFormationAsyncClient client, ListLakeFormationOptInsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListLakeFormationOptInsResponseFetcher();
    }

    @Override
    public void subscribe(Subscriber<? super ListLakeFormationOptInsResponse> subscriber) {
        subscriber.onSubscribe(((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private class ListLakeFormationOptInsResponseFetcher
    implements AsyncPageFetcher<ListLakeFormationOptInsResponse> {
        private ListLakeFormationOptInsResponseFetcher() {
        }

        @Override
        public boolean hasNextPage(ListLakeFormationOptInsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable(previousPage.nextToken());
        }

        @Override
        public CompletableFuture<ListLakeFormationOptInsResponse> nextPage(ListLakeFormationOptInsResponse previousPage) {
            if (previousPage == null) {
                return ListLakeFormationOptInsPublisher.this.client.listLakeFormationOptIns(ListLakeFormationOptInsPublisher.this.firstRequest);
            }
            return ListLakeFormationOptInsPublisher.this.client.listLakeFormationOptIns((ListLakeFormationOptInsRequest)ListLakeFormationOptInsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build());
        }
    }
}

