/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lakeformation.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.lakeformation.LakeFormationAsyncClient;
import software.amazon.awssdk.services.lakeformation.internal.UserAgentUtils;
import software.amazon.awssdk.services.lakeformation.model.ListResourcesRequest;
import software.amazon.awssdk.services.lakeformation.model.ListResourcesResponse;

public class ListResourcesPublisher
implements SdkPublisher<ListResourcesResponse> {
    private final LakeFormationAsyncClient client;
    private final ListResourcesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListResourcesPublisher(LakeFormationAsyncClient client, ListResourcesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListResourcesPublisher(LakeFormationAsyncClient client, ListResourcesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListResourcesResponseFetcher();
    }

    @Override
    public void subscribe(Subscriber<? super ListResourcesResponse> subscriber) {
        subscriber.onSubscribe(((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private class ListResourcesResponseFetcher
    implements AsyncPageFetcher<ListResourcesResponse> {
        private ListResourcesResponseFetcher() {
        }

        @Override
        public boolean hasNextPage(ListResourcesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable(previousPage.nextToken());
        }

        @Override
        public CompletableFuture<ListResourcesResponse> nextPage(ListResourcesResponse previousPage) {
            if (previousPage == null) {
                return ListResourcesPublisher.this.client.listResources(ListResourcesPublisher.this.firstRequest);
            }
            return ListResourcesPublisher.this.client.listResources((ListResourcesRequest)ListResourcesPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build());
        }
    }
}

