/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lakeformation.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.lakeformation.LakeFormationClient;
import software.amazon.awssdk.services.lakeformation.internal.UserAgentUtils;
import software.amazon.awssdk.services.lakeformation.model.ListTableStorageOptimizersRequest;
import software.amazon.awssdk.services.lakeformation.model.ListTableStorageOptimizersResponse;

public class ListTableStorageOptimizersIterable
implements SdkIterable<ListTableStorageOptimizersResponse> {
    private final LakeFormationClient client;
    private final ListTableStorageOptimizersRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListTableStorageOptimizersIterable(LakeFormationClient client, ListTableStorageOptimizersRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListTableStorageOptimizersResponseFetcher();
    }

    @Override
    public Iterator<ListTableStorageOptimizersResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class ListTableStorageOptimizersResponseFetcher
    implements SyncPageFetcher<ListTableStorageOptimizersResponse> {
        private ListTableStorageOptimizersResponseFetcher() {
        }

        @Override
        public boolean hasNextPage(ListTableStorageOptimizersResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable(previousPage.nextToken());
        }

        @Override
        public ListTableStorageOptimizersResponse nextPage(ListTableStorageOptimizersResponse previousPage) {
            if (previousPage == null) {
                return ListTableStorageOptimizersIterable.this.client.listTableStorageOptimizers(ListTableStorageOptimizersIterable.this.firstRequest);
            }
            return ListTableStorageOptimizersIterable.this.client.listTableStorageOptimizers((ListTableStorageOptimizersRequest)ListTableStorageOptimizersIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build());
        }
    }
}

