/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lakeformation.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.lakeformation.LakeFormationAsyncClient;
import software.amazon.awssdk.services.lakeformation.internal.UserAgentUtils;
import software.amazon.awssdk.services.lakeformation.model.ListTransactionsRequest;
import software.amazon.awssdk.services.lakeformation.model.ListTransactionsResponse;

public class ListTransactionsPublisher
implements SdkPublisher<ListTransactionsResponse> {
    private final LakeFormationAsyncClient client;
    private final ListTransactionsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListTransactionsPublisher(LakeFormationAsyncClient client, ListTransactionsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListTransactionsPublisher(LakeFormationAsyncClient client, ListTransactionsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListTransactionsResponseFetcher();
    }

    @Override
    public void subscribe(Subscriber<? super ListTransactionsResponse> subscriber) {
        subscriber.onSubscribe(((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private class ListTransactionsResponseFetcher
    implements AsyncPageFetcher<ListTransactionsResponse> {
        private ListTransactionsResponseFetcher() {
        }

        @Override
        public boolean hasNextPage(ListTransactionsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable(previousPage.nextToken());
        }

        @Override
        public CompletableFuture<ListTransactionsResponse> nextPage(ListTransactionsResponse previousPage) {
            if (previousPage == null) {
                return ListTransactionsPublisher.this.client.listTransactions(ListTransactionsPublisher.this.firstRequest);
            }
            return ListTransactionsPublisher.this.client.listTransactions((ListTransactionsRequest)ListTransactionsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build());
        }
    }
}

