/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3.internal.crt;

import java.util.concurrent.CompletableFuture;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.http.auth.spi.signer.AsyncSignRequest;
import software.amazon.awssdk.http.auth.spi.signer.AsyncSignedRequest;
import software.amazon.awssdk.http.auth.spi.signer.HttpSigner;
import software.amazon.awssdk.http.auth.spi.signer.SignRequest;
import software.amazon.awssdk.http.auth.spi.signer.SignedRequest;
import software.amazon.awssdk.identity.spi.IdentityProvider;
import software.amazon.awssdk.identity.spi.IdentityProviders;
import software.amazon.awssdk.identity.spi.ResolveIdentityRequest;
import software.amazon.awssdk.services.s3.s3express.S3ExpressAuthScheme;
import software.amazon.awssdk.services.s3.s3express.S3ExpressSessionCredentials;

@SdkInternalApi
public final class CrtS3ExpressNoOpAuthScheme
implements S3ExpressAuthScheme {
    @Override
    public String schemeId() {
        return "aws.auth#sigv4-s3express";
    }

    @Override
    public IdentityProvider<S3ExpressSessionCredentials> identityProvider(IdentityProviders providers) {
        return NoOpIdentityProvider.INSTANCE;
    }

    @Override
    public HttpSigner<S3ExpressSessionCredentials> signer() {
        return NoOpSigner.INSTANCE;
    }

    private static final class NoOpIdentityProvider
    implements IdentityProvider<S3ExpressSessionCredentials> {
        private static final NoOpIdentityProvider INSTANCE = new NoOpIdentityProvider();

        private NoOpIdentityProvider() {
        }

        @Override
        public Class<S3ExpressSessionCredentials> identityType() {
            return S3ExpressSessionCredentials.class;
        }

        @Override
        public CompletableFuture<? extends S3ExpressSessionCredentials> resolveIdentity(ResolveIdentityRequest request) {
            return CompletableFuture.completedFuture(null);
        }
    }

    private static final class NoOpSigner
    implements HttpSigner<S3ExpressSessionCredentials> {
        private static final NoOpSigner INSTANCE = new NoOpSigner();

        private NoOpSigner() {
        }

        @Override
        public SignedRequest sign(SignRequest<? extends S3ExpressSessionCredentials> request) {
            throw new UnsupportedOperationException();
        }

        @Override
        public CompletableFuture<AsyncSignedRequest> signAsync(AsyncSignRequest<? extends S3ExpressSessionCredentials> request) {
            throw new UnsupportedOperationException();
        }
    }
}

